/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinAntiJoinGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashSet;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorMapJoinAntiJoinStringOperator
extends VectorMapJoinAntiJoinGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorMapJoinAntiJoinStringOperator.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private transient VectorMapJoinBytesHashSet hashSet;
    private transient int singleJoinColumn;

    @Override
    protected String getLoggingPrefix() {
        return super.getLoggingPrefix(CLASS_NAME);
    }

    protected VectorMapJoinAntiJoinStringOperator() {
    }

    public VectorMapJoinAntiJoinStringOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorMapJoinAntiJoinStringOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) throws HiveException {
        super(ctx, conf, vContext, vectorDesc);
    }

    @Override
    protected void commonSetup() throws HiveException {
        super.commonSetup();
        this.singleJoinColumn = this.bigTableKeyColumnMap[0];
    }

    @Override
    public void hashTableSetup() throws HiveException {
        super.hashTableSetup();
        this.hashSet = (VectorMapJoinBytesHashSet)this.vectorMapJoinHashTable;
    }

    @Override
    public void processBatch(VectorizedRowBatch batch) throws HiveException {
        try {
            for (VectorExpression ve : this.bigTableFilterExpressions) {
                ve.evaluate(batch);
            }
            int inputLogicalSize = batch.size;
            if (inputLogicalSize == 0) {
                return;
            }
            if (this.bigTableKeyExpressions != null) {
                for (VectorExpression ve : this.bigTableKeyExpressions) {
                    ve.evaluate(batch);
                }
            }
            BytesColumnVector joinColVector = (BytesColumnVector)batch.cols[this.singleJoinColumn];
            byte[][] vector = joinColVector.vector;
            int[] start = joinColVector.start;
            int[] length = joinColVector.length;
            boolean allKeyInputColumnsRepeating = joinColVector.isRepeating;
            if (allKeyInputColumnsRepeating) {
                JoinUtil.JoinResult joinResult;
                if (!joinColVector.noNulls && joinColVector.isNull[0]) {
                    joinResult = JoinUtil.JoinResult.MATCH;
                } else {
                    byte[] keyBytes = vector[0];
                    int keyStart = start[0];
                    int keyLength = length[0];
                    joinResult = this.hashSet.contains(keyBytes, keyStart, keyLength, this.hashSetResults[0]);
                    joinResult = this.inverseResultForAntiJoin(joinResult);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " repeated joinResult " + joinResult.name());
                }
                this.finishAntiRepeated(batch, joinResult, this.hashSetResults[0]);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " batch #" + this.batchCounter + " non-repeated");
                }
                int[] selected = batch.selected;
                boolean selectedInUse = batch.selectedInUse;
                int hashSetResultCount = 0;
                int allMatchCount = 0;
                int spillCount = 0;
                int saveKeyBatchIndex = -1;
                boolean haveSaveKey = false;
                JoinUtil.JoinResult saveJoinResult = JoinUtil.JoinResult.NOMATCH;
                block20: for (int logical = 0; logical < inputLogicalSize; ++logical) {
                    boolean isNull;
                    int batchIndex = selectedInUse ? selected[logical] : logical;
                    boolean bl = isNull = !joinColVector.noNulls && joinColVector.isNull[batchIndex];
                    if (isNull || !haveSaveKey || !StringExpr.equal((byte[])vector[saveKeyBatchIndex], (int)start[saveKeyBatchIndex], (int)length[saveKeyBatchIndex], (byte[])vector[batchIndex], (int)start[batchIndex], (int)length[batchIndex])) {
                        if (haveSaveKey) {
                            switch (saveJoinResult) {
                                case MATCH: {
                                    break;
                                }
                                case SPILL: {
                                    ++hashSetResultCount;
                                    break;
                                }
                            }
                        }
                        if (isNull) {
                            saveJoinResult = JoinUtil.JoinResult.NOMATCH;
                            haveSaveKey = false;
                        } else {
                            haveSaveKey = true;
                            saveKeyBatchIndex = batchIndex;
                            byte[] keyBytes = vector[batchIndex];
                            int keyStart = start[batchIndex];
                            int keyLength = length[batchIndex];
                            saveJoinResult = this.hashSet.contains(keyBytes, keyStart, keyLength, this.hashSetResults[hashSetResultCount]);
                            saveJoinResult = this.inverseResultForAntiJoin(saveJoinResult);
                        }
                        switch (saveJoinResult) {
                            case MATCH: {
                                this.allMatchs[allMatchCount++] = batchIndex;
                                break;
                            }
                            case SPILL: {
                                this.spills[spillCount] = batchIndex;
                                this.spillHashMapResultIndices[spillCount] = hashSetResultCount;
                                ++spillCount;
                                break;
                            }
                        }
                        continue;
                    }
                    switch (saveJoinResult) {
                        case MATCH: {
                            this.allMatchs[allMatchCount++] = batchIndex;
                            continue block20;
                        }
                        case SPILL: {
                            this.spills[spillCount] = batchIndex;
                            this.spillHashMapResultIndices[spillCount] = hashSetResultCount;
                            ++spillCount;
                            continue block20;
                        }
                    }
                }
                if (haveSaveKey) {
                    switch (saveJoinResult) {
                        case MATCH: {
                            break;
                        }
                        case SPILL: {
                            ++hashSetResultCount;
                            break;
                        }
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(CLASS_NAME + " allMatchs " + VectorMapJoinAntiJoinStringOperator.intArrayToRangesString(this.allMatchs, allMatchCount) + " spills " + VectorMapJoinAntiJoinStringOperator.intArrayToRangesString(this.spills, spillCount) + " spillHashMapResultIndices " + VectorMapJoinAntiJoinStringOperator.intArrayToRangesString(this.spillHashMapResultIndices, spillCount) + " hashMapResults " + Arrays.toString(Arrays.copyOfRange(this.hashSetResults, 0, hashSetResultCount)));
                }
                this.finishAnti(batch, allMatchCount, spillCount, this.hashSetResults);
            }
            if (batch.size > 0) {
                this.forwardBigTableBatch(batch);
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }
}

