/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.io.IOException;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashSetResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashTableResult;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VectorMapJoinAntiJoinGenerateResultOperator
extends VectorMapJoinGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)VectorMapJoinAntiJoinGenerateResultOperator.class.getName());
    protected transient VectorMapJoinHashSetResult[] hashSetResults;
    protected transient int[] allMatchs;
    protected transient int[] spills;
    protected transient int[] spillHashMapResultIndices;

    protected VectorMapJoinAntiJoinGenerateResultOperator() {
    }

    public VectorMapJoinAntiJoinGenerateResultOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorMapJoinAntiJoinGenerateResultOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) throws HiveException {
        super(ctx, conf, vContext, vectorDesc);
    }

    @Override
    protected void commonSetup() throws HiveException {
        super.commonSetup();
        VectorMapJoinHashSet baseHashSet = (VectorMapJoinHashSet)this.vectorMapJoinHashTable;
        this.hashSetResults = new VectorMapJoinHashSetResult[1024];
        for (int i = 0; i < this.hashSetResults.length; ++i) {
            this.hashSetResults[i] = baseHashSet.createHashSetResult();
        }
        this.allMatchs = new int[1024];
        this.spills = new int[1024];
        this.spillHashMapResultIndices = new int[1024];
    }

    protected void finishAnti(VectorizedRowBatch batch, int allMatchCount, int spillCount, VectorMapJoinHashTableResult[] hashTableResults) throws HiveException, IOException {
        if (spillCount > 0) {
            this.spillHashMapBatch(batch, hashTableResults, this.spills, this.spillHashMapResultIndices, spillCount);
        }
        if (allMatchCount > 0 && this.bigTableValueExpressions != null) {
            this.performValueExpressions(batch, this.allMatchs, allMatchCount);
        }
        batch.size = this.generateHashSetResults(batch, this.allMatchs, allMatchCount);
        batch.selectedInUse = true;
    }

    private int generateHashSetResults(VectorizedRowBatch batch, int[] allMatches, int allMatchCount) {
        int numSel = 0;
        for (int i = 0; i < allMatchCount; ++i) {
            int batchIndex = this.allMatchs[i];
            batch.selected[numSel++] = batchIndex;
        }
        return numSel;
    }

    protected JoinUtil.JoinResult inverseResultForAntiJoin(JoinUtil.JoinResult joinResult) {
        if (joinResult == JoinUtil.JoinResult.NOMATCH) {
            return JoinUtil.JoinResult.MATCH;
        }
        if (joinResult == JoinUtil.JoinResult.MATCH) {
            return JoinUtil.JoinResult.NOMATCH;
        }
        return joinResult;
    }

    protected int generateHashSetResultRepeatedAll(VectorizedRowBatch batch) {
        if (!batch.selectedInUse) {
            int[] selected = batch.selected;
            for (int i = 0; i < batch.size; ++i) {
                selected[i] = i;
            }
            batch.selectedInUse = true;
        }
        return batch.size;
    }

    protected void finishAntiRepeated(VectorizedRowBatch batch, JoinUtil.JoinResult joinResult, VectorMapJoinHashTableResult hashSetResult) throws HiveException, IOException {
        switch (joinResult) {
            case MATCH: {
                if (this.bigTableValueExpressions != null) {
                    for (VectorExpression ve : this.bigTableValueExpressions) {
                        ve.evaluate(batch);
                    }
                }
                batch.size = this.generateHashSetResultRepeatedAll(batch);
                batch.selectedInUse = true;
                break;
            }
            case SPILL: {
                this.spillBatchRepeated(batch, hashSetResult);
                batch.size = 0;
                break;
            }
            case NOMATCH: {
                batch.size = 0;
            }
        }
    }
}

