/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class LongColumnBetween
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected int colNum;
    protected final long leftValue;
    protected final long rightValue;

    public LongColumnBetween(int colNum, long leftValue, long rightValue, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum = colNum;
        this.leftValue = leftValue;
        this.rightValue = rightValue;
    }

    public LongColumnBetween() {
        this.colNum = -1;
        this.leftValue = 0L;
        this.rightValue = 0L;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector = (LongColumnVector)batch.cols[this.colNum];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        int n = batch.size;
        long[] vector = inputColVector.vector;
        long[] outputVector = outputColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                long repeatValue = vector[0];
                outputVector[0] = repeatValue < this.leftValue || repeatValue > this.rightValue ? 0L : 1L;
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        long value = vector[i];
                        outputVector[i] = value < this.leftValue || value > this.rightValue ? 0L : 1L;
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        long value = vector[i];
                        outputVector[i] = value < this.leftValue || value > this.rightValue ? 0L : 1L;
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    long value = vector[i];
                    outputVector[i] = value < this.leftValue || value > this.rightValue ? 0L : 1L;
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = inputIsNull[i];
                    long value = vector[i];
                    outputVector[i] = value < this.leftValue || value > this.rightValue ? 0L : 1L;
                }
            } else {
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    long value = vector[i];
                    outputVector[i] = value < this.leftValue || value > this.rightValue ? 0L : 1L;
                }
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNum) + ", left " + this.leftValue + ", right " + this.rightValue;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return null;
    }
}

