/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationDesc;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

@Description(name="avg", value="_FUNC_(AVG) - Returns the average value of expr (vectorized, type: decimal)")
public class VectorUDAFAvgDecimalPartial2
extends VectorAggregateExpression {
    private static final long serialVersionUID = 1L;

    public VectorUDAFAvgDecimalPartial2() {
    }

    public VectorUDAFAvgDecimalPartial2(VectorAggregationDesc vecAggrDesc) {
        super(vecAggrDesc);
        Preconditions.checkState((this.mode == GenericUDAFEvaluator.Mode.PARTIAL2 ? 1 : 0) != 0);
        this.init();
    }

    private void init() {
    }

    private Aggregation getCurrentAggregationBuffer(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, int row) {
        VectorAggregationBufferRow mySet = aggregationBufferSets[row];
        Aggregation myagg = (Aggregation)mySet.getAggregationBuffer(bufferIndex);
        return myagg;
    }

    @Override
    public void aggregateInputSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, VectorizedRowBatch batch) throws HiveException {
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        this.inputExpression.evaluate(batch);
        StructColumnVector inputStructColVector = (StructColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
        ColumnVector[] fields = inputStructColVector.fields;
        long[] countVector = ((LongColumnVector)fields[0]).vector;
        HiveDecimalWritable[] sumVector = ((DecimalColumnVector)fields[1]).vector;
        if (inputStructColVector.noNulls) {
            if (inputStructColVector.isRepeating) {
                this.iterateNoNullsRepeatingWithAggregationSelection(aggregationBufferSets, bufferIndex, countVector[0], sumVector[0], batchSize);
            } else if (batch.selectedInUse) {
                this.iterateNoNullsSelectionWithAggregationSelection(aggregationBufferSets, bufferIndex, countVector, sumVector, batch.selected, batchSize);
            } else {
                this.iterateNoNullsWithAggregationSelection(aggregationBufferSets, bufferIndex, countVector, sumVector, batchSize);
            }
        } else if (inputStructColVector.isRepeating) {
            this.iterateHasNullsRepeatingWithAggregationSelection(aggregationBufferSets, bufferIndex, countVector[0], sumVector[0], batchSize, inputStructColVector.isNull);
        } else if (batch.selectedInUse) {
            this.iterateHasNullsSelectionWithAggregationSelection(aggregationBufferSets, bufferIndex, countVector, sumVector, batchSize, batch.selected, inputStructColVector.isNull);
        } else {
            this.iterateHasNullsWithAggregationSelection(aggregationBufferSets, bufferIndex, countVector, sumVector, batchSize, inputStructColVector.isNull);
        }
    }

    private void iterateNoNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, long count, HiveDecimalWritable sum, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.merge(count, sum);
        }
    }

    private void iterateNoNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, long[] countVector, HiveDecimalWritable[] sumVector, int[] selection, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            int batchIndex = selection[i];
            myagg.merge(countVector[batchIndex], sumVector[batchIndex]);
        }
    }

    private void iterateNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, long[] countVector, HiveDecimalWritable[] sumVector, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.merge(countVector[i], sumVector[i]);
        }
    }

    private void iterateHasNullsRepeatingWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, long count, HiveDecimalWritable sum, int batchSize, boolean[] isNull) {
        if (isNull[0]) {
            return;
        }
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.merge(count, sum);
        }
    }

    private void iterateHasNullsSelectionWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, long[] countVector, HiveDecimalWritable[] sumVector, int batchSize, int[] selection, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            int batchIndex = selection[i];
            if (isNull[batchIndex]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.merge(countVector[batchIndex], sumVector[batchIndex]);
        }
    }

    private void iterateHasNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int bufferIndex, long[] countVector, HiveDecimalWritable[] sumVector, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, bufferIndex, i);
            myagg.merge(countVector[i], sumVector[i]);
        }
    }

    @Override
    public void aggregateInput(VectorAggregateExpression.AggregationBuffer agg, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        StructColumnVector inputStructColVector = (StructColumnVector)batch.cols[this.inputExpression.getOutputColumnNum()];
        ColumnVector[] fields = inputStructColVector.fields;
        long[] countVector = ((LongColumnVector)fields[0]).vector;
        HiveDecimalWritable[] sumVector = ((DecimalColumnVector)fields[1]).vector;
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        Aggregation myagg = (Aggregation)agg;
        if (inputStructColVector.isRepeating) {
            if (inputStructColVector.noNulls || !inputStructColVector.isNull[0]) {
                if (myagg.isNull) {
                    myagg.isNull = false;
                    myagg.mergeSum.setFromLong(0L);
                    myagg.mergeCount = 0L;
                }
                Aggregation aggregation = myagg;
                aggregation.mergeCount = aggregation.mergeCount + countVector[0] * (long)batchSize;
                HiveDecimal sum = sumVector[0].getHiveDecimal();
                HiveDecimal multiple = sum.multiply(HiveDecimal.create((int)batchSize));
                myagg.mergeSum.mutateAdd(multiple);
            }
            return;
        }
        if (!batch.selectedInUse && inputStructColVector.noNulls) {
            this.iterateNoSelectionNoNulls(myagg, countVector, sumVector, batchSize);
        } else if (!batch.selectedInUse) {
            this.iterateNoSelectionHasNulls(myagg, countVector, sumVector, batchSize, inputStructColVector.isNull);
        } else if (inputStructColVector.noNulls) {
            this.iterateSelectionNoNulls(myagg, countVector, sumVector, batchSize, batch.selected);
        } else {
            this.iterateSelectionHasNulls(myagg, countVector, sumVector, batchSize, inputStructColVector.isNull, batch.selected);
        }
    }

    private void iterateSelectionHasNulls(Aggregation myagg, long[] countVector, HiveDecimalWritable[] sumVector, int batchSize, boolean[] isNull, int[] selected) {
        for (int i = 0; i < batchSize; ++i) {
            int batchIndex = selected[i];
            if (isNull[batchIndex]) continue;
            myagg.merge(countVector[batchIndex], sumVector[batchIndex]);
        }
    }

    private void iterateSelectionNoNulls(Aggregation myagg, long[] countVector, HiveDecimalWritable[] sumVector, int batchSize, int[] selected) {
        if (myagg.isNull) {
            myagg.isNull = false;
            myagg.mergeSum.setFromLong(0L);
            myagg.mergeCount = 0L;
        }
        for (int i = 0; i < batchSize; ++i) {
            int batchIndex = selected[i];
            myagg.mergeNoNullCheck(countVector[batchIndex], sumVector[batchIndex]);
        }
    }

    private void iterateNoSelectionHasNulls(Aggregation myagg, long[] countVector, HiveDecimalWritable[] sumVector, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            myagg.merge(countVector[i], sumVector[i]);
        }
    }

    private void iterateNoSelectionNoNulls(Aggregation myagg, long[] countVector, HiveDecimalWritable[] sumVector, int batchSize) {
        if (myagg.isNull) {
            myagg.isNull = false;
            myagg.mergeSum.setFromLong(0L);
            myagg.mergeCount = 0L;
        }
        for (int i = 0; i < batchSize; ++i) {
            myagg.mergeNoNullCheck(countVector[i], sumVector[i]);
        }
    }

    @Override
    public VectorAggregateExpression.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new Aggregation();
    }

    @Override
    public void reset(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myAgg = (Aggregation)agg;
        myAgg.reset();
    }

    @Override
    public long getAggregationBufferFixedSize() {
        JavaDataModel model = JavaDataModel.get();
        return JavaDataModel.alignUp((long)(model.object() + model.primitive2() * 2), (long)model.memoryAlign());
    }

    @Override
    public boolean matches(String name, ColumnVector.Type inputColVectorType, ColumnVector.Type outputColVectorType, GenericUDAFEvaluator.Mode mode) {
        return name.equals("avg") && inputColVectorType == ColumnVector.Type.STRUCT && outputColVectorType == ColumnVector.Type.STRUCT && mode == GenericUDAFEvaluator.Mode.PARTIAL2;
    }

    @Override
    public void assignRowColumn(VectorizedRowBatch batch, int batchIndex, int columnNum, VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        StructColumnVector outputColVector = (StructColumnVector)batch.cols[columnNum];
        Aggregation myagg = (Aggregation)agg;
        if (myagg.isNull || myagg.mergeCount == 0L) {
            outputColVector.noNulls = false;
            outputColVector.isNull[batchIndex] = true;
            return;
        }
        outputColVector.isNull[batchIndex] = false;
        ColumnVector[] fields = outputColVector.fields;
        fields[0].isNull[batchIndex] = false;
        ((LongColumnVector)fields[0]).vector[batchIndex] = myagg.mergeCount;
        fields[1].isNull[batchIndex] = false;
        ((DecimalColumnVector)fields[1]).set(batchIndex, myagg.mergeSum);
        ColumnVector sourceColVector = fields[2];
        sourceColVector.isRepeating = true;
        sourceColVector.noNulls = false;
        sourceColVector.isNull[0] = true;
    }

    static class Aggregation
    implements VectorAggregateExpression.AggregationBuffer {
        private static final long serialVersionUID = 1L;
        private final transient HiveDecimalWritable mergeSum = new HiveDecimalWritable();
        private transient long mergeCount;
        private transient boolean isNull;

        Aggregation() {
        }

        public void merge(long count, HiveDecimalWritable sum) {
            if (this.isNull) {
                this.mergeCount = count;
                this.mergeSum.set(sum);
                this.isNull = false;
            } else {
                this.mergeCount += count;
                this.mergeSum.mutateAdd(sum);
            }
        }

        public void mergeNoNullCheck(long count, HiveDecimalWritable sum) {
            this.mergeCount += count;
            this.mergeSum.mutateAdd(sum);
        }

        @Override
        public int getVariableSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.isNull = true;
            this.mergeCount = 0L;
            this.mergeSum.setFromLong(0L);
        }
    }
}

