/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IdentityExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VectorExpression
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final transient Logger LOG = LoggerFactory.getLogger((String)this.getClass().getName());
    protected VectorExpression[] childExpressions = null;
    protected TypeInfo[] inputTypeInfos = null;
    protected DataTypePhysicalVariation[] inputDataTypePhysicalVariations = null;
    protected final int outputColumnNum;
    protected TypeInfo outputTypeInfo;
    protected DataTypePhysicalVariation outputDataTypePhysicalVariation;

    public VectorExpression() {
        this.outputColumnNum = -1;
        this.outputTypeInfo = null;
        this.outputDataTypePhysicalVariation = null;
    }

    public VectorExpression(int outputColumnNum) {
        this.outputColumnNum = outputColumnNum;
        this.outputTypeInfo = null;
        this.outputDataTypePhysicalVariation = null;
    }

    public void setChildExpressions(VectorExpression[] childExpressions) {
        this.childExpressions = childExpressions;
    }

    public VectorExpression[] getChildExpressions() {
        return this.childExpressions;
    }

    public void setInputTypeInfos(TypeInfo ... inputTypeInfos) {
        this.inputTypeInfos = inputTypeInfos;
    }

    public TypeInfo[] getInputTypeInfos() {
        return this.inputTypeInfos;
    }

    public void setInputDataTypePhysicalVariations(DataTypePhysicalVariation ... inputDataTypePhysicalVariations) {
        this.inputDataTypePhysicalVariations = inputDataTypePhysicalVariations;
    }

    public DataTypePhysicalVariation[] getInputDataTypePhysicalVariations() {
        return this.inputDataTypePhysicalVariations;
    }

    public abstract String vectorExpressionParameters();

    public void transientInit(Configuration conf) throws HiveException {
    }

    public static void doTransientInit(VectorExpression vecExpr, Configuration conf) throws HiveException {
        if (vecExpr == null) {
            return;
        }
        VectorExpression.doTransientInitRecurse(vecExpr, conf);
    }

    public static void doTransientInit(VectorExpression[] vecExprs, Configuration conf) throws HiveException {
        if (vecExprs == null) {
            return;
        }
        for (VectorExpression vecExpr : vecExprs) {
            VectorExpression.doTransientInitRecurse(vecExpr, conf);
        }
    }

    private static void doTransientInitRecurse(VectorExpression vecExpr, Configuration conf) throws HiveException {
        vecExpr.transientInit(conf);
        ArrayList newChildren = new ArrayList();
        VectorExpression[] children = vecExpr.getChildExpressions();
        if (children != null) {
            Collections.addAll(newChildren, children);
        }
        while (!newChildren.isEmpty()) {
            VectorExpression childVecExpr = (VectorExpression)newChildren.remove(0);
            children = childVecExpr.getChildExpressions();
            if (children != null) {
                Collections.addAll(newChildren, children);
            }
            childVecExpr.transientInit(conf);
        }
    }

    public int getOutputColumnNum() {
        return this.outputColumnNum;
    }

    public TypeInfo getOutputTypeInfo() {
        return this.outputTypeInfo;
    }

    public void setOutputTypeInfo(TypeInfo outputTypeInfo) {
        this.outputTypeInfo = outputTypeInfo;
    }

    public void setOutputDataTypePhysicalVariation(DataTypePhysicalVariation outputDataTypePhysicalVariation) {
        this.outputDataTypePhysicalVariation = outputDataTypePhysicalVariation;
    }

    public DataTypePhysicalVariation getOutputDataTypePhysicalVariation() {
        return this.outputDataTypePhysicalVariation;
    }

    public ColumnVector.Type getOutputColumnVectorType() throws HiveException {
        return VectorizationContext.getColumnVectorTypeFromTypeInfo(this.outputTypeInfo, this.outputDataTypePhysicalVariation);
    }

    public abstract void evaluate(VectorizedRowBatch var1) throws HiveException;

    public void init(Configuration conf) {
        if (this.childExpressions != null) {
            for (VectorExpression child : this.childExpressions) {
                child.init(conf);
            }
        }
    }

    public abstract VectorExpressionDescriptor.Descriptor getDescriptor();

    protected final void evaluateChildren(VectorizedRowBatch vrg) throws HiveException {
        if (this.childExpressions != null) {
            for (VectorExpression ve : this.childExpressions) {
                ve.evaluate(vrg);
            }
        }
    }

    protected String getColumnParamString(int typeNum, int columnNum) {
        return "col " + columnNum + ":" + this.getParamTypeString(typeNum);
    }

    protected String getLongValueParamString(int typeNum, long value) {
        return "val " + value + ":" + this.getParamTypeString(typeNum);
    }

    protected String getDoubleValueParamString(int typeNum, double value) {
        return "val " + value + ":" + this.getParamTypeString(typeNum);
    }

    protected String getParamTypeString(int typeNum) {
        if (this.inputTypeInfos == null) {
            return "<input types is null>";
        }
        if (this.inputDataTypePhysicalVariations == null) {
            return "<input data type physical variations is null>";
        }
        return VectorExpression.getTypeName(this.inputTypeInfos[typeNum], this.inputDataTypePhysicalVariations[typeNum]);
    }

    public static String getTypeName(TypeInfo typeInfo, DataTypePhysicalVariation dataTypePhysicalVariation) {
        if (typeInfo == null) {
            return "<input type is null>";
        }
        if (dataTypePhysicalVariation != null && dataTypePhysicalVariation != DataTypePhysicalVariation.NONE) {
            return typeInfo.toString() + "/" + dataTypePhysicalVariation;
        }
        return typeInfo.toString();
    }

    public boolean supportsCheckedExecution() {
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this instanceof IdentityExpression) {
            b.append(this.vectorExpressionParameters());
        } else {
            b.append(this.getClass().getSimpleName());
            String vectorExpressionParameters = this.vectorExpressionParameters();
            if (vectorExpressionParameters != null) {
                b.append("(");
                b.append(vectorExpressionParameters);
                b.append(")");
            }
            if (this.childExpressions != null) {
                b.append("(children: ");
                for (int i = 0; i < this.childExpressions.length; ++i) {
                    b.append(this.childExpressions[i].toString());
                    if (i >= this.childExpressions.length - 1) continue;
                    b.append(", ");
                }
                b.append(")");
            }
            if (this.outputColumnNum != -1) {
                b.append(" -> ");
                b.append(this.outputColumnNum);
                b.append(":");
                b.append(VectorExpression.getTypeName(this.outputTypeInfo, this.outputDataTypePhysicalVariation));
            }
        }
        return b.toString();
    }

    public static String displayUtf8Bytes(byte[] bytes) {
        if (bytes == null) {
            return "NULL";
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String displayArrayOfUtf8ByteArrays(byte[][] arrayOfByteArrays) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (byte[] bytes : arrayOfByteArrays) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(VectorExpression.displayUtf8Bytes(bytes));
        }
        return sb.toString();
    }
}

