/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ColOrCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ConstantVectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class ScalarNullOrCol
extends ColOrCol {
    private static final long serialVersionUID = 1L;
    protected final int colNum;

    public ScalarNullOrCol(ConstantVectorExpression expression, int colNum, int outputColumnNum) {
        super(colNum, -1, outputColumnNum);
        this.colNum = colNum;
    }

    public ScalarNullOrCol() {
        this.colNum = -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector = (LongColumnVector)batch.cols[this.colNum];
        super.doEvaluate(batch, new LongColumnVector(inputColVector.vector.length).fillWithNulls(), inputColVector);
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNum) + ", " + this.getLongValueParamString(1, 0L);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("long"), VectorExpressionDescriptor.ArgumentType.getType("long")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.NULLSCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

