/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.ByteBuffer;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.MurmurHashExpression;
import org.apache.hive.common.util.Murmur3;

public class MurmurHashStringColIntCol
extends MurmurHashExpression {
    private static final long serialVersionUID = 1L;

    public MurmurHashStringColIntCol() {
    }

    public MurmurHashStringColIntCol(int colNumFirst, int colNumSecond, int outputColumnNum) {
        super(colNumFirst, colNumSecond, outputColumnNum);
    }

    @Override
    protected void hash(ColumnVector inputColVector1, ColumnVector inputColVector2, LongColumnVector outputColVector, int i, ByteBuffer byteBuffer) {
        BytesColumnVector inV1 = (BytesColumnVector)inputColVector1;
        LongColumnVector inV2 = (LongColumnVector)inputColVector2;
        int hash = inV1.isNull[i] ? 0 : Murmur3.hash32((byte[])inV1.vector[i], (int)inV1.start[i], (int)inV1.length[i], (int)104729);
        int hash2 = 0;
        if (!inV2.isNull[i]) {
            byteBuffer.clear();
            byteBuffer.putLong(inV2.vector[i]);
            hash2 = Murmur3.hash32((byte[])byteBuffer.array(), (int)8);
        }
        outputColVector.vector[i] = 31 * hash + hash2;
    }

    @Override
    protected void setArguments(VectorExpressionDescriptor.Builder builder) {
        builder.setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY);
    }
}

