/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.ByteBuffer;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.MurmurHashExpression;
import org.apache.hive.common.util.Murmur3;

public class MurmurHashIntColIntCol
extends MurmurHashExpression {
    private static final long serialVersionUID = 1L;

    public MurmurHashIntColIntCol() {
    }

    public MurmurHashIntColIntCol(int colNumFirst, int colNumSecond, int outputColumnNum) {
        super(colNumFirst, colNumSecond, outputColumnNum);
    }

    @Override
    protected void hash(ColumnVector inputColVector1, ColumnVector inputColVector2, LongColumnVector outputColVector, int i, ByteBuffer byteBuffer) {
        LongColumnVector inV1 = (LongColumnVector)inputColVector1;
        LongColumnVector inV2 = (LongColumnVector)inputColVector2;
        int hash = 0;
        if (!inV1.isNull[i]) {
            byteBuffer.clear();
            byteBuffer.putLong(inV1.vector[i]);
            hash = Murmur3.hash32((byte[])byteBuffer.array(), (int)8);
        }
        int hash2 = 0;
        if (!inV2.isNull[i]) {
            byteBuffer.clear();
            byteBuffer.putLong(inV2.vector[i]);
            hash2 = Murmur3.hash32((byte[])byteBuffer.array(), (int)8);
        }
        outputColVector.vector[i] = 31 * hash + hash2;
    }

    @Override
    protected void setArguments(VectorExpressionDescriptor.Builder builder) {
        builder.setArgumentTypes(VectorExpressionDescriptor.ArgumentType.INT_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY);
    }
}

