/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.ByteBuffer;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public abstract class MurmurHashExpression
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNumFirst;
    private int colNumSecond;

    public MurmurHashExpression() {
    }

    public MurmurHashExpression(int colNumFirst, int colNumSecond, int outputColumnNum) {
        super(outputColumnNum);
        this.colNumFirst = colNumFirst;
        this.colNumSecond = colNumSecond;
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNumFirst) + ", " + this.getColumnParamString(1, this.colNumSecond);
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            this.evaluateChildren(batch);
        }
        ColumnVector inputColVector1 = batch.cols[this.colNumFirst];
        ColumnVector inputColVector2 = batch.cols[this.colNumSecond];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull1 = inputColVector1.isNull;
        boolean[] inputIsNull2 = inputColVector2.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        int n = batch.size;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        ByteBuffer buffer = ByteBuffer.allocate(8);
        if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            outputIsNull[0] = false;
            if (inputColVector1.noNulls || !inputIsNull1[0] || inputColVector2.noNulls || !inputIsNull2[0]) {
                this.hash(inputColVector1, inputColVector2, outputColVector, 0, buffer);
            } else {
                outputColVector.vector[0] = 0L;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                this.hash(inputColVector1, inputColVector2, outputColVector, sel[j], buffer);
            }
        } else {
            for (int i = 0; i != n; ++i) {
                this.hash(inputColVector1, inputColVector2, outputColVector, i, buffer);
            }
        }
    }

    protected abstract void hash(ColumnVector var1, ColumnVector var2, LongColumnVector var3, int var4, ByteBuffer var5);

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN);
        this.setArguments(b);
        return b.build();
    }

    protected abstract void setArguments(VectorExpressionDescriptor.Builder var1);
}

