/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterLongColumnInList;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;

public class FilterDecimal64ColumnInList
extends FilterLongColumnInList {
    private static final long serialVersionUID = 1L;

    public FilterDecimal64ColumnInList() {
    }

    public FilterDecimal64ColumnInList(int colNum) {
        super(colNum);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return null;
    }

    @Override
    public String vectorExpressionParameters() {
        DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)this.inputTypeInfos[0];
        int scale = decimalTypeInfo.scale();
        HiveDecimalWritable writable = new HiveDecimalWritable();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getColumnParamString(0, this.inputCol));
        sb.append(", values [");
        for (long value : this.inListValues) {
            writable.deserialize64(value, scale);
            sb.append(", decimal64Val ");
            sb.append(value);
            sb.append(", decimalVal ");
            sb.append(writable.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

