/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.List;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.Decimal64ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VoidColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class ConstantVectorExpression
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected long longValue = 0L;
    private double doubleValue = 0.0;
    private byte[] bytesValue = null;
    private HiveDecimal decimalValue = null;
    private Timestamp timestampValue = null;
    private HiveIntervalDayTime intervalDayTimeValue = null;
    private ConstantVectorExpression[] structValue;
    private boolean isNullValue = false;
    private final ColumnVector.Type type;
    private int bytesValueLength = 0;

    public ConstantVectorExpression() {
        this.type = null;
    }

    ConstantVectorExpression(int outputColumnNum, TypeInfo outputTypeInfo) throws HiveException {
        super(outputColumnNum);
        this.outputTypeInfo = outputTypeInfo;
        this.outputDataTypePhysicalVariation = DataTypePhysicalVariation.NONE;
        this.type = VectorizationContext.getColumnVectorTypeFromTypeInfo(outputTypeInfo);
    }

    public ConstantVectorExpression(int outputColumnNum, long value, TypeInfo outputTypeInfo) throws HiveException {
        this(outputColumnNum, outputTypeInfo);
        this.longValue = value;
    }

    public ConstantVectorExpression(int outputColumnNum, double value, TypeInfo outputTypeInfo) throws HiveException {
        this(outputColumnNum, outputTypeInfo);
        this.doubleValue = value;
    }

    public ConstantVectorExpression(int outputColumnNum, byte[] value, TypeInfo outputTypeInfo) throws HiveException {
        this(outputColumnNum, outputTypeInfo);
        this.setBytesValue(value);
    }

    public ConstantVectorExpression(int outputColumnNum, HiveChar value, TypeInfo outputTypeInfo) throws HiveException {
        this(outputColumnNum, outputTypeInfo);
        this.setBytesValue(value.getStrippedValue().getBytes());
    }

    public ConstantVectorExpression(int outputColumnNum, HiveVarchar value, TypeInfo outputTypeInfo) throws HiveException {
        this(outputColumnNum, outputTypeInfo);
        this.setBytesValue(value.getValue().getBytes());
    }

    public ConstantVectorExpression(int outputColumnNum, HiveDecimal value, TypeInfo outputTypeInfo) throws HiveException {
        this(outputColumnNum, outputTypeInfo);
        this.setDecimalValue(value);
    }

    public ConstantVectorExpression(int outputColumnNum, Timestamp value, TypeInfo outputTypeInfo) throws HiveException {
        this(outputColumnNum, outputTypeInfo);
        this.setTimestampValue(value);
    }

    public ConstantVectorExpression(int outputColumnNum, HiveIntervalDayTime value, TypeInfo outputTypeInfo) throws HiveException {
        this(outputColumnNum, outputTypeInfo);
        this.setIntervalDayTimeValue(value);
    }

    public ConstantVectorExpression(int outputColumnNum, TypeInfo outputTypeInfo, boolean isNull) throws HiveException {
        this(outputColumnNum, outputTypeInfo);
        this.isNullValue = isNull;
    }

    public static ConstantVectorExpression createStruct(int outputColumnNum, Object value, TypeInfo outputTypeInfo) throws HiveException {
        ConstantVectorExpression result = new ConstantVectorExpression(outputColumnNum, outputTypeInfo);
        result.setStructValue(value);
        return result;
    }

    public static ConstantVectorExpression create(int outputColumnNum, Object constantValue, TypeInfo outputTypeInfo) throws HiveException {
        if (constantValue == null) {
            return new ConstantVectorExpression(outputColumnNum, outputTypeInfo, true);
        }
        ObjectInspector.Category category = outputTypeInfo.getCategory();
        switch (category) {
            case PRIMITIVE: {
                PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)outputTypeInfo;
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = primitiveTypeInfo.getPrimitiveCategory();
                switch (primitiveCategory) {
                    case BOOLEAN: {
                        if (((Boolean)constantValue).booleanValue()) {
                            return new ConstantVectorExpression(outputColumnNum, 1L, outputTypeInfo);
                        }
                        return new ConstantVectorExpression(outputColumnNum, 0L, outputTypeInfo);
                    }
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: {
                        return new ConstantVectorExpression(outputColumnNum, ((Number)constantValue).longValue(), outputTypeInfo);
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        return new ConstantVectorExpression(outputColumnNum, ((Number)constantValue).doubleValue(), outputTypeInfo);
                    }
                    case DATE: {
                        return new ConstantVectorExpression(outputColumnNum, DateWritableV2.dateToDays((Date)((Date)constantValue)), outputTypeInfo);
                    }
                    case TIMESTAMP: {
                        return new ConstantVectorExpression(outputColumnNum, ((org.apache.hadoop.hive.common.type.Timestamp)constantValue).toSqlTimestamp(), outputTypeInfo);
                    }
                    case DECIMAL: {
                        return new ConstantVectorExpression(outputColumnNum, (HiveDecimal)constantValue, outputTypeInfo);
                    }
                    case STRING: {
                        return new ConstantVectorExpression(outputColumnNum, ((String)constantValue).getBytes(), outputTypeInfo);
                    }
                    case VARCHAR: {
                        return new ConstantVectorExpression(outputColumnNum, (HiveVarchar)constantValue, outputTypeInfo);
                    }
                    case CHAR: {
                        return new ConstantVectorExpression(outputColumnNum, (HiveChar)constantValue, outputTypeInfo);
                    }
                    case BINARY: {
                        return new ConstantVectorExpression(outputColumnNum, (byte[])constantValue, outputTypeInfo);
                    }
                    case INTERVAL_YEAR_MONTH: {
                        return new ConstantVectorExpression(outputColumnNum, ((HiveIntervalYearMonth)constantValue).getTotalMonths(), outputTypeInfo);
                    }
                    case INTERVAL_DAY_TIME: {
                        return new ConstantVectorExpression(outputColumnNum, (HiveIntervalDayTime)constantValue, outputTypeInfo);
                    }
                }
                throw new RuntimeException("Unexpected primitive category " + primitiveCategory);
            }
            case STRUCT: {
                return ConstantVectorExpression.createStruct(outputColumnNum, constantValue, outputTypeInfo);
            }
        }
        throw new RuntimeException("Unexpected category " + category);
    }

    private void evaluateLong(ColumnVector colVector) {
        LongColumnVector cv = (LongColumnVector)colVector;
        cv.isRepeating = true;
        if (!this.isNullValue) {
            cv.isNull[0] = false;
            cv.vector[0] = this.longValue;
        } else {
            cv.isNull[0] = true;
            cv.noNulls = false;
        }
    }

    private void evaluateDouble(ColumnVector colVector) {
        DoubleColumnVector cv = (DoubleColumnVector)colVector;
        cv.isRepeating = true;
        if (!this.isNullValue) {
            cv.isNull[0] = false;
            cv.vector[0] = this.doubleValue;
        } else {
            cv.isNull[0] = true;
            cv.noNulls = false;
        }
    }

    private void evaluateBytes(ColumnVector colVector) {
        BytesColumnVector cv = (BytesColumnVector)colVector;
        cv.isRepeating = true;
        cv.initBuffer();
        if (!this.isNullValue) {
            cv.isNull[0] = false;
            cv.setVal(0, this.bytesValue, 0, this.bytesValueLength);
        } else {
            cv.isNull[0] = true;
            cv.noNulls = false;
        }
    }

    private void evaluateDecimal(ColumnVector colVector) {
        DecimalColumnVector dcv = (DecimalColumnVector)colVector;
        dcv.isRepeating = true;
        if (!this.isNullValue) {
            dcv.isNull[0] = false;
            dcv.set(0, this.decimalValue);
        } else {
            dcv.isNull[0] = true;
            dcv.noNulls = false;
        }
    }

    private void evaluateDecimal64(ColumnVector colVector) {
        Decimal64ColumnVector dcv = (Decimal64ColumnVector)colVector;
        dcv.isRepeating = true;
        if (!this.isNullValue) {
            dcv.isNull[0] = false;
            dcv.vector[0] = this.longValue;
        } else {
            dcv.isNull[0] = true;
            dcv.noNulls = false;
        }
    }

    private void evaluateTimestamp(ColumnVector colVector) {
        TimestampColumnVector tcv = (TimestampColumnVector)colVector;
        tcv.isRepeating = true;
        if (!this.isNullValue) {
            tcv.isNull[0] = false;
            tcv.set(0, this.timestampValue);
        } else {
            tcv.isNull[0] = true;
            tcv.noNulls = false;
        }
    }

    private void evaluateIntervalDayTime(ColumnVector colVector) {
        IntervalDayTimeColumnVector dcv = (IntervalDayTimeColumnVector)colVector;
        dcv.isRepeating = true;
        if (!this.isNullValue) {
            dcv.isNull[0] = false;
            dcv.set(0, this.intervalDayTimeValue);
        } else {
            dcv.isNull[0] = true;
            dcv.noNulls = false;
        }
    }

    private void evaluateStruct(ColumnVector colVector) {
        StructColumnVector scv = (StructColumnVector)colVector;
        scv.isRepeating = true;
        if (!this.isNullValue) {
            scv.isNull[0] = false;
            int size = this.structValue.length;
            for (int i = 0; i < size; ++i) {
                this.structValue[i].evaluateColumn(scv.fields[i]);
            }
        } else {
            scv.isNull[0] = true;
            scv.noNulls = false;
        }
    }

    private void evaluateVoid(ColumnVector colVector) {
        VoidColumnVector voidColVector = (VoidColumnVector)colVector;
        voidColVector.isRepeating = true;
        voidColVector.isNull[0] = true;
        voidColVector.noNulls = false;
    }

    @Override
    public void evaluate(VectorizedRowBatch vrg) {
        this.evaluateColumn(vrg.cols[this.outputColumnNum]);
    }

    private void evaluateColumn(ColumnVector colVector) {
        switch (this.type) {
            case LONG: {
                this.evaluateLong(colVector);
                break;
            }
            case DOUBLE: {
                this.evaluateDouble(colVector);
                break;
            }
            case BYTES: {
                this.evaluateBytes(colVector);
                break;
            }
            case DECIMAL: {
                if (this.outputDataTypePhysicalVariation == DataTypePhysicalVariation.DECIMAL_64) {
                    this.evaluateDecimal64(colVector);
                    break;
                }
                this.evaluateDecimal(colVector);
                break;
            }
            case TIMESTAMP: {
                this.evaluateTimestamp(colVector);
                break;
            }
            case INTERVAL_DAY_TIME: {
                this.evaluateIntervalDayTime(colVector);
                break;
            }
            case STRUCT: {
                this.evaluateStruct(colVector);
                break;
            }
            case VOID: {
                this.evaluateVoid(colVector);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected column vector type " + this.type);
            }
        }
    }

    public long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(long longValue) {
        this.longValue = longValue;
    }

    public double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(double doubleValue) {
        this.doubleValue = doubleValue;
    }

    public byte[] getBytesValue() {
        return this.bytesValue;
    }

    public void setBytesValue(byte[] bytesValue) {
        this.bytesValue = (byte[])bytesValue.clone();
        this.bytesValueLength = bytesValue.length;
    }

    public void setDecimalValue(HiveDecimal decimalValue) {
        this.decimalValue = decimalValue;
    }

    public HiveDecimal getDecimalValue() {
        return this.decimalValue;
    }

    public void setTimestampValue(Timestamp timestampValue) {
        this.timestampValue = timestampValue;
    }

    public Timestamp getTimestampValue() {
        return this.timestampValue;
    }

    public void setIntervalDayTimeValue(HiveIntervalDayTime intervalDayTimeValue) {
        this.intervalDayTimeValue = intervalDayTimeValue;
    }

    public HiveIntervalDayTime getIntervalDayTimeValue() {
        return this.intervalDayTimeValue;
    }

    public Object getValue() {
        switch (this.type) {
            case LONG: {
                return this.getLongValue();
            }
            case DOUBLE: {
                return this.getDoubleValue();
            }
            case BYTES: {
                return this.getBytesValue();
            }
            case DECIMAL: {
                return this.getDecimalValue();
            }
            case TIMESTAMP: {
                return this.getTimestampValue();
            }
            case INTERVAL_DAY_TIME: {
                return this.getIntervalDayTimeValue();
            }
        }
        throw new RuntimeException("Unexpected column vector type " + this.type);
    }

    public void setStructValue(Object structValue) throws HiveException {
        StructTypeInfo structTypeInfo = (StructTypeInfo)this.outputTypeInfo;
        List fieldTypeInfoList = structTypeInfo.getAllStructFieldTypeInfos();
        int size = fieldTypeInfoList.size();
        this.structValue = new ConstantVectorExpression[size];
        List fieldValueList = (List)structValue;
        for (int i = 0; i < size; ++i) {
            this.structValue[i] = ConstantVectorExpression.create(i, fieldValueList.get(i), (TypeInfo)fieldTypeInfoList.get(i));
        }
    }

    @Override
    public String vectorExpressionParameters() {
        String value;
        if (this.isNullValue) {
            value = "null";
        } else {
            switch (this.type) {
                case LONG: {
                    value = Long.toString(this.longValue);
                    break;
                }
                case DOUBLE: {
                    value = Double.toString(this.doubleValue);
                    break;
                }
                case BYTES: {
                    value = new String(this.bytesValue, StandardCharsets.UTF_8);
                    break;
                }
                case DECIMAL: {
                    value = this.decimalValue.toString();
                    break;
                }
                case TIMESTAMP: {
                    value = org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli((long)this.timestampValue.getTime(), (int)this.timestampValue.getNanos()).toString();
                    break;
                }
                case INTERVAL_DAY_TIME: {
                    value = this.intervalDayTimeValue.toString();
                    break;
                }
                case STRUCT: {
                    StringBuilder sb = new StringBuilder();
                    sb.append("STRUCT {");
                    boolean isFirst = true;
                    int size = this.structValue.length;
                    for (int i = 0; i < size; ++i) {
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            sb.append(", ");
                        }
                        sb.append(this.structValue[i].toString());
                    }
                    sb.append("}");
                    value = sb.toString();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown vector column type " + this.type);
                }
            }
        }
        return "val " + value;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().build();
    }

    public boolean getIsNullValue() {
        return this.isNullValue;
    }
}

