/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class ColOrCol
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int colNum1;
    private final int colNum2;

    public ColOrCol(int colNum1, int colNum2, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
    }

    public ColOrCol() {
        this.colNum1 = -1;
        this.colNum2 = -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector1 = (LongColumnVector)batch.cols[this.colNum1];
        LongColumnVector inputColVector2 = (LongColumnVector)batch.cols[this.colNum2];
        this.doEvaluate(batch, inputColVector1, inputColVector2);
    }

    protected void doEvaluate(VectorizedRowBatch batch, LongColumnVector inputColVector1, LongColumnVector inputColVector2) {
        int[] sel = batch.selected;
        int n = batch.size;
        long[] vector1 = inputColVector1.vector;
        long[] vector2 = inputColVector2.vector;
        LongColumnVector outV = (LongColumnVector)batch.cols[this.outputColumnNum];
        long[] outputVector = outV.vector;
        if (n <= 0) {
            return;
        }
        boolean[] outputIsNull = outV.isNull;
        outV.isRepeating = false;
        long vector1Value = vector1[0];
        long vector2Value = vector2[0];
        if (inputColVector1.noNulls && inputColVector2.noNulls) {
            if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                outV.isRepeating = true;
                outputIsNull[0] = false;
                outputVector[0] = vector1[0] | vector2[0];
            } else if (inputColVector1.isRepeating && !inputColVector2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        outputVector[i] = vector1Value | vector2[i];
                    }
                } else {
                    Arrays.fill(outputIsNull, 0, n, false);
                    for (int i = 0; i != n; ++i) {
                        outputVector[i] = vector1Value | vector2[i];
                    }
                }
            } else if (!inputColVector1.isRepeating && inputColVector2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        outputVector[i] = vector1[i] | vector2Value;
                    }
                } else {
                    Arrays.fill(outputIsNull, 0, n, false);
                    for (int i = 0; i != n; ++i) {
                        outputVector[i] = vector1[i] | vector2Value;
                    }
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = false;
                    outputVector[i] = vector1[i] | vector2[i];
                }
            } else {
                Arrays.fill(outputIsNull, 0, n, false);
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = vector1[i] | vector2[i];
                }
            }
            return;
        }
        outV.noNulls = false;
        if (inputColVector1.noNulls && !inputColVector2.noNulls) {
            if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                outV.isRepeating = true;
                outputVector[0] = vector1[0] | vector2[0];
                outputIsNull[0] = vector1[0] == 0L && inputColVector2.isNull[0];
            } else if (inputColVector1.isRepeating && !inputColVector2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = vector1Value | vector2[i];
                        outputIsNull[i] = vector1Value == 0L && inputColVector2.isNull[i];
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputVector[i] = vector1Value | vector2[i];
                        outputIsNull[i] = vector1Value == 0L && inputColVector2.isNull[i];
                    }
                }
            } else if (!inputColVector1.isRepeating && inputColVector2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = vector1[i] | vector2Value;
                        outputIsNull[i] = vector1[i] == 0L && inputColVector2.isNull[0];
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputVector[i] = vector1[i] | vector2Value;
                        outputIsNull[i] = vector1[i] == 0L && inputColVector2.isNull[0];
                    }
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = vector1[i] | vector2[i];
                    outputIsNull[i] = vector1[i] == 0L && inputColVector2.isNull[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = vector1[i] | vector2[i];
                    outputIsNull[i] = vector1[i] == 0L && inputColVector2.isNull[i];
                }
            }
        } else if (!inputColVector1.noNulls && inputColVector2.noNulls) {
            if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                outV.isRepeating = true;
                outputVector[0] = vector1[0] | vector2[0];
                outputIsNull[0] = inputColVector1.isNull[0] && vector2[0] == 0L;
            } else if (inputColVector1.isRepeating && !inputColVector2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = vector1Value | vector2[i];
                        outputIsNull[i] = inputColVector1.isNull[0] && vector2[i] == 0L;
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputVector[i] = vector1Value | vector2[i];
                        outputIsNull[i] = inputColVector1.isNull[0] && vector2[i] == 0L;
                    }
                }
            } else if (!inputColVector1.isRepeating && inputColVector2.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = vector1[i] | vector2Value;
                        outputIsNull[i] = inputColVector1.isNull[i] && vector2Value == 0L;
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        outputVector[i] = vector1[i] | vector2Value;
                        outputIsNull[i] = inputColVector1.isNull[i] && vector2Value == 0L;
                    }
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = vector1[i] | vector2[i];
                    outputIsNull[i] = inputColVector1.isNull[i] && vector2[i] == 0L;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = vector1[i] | vector2[i];
                    outputIsNull[i] = inputColVector1.isNull[i] && vector2[i] == 0L;
                }
            }
        } else if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            outV.isRepeating = true;
            outputVector[0] = vector1[0] | vector2[0];
            outputIsNull[0] = vector1[0] == 0L && inputColVector2.isNull[0] || inputColVector1.isNull[0] && vector2[0] == 0L || inputColVector1.isNull[0] && inputColVector2.isNull[0];
        } else if (inputColVector1.isRepeating && !inputColVector2.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = vector1Value | vector2[i];
                    outputIsNull[i] = vector1[0] == 0L && inputColVector2.isNull[i] || inputColVector1.isNull[0] && vector2[i] == 0L || inputColVector1.isNull[0] && inputColVector2.isNull[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = vector1Value | vector2[i];
                    outputIsNull[i] = vector1[0] == 0L && inputColVector2.isNull[i] || inputColVector1.isNull[0] && vector2[i] == 0L || inputColVector1.isNull[0] && inputColVector2.isNull[i];
                }
            }
        } else if (!inputColVector1.isRepeating && inputColVector2.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = vector1[i] | vector2Value;
                    outputIsNull[i] = vector1[i] == 0L && inputColVector2.isNull[0] || inputColVector1.isNull[i] && vector2[0] == 0L || inputColVector1.isNull[i] && inputColVector2.isNull[0];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = vector1[i] | vector2Value;
                    outputIsNull[i] = vector1[i] == 0L && inputColVector2.isNull[0] || inputColVector1.isNull[i] && vector2[0] == 0L || inputColVector1.isNull[i] && inputColVector2.isNull[0];
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outputVector[i] = vector1[i] | vector2[i];
                outputIsNull[i] = vector1[i] == 0L && inputColVector2.isNull[i] || inputColVector1.isNull[i] && vector2[i] == 0L || inputColVector1.isNull[i] && inputColVector2.isNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outputVector[i] = vector1[i] | vector2[i];
                outputIsNull[i] = vector1[i] == 0L && inputColVector2.isNull[i] || inputColVector1.isNull[i] && vector2[i] == 0L || inputColVector1.isNull[i] && inputColVector2.isNull[i];
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNum1) + ", " + this.getColumnParamString(1, this.colNum2);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("long"), VectorExpressionDescriptor.ArgumentType.getType("long")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

