/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressionsSupportDecimal64;
import org.apache.hadoop.hive.ql.exec.vector.expressions.BucketNumExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastBooleanToCharViaLongToChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastBooleanToStringViaLongToString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastBooleanToVarCharViaLongToVarChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastCharToBinary;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDateToChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDateToCharWithFormat;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDateToString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDateToStringWithFormat;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDateToVarChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDateToVarCharWithFormat;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToVarChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDoubleToChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDoubleToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDoubleToString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDoubleToVarChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastFloatToChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastFloatToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastFloatToString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastFloatToVarChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastLongToChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastLongToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastLongToDecimal64;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastLongToString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastLongToTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastLongToVarChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastMillisecondsLongToTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringGroupToChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringGroupToVarChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToBoolean;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToDateWithFormat;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToTimestampWithFormat;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToCharWithFormat;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToStringWithFormat;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToVarChar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToVarCharWithFormat;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ConstantVectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ConvertDecimal64ToDecimal;
import org.apache.hadoop.hive.ql.exec.vector.expressions.Decimal64ColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.DecimalColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.DoubleColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.DynamicValueVectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterConstantBooleanVectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterDecimal64ColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterDecimal64ColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterDecimal64ColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterDecimalColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterDoubleColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterExprAndExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterExprOrExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterLongColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterStringColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterStructColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterTimestampColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.GroupingColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.GroupingColumns;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IDecimalInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IDoubleInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ILongInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IStringInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IStructInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ITimestampInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IdentityExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IfExprColumnCondExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IfExprColumnNull;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IfExprCondExprBase;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IfExprCondExprColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IfExprCondExprCondExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IfExprCondExprNull;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IfExprNullColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IfExprNullCondExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IfExprNullNull;
import org.apache.hadoop.hive.ql.exec.vector.expressions.LongColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.MathFuncLongToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.SelectColumnIsTrue;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StructColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.TimestampColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.TruncStringOutput;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorCoalesce;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorElt;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastLongToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastLongToFloatViaLongToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CharColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CharColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.Decimal64ColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.Decimal64ColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DecimalColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.DoubleColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterCharColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterCharColumnBetweenDynamicValue;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterCharColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDateColumnBetweenDynamicValue;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDecimalColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDecimalColumnBetweenDynamicValue;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDecimalColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColumnBetweenDynamicValue;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterDoubleColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColumnBetweenDynamicValue;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterLongColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringColumnBetweenDynamicValue;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterStringColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterTimestampColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterTimestampColumnBetweenDynamicValue;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterTimestampColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterVarCharColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterVarCharColumnBetweenDynamicValue;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterVarCharColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.StringColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.StringColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.TimestampColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.TimestampColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.VarCharColumnBetween;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.VarCharColumnNotBetween;
import org.apache.hadoop.hive.ql.exec.vector.udf.VectorUDFAdaptor;
import org.apache.hadoop.hive.ql.exec.vector.udf.VectorUDFArgDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicValueDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.SettableUDF;
import org.apache.hadoop.hive.ql.udf.UDFAcos;
import org.apache.hadoop.hive.ql.udf.UDFAsin;
import org.apache.hadoop.hive.ql.udf.UDFAtan;
import org.apache.hadoop.hive.ql.udf.UDFConv;
import org.apache.hadoop.hive.ql.udf.UDFCos;
import org.apache.hadoop.hive.ql.udf.UDFDegrees;
import org.apache.hadoop.hive.ql.udf.UDFExp;
import org.apache.hadoop.hive.ql.udf.UDFHex;
import org.apache.hadoop.hive.ql.udf.UDFLn;
import org.apache.hadoop.hive.ql.udf.UDFLog;
import org.apache.hadoop.hive.ql.udf.UDFLog10;
import org.apache.hadoop.hive.ql.udf.UDFLog2;
import org.apache.hadoop.hive.ql.udf.UDFOPLongDivide;
import org.apache.hadoop.hive.ql.udf.UDFRadians;
import org.apache.hadoop.hive.ql.udf.UDFRand;
import org.apache.hadoop.hive.ql.udf.UDFRegExpExtract;
import org.apache.hadoop.hive.ql.udf.UDFRegExpReplace;
import org.apache.hadoop.hive.ql.udf.UDFSign;
import org.apache.hadoop.hive.ql.udf.UDFSin;
import org.apache.hadoop.hive.ql.udf.UDFSqrt;
import org.apache.hadoop.hive.ql.udf.UDFTan;
import org.apache.hadoop.hive.ql.udf.UDFToBoolean;
import org.apache.hadoop.hive.ql.udf.UDFToByte;
import org.apache.hadoop.hive.ql.udf.UDFToDouble;
import org.apache.hadoop.hive.ql.udf.UDFToFloat;
import org.apache.hadoop.hive.ql.udf.UDFToInteger;
import org.apache.hadoop.hive.ql.udf.UDFToLong;
import org.apache.hadoop.hive.ql.udf.UDFToShort;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAbs;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBRound;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseArithmetic;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseBinary;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseCompare;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBucketNumber;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCastFormat;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCbrt;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCeil;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCoalesce;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFElt;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFactorial;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFloor;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFromUnixTime;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFGreatest;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFGrouping;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIf;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLeast;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPDivide;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualNS;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMinus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMod;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMultiply;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNegative;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPlus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPositive;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPScaleUpDecimal64;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPosMod;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPower;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRound;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFStructField;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToBinary;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToChar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDecimal;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToIntervalDayTime;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToIntervalYearMonth;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToString;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUtcTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToVarchar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFWhen;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.BaseCharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hive.common.util.AnnotationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorizationContext {
    private static final Logger LOG = LoggerFactory.getLogger((String)VectorizationContext.class.getName());
    private final String contextName;
    private final int level;
    VectorExpressionDescriptor vMap;
    private final List<String> initialColumnNames;
    private List<TypeInfo> initialTypeInfos;
    private List<DataTypePhysicalVariation> initialDataTypePhysicalVariations;
    private List<Integer> projectedColumns;
    private List<String> projectionColumnNames;
    private Map<String, Integer> projectionColumnMap;
    private int firstOutputColumnIndex;
    private HiveVectorAdaptorUsageMode hiveVectorAdaptorUsageMode;
    private boolean testVectorAdaptorOverride;
    private HiveVectorIfStmtMode hiveVectorIfStmtMode;
    private boolean useCheckedVectorExpressions;
    private boolean reuseScratchColumns;
    private boolean adaptorSuppressEvaluateExceptions;
    public static final Pattern decimalTypePattern = Pattern.compile("decimal.*", 2);
    public static final Pattern charTypePattern = Pattern.compile("char.*", 2);
    public static final Pattern varcharTypePattern = Pattern.compile("varchar.*", 2);
    public static final Pattern charVarcharTypePattern = Pattern.compile("char.*|varchar.*", 2);
    public static final Pattern structTypePattern = Pattern.compile("struct.*", 2);
    public static final Pattern listTypePattern = Pattern.compile("array.*", 2);
    public static final Pattern mapTypePattern = Pattern.compile("map.*", 2);
    private OutputColumnManager ocm;
    boolean tryDecimal64Cast;
    private static final Set<Class<?>> castExpressionUdfs = new HashSet();
    private static final Set<Class<?>> udfsNeedingImplicitDecimalCast;
    private static final long[] POWEROFTENTABLE;
    private static final int STACK_LENGTH_LIMIT = 15;

    private void setHiveConfVars(HiveConf hiveConf) {
        this.hiveVectorAdaptorUsageMode = HiveVectorAdaptorUsageMode.getHiveConfValue(hiveConf);
        this.testVectorAdaptorOverride = HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEST_VECTOR_ADAPTOR_OVERRIDE);
        this.hiveVectorIfStmtMode = HiveVectorIfStmtMode.getHiveConfValue(hiveConf);
        this.reuseScratchColumns = HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_TESTING_REUSE_SCRATCH_COLUMNS);
        this.ocm.setReuseColumns(this.reuseScratchColumns);
        this.useCheckedVectorExpressions = HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_USE_CHECKED_EXPRESSIONS);
        this.adaptorSuppressEvaluateExceptions = HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZED_ADAPTOR_SUPPRESS_EVALUATE_EXCEPTIONS);
    }

    private void copyHiveConfVars(VectorizationContext vContextEnvironment) {
        this.hiveVectorAdaptorUsageMode = vContextEnvironment.hiveVectorAdaptorUsageMode;
        this.testVectorAdaptorOverride = vContextEnvironment.testVectorAdaptorOverride;
        this.hiveVectorIfStmtMode = vContextEnvironment.hiveVectorIfStmtMode;
        this.reuseScratchColumns = vContextEnvironment.reuseScratchColumns;
        this.useCheckedVectorExpressions = vContextEnvironment.useCheckedVectorExpressions;
        this.adaptorSuppressEvaluateExceptions = vContextEnvironment.adaptorSuppressEvaluateExceptions;
        this.ocm.setReuseColumns(this.reuseScratchColumns);
    }

    public VectorizationContext(String contextName, List<String> initialColumnNames, List<TypeInfo> initialTypeInfos, List<DataTypePhysicalVariation> initialDataTypePhysicalVariations, HiveConf hiveConf) {
        this.reuseScratchColumns = HiveConf.ConfVars.HIVE_VECTORIZATION_TESTING_REUSE_SCRATCH_COLUMNS.defaultBoolVal;
        this.contextName = contextName;
        this.level = 0;
        this.initialColumnNames = initialColumnNames;
        this.initialTypeInfos = initialTypeInfos;
        this.initialDataTypePhysicalVariations = initialDataTypePhysicalVariations;
        this.projectionColumnNames = initialColumnNames;
        this.projectedColumns = new ArrayList<Integer>();
        this.projectionColumnMap = new HashMap<String, Integer>();
        for (int i = 0; i < this.projectionColumnNames.size(); ++i) {
            this.projectedColumns.add(i);
            this.projectionColumnMap.put(this.projectionColumnNames.get(i), i);
        }
        int firstOutputColumnIndex = this.projectedColumns.size();
        this.ocm = new OutputColumnManager(firstOutputColumnIndex);
        this.firstOutputColumnIndex = firstOutputColumnIndex;
        this.vMap = new VectorExpressionDescriptor();
        if (hiveConf != null) {
            this.setHiveConfVars(hiveConf);
        }
        this.tryDecimal64Cast = false;
    }

    public VectorizationContext(String contextName, List<String> initialColumnNames, HiveConf hiveConf) {
        this.reuseScratchColumns = HiveConf.ConfVars.HIVE_VECTORIZATION_TESTING_REUSE_SCRATCH_COLUMNS.defaultBoolVal;
        this.contextName = contextName;
        this.level = 0;
        this.initialColumnNames = initialColumnNames;
        this.projectionColumnNames = initialColumnNames;
        this.projectedColumns = new ArrayList<Integer>();
        this.projectionColumnMap = new HashMap<String, Integer>();
        for (int i = 0; i < this.projectionColumnNames.size(); ++i) {
            this.projectedColumns.add(i);
            this.projectionColumnMap.put(this.projectionColumnNames.get(i), i);
        }
        int firstOutputColumnIndex = this.projectedColumns.size();
        this.ocm = new OutputColumnManager(firstOutputColumnIndex);
        this.firstOutputColumnIndex = firstOutputColumnIndex;
        this.vMap = new VectorExpressionDescriptor();
        if (hiveConf != null) {
            this.setHiveConfVars(hiveConf);
        }
        this.tryDecimal64Cast = false;
    }

    public VectorizationContext(String contextName, List<String> initialColumnNames, VectorizationContext vContextEnvironment) {
        this(contextName, initialColumnNames, (HiveConf)null);
        this.copyHiveConfVars(vContextEnvironment);
    }

    @VisibleForTesting
    public VectorizationContext(String contextName, List<String> initialColumnNames) {
        this(contextName, initialColumnNames, (HiveConf)null);
    }

    public VectorizationContext(String contextName, HiveConf hiveConf) {
        this.reuseScratchColumns = HiveConf.ConfVars.HIVE_VECTORIZATION_TESTING_REUSE_SCRATCH_COLUMNS.defaultBoolVal;
        this.contextName = contextName;
        this.level = 0;
        this.initialColumnNames = new ArrayList<String>();
        this.projectedColumns = new ArrayList<Integer>();
        this.projectionColumnNames = new ArrayList<String>();
        this.projectionColumnMap = new HashMap<String, Integer>();
        this.ocm = new OutputColumnManager(0);
        this.tryDecimal64Cast = false;
        this.firstOutputColumnIndex = 0;
        this.vMap = new VectorExpressionDescriptor();
        if (hiveConf != null) {
            this.setHiveConfVars(hiveConf);
        }
    }

    @VisibleForTesting
    public VectorizationContext(String contextName) {
        this(contextName, (HiveConf)null);
    }

    public VectorizationContext(String contextName, VectorizationContext vContext) {
        this.reuseScratchColumns = HiveConf.ConfVars.HIVE_VECTORIZATION_TESTING_REUSE_SCRATCH_COLUMNS.defaultBoolVal;
        this.contextName = contextName;
        this.level = vContext.level + 1;
        this.initialColumnNames = vContext.initialColumnNames;
        this.initialTypeInfos = vContext.initialTypeInfos;
        this.initialDataTypePhysicalVariations = vContext.initialDataTypePhysicalVariations;
        this.projectedColumns = new ArrayList<Integer>();
        this.projectionColumnNames = new ArrayList<String>();
        this.projectionColumnMap = new HashMap<String, Integer>();
        this.ocm = vContext.ocm;
        this.tryDecimal64Cast = false;
        this.firstOutputColumnIndex = vContext.firstOutputColumnIndex;
        this.vMap = new VectorExpressionDescriptor();
        this.copyHiveConfVars(vContext);
    }

    public void addInitialColumn(String columnName) {
        this.initialColumnNames.add(columnName);
        int index = this.projectedColumns.size();
        this.projectedColumns.add(index);
        this.projectionColumnNames.add(columnName);
        this.projectionColumnMap.put(columnName, index);
    }

    @VisibleForTesting
    public void finishedAddingInitialColumns() {
        int firstOutputColumnIndex = this.projectedColumns.size();
        this.ocm = new OutputColumnManager(firstOutputColumnIndex);
        this.ocm.setReuseColumns(this.reuseScratchColumns);
        this.firstOutputColumnIndex = firstOutputColumnIndex;
    }

    public void resetProjectionColumns() {
        this.projectedColumns = new ArrayList<Integer>();
        this.projectionColumnNames = new ArrayList<String>();
        this.projectionColumnMap = new HashMap<String, Integer>();
    }

    public void addProjectionColumn(String columnName, int vectorBatchColIndex) {
        if (vectorBatchColIndex < 0) {
            throw new RuntimeException("Negative projected column number");
        }
        this.projectedColumns.add(vectorBatchColIndex);
        this.projectionColumnNames.add(columnName);
        this.projectionColumnMap.put(columnName, vectorBatchColIndex);
    }

    public void setInitialTypeInfos(List<TypeInfo> initialTypeInfos) {
        this.initialTypeInfos = initialTypeInfos;
        int size = initialTypeInfos.size();
        this.initialDataTypePhysicalVariations = new ArrayList<DataTypePhysicalVariation>(size);
        for (int i = 0; i < size; ++i) {
            this.initialDataTypePhysicalVariations.add(DataTypePhysicalVariation.NONE);
        }
    }

    public void setInitialDataTypePhysicalVariations(List<DataTypePhysicalVariation> initialDataTypePhysicalVariations) {
        this.initialDataTypePhysicalVariations = initialDataTypePhysicalVariations;
    }

    public List<String> getInitialColumnNames() {
        return this.initialColumnNames;
    }

    public List<Integer> getProjectedColumns() {
        return this.projectedColumns;
    }

    public List<String> getProjectionColumnNames() {
        return this.projectionColumnNames;
    }

    public Map<String, Integer> getProjectionColumnMap() {
        return this.projectionColumnMap;
    }

    public TypeInfo[] getInitialTypeInfos() {
        return this.initialTypeInfos.toArray(new TypeInfo[0]);
    }

    public TypeInfo getTypeInfo(int columnNum) throws HiveException {
        if (this.initialTypeInfos == null) {
            throw new HiveException("initialTypeInfos array is null in contextName " + this.contextName);
        }
        int initialSize = this.initialTypeInfos.size();
        if (columnNum < initialSize) {
            return this.initialTypeInfos.get(columnNum);
        }
        String typeName = this.ocm.getScratchTypeName(columnNum);
        if ((typeName = VectorizationContext.mapTypeNameSynonyms(typeName)).equals("char")) {
            typeName = "char(255)";
        } else if (typeName.equals("varchar")) {
            typeName = "varchar(65535)";
        }
        return TypeInfoUtils.getTypeInfoFromTypeString((String)typeName);
    }

    public DataTypePhysicalVariation getDataTypePhysicalVariation(int columnNum) throws HiveException {
        if (this.initialDataTypePhysicalVariations == null) {
            return null;
        }
        if (columnNum < this.initialDataTypePhysicalVariations.size()) {
            return this.initialDataTypePhysicalVariations.get(columnNum);
        }
        return this.ocm.getDataTypePhysicalVariation(columnNum);
    }

    public TypeInfo[] getAllTypeInfos() throws HiveException {
        int size = this.initialTypeInfos.size() + this.ocm.outputColCount;
        TypeInfo[] result = new TypeInfo[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.getTypeInfo(i);
        }
        return result;
    }

    protected boolean needsImplicitCastForDecimal(GenericUDF udf) {
        Class<Object> udfClass = udf.getClass();
        if (udf instanceof GenericUDFBridge) {
            udfClass = ((GenericUDFBridge)udf).getUdfClass();
        }
        return udfsNeedingImplicitDecimalCast.contains(udfClass);
    }

    public int getInputColumnIndex(String name) throws HiveException {
        if (name == null) {
            throw new HiveException("Null column name");
        }
        if (!this.projectionColumnMap.containsKey(name)) {
            throw new HiveException(String.format("The column %s is not in the vectorization context column map %s.", name, this.projectionColumnMap.toString()));
        }
        int projectedColumnNum = this.projectionColumnMap.get(name);
        if (projectedColumnNum < 0) {
            throw new HiveException("Negative projected column number");
        }
        return projectedColumnNum;
    }

    protected int getInputColumnIndex(ExprNodeColumnDesc colExpr) throws HiveException {
        return this.getInputColumnIndex(colExpr.getColumn());
    }

    public int allocateScratchColumn(TypeInfo typeInfo) throws HiveException {
        return this.ocm.allocateOutputColumn(typeInfo);
    }

    public int[] currentScratchColumns() {
        return this.ocm.currentScratchColumns();
    }

    public void markActualScratchColumns() {
        this.ocm.markScratchColumns();
    }

    public void freeMarkedScratchColumns() {
        this.ocm.freeMarkedScratchColumns();
    }

    private VectorExpression getFilterOnBooleanColumnExpression(ExprNodeColumnDesc exprDesc, int columnNum) throws HiveException {
        VectorExpression expr;
        TypeInfo typeInfo = exprDesc.getTypeInfo();
        if (typeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE && ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN) {
            expr = new SelectColumnIsTrue(columnNum);
            expr.setInputTypeInfos(typeInfo);
            expr.setInputDataTypePhysicalVariations(DataTypePhysicalVariation.NONE);
        } else {
            List<ExprNodeDesc> exprAsList = Collections.singletonList(exprDesc);
            expr = this.getCastToBooleanExpression(exprAsList, VectorExpressionDescriptor.Mode.FILTER);
            if (expr == null) {
                throw new HiveException("Cannot vectorize converting expression " + exprDesc.getExprString() + " to boolean");
            }
        }
        return expr;
    }

    private VectorExpression getColumnVectorExpression(ExprNodeColumnDesc exprDesc, VectorExpressionDescriptor.Mode mode) throws HiveException {
        VectorExpression expr;
        int columnNum = this.getInputColumnIndex(exprDesc.getColumn());
        switch (mode) {
            case FILTER: {
                expr = this.getFilterOnBooleanColumnExpression(exprDesc, columnNum);
                break;
            }
            case PROJECTION: {
                expr = new IdentityExpression(columnNum);
                TypeInfo identityTypeInfo = exprDesc.getTypeInfo();
                DataTypePhysicalVariation identityDataTypePhysicalVariation = this.getDataTypePhysicalVariation(columnNum);
                expr.setInputTypeInfos(identityTypeInfo);
                expr.setInputDataTypePhysicalVariations(identityDataTypePhysicalVariation);
                expr.setOutputTypeInfo(identityTypeInfo);
                expr.setOutputDataTypePhysicalVariation(identityDataTypePhysicalVariation);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected mode " + (Object)((Object)mode));
            }
        }
        return expr;
    }

    public VectorExpression[] getVectorExpressionsUpConvertDecimal64(List<ExprNodeDesc> exprNodes) throws HiveException {
        VectorExpression[] vecExprs = this.getVectorExpressions(exprNodes, VectorExpressionDescriptor.Mode.PROJECTION);
        int size = vecExprs.length;
        for (int i = 0; i < size; ++i) {
            VectorExpression vecExpr = vecExprs[i];
            if (vecExpr.getOutputColumnVectorType() != ColumnVector.Type.DECIMAL_64) continue;
            vecExprs[i] = this.wrapWithDecimal64ToDecimalConversion(vecExpr);
        }
        return vecExprs;
    }

    public VectorExpression[] getVectorExpressions(List<ExprNodeDesc> exprNodes) throws HiveException {
        return this.getVectorExpressions(exprNodes, VectorExpressionDescriptor.Mode.PROJECTION);
    }

    public VectorExpression[] getVectorExpressions(List<ExprNodeDesc> exprNodes, VectorExpressionDescriptor.Mode mode) throws HiveException {
        int i = 0;
        if (null == exprNodes) {
            return new VectorExpression[0];
        }
        VectorExpression[] ret = new VectorExpression[exprNodes.size()];
        for (ExprNodeDesc e : exprNodes) {
            ret[i++] = this.getVectorExpression(e, mode);
        }
        return ret;
    }

    public VectorExpression getVectorExpression(ExprNodeDesc exprDesc) throws HiveException {
        return this.getVectorExpression(exprDesc, VectorExpressionDescriptor.Mode.PROJECTION);
    }

    public VectorExpression getVectorExpression(ExprNodeDesc exprDesc, VectorExpressionDescriptor.Mode mode) throws HiveException {
        VectorExpression ve = null;
        if (exprDesc instanceof ExprNodeColumnDesc) {
            ve = this.getColumnVectorExpression((ExprNodeColumnDesc)exprDesc, mode);
        } else if (exprDesc instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc childExpr;
            ExprNodeDesc child;
            ExprNodeGenericFuncDesc expr = (ExprNodeGenericFuncDesc)exprDesc;
            if ("not".equals(expr.getFuncText()) && expr.getChildren() != null && expr.getChildren().size() == 1 && (child = expr.getChildren().get(0)) instanceof ExprNodeGenericFuncDesc && "between".equals((childExpr = (ExprNodeGenericFuncDesc)child).getFuncText())) {
                ExprNodeConstantDesc flag = (ExprNodeConstantDesc)childExpr.getChildren().get(0);
                ArrayList<ExprNodeDesc> newChildren = new ArrayList<ExprNodeDesc>();
                if (Boolean.TRUE.equals(flag.getValue())) {
                    newChildren.add(new ExprNodeConstantDesc(Boolean.FALSE));
                } else {
                    newChildren.add(new ExprNodeConstantDesc(Boolean.TRUE));
                }
                newChildren.addAll(childExpr.getChildren().subList(1, childExpr.getChildren().size()));
                expr.setTypeInfo(childExpr.getTypeInfo());
                expr.setGenericUDF(childExpr.getGenericUDF());
                expr.setChildren(newChildren);
            }
            List<ExprNodeDesc> childExpressions = this.getChildExpressionsWithImplicitCast(expr.getGenericUDF(), exprDesc.getChildren(), exprDesc.getTypeInfo());
            if (!this.testVectorAdaptorOverride) {
                ve = this.getGenericUdfVectorExpression(expr.getGenericUDF(), childExpressions, mode, exprDesc.getTypeInfo());
            }
            if (ve == null && this.hiveVectorAdaptorUsageMode != null) {
                switch (this.hiveVectorAdaptorUsageMode) {
                    case NONE: {
                        throw new HiveException("Could not vectorize expression (mode = " + mode.name() + "): " + exprDesc.toString() + " because hive.vectorized.adaptor.usage.mode=none");
                    }
                    case CHOSEN: {
                        if (VectorizationContext.isNonVectorizedPathUDF(expr, mode)) {
                            ve = this.getCustomUDFExpression(expr, mode);
                            break;
                        }
                        throw new HiveException("Could not vectorize expression (mode = " + mode.name() + "): " + exprDesc.toString() + " because hive.vectorized.adaptor.usage.mode=chosen and the UDF wasn't one of the chosen ones");
                    }
                    case ALL: {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("We will try to use the VectorUDFAdaptor for " + exprDesc.toString() + " because hive.vectorized.adaptor.usage.mode=all");
                        }
                        ve = this.getCustomUDFExpression(expr, mode);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown hive vector adaptor usage mode " + this.hiveVectorAdaptorUsageMode.name());
                    }
                }
                if (ve == null) {
                    throw new HiveException("Unable vectorize expression (mode = " + mode.name() + "): " + exprDesc.toString() + " even for the VectorUDFAdaptor");
                }
            }
        } else if (exprDesc instanceof ExprNodeConstantDesc) {
            ve = this.getConstantVectorExpression(((ExprNodeConstantDesc)exprDesc).getValue(), exprDesc.getTypeInfo(), mode);
        } else if (exprDesc instanceof ExprNodeDynamicValueDesc) {
            ve = this.getDynamicValueVectorExpression((ExprNodeDynamicValueDesc)exprDesc, mode);
        } else if (exprDesc instanceof ExprNodeFieldDesc) {
            ve = this.getGenericUDFStructField((ExprNodeFieldDesc)exprDesc, mode, exprDesc.getTypeInfo());
        }
        if (ve == null) {
            throw new HiveException("Could not vectorize expression (mode = " + mode.name() + "): " + exprDesc.toString());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Input Expression = " + exprDesc.toString() + ", Vectorized Expression = " + ve.toString());
        }
        return ve;
    }

    private VectorExpression getGenericUDFStructField(ExprNodeFieldDesc exprNodeFieldDesc, VectorExpressionDescriptor.Mode mode, TypeInfo returnType) throws HiveException {
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>(2);
        children.add(exprNodeFieldDesc.getDesc());
        children.add(new ExprNodeConstantDesc(this.getStructFieldIndex(exprNodeFieldDesc)));
        return this.getVectorExpressionForUdf(null, GenericUDFStructField.class, children, mode, returnType);
    }

    private int getStructFieldIndex(ExprNodeFieldDesc exprNodeFieldDesc) throws HiveException {
        ExprNodeDesc structNodeDesc = exprNodeFieldDesc.getDesc();
        String fieldName = exprNodeFieldDesc.getFieldName();
        StructTypeInfo structTypeInfo = (StructTypeInfo)structNodeDesc.getTypeInfo();
        int index = 0;
        boolean isFieldExist = false;
        for (String fn : structTypeInfo.getAllStructFieldNames()) {
            if (fieldName.equals(fn)) {
                isFieldExist = true;
                break;
            }
            ++index;
        }
        if (isFieldExist) {
            return index;
        }
        throw new HiveException("Could not vectorize expression:" + exprNodeFieldDesc.toString() + ", the field " + fieldName + " doesn't exist.");
    }

    private TypeInfo getCommonTypeForChildExpressions(GenericUDF genericUdf, List<ExprNodeDesc> children, TypeInfo returnType) throws HiveException {
        TypeInfo commonType;
        if (genericUdf instanceof GenericUDFBaseCompare) {
            TypeInfo tRight;
            TypeInfo tLeft = children.get(0).getTypeInfo();
            commonType = FunctionRegistry.getCommonClassForComparison(tLeft, tRight = children.get(1).getTypeInfo());
            if (commonType == null) {
                commonType = returnType;
            }
        } else {
            if (genericUdf instanceof GenericUDFIn) {
                TypeInfo colTi = children.get(0).getTypeInfo();
                if (colTi.getCategory() != ObjectInspector.Category.PRIMITIVE) {
                    return colTi;
                }
                TypeInfo opTi = GenericUDFUtils.deriveInType(children);
                if (opTi == null || opTi.getCategory() != ObjectInspector.Category.PRIMITIVE) {
                    throw new HiveException("Cannot vectorize IN() - common type is " + opTi);
                }
                if (((PrimitiveTypeInfo)colTi).getPrimitiveCategory() != ((PrimitiveTypeInfo)opTi).getPrimitiveCategory()) {
                    throw new HiveException("Cannot vectorize IN() - casting a column is not supported. Column type is " + colTi + " but the common type is " + opTi);
                }
                return colTi;
            }
            commonType = returnType;
        }
        return commonType;
    }

    private List<ExprNodeDesc> getChildExpressionsWithImplicitCast(GenericUDF genericUDF, List<ExprNodeDesc> children, TypeInfo returnType) throws HiveException {
        if (VectorizationContext.isCustomUDF(genericUDF.getUdfName())) {
            return children;
        }
        if (this.isExcludedFromCast(genericUDF)) {
            return children;
        }
        if (children == null) {
            return null;
        }
        TypeInfo commonType = this.getCommonTypeForChildExpressions(genericUDF, children, returnType);
        if (commonType == null) {
            return children;
        }
        ArrayList<ExprNodeDesc> childrenWithCasts = new ArrayList<ExprNodeDesc>();
        boolean atleastOneCastNeeded = false;
        if (genericUDF instanceof GenericUDFElt) {
            int i = 0;
            for (ExprNodeDesc child : children) {
                ExprNodeDesc castExpression;
                TypeInfo castType = commonType;
                if (i++ == 0) {
                    Object object = castType = VectorizationContext.isIntFamily(child.getTypeString()) ? child.getTypeInfo() : TypeInfoFactory.intTypeInfo;
                }
                if ((castExpression = this.getImplicitCastExpression(genericUDF, child, castType)) != null) {
                    atleastOneCastNeeded = true;
                    childrenWithCasts.add(castExpression);
                    continue;
                }
                childrenWithCasts.add(child);
            }
        } else if (genericUDF instanceof GenericUDFIf) {
            int i = 0;
            for (ExprNodeDesc child : children) {
                if (i++ == 0) {
                    childrenWithCasts.add(child);
                    continue;
                }
                if (child instanceof ExprNodeConstantDesc && ((ExprNodeConstantDesc)child).getValue() == null) {
                    childrenWithCasts.add(new ExprNodeConstantDesc(commonType, null));
                    atleastOneCastNeeded = true;
                    continue;
                }
                ExprNodeDesc castExpression = this.getImplicitCastExpression(genericUDF, child, commonType);
                if (castExpression != null) {
                    atleastOneCastNeeded = true;
                    childrenWithCasts.add(castExpression);
                    continue;
                }
                childrenWithCasts.add(child);
            }
        } else if (genericUDF instanceof GenericUDFWhen) {
            boolean hasElseClause = children.size() % 2 == 1;
            for (int i = 0; i < children.size(); ++i) {
                ExprNodeDesc castExpression = null;
                if (i % 2 == 1) {
                    castExpression = this.getImplicitCastExpression(genericUDF, children.get(i), commonType);
                }
                if (hasElseClause && i == children.size() - 1) {
                    castExpression = this.getImplicitCastExpression(genericUDF, children.get(i), commonType);
                }
                if (castExpression != null) {
                    atleastOneCastNeeded = true;
                    childrenWithCasts.add(castExpression);
                    continue;
                }
                childrenWithCasts.add(children.get(i));
            }
        } else {
            for (ExprNodeDesc child : children) {
                ExprNodeDesc castExpression = this.getImplicitCastExpression(genericUDF, child, commonType);
                if (castExpression != null) {
                    atleastOneCastNeeded = true;
                    childrenWithCasts.add(castExpression);
                    continue;
                }
                childrenWithCasts.add(child);
            }
        }
        if (atleastOneCastNeeded) {
            return childrenWithCasts;
        }
        return children;
    }

    private boolean isExcludedFromCast(GenericUDF genericUDF) {
        boolean ret;
        boolean bl = ret = castExpressionUdfs.contains(genericUDF.getClass()) || genericUDF instanceof GenericUDFRound || genericUDF instanceof GenericUDFBetween;
        if (ret) {
            return true;
        }
        if (genericUDF instanceof GenericUDFBridge) {
            Class<? extends UDF> udfClass = ((GenericUDFBridge)genericUDF).getUdfClass();
            return castExpressionUdfs.contains(udfClass) || UDFSign.class.isAssignableFrom(udfClass);
        }
        return false;
    }

    private TypeInfo updatePrecision(TypeInfo inputTypeInfo, DecimalTypeInfo returnType) {
        if (!(inputTypeInfo instanceof PrimitiveTypeInfo)) {
            return returnType;
        }
        PrimitiveTypeInfo ptinfo = (PrimitiveTypeInfo)inputTypeInfo;
        int precision = this.getPrecisionForType(ptinfo);
        int scale = HiveDecimalUtils.getScaleForType((PrimitiveTypeInfo)ptinfo);
        return new DecimalTypeInfo(precision, scale);
    }

    private ExprNodeDesc getImplicitCastExpression(GenericUDF udf, ExprNodeDesc child, TypeInfo castType) throws HiveException {
        String castTypeString;
        TypeInfo inputTypeInfo = child.getTypeInfo();
        String inputTypeString = inputTypeInfo.getTypeName();
        if (inputTypeString.equals(castTypeString = castType.getTypeName())) {
            return null;
        }
        boolean inputTypeDecimal = false;
        boolean castTypeDecimal = false;
        if (decimalTypePattern.matcher(inputTypeString).matches()) {
            inputTypeDecimal = true;
        }
        if (decimalTypePattern.matcher(castTypeString).matches()) {
            castTypeDecimal = true;
        }
        if (castTypeDecimal && !inputTypeDecimal) {
            if (this.needsImplicitCastForDecimal(udf)) {
                castType = this.updatePrecision(inputTypeInfo, (DecimalTypeInfo)castType);
                GenericUDFToDecimal castToDecimalUDF = new GenericUDFToDecimal();
                castToDecimalUDF.setTypeInfo(castType);
                ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
                children.add(child);
                return new ExprNodeGenericFuncDesc(castType, (GenericUDF)castToDecimalUDF, children);
            }
        } else if (!castTypeDecimal && inputTypeDecimal) {
            if (this.needsImplicitCastForDecimal(udf)) {
                GenericUDF genericUdf = VectorizationContext.getGenericUDFForCast(castType);
                ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
                children.add(child);
                return new ExprNodeGenericFuncDesc(castType, genericUdf, children);
            }
        } else if (udf instanceof GenericUDFCoalesce || udf instanceof GenericUDFElt || udf instanceof GenericUDFIf) {
            GenericUDF genericUdf = VectorizationContext.getGenericUDFForCast(castType);
            ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
            children.add(child);
            return new ExprNodeGenericFuncDesc(castType, genericUdf, children);
        }
        return null;
    }

    private int getPrecisionForType(PrimitiveTypeInfo typeInfo) {
        if (VectorizationContext.isFloatFamily(typeInfo.getTypeName())) {
            return 38;
        }
        return HiveDecimalUtils.getPrecisionForType((PrimitiveTypeInfo)typeInfo);
    }

    public static GenericUDF getGenericUDFForCast(TypeInfo castType) throws HiveException {
        UDF udfClass = null;
        GenericUDF genericUdf = null;
        switch (((PrimitiveTypeInfo)castType).getPrimitiveCategory()) {
            case BYTE: {
                udfClass = new UDFToByte();
                break;
            }
            case SHORT: {
                udfClass = new UDFToShort();
                break;
            }
            case INT: {
                udfClass = new UDFToInteger();
                break;
            }
            case LONG: {
                udfClass = new UDFToLong();
                break;
            }
            case FLOAT: {
                udfClass = new UDFToFloat();
                break;
            }
            case DOUBLE: {
                udfClass = new UDFToDouble();
                break;
            }
            case STRING: {
                genericUdf = new GenericUDFToString();
                break;
            }
            case CHAR: {
                genericUdf = new GenericUDFToChar();
                break;
            }
            case VARCHAR: {
                genericUdf = new GenericUDFToVarchar();
                break;
            }
            case BOOLEAN: {
                udfClass = new UDFToBoolean();
                break;
            }
            case DATE: {
                genericUdf = new GenericUDFToDate();
                break;
            }
            case TIMESTAMP: {
                genericUdf = new GenericUDFTimestamp();
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                genericUdf = new GenericUDFToIntervalYearMonth();
                break;
            }
            case INTERVAL_DAY_TIME: {
                genericUdf = new GenericUDFToIntervalDayTime();
                break;
            }
            case BINARY: {
                genericUdf = new GenericUDFToBinary();
                break;
            }
            case DECIMAL: {
                genericUdf = new GenericUDFToDecimal();
                break;
            }
        }
        if (genericUdf == null) {
            if (udfClass == null) {
                throw new HiveException("Could not add implicit cast for type " + castType.getTypeName());
            }
            GenericUDFBridge genericUDFBridge = new GenericUDFBridge();
            genericUDFBridge.setUdfClassName(udfClass.getClass().getName());
            genericUDFBridge.setUdfName(udfClass.getClass().getSimpleName());
            genericUdf = genericUDFBridge;
        }
        if (genericUdf instanceof SettableUDF) {
            ((SettableUDF)((Object)genericUdf)).setTypeInfo(castType);
        }
        return genericUdf;
    }

    public static boolean isNonVectorizedPathUDF(ExprNodeGenericFuncDesc expr, VectorExpressionDescriptor.Mode mode) {
        GenericUDF gudf = expr.getGenericUDF();
        if (gudf instanceof GenericUDFBridge) {
            GenericUDFBridge bridge = (GenericUDFBridge)gudf;
            Class<? extends UDF> udfClass = bridge.getUdfClass();
            return udfClass.equals(UDFHex.class) || udfClass.equals(UDFRegExpExtract.class) || udfClass.equals(UDFRegExpReplace.class) || udfClass.equals(UDFConv.class) || VectorizationContext.isCastToIntFamily(udfClass) && VectorizationContext.isStringFamily(VectorizationContext.arg0Type(expr)) || VectorizationContext.isCastToFloatFamily(udfClass) && VectorizationContext.isStringFamily(VectorizationContext.arg0Type(expr));
        }
        if (gudf instanceof GenericUDFFromUnixTime && VectorizationContext.isIntFamily(VectorizationContext.arg0Type(expr)) || gudf instanceof GenericUDFTimestamp && VectorizationContext.isStringFamily(VectorizationContext.arg0Type(expr)) || gudf instanceof GenericUDFCase || gudf instanceof GenericUDFWhen) {
            return true;
        }
        if ((gudf instanceof GenericUDFToString || gudf instanceof GenericUDFToChar || gudf instanceof GenericUDFToVarchar) && (VectorizationContext.arg0Type(expr).equals("timestamp") || VectorizationContext.arg0Type(expr).equals("double") || VectorizationContext.arg0Type(expr).equals("float"))) {
            return true;
        }
        return gudf instanceof GenericUDFBetween && mode == VectorExpressionDescriptor.Mode.PROJECTION;
    }

    public static boolean isCastToIntFamily(Class<? extends UDF> udfClass) {
        return udfClass.equals(UDFToByte.class) || udfClass.equals(UDFToShort.class) || udfClass.equals(UDFToInteger.class) || udfClass.equals(UDFToLong.class);
    }

    public static boolean isCastToBoolean(Class<? extends UDF> udfClass) {
        return udfClass.equals(UDFToBoolean.class);
    }

    public static boolean isCastToFloatFamily(Class<? extends UDF> udfClass) {
        return udfClass.equals(UDFToDouble.class) || udfClass.equals(UDFToFloat.class);
    }

    public static String arg0Type(ExprNodeGenericFuncDesc expr) {
        return expr.getChildren().get(0).getTypeString();
    }

    public static boolean isCustomUDF(ExprNodeGenericFuncDesc expr) {
        return VectorizationContext.isCustomUDF(expr.getFuncText());
    }

    private static boolean isCustomUDF(String udfName) {
        FunctionInfo funcInfo;
        if (udfName == null) {
            return false;
        }
        try {
            funcInfo = FunctionRegistry.getFunctionInfo(udfName);
        }
        catch (SemanticException e) {
            LOG.warn("Failed to load " + udfName, (Throwable)e);
            funcInfo = null;
        }
        if (funcInfo == null) {
            return false;
        }
        boolean isNativeFunc = funcInfo.isNative();
        return !isNativeFunc;
    }

    ExprNodeDesc evaluateCastOnConstants(ExprNodeDesc exprDesc) throws HiveException {
        if (!(exprDesc instanceof ExprNodeGenericFuncDesc)) {
            return exprDesc;
        }
        if (exprDesc.getChildren() == null || exprDesc.getChildren().size() != 1) {
            return exprDesc;
        }
        ExprNodeConstantDesc foldedChild = null;
        if (!(exprDesc.getChildren().get(0) instanceof ExprNodeConstantDesc)) {
            ExprNodeDesc expr = this.evaluateCastOnConstants(exprDesc.getChildren().get(0));
            if (expr instanceof ExprNodeConstantDesc) {
                foldedChild = (ExprNodeConstantDesc)expr;
            }
        } else {
            foldedChild = (ExprNodeConstantDesc)exprDesc.getChildren().get(0);
        }
        if (foldedChild == null) {
            return exprDesc;
        }
        ConstantObjectInspector childoi = foldedChild.getWritableObjectInspector();
        GenericUDF gudf = ((ExprNodeGenericFuncDesc)exprDesc).getGenericUDF();
        if (gudf instanceof GenericUDFOPNegative || gudf instanceof GenericUDFOPPositive || castExpressionUdfs.contains(gudf.getClass()) || gudf instanceof GenericUDFBridge && castExpressionUdfs.contains(((GenericUDFBridge)gudf).getUdfClass())) {
            ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get(exprDesc);
            ObjectInspector output = evaluator.initialize((ObjectInspector)childoi);
            Object constant = evaluator.evaluate(null);
            Object java = ObjectInspectorUtils.copyToStandardJavaObject((Object)constant, (ObjectInspector)output);
            return new ExprNodeConstantDesc(exprDesc.getTypeInfo(), java);
        }
        return exprDesc;
    }

    private List<ExprNodeDesc> evaluateCastOnConstants(List<ExprNodeDesc> childExpr) throws HiveException {
        ArrayList<ExprNodeDesc> evaluatedChildren = new ArrayList<ExprNodeDesc>();
        if (childExpr != null) {
            for (ExprNodeDesc expr : childExpr) {
                expr = this.evaluateCastOnConstants(expr);
                evaluatedChildren.add(expr);
            }
        }
        return evaluatedChildren;
    }

    private VectorExpression getConstantVectorExpression(Object constantValue, TypeInfo typeInfo, VectorExpressionDescriptor.Mode mode) throws HiveException {
        String typeName = typeInfo.getTypeName();
        VectorExpressionDescriptor.ArgumentType vectorArgType = VectorExpressionDescriptor.ArgumentType.fromHiveTypeName(typeName);
        if (vectorArgType == VectorExpressionDescriptor.ArgumentType.NONE) {
            throw new HiveException("No vector argument type for type name " + typeName);
        }
        int outCol = -1;
        if (mode == VectorExpressionDescriptor.Mode.PROJECTION) {
            outCol = this.ocm.allocateOutputColumn(typeInfo);
        }
        if (constantValue == null) {
            if (typeInfo.getCategory() != ObjectInspector.Category.PRIMITIVE) {
                throw new HiveException("Complex type constants (" + typeInfo.getCategory() + ") not supported for type name " + typeName);
            }
            if (mode == VectorExpressionDescriptor.Mode.FILTER) {
                return new FilterConstantBooleanVectorExpression(0L);
            }
            return new ConstantVectorExpression(outCol, typeInfo, true);
        }
        if (typeName.equalsIgnoreCase("boolean")) {
            if (mode == VectorExpressionDescriptor.Mode.FILTER) {
                if (((Boolean)constantValue).booleanValue()) {
                    return new FilterConstantBooleanVectorExpression(1L);
                }
                return new FilterConstantBooleanVectorExpression(0L);
            }
            if (((Boolean)constantValue).booleanValue()) {
                return new ConstantVectorExpression(outCol, 1L, typeInfo);
            }
            return new ConstantVectorExpression(outCol, 0L, typeInfo);
        }
        return ConstantVectorExpression.create(outCol, constantValue, typeInfo);
    }

    private VectorExpression getDynamicValueVectorExpression(ExprNodeDynamicValueDesc dynamicValueExpr, VectorExpressionDescriptor.Mode mode) throws HiveException {
        String typeName = dynamicValueExpr.getTypeInfo().getTypeName();
        VectorExpressionDescriptor.ArgumentType vectorArgType = VectorExpressionDescriptor.ArgumentType.fromHiveTypeName(typeName);
        if (vectorArgType == VectorExpressionDescriptor.ArgumentType.NONE) {
            throw new HiveException("No vector argument type for type name " + typeName);
        }
        int outCol = -1;
        if (mode == VectorExpressionDescriptor.Mode.PROJECTION) {
            outCol = this.ocm.allocateOutputColumn(dynamicValueExpr.getTypeInfo());
        }
        return new DynamicValueVectorExpression(outCol, dynamicValueExpr.getTypeInfo(), dynamicValueExpr.getDynamicValue());
    }

    private VectorExpression getIdentityExpression(List<ExprNodeDesc> childExprList) throws HiveException {
        if (childExprList.size() != 1) {
            return null;
        }
        ExprNodeDesc childExpr = childExprList.get(0);
        if (!(childExpr instanceof ExprNodeColumnDesc)) {
            return this.getVectorExpression(childExpr);
        }
        ExprNodeColumnDesc colDesc = (ExprNodeColumnDesc)childExpr;
        int identityCol = this.getInputColumnIndex(colDesc.getColumn());
        TypeInfo identityTypeInfo = colDesc.getTypeInfo();
        DataTypePhysicalVariation identityDataTypePhysicalVariation = this.getDataTypePhysicalVariation(identityCol);
        IdentityExpression ve = new IdentityExpression(identityCol);
        ve.setInputTypeInfos(identityTypeInfo);
        ve.setInputDataTypePhysicalVariations(identityDataTypePhysicalVariation);
        ve.setOutputTypeInfo(identityTypeInfo);
        ve.setOutputDataTypePhysicalVariation(identityDataTypePhysicalVariation);
        return ve;
    }

    private boolean checkExprNodeDescForDecimal64(ExprNodeDesc exprNodeDesc) throws HiveException {
        if (exprNodeDesc instanceof ExprNodeColumnDesc) {
            int colIndex = this.getInputColumnIndex((ExprNodeColumnDesc)exprNodeDesc);
            DataTypePhysicalVariation dataTypePhysicalVariation = this.getDataTypePhysicalVariation(colIndex);
            return dataTypePhysicalVariation == DataTypePhysicalVariation.DECIMAL_64;
        }
        if (exprNodeDesc instanceof ExprNodeGenericFuncDesc) {
            TypeInfo returnType = exprNodeDesc.getTypeInfo();
            if (!this.checkTypeInfoForDecimal64(returnType)) {
                return false;
            }
            DecimalTypeInfo returnDecimalType = (DecimalTypeInfo)returnType;
            GenericUDF udf = ((ExprNodeGenericFuncDesc)exprNodeDesc).getGenericUDF();
            Class<?> udfClass = udf.getClass();
            if (udf instanceof GenericUDFToDecimal) {
                return true;
            }
            VectorizedExpressionsSupportDecimal64 annotation = (VectorizedExpressionsSupportDecimal64)AnnotationUtils.getAnnotation(udfClass, VectorizedExpressionsSupportDecimal64.class);
            if (annotation == null) {
                return false;
            }
            List<ExprNodeDesc> children = exprNodeDesc.getChildren();
            for (ExprNodeDesc childExprNodeDesc : children) {
                if (childExprNodeDesc instanceof ExprNodeConstantDesc) {
                    DecimalTypeInfo childDecimalTypeInfo = this.decimalTypeFromCastToDecimal(childExprNodeDesc, returnDecimalType);
                    if (childDecimalTypeInfo == null) {
                        return false;
                    }
                    if (this.checkTypeInfoForDecimal64((TypeInfo)childDecimalTypeInfo)) continue;
                    return false;
                }
                if (this.checkExprNodeDescForDecimal64(childExprNodeDesc)) continue;
                return false;
            }
            return true;
        }
        if (exprNodeDesc instanceof ExprNodeConstantDesc) {
            return this.checkTypeInfoForDecimal64(exprNodeDesc.getTypeInfo());
        }
        return false;
    }

    private boolean checkTypeInfoForDecimal64(TypeInfo typeInfo) {
        if (typeInfo instanceof DecimalTypeInfo) {
            DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
            return HiveDecimalWritable.isPrecisionDecimal64((int)decimalTypeInfo.precision());
        }
        return false;
    }

    private VectorExpression getDecimal64VectorExpressionForUdf(GenericUDF genericUdf, Class<?> udfClass, List<ExprNodeDesc> childExprs, int numChildren, VectorExpressionDescriptor.Mode mode, TypeInfo returnTypeInfo) throws HiveException {
        VectorExpressionDescriptor.Descriptor descriptor;
        Class<?> vectorClass;
        DataTypePhysicalVariation returnDataTypePhysicalVariation;
        VectorExpressionDescriptor.Builder builder = new VectorExpressionDescriptor.Builder();
        builder.setNumArguments(numChildren);
        builder.setMode(mode);
        boolean anyDecimal64Expr = false;
        boolean isDecimal64ScaleEstablished = false;
        int decimal64ColumnScale = 0;
        boolean hasConstants = false;
        boolean scaleMismatch = false;
        for (int i = 0; i < numChildren; ++i) {
            ExprNodeDesc childExpr = childExprs.get(i);
            boolean isExprDecimal64 = this.checkExprNodeDescForDecimal64(childExpr);
            if (isExprDecimal64) {
                anyDecimal64Expr = true;
            }
            TypeInfo typeInfo = childExpr.getTypeInfo();
            if (childExpr instanceof ExprNodeGenericFuncDesc || childExpr instanceof ExprNodeColumnDesc) {
                if (isExprDecimal64) {
                    DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                    if (decimalTypeInfo.getScale() != decimal64ColumnScale && i > 0) {
                        scaleMismatch = true;
                    }
                    if (decimalTypeInfo.getScale() >= decimal64ColumnScale) {
                        decimal64ColumnScale = decimalTypeInfo.getScale();
                        isDecimal64ScaleEstablished = true;
                    }
                }
                builder.setInputExpressionType(i, VectorExpressionDescriptor.InputExpressionType.COLUMN);
            } else if (childExpr instanceof ExprNodeConstantDesc) {
                hasConstants = true;
                if (this.isNullConst(childExpr)) {
                    return null;
                }
                builder.setInputExpressionType(i, VectorExpressionDescriptor.InputExpressionType.SCALAR);
            } else {
                return null;
            }
            if (isExprDecimal64) {
                builder.setArgumentType(i, VectorExpressionDescriptor.ArgumentType.DECIMAL_64);
                continue;
            }
            String undecoratedTypeName = VectorizationContext.getUndecoratedName(childExpr.getTypeString());
            if (undecoratedTypeName == null) {
                return null;
            }
            builder.setArgumentType(i, undecoratedTypeName);
        }
        if (!anyDecimal64Expr) {
            return null;
        }
        boolean isReturnDecimal64 = this.checkTypeInfoForDecimal64(returnTypeInfo);
        boolean dontRescaleArguments = genericUdf instanceof GenericUDFOPMultiply;
        if (isReturnDecimal64) {
            DecimalTypeInfo leftType;
            DecimalTypeInfo returnDecimalTypeInfo = (DecimalTypeInfo)returnTypeInfo;
            if (!isDecimal64ScaleEstablished) {
                decimal64ColumnScale = returnDecimalTypeInfo.getScale();
                isDecimal64ScaleEstablished = true;
            } else if (genericUdf instanceof GenericUDFOPDivide ? (leftType = (DecimalTypeInfo)childExprs.get(0).getTypeInfo()).precision() + returnDecimalTypeInfo.getScale() > 18 : returnDecimalTypeInfo.getScale() != decimal64ColumnScale && !dontRescaleArguments) {
                return null;
            }
            returnDataTypePhysicalVariation = DataTypePhysicalVariation.DECIMAL_64;
        } else {
            if (returnTypeInfo instanceof DecimalTypeInfo) {
                return null;
            }
            returnDataTypePhysicalVariation = DataTypePhysicalVariation.NONE;
        }
        if (dontRescaleArguments && hasConstants) {
            builder.setUnscaled(true);
        }
        if ((vectorClass = this.vMap.getVectorExpressionClass(udfClass, descriptor = builder.build(), this.useCheckedVectorExpressions)) == null) {
            return null;
        }
        VectorExpressionDescriptor.Mode childrenMode = this.getChildrenMode(mode, udfClass);
        if (scaleMismatch && !hasConstants && (genericUdf instanceof GenericUDFBaseArithmetic || genericUdf instanceof GenericUDFBaseCompare)) {
            ExprNodeDesc left = childExprs.get(0);
            ExprNodeDesc right = childExprs.get(1);
            DecimalTypeInfo leftTypeInfo = (DecimalTypeInfo)left.getTypeInfo();
            DecimalTypeInfo rightTypeInfo = (DecimalTypeInfo)right.getTypeInfo();
            int leftScale = leftTypeInfo.getScale();
            int rightScale = rightTypeInfo.getScale();
            int leftPrecision = leftTypeInfo.precision();
            int rightPrecision = rightTypeInfo.precision();
            ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
            int childIndexToRewrite = -1;
            int scaleDiff = 0;
            int resultPrecision = 0;
            int resultScale = 0;
            if (leftScale < rightScale) {
                scaleDiff = rightScale - leftScale;
                childIndexToRewrite = 0;
                resultPrecision = leftPrecision + rightScale - leftScale;
                resultScale = rightScale;
            } else {
                scaleDiff = leftScale - rightScale;
                childIndexToRewrite = 1;
                resultPrecision = rightPrecision + leftScale - rightScale;
                resultScale = leftScale;
            }
            ExprNodeConstantDesc newConstant = new ExprNodeConstantDesc((TypeInfo)new DecimalTypeInfo(scaleDiff, 0), HiveDecimal.create((long)POWEROFTENTABLE[scaleDiff]));
            DecimalTypeInfo resultTypeInfo = new DecimalTypeInfo(resultPrecision, resultScale);
            children.add(childExprs.get(childIndexToRewrite));
            children.add(newConstant);
            ExprNodeGenericFuncDesc newScaledExpr = new ExprNodeGenericFuncDesc((TypeInfo)resultTypeInfo, (GenericUDF)new GenericUDFOPScaleUpDecimal64(), " ScaleUp ", children);
            childExprs.remove(childIndexToRewrite);
            childExprs.add(childIndexToRewrite, newScaledExpr);
        }
        return this.createDecimal64VectorExpression(vectorClass, childExprs, childrenMode, isDecimal64ScaleEstablished, decimal64ColumnScale, returnTypeInfo, returnDataTypePhysicalVariation, dontRescaleArguments, genericUdf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VectorExpression createDecimal64VectorExpression(Class<?> vectorClass, List<ExprNodeDesc> childExprs, VectorExpressionDescriptor.Mode childrenMode, boolean isDecimal64ScaleEstablished, int decimal64ColumnScale, TypeInfo returnTypeInfo, DataTypePhysicalVariation returnDataTypePhysicalVariation, boolean dontRescaleArguments, GenericUDF genericUdf) throws HiveException {
        int numChildren = childExprs.size();
        VectorExpression vectorExpression = null;
        boolean oldTryDecimal64Cast = this.tryDecimal64Cast;
        this.tryDecimal64Cast = true;
        try {
            ArrayList<VectorExpression> children = new ArrayList<VectorExpression>();
            Object[] arguments = new Object[numChildren];
            TypeInfo[] typeInfos = new TypeInfo[numChildren];
            DataTypePhysicalVariation[] dataTypePhysicalVariations = new DataTypePhysicalVariation[numChildren];
            for (int i = 0; i < numChildren; ++i) {
                VectorExpression filterExpr;
                TypeInfo typeInfo;
                ExprNodeDesc childExpr = childExprs.get(i);
                typeInfos[i] = typeInfo = childExpr.getTypeInfo();
                DataTypePhysicalVariation dataTypePhysicalVariation = dataTypePhysicalVariations[i] = this.checkTypeInfoForDecimal64(typeInfo) ? DataTypePhysicalVariation.DECIMAL_64 : DataTypePhysicalVariation.NONE;
                if (childExpr instanceof ExprNodeGenericFuncDesc) {
                    VectorExpression vChild = this.getVectorExpression(childExpr, childrenMode);
                    if (genericUdf instanceof GenericUDFBaseBinary && vChild.getOutputDataTypePhysicalVariation() == DataTypePhysicalVariation.NONE) {
                        VectorExpression vectorExpression2 = null;
                        return vectorExpression2;
                    }
                    children.add(vChild);
                    arguments[i] = vChild.getOutputColumnNum();
                    continue;
                }
                if (childExpr instanceof ExprNodeColumnDesc) {
                    int colIndex = this.getInputColumnIndex((ExprNodeColumnDesc)childExpr);
                    if (childrenMode == VectorExpressionDescriptor.Mode.FILTER) {
                        filterExpr = this.getFilterOnBooleanColumnExpression((ExprNodeColumnDesc)childExpr, colIndex);
                        if (filterExpr == null) {
                            VectorExpression vectorExpression3 = null;
                            return vectorExpression3;
                        }
                        children.add(filterExpr);
                    }
                    arguments[i] = colIndex;
                    continue;
                }
                if (childExpr instanceof ExprNodeConstantDesc) {
                    ExprNodeConstantDesc constDesc = (ExprNodeConstantDesc)childExpr;
                    if (typeInfo instanceof DecimalTypeInfo) {
                        if (!isDecimal64ScaleEstablished) {
                            filterExpr = null;
                            return filterExpr;
                        }
                        HiveDecimal hiveDecimal = (HiveDecimal)constDesc.getValue();
                        if (hiveDecimal.scale() > decimal64ColumnScale) {
                            VectorExpression vectorExpression4 = null;
                            return vectorExpression4;
                        }
                        if (dontRescaleArguments) {
                            arguments[i] = new HiveDecimalWritable(hiveDecimal).serialize64(hiveDecimal.scale());
                            continue;
                        }
                        arguments[i] = new HiveDecimalWritable(hiveDecimal).serialize64(decimal64ColumnScale);
                        continue;
                    }
                    Object scalarValue = this.getVectorTypeScalarValue(constDesc);
                    arguments[i] = scalarValue == null ? this.getConstantVectorExpression(null, typeInfo, childrenMode) : scalarValue;
                    continue;
                }
                VectorExpression vectorExpression5 = null;
                return vectorExpression5;
            }
            vectorExpression = this.instantiateExpression(vectorClass, returnTypeInfo, returnDataTypePhysicalVariation, arguments);
            if (vectorExpression == null) {
                this.handleCouldNotInstantiateVectorExpression(vectorClass, returnTypeInfo, returnDataTypePhysicalVariation, arguments);
            }
            Objects.requireNonNull(vectorExpression).setInputTypeInfos(typeInfos);
            vectorExpression.setInputDataTypePhysicalVariations(dataTypePhysicalVariations);
            if (!children.isEmpty()) {
                vectorExpression.setChildExpressions(children.toArray(new VectorExpression[0]));
            }
        }
        finally {
            this.tryDecimal64Cast = oldTryDecimal64Cast;
        }
        return vectorExpression;
    }

    private VectorExpression getVectorExpressionForUdf(GenericUDF genericUdf, Class<?> udfClass, List<ExprNodeDesc> childExpr, VectorExpressionDescriptor.Mode mode, TypeInfo returnType) throws HiveException {
        int numChildren;
        int n = numChildren = childExpr == null ? 0 : childExpr.size();
        if (numChildren > 2 && mode == VectorExpressionDescriptor.Mode.FILTER && (genericUdf instanceof GenericUDFOPOr || genericUdf instanceof GenericUDFOPAnd)) {
            for (int i = 0; i < numChildren; ++i) {
                ExprNodeDesc child = childExpr.get(i);
                String childTypeString = child.getTypeString();
                if (childTypeString == null) {
                    throw new HiveException("Null child type name string");
                }
                TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)childTypeString);
                ColumnVector.Type columnVectorType = VectorizationContext.getColumnVectorTypeFromTypeInfo(typeInfo);
                if (columnVectorType != ColumnVector.Type.LONG) {
                    return null;
                }
                if (child instanceof ExprNodeGenericFuncDesc || child instanceof ExprNodeColumnDesc) continue;
                return null;
            }
            Class vclass = genericUdf instanceof GenericUDFOPOr ? FilterExprOrExpr.class : FilterExprAndExpr.class;
            VectorExpressionDescriptor.Mode childrenMode = this.getChildrenMode(mode, udfClass);
            return this.createVectorExpression(vclass, childExpr, childrenMode, returnType, DataTypePhysicalVariation.NONE);
        }
        if (numChildren > 3) {
            return null;
        }
        VectorExpression result = this.getDecimal64VectorExpressionForUdf(genericUdf, udfClass, childExpr, numChildren, mode, returnType);
        if (result != null) {
            return result;
        }
        VectorExpressionDescriptor.Builder builder = new VectorExpressionDescriptor.Builder();
        builder.setNumArguments(numChildren);
        builder.setMode(mode);
        for (int i = 0; i < numChildren; ++i) {
            ExprNodeDesc child = childExpr.get(i);
            TypeInfo childTypeInfo = child.getTypeInfo();
            String childTypeString = childTypeInfo.toString();
            if (childTypeString == null) {
                throw new HiveException("Null child type name string");
            }
            String undecoratedTypeName = VectorizationContext.getUndecoratedName(childTypeString);
            if (undecoratedTypeName == null) {
                throw new HiveException("No match for type string " + childTypeString + " from undecorated type name method");
            }
            builder.setArgumentType(i, undecoratedTypeName);
            if (child instanceof ExprNodeGenericFuncDesc || child instanceof ExprNodeColumnDesc || child instanceof ExprNodeFieldDesc) {
                builder.setInputExpressionType(i, VectorExpressionDescriptor.InputExpressionType.COLUMN);
                continue;
            }
            if (child instanceof ExprNodeConstantDesc) {
                if (this.isNullConst(child)) {
                    builder.setInputExpressionType(i, VectorExpressionDescriptor.InputExpressionType.NULLSCALAR);
                    continue;
                }
                builder.setInputExpressionType(i, VectorExpressionDescriptor.InputExpressionType.SCALAR);
                continue;
            }
            if (child instanceof ExprNodeDynamicValueDesc) {
                builder.setInputExpressionType(i, VectorExpressionDescriptor.InputExpressionType.DYNAMICVALUE);
                continue;
            }
            throw new HiveException("Cannot handle expression type: " + child.getClass().getSimpleName());
        }
        VectorExpressionDescriptor.Descriptor descriptor = builder.build();
        Class<?> vclass = this.vMap.getVectorExpressionClass(udfClass, descriptor, this.useCheckedVectorExpressions);
        if (vclass == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No vector udf found for " + udfClass.getSimpleName() + ", descriptor: " + descriptor);
            }
            return null;
        }
        VectorExpressionDescriptor.Mode childrenMode = this.getChildrenMode(mode, udfClass);
        return this.createVectorExpression(vclass, childExpr, childrenMode, returnType, DataTypePhysicalVariation.NONE);
    }

    private VectorExpression createDecimal64ToDecimalConversion(int colIndex, TypeInfo resultTypeInfo) throws HiveException {
        Object[] conversionArgs = new Object[]{colIndex};
        VectorExpression vectorExpression = this.instantiateExpression(ConvertDecimal64ToDecimal.class, resultTypeInfo, DataTypePhysicalVariation.NONE, conversionArgs);
        if (vectorExpression == null) {
            this.handleCouldNotInstantiateVectorExpression(ConvertDecimal64ToDecimal.class, resultTypeInfo, DataTypePhysicalVariation.NONE, conversionArgs);
        }
        Objects.requireNonNull(vectorExpression).setInputTypeInfos(resultTypeInfo);
        vectorExpression.setInputDataTypePhysicalVariations(DataTypePhysicalVariation.DECIMAL_64);
        return vectorExpression;
    }

    public void wrapWithDecimal64ToDecimalConversions(VectorExpression[] vecExprs) throws HiveException {
        if (vecExprs == null) {
            return;
        }
        for (VectorExpression vecExpr : vecExprs) {
            DataTypePhysicalVariation outputDataTypePhysicalVariation;
            if (!(vecExpr.getOutputTypeInfo() instanceof DecimalTypeInfo) || (outputDataTypePhysicalVariation = vecExpr.getOutputDataTypePhysicalVariation()) != DataTypePhysicalVariation.DECIMAL_64) continue;
            vecExprs[i] = this.wrapWithDecimal64ToDecimalConversion(vecExpr);
        }
    }

    public VectorExpression wrapWithDecimal64ToDecimalConversion(VectorExpression inputExpression) throws HiveException {
        VectorExpression wrapExpression = this.createDecimal64ToDecimalConversion(inputExpression.getOutputColumnNum(), inputExpression.getOutputTypeInfo());
        if (inputExpression instanceof IdentityExpression) {
            return wrapExpression;
        }
        VectorExpression[] child = new VectorExpression[]{inputExpression};
        wrapExpression.setChildExpressions(child);
        return wrapExpression;
    }

    private VectorExpression createVectorExpression(Class<?> vectorClass, List<ExprNodeDesc> childExpr, VectorExpressionDescriptor.Mode childrenMode, TypeInfo returnType, DataTypePhysicalVariation returnDataTypePhysicalVariation) throws HiveException {
        int numChildren = childExpr == null ? 0 : childExpr.size();
        TypeInfo[] inputTypeInfos = new TypeInfo[numChildren];
        DataTypePhysicalVariation[] inputDataTypePhysicalVariations = new DataTypePhysicalVariation[numChildren];
        ArrayList<VectorExpression> children = new ArrayList<VectorExpression>();
        Object[] arguments = new Object[numChildren];
        for (int i = 0; i < numChildren; ++i) {
            TypeInfo childTypeInfo;
            ExprNodeDesc child = childExpr.get(i);
            inputTypeInfos[i] = childTypeInfo = child.getTypeInfo();
            inputDataTypePhysicalVariations[i] = DataTypePhysicalVariation.NONE;
            if (child instanceof ExprNodeGenericFuncDesc || child instanceof ExprNodeFieldDesc) {
                VectorExpression vChild = this.getVectorExpression(child, childrenMode);
                children.add(vChild);
                arguments[i] = vChild.getOutputColumnNum();
                inputDataTypePhysicalVariations[i] = vChild.getOutputDataTypePhysicalVariation();
                continue;
            }
            if (child instanceof ExprNodeColumnDesc) {
                DataTypePhysicalVariation dataTypePhysicalVariation;
                int colIndex = this.getInputColumnIndex((ExprNodeColumnDesc)child);
                if (childTypeInfo instanceof DecimalTypeInfo && (dataTypePhysicalVariation = this.getDataTypePhysicalVariation(colIndex)) != null && dataTypePhysicalVariation == DataTypePhysicalVariation.DECIMAL_64) {
                    VectorExpression vChild = this.createDecimal64ToDecimalConversion(colIndex, childTypeInfo);
                    children.add(vChild);
                    arguments[i] = vChild.getOutputColumnNum();
                    inputDataTypePhysicalVariations[i] = vChild.getOutputDataTypePhysicalVariation();
                    continue;
                }
                if (childrenMode == VectorExpressionDescriptor.Mode.FILTER) {
                    SelectColumnIsTrue selectColumnIsTrue = new SelectColumnIsTrue(colIndex);
                    selectColumnIsTrue.setInputTypeInfos(childTypeInfo);
                    selectColumnIsTrue.setInputDataTypePhysicalVariations(DataTypePhysicalVariation.NONE);
                    children.add(selectColumnIsTrue);
                }
                arguments[i] = colIndex;
                continue;
            }
            if (child instanceof ExprNodeConstantDesc) {
                Object scalarValue = this.getVectorTypeScalarValue((ExprNodeConstantDesc)child);
                arguments[i] = null == scalarValue ? this.getConstantVectorExpression(null, child.getTypeInfo(), childrenMode) : scalarValue;
                continue;
            }
            if (child instanceof ExprNodeDynamicValueDesc) {
                arguments[i] = ((ExprNodeDynamicValueDesc)child).getDynamicValue();
                continue;
            }
            throw new HiveException("Cannot handle expression type: " + child.getClass().getSimpleName());
        }
        VectorExpression vectorExpression = this.instantiateExpression(vectorClass, returnType, returnDataTypePhysicalVariation, arguments);
        if (vectorExpression == null) {
            this.handleCouldNotInstantiateVectorExpression(vectorClass, returnType, DataTypePhysicalVariation.NONE, arguments);
        }
        Objects.requireNonNull(vectorExpression).setInputTypeInfos(inputTypeInfos);
        vectorExpression.setInputDataTypePhysicalVariations(inputDataTypePhysicalVariations);
        if (!children.isEmpty()) {
            vectorExpression.setChildExpressions(children.toArray(new VectorExpression[0]));
        }
        this.freeNonColumns(children.toArray(new VectorExpression[0]));
        return vectorExpression;
    }

    private void handleCouldNotInstantiateVectorExpression(Class<?> vectorClass, TypeInfo returnType, DataTypePhysicalVariation dataTypePhysicalVariation, Object[] arguments) throws HiveException {
        String displayString = "Could not instantiate vector expression class " + vectorClass.getName() + " for arguments " + Arrays.toString(arguments) + " return type " + VectorExpression.getTypeName(returnType, dataTypePhysicalVariation);
        throw new HiveException(displayString);
    }

    private VectorExpressionDescriptor.Mode getChildrenMode(VectorExpressionDescriptor.Mode mode, Class<?> udf) {
        if (mode.equals((Object)VectorExpressionDescriptor.Mode.FILTER) && (udf.equals(GenericUDFOPAnd.class) || udf.equals(GenericUDFOPOr.class))) {
            return VectorExpressionDescriptor.Mode.FILTER;
        }
        return VectorExpressionDescriptor.Mode.PROJECTION;
    }

    private String getNewInstanceArgumentString(Object[] args) {
        if (args == null) {
            return "arguments: NULL";
        }
        ArrayList<String> argClasses = new ArrayList<String>();
        for (Object obj : args) {
            argClasses.add(obj.getClass().getSimpleName());
        }
        return "arguments: " + Arrays.toString(args) + ", argument classes: " + argClasses.toString();
    }

    public static String getStackTraceAsSingleLine(Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e);
        sb.append(" stack trace: ");
        StackTraceElement[] stackTrace = e.getStackTrace();
        int length = stackTrace.length;
        boolean isTruncated = false;
        if (length > 15) {
            length = 15;
            isTruncated = true;
        }
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(stackTrace[i]);
        }
        if (isTruncated) {
            sb.append(", ...");
        }
        return sb.toString().replaceAll("GeneratedConstructorAccessor[0-9]*", "GeneratedConstructorAccessor<omitted>");
    }

    public VectorExpression instantiateExpression(Class<?> vclass, TypeInfo returnTypeInfo, DataTypePhysicalVariation returnDataTypePhysicalVariation, Object ... args) throws HiveException {
        int argsLength;
        VectorExpression ve = null;
        Constructor<?> ctor = this.getConstructor(vclass);
        int numParams = ctor.getParameterTypes().length;
        int n = argsLength = args == null ? 0 : args.length;
        if (numParams == 0) {
            try {
                ve = (VectorExpression)ctor.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new HiveException("Could not instantiate " + vclass.getSimpleName() + " with 0 arguments, exception: " + VectorizationContext.getStackTraceAsSingleLine(ex));
            }
        }
        if (numParams == argsLength) {
            try {
                ve = (VectorExpression)ctor.newInstance(args);
            }
            catch (Exception ex) {
                throw new HiveException("Could not instantiate " + vclass.getSimpleName() + " with " + this.getNewInstanceArgumentString(args) + ", exception: " + VectorizationContext.getStackTraceAsSingleLine(ex));
            }
        }
        if (numParams == argsLength + 1) {
            Object[] newArgs = null;
            try {
                if (returnTypeInfo == null) {
                    throw new HiveException("Missing output type information");
                }
                String returnTypeName = returnTypeInfo.getTypeName();
                int outputColumnNum = this.ocm.allocateOutputColumn(returnTypeInfo, returnDataTypePhysicalVariation);
                newArgs = Arrays.copyOf(Objects.requireNonNull(args), numParams);
                newArgs[numParams - 1] = outputColumnNum;
                ve = (VectorExpression)ctor.newInstance(newArgs);
                ve.setOutputTypeInfo(returnTypeInfo);
                ve.setOutputDataTypePhysicalVariation(returnDataTypePhysicalVariation);
            }
            catch (Exception ex) {
                throw new HiveException("Could not instantiate " + vclass.getSimpleName() + " with arguments " + this.getNewInstanceArgumentString(newArgs) + ", exception: " + VectorizationContext.getStackTraceAsSingleLine(ex));
            }
        }
        if (ve instanceof TruncStringOutput) {
            TruncStringOutput truncStringOutput = (TruncStringOutput)((Object)ve);
            if (returnTypeInfo instanceof BaseCharTypeInfo) {
                BaseCharTypeInfo baseCharTypeInfo = (BaseCharTypeInfo)returnTypeInfo;
                truncStringOutput.setMaxLength(baseCharTypeInfo.getLength());
            }
        }
        return ve;
    }

    private VectorExpression getIdentityForDateToDate(List<ExprNodeDesc> childExprs, TypeInfo returnTypeInfo) throws HiveException {
        if (childExprs.size() != 1) {
            return null;
        }
        TypeInfo childTypeInfo = childExprs.get(0).getTypeInfo();
        if (childTypeInfo.getCategory() != ObjectInspector.Category.PRIMITIVE || ((PrimitiveTypeInfo)childTypeInfo).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.DATE) {
            return null;
        }
        if (returnTypeInfo.getCategory() != ObjectInspector.Category.PRIMITIVE || ((PrimitiveTypeInfo)returnTypeInfo).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.DATE) {
            return null;
        }
        return this.getIdentityExpression(childExprs);
    }

    private VectorExpression getGenericUdfVectorExpression(GenericUDF udf, List<ExprNodeDesc> childExpr, VectorExpressionDescriptor.Mode mode, TypeInfo returnType) throws HiveException {
        List<ExprNodeDesc> castedChildren = this.evaluateCastOnConstants(childExpr);
        childExpr = castedChildren;
        VectorExpression ve = null;
        if (udf instanceof GenericUDFBetween) {
            ve = this.getBetweenExpression(childExpr, mode, returnType);
        } else if (udf instanceof GenericUDFIn) {
            ve = this.getInExpression(childExpr, mode, returnType);
        } else if (udf instanceof GenericUDFIf) {
            ve = this.getIfExpression((GenericUDFIf)udf, childExpr, mode, returnType);
        } else if (udf instanceof GenericUDFWhen) {
            ve = this.getWhenExpression(childExpr, mode, returnType);
        } else if (udf instanceof GenericUDFOPPositive) {
            ve = this.getIdentityExpression(childExpr);
        } else if (udf instanceof GenericUDFCoalesce) {
            ve = this.getCoalesceExpression(childExpr, mode, returnType);
        } else if (udf instanceof GenericUDFElt) {
            ve = this.getEltExpression(childExpr, returnType);
        } else if (udf instanceof GenericUDFGrouping) {
            ve = this.getGroupingExpression((GenericUDFGrouping)udf, childExpr, returnType);
        } else if (udf instanceof GenericUDFBridge) {
            ve = this.getGenericUDFBridgeVectorExpression((GenericUDFBridge)udf, childExpr, mode, returnType);
        } else if (udf instanceof GenericUDFToString) {
            ve = this.getCastToString(childExpr, returnType);
        } else if (udf instanceof GenericUDFToDecimal) {
            ve = this.getCastToDecimal(childExpr, returnType);
        } else if (udf instanceof GenericUDFToChar) {
            ve = this.getCastToChar(childExpr, returnType);
        } else if (udf instanceof GenericUDFToVarchar) {
            ve = this.getCastToVarChar(childExpr, returnType);
        } else if (udf instanceof GenericUDFToBinary) {
            ve = this.getCastToBinary(childExpr, returnType);
        } else if (udf instanceof GenericUDFTimestamp) {
            ve = this.getCastToTimestamp((GenericUDFTimestamp)udf, childExpr, mode, returnType);
        } else if (udf instanceof GenericUDFDate || udf instanceof GenericUDFToDate) {
            ve = this.getIdentityForDateToDate(childExpr, returnType);
        } else if (udf instanceof GenericUDFBucketNumber) {
            int outCol = this.ocm.allocateOutputColumn(returnType);
            ve = new BucketNumExpression(outCol);
            ve.setInputTypeInfos(returnType);
            ve.setOutputTypeInfo(returnType);
        } else if (udf instanceof GenericUDFCastFormat) {
            ve = this.getCastWithFormat(udf, childExpr, returnType);
        }
        if (ve != null) {
            return ve;
        }
        Class<Object> udfClass = udf.getClass();
        boolean isSubstituted = false;
        if (udf instanceof GenericUDFBridge) {
            udfClass = ((GenericUDFBridge)udf).getUdfClass();
            isSubstituted = true;
        }
        ve = this.getVectorExpressionForUdf(!isSubstituted ? udf : null, udfClass, castedChildren, mode, returnType);
        return ve;
    }

    private VectorExpression getCastToTimestamp(GenericUDFTimestamp udf, List<ExprNodeDesc> childExpr, VectorExpressionDescriptor.Mode mode, TypeInfo returnType) throws HiveException {
        VectorExpression ve = this.getVectorExpressionForUdf(udf, udf.getClass(), childExpr, mode, returnType);
        if (!udf.isIntToTimestampInSeconds() && ve instanceof CastLongToTimestamp) {
            ve = this.createVectorExpression(CastMillisecondsLongToTimestamp.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        return ve;
    }

    private void freeNonColumns(VectorExpression[] vectorChildren) {
        if (vectorChildren == null) {
            return;
        }
        for (VectorExpression v : vectorChildren) {
            if (v instanceof IdentityExpression) continue;
            this.ocm.freeOutputColumn(v.getOutputColumnNum());
        }
    }

    private VectorExpression getCoalesceExpression(List<ExprNodeDesc> childExpr, VectorExpressionDescriptor.Mode mode, TypeInfo returnType) throws HiveException {
        int i;
        int[] inputColumns = new int[childExpr.size()];
        VectorExpression[] vectorChildren = this.getVectorExpressions(childExpr, VectorExpressionDescriptor.Mode.PROJECTION);
        int size = vectorChildren.length;
        TypeInfo[] inputTypeInfos = new TypeInfo[size];
        DataTypePhysicalVariation[] inputDataTypePhysicalVariations = new DataTypePhysicalVariation[size];
        DataTypePhysicalVariation outputDataTypePhysicalVariation = DataTypePhysicalVariation.DECIMAL_64;
        boolean fixConstants = false;
        for (i = 0; i < vectorChildren.length; ++i) {
            VectorExpression ve = vectorChildren[i];
            inputColumns[i] = ve.getOutputColumnNum();
            inputTypeInfos[i] = ve.getOutputTypeInfo();
            inputDataTypePhysicalVariations[i] = ve.getOutputDataTypePhysicalVariation();
            if (inputDataTypePhysicalVariations[i] != DataTypePhysicalVariation.NONE && inputDataTypePhysicalVariations[i] != null) continue;
            if (childExpr.get(i) instanceof ExprNodeConstantDesc && inputTypeInfos[i] instanceof DecimalTypeInfo && ((DecimalTypeInfo)inputTypeInfos[i]).precision() <= 18) {
                fixConstants = true;
                continue;
            }
            outputDataTypePhysicalVariation = DataTypePhysicalVariation.NONE;
        }
        if (outputDataTypePhysicalVariation == DataTypePhysicalVariation.DECIMAL_64 && fixConstants) {
            for (i = 0; i < vectorChildren.length; ++i) {
                if (inputDataTypePhysicalVariations[i] != DataTypePhysicalVariation.NONE && inputDataTypePhysicalVariations[i] != null || !(vectorChildren[i] instanceof ConstantVectorExpression)) continue;
                ConstantVectorExpression cve = (ConstantVectorExpression)vectorChildren[i];
                HiveDecimal hd = cve.getDecimalValue();
                Long longValue = new HiveDecimalWritable(hd).serialize64(((DecimalTypeInfo)cve.getOutputTypeInfo()).getScale());
                ((ConstantVectorExpression)vectorChildren[i]).setLongValue(longValue);
                vectorChildren[i].setOutputDataTypePhysicalVariation(DataTypePhysicalVariation.DECIMAL_64);
                int scratchColIndex = vectorChildren[i].getOutputColumnNum() - this.ocm.initialOutputCol;
                ((OutputColumnManager)this.ocm).scratchDataTypePhysicalVariations[scratchColIndex] = DataTypePhysicalVariation.DECIMAL_64;
            }
        }
        int outputColumnNum = this.ocm.allocateOutputColumn(returnType, outputDataTypePhysicalVariation);
        VectorCoalesce vectorCoalesce = new VectorCoalesce(inputColumns, outputColumnNum);
        vectorCoalesce.setChildExpressions(vectorChildren);
        vectorCoalesce.setInputTypeInfos(inputTypeInfos);
        vectorCoalesce.setInputDataTypePhysicalVariations(inputDataTypePhysicalVariations);
        vectorCoalesce.setOutputTypeInfo(returnType);
        vectorCoalesce.setOutputDataTypePhysicalVariation(outputDataTypePhysicalVariation);
        this.freeNonColumns(vectorChildren);
        boolean isFilter = false;
        if (mode == VectorExpressionDescriptor.Mode.FILTER) {
            if (returnType.getCategory() == ObjectInspector.Category.PRIMITIVE && ((PrimitiveTypeInfo)returnType).getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN) {
                isFilter = true;
            } else {
                return null;
            }
        }
        if (isFilter) {
            SelectColumnIsTrue filterVectorExpr = new SelectColumnIsTrue(vectorCoalesce.getOutputColumnNum());
            filterVectorExpr.setChildExpressions(new VectorExpression[]{vectorCoalesce});
            filterVectorExpr.setInputTypeInfos(vectorCoalesce.getOutputTypeInfo());
            filterVectorExpr.setInputDataTypePhysicalVariations(vectorCoalesce.getOutputDataTypePhysicalVariation());
            return filterVectorExpr;
        }
        return vectorCoalesce;
    }

    private VectorExpression getEltExpression(List<ExprNodeDesc> childExpr, TypeInfo returnType) throws HiveException {
        int[] inputColumns = new int[childExpr.size()];
        VectorExpression[] vectorChildren = this.getVectorExpressions(childExpr, VectorExpressionDescriptor.Mode.PROJECTION);
        int size = vectorChildren.length;
        TypeInfo[] inputTypeInfos = new TypeInfo[size];
        DataTypePhysicalVariation[] inputDataTypePhysicalVariations = new DataTypePhysicalVariation[size];
        int i = 0;
        for (VectorExpression ve : vectorChildren) {
            inputColumns[i] = ve.getOutputColumnNum();
            inputTypeInfos[i] = ve.getOutputTypeInfo();
            inputDataTypePhysicalVariations[i++] = ve.getOutputDataTypePhysicalVariation();
        }
        int outputColumnNum = this.ocm.allocateOutputColumn(returnType);
        VectorElt vectorElt = new VectorElt(inputColumns, outputColumnNum);
        vectorElt.setChildExpressions(vectorChildren);
        vectorElt.setInputTypeInfos(inputTypeInfos);
        vectorElt.setInputDataTypePhysicalVariations(inputDataTypePhysicalVariations);
        vectorElt.setOutputTypeInfo(returnType);
        vectorElt.setOutputDataTypePhysicalVariation(DataTypePhysicalVariation.NONE);
        this.freeNonColumns(vectorChildren);
        return vectorElt;
    }

    private VectorExpression getGroupingExpression(GenericUDFGrouping udf, List<ExprNodeDesc> childExprs, TypeInfo returnType) throws HiveException {
        ExprNodeDesc childExpr0 = childExprs.get(0);
        if (!(childExpr0 instanceof ExprNodeColumnDesc)) {
            return null;
        }
        ExprNodeColumnDesc groupingIdColDesc = (ExprNodeColumnDesc)childExpr0;
        int groupingIdColNum = this.getInputColumnIndex(groupingIdColDesc.getColumn());
        int indexCount = childExprs.size() - 1;
        int[] indices = new int[indexCount];
        for (int i = 0; i < indexCount; ++i) {
            int index;
            ExprNodeDesc indexChildExpr = childExprs.get(i + 1);
            if (!(indexChildExpr instanceof ExprNodeConstantDesc)) {
                return null;
            }
            Object scalarObject = ((ExprNodeConstantDesc)indexChildExpr).getValue();
            if (scalarObject instanceof Integer) {
                index = (Integer)scalarObject;
            } else if (scalarObject instanceof Long) {
                index = (int)((Long)scalarObject).longValue();
            } else {
                return null;
            }
            indices[i] = index;
        }
        int outputColumnNum = this.ocm.allocateOutputColumn(returnType);
        MathFuncLongToLong ve = indices.length == 1 ? new GroupingColumn(groupingIdColNum, indices[0], outputColumnNum) : new GroupingColumns(groupingIdColNum, indices, outputColumnNum);
        ve.setInputTypeInfos(groupingIdColDesc.getTypeInfo());
        ve.setInputDataTypePhysicalVariations(DataTypePhysicalVariation.NONE);
        ve.setOutputTypeInfo(returnType);
        ve.setOutputDataTypePhysicalVariation(DataTypePhysicalVariation.NONE);
        return ve;
    }

    public static InConstantType getInConstantTypeFromPrimitiveCategory(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory) {
        switch (primitiveCategory) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case BOOLEAN: {
                return InConstantType.INT_FAMILY;
            }
            case DATE: {
                return InConstantType.DATE;
            }
            case TIMESTAMP: {
                return InConstantType.TIMESTAMP;
            }
            case FLOAT: 
            case DOUBLE: {
                return InConstantType.FLOAT_FAMILY;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: 
            case BINARY: {
                return InConstantType.STRING_FAMILY;
            }
            case DECIMAL: {
                return InConstantType.DECIMAL;
            }
        }
        throw new RuntimeException("Unexpected primitive type category " + primitiveCategory);
    }

    private VectorExpression getStructInExpression(List<ExprNodeDesc> childExpr, ExprNodeDesc colExpr, TypeInfo colTypeInfo, List<ExprNodeDesc> inChildren, VectorExpressionDescriptor.Mode mode, TypeInfo returnType) throws HiveException {
        StructTypeInfo structTypeInfo = (StructTypeInfo)colTypeInfo;
        List fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
        int fieldCount = fieldTypeInfos.size();
        ColumnVector.Type[] fieldVectorColumnTypes = new ColumnVector.Type[fieldCount];
        InConstantType[] fieldInConstantTypes = new InConstantType[fieldCount];
        for (int f = 0; f < fieldCount; ++f) {
            InConstantType inConstantType;
            ColumnVector.Type fieldVectorColumnType;
            TypeInfo fieldTypeInfo = (TypeInfo)fieldTypeInfos.get(f);
            if (fieldTypeInfo.getCategory() != ObjectInspector.Category.PRIMITIVE) {
                return null;
            }
            fieldVectorColumnTypes[f] = fieldVectorColumnType = VectorizationContext.getColumnVectorTypeFromTypeInfo(fieldTypeInfo);
            PrimitiveObjectInspector.PrimitiveCategory fieldPrimitiveCategory = ((PrimitiveTypeInfo)fieldTypeInfo).getPrimitiveCategory();
            fieldInConstantTypes[f] = inConstantType = VectorizationContext.getInConstantTypeFromPrimitiveCategory(fieldPrimitiveCategory);
        }
        ByteStream.Output buffer = new ByteStream.Output();
        BinarySortableSerializeWrite binarySortableSerializeWrite = new BinarySortableSerializeWrite(fieldCount);
        int inChildrenCount = inChildren.size();
        byte[][] serializedInChildren = new byte[inChildrenCount][];
        try {
            for (int i = 0; i < inChildrenCount; ++i) {
                Object[] constants;
                ExprNodeDesc node = inChildren.get(i);
                if (node instanceof ExprNodeConstantDesc) {
                    ExprNodeConstantDesc constNode = (ExprNodeConstantDesc)node;
                    ConstantObjectInspector output = constNode.getWritableObjectInspector();
                    constants = ((List)output.getWritableConstantValue()).toArray();
                } else {
                    ExprNodeGenericFuncDesc exprNode = (ExprNodeGenericFuncDesc)node;
                    ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get(exprNode);
                    ObjectInspector output = evaluator.initialize(exprNode.getWritableObjectInspector());
                    constants = (Object[])evaluator.evaluate(null);
                }
                binarySortableSerializeWrite.set(buffer);
                block9: for (int f = 0; f < fieldCount; ++f) {
                    Object constant = constants[f];
                    if (constant == null) {
                        binarySortableSerializeWrite.writeNull();
                        continue;
                    }
                    InConstantType inConstantType = fieldInConstantTypes[f];
                    switch (inConstantType) {
                        case STRING_FAMILY: {
                            if (constant instanceof Text) {
                                Text text = (Text)constant;
                                byte[] bytes = text.getBytes();
                                binarySortableSerializeWrite.writeString(bytes, 0, text.getLength());
                                continue block9;
                            }
                            throw new HiveException("Unexpected constant String type " + constant.getClass().getSimpleName());
                        }
                        case INT_FAMILY: {
                            long value;
                            if (constant instanceof IntWritable) {
                                value = ((IntWritable)constant).get();
                            } else if (constant instanceof LongWritable) {
                                value = ((LongWritable)constant).get();
                            } else {
                                throw new HiveException("Unexpected constant Long type " + constant.getClass().getSimpleName());
                            }
                            binarySortableSerializeWrite.writeLong(value);
                            continue block9;
                        }
                        case FLOAT_FAMILY: {
                            if (!(constant instanceof DoubleWritable)) {
                                throw new HiveException("Unexpected constant Double type " + constant.getClass().getSimpleName());
                            }
                            double value = ((DoubleWritable)constant).get();
                            binarySortableSerializeWrite.writeDouble(value);
                            continue block9;
                        }
                        default: {
                            throw new RuntimeException("Unexpected IN constant type " + inConstantType.name());
                        }
                    }
                }
                serializedInChildren[i] = Arrays.copyOfRange(buffer.getData(), 0, buffer.getLength());
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        int scratchBytesCol = this.ocm.allocateOutputColumn((TypeInfo)TypeInfoFactory.stringTypeInfo);
        Class cl = mode == VectorExpressionDescriptor.Mode.FILTER ? FilterStructColumnInList.class : StructColumnInList.class;
        VectorExpression expr = this.createVectorExpression(cl, null, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        ((IStringInExpr)((Object)expr)).setInListValues(serializedInChildren);
        ((IStructInExpr)((Object)expr)).setScratchBytesColumn(scratchBytesCol);
        ((IStructInExpr)((Object)expr)).setStructColumnExprs(this, colExpr.getChildren(), fieldVectorColumnTypes);
        return expr;
    }

    private VectorExpression getInExpression(List<ExprNodeDesc> childExpr, VectorExpressionDescriptor.Mode mode, TypeInfo returnType) throws HiveException {
        Object inVals;
        Class cl;
        ExprNodeDesc colExpr = childExpr.get(0);
        List<ExprNodeDesc> inChildren = childExpr.subList(1, childExpr.size());
        String colType = colExpr.getTypeString();
        TypeInfo colTypeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)(colType = VectorizationContext.mapTypeNameSynonyms(colType)));
        ObjectInspector.Category category = colTypeInfo.getCategory();
        if (category == ObjectInspector.Category.STRUCT) {
            return this.getStructInExpression(childExpr, colExpr, colTypeInfo, inChildren, mode, returnType);
        }
        if (category != ObjectInspector.Category.PRIMITIVE) {
            return null;
        }
        List<ExprNodeDesc> childrenForInList = this.evaluateCastOnConstants(inChildren);
        VectorExpression expr = null;
        for (ExprNodeDesc inListChild : childrenForInList) {
            if (inListChild instanceof ExprNodeConstantDesc) continue;
            throw new HiveException("Vectorizing IN expression only supported for constant values");
        }
        if (VectorizationContext.isIntFamily(colType)) {
            cl = mode == VectorExpressionDescriptor.Mode.FILTER ? FilterLongColumnInList.class : LongColumnInList.class;
            inVals = new long[childrenForInList.size()];
            for (int i = 0; i != ((long[])inVals).length; ++i) {
                inVals[i] = this.getIntFamilyScalarAsLong((ExprNodeConstantDesc)childrenForInList.get(i));
            }
            expr = this.createVectorExpression(cl, childExpr.subList(0, 1), VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
            ((ILongInExpr)((Object)expr)).setInListValues((long[])inVals);
        } else if (VectorizationContext.isTimestampFamily(colType)) {
            cl = mode == VectorExpressionDescriptor.Mode.FILTER ? FilterTimestampColumnInList.class : TimestampColumnInList.class;
            inVals = new Timestamp[childrenForInList.size()];
            for (int i = 0; i != ((long[])inVals).length; ++i) {
                inVals[i] = (long)this.getTimestampScalar(childrenForInList.get(i));
            }
            expr = this.createVectorExpression(cl, childExpr.subList(0, 1), VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
            ((ITimestampInExpr)((Object)expr)).setInListValues((Timestamp[])inVals);
        } else if (VectorizationContext.isStringFamily(colType)) {
            cl = mode == VectorExpressionDescriptor.Mode.FILTER ? FilterStringColumnInList.class : StringColumnInList.class;
            inVals = new byte[childrenForInList.size()][];
            for (int i = 0; i != ((long[])inVals).length; ++i) {
                inVals[i] = (long)this.getStringScalarAsByteArray((ExprNodeConstantDesc)childrenForInList.get(i));
            }
            expr = this.createVectorExpression(cl, childExpr.subList(0, 1), VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
            ((IStringInExpr)((Object)expr)).setInListValues((byte[][])inVals);
        } else if (VectorizationContext.isFloatFamily(colType)) {
            cl = mode == VectorExpressionDescriptor.Mode.FILTER ? FilterDoubleColumnInList.class : DoubleColumnInList.class;
            double[] inValsD = new double[childrenForInList.size()];
            for (int i = 0; i != inValsD.length; ++i) {
                inValsD[i] = this.getNumericScalarAsDouble(childrenForInList.get(i));
            }
            expr = this.createVectorExpression(cl, childExpr.subList(0, 1), VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
            ((IDoubleInExpr)((Object)expr)).setInListValues(inValsD);
        } else if (VectorizationContext.isDecimalFamily(colType)) {
            boolean tryDecimal64 = this.checkExprNodeDescForDecimal64(colExpr);
            if (tryDecimal64) {
                cl = mode == VectorExpressionDescriptor.Mode.FILTER ? FilterDecimal64ColumnInList.class : Decimal64ColumnInList.class;
                int scale = ((DecimalTypeInfo)colExpr.getTypeInfo()).getScale();
                expr = this.createDecimal64VectorExpression(cl, childExpr.subList(0, 1), VectorExpressionDescriptor.Mode.PROJECTION, true, scale, returnType, DataTypePhysicalVariation.NONE, false, new GenericUDFIn());
                if (expr != null) {
                    long[] inVals2 = new long[childrenForInList.size()];
                    for (int i = 0; i != inVals2.length; ++i) {
                        long decimal64Scalar;
                        ExprNodeConstantDesc constDesc = (ExprNodeConstantDesc)childrenForInList.get(i);
                        HiveDecimal hiveDecimal = (HiveDecimal)constDesc.getValue();
                        inVals2[i] = decimal64Scalar = new HiveDecimalWritable(hiveDecimal).serialize64(scale);
                    }
                    ((ILongInExpr)((Object)expr)).setInListValues(inVals2);
                }
            }
            if (expr == null) {
                cl = mode == VectorExpressionDescriptor.Mode.FILTER ? FilterDecimalColumnInList.class : DecimalColumnInList.class;
                expr = this.createVectorExpression(cl, childExpr.subList(0, 1), VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
                HiveDecimal[] inValsD = new HiveDecimal[childrenForInList.size()];
                for (int i = 0; i != inValsD.length; ++i) {
                    inValsD[i] = (HiveDecimal)this.getVectorTypeScalarValue((ExprNodeConstantDesc)childrenForInList.get(i));
                }
                ((IDecimalInExpr)((Object)expr)).setInListValues(inValsD);
            }
        } else if (VectorizationContext.isDateFamily(colType)) {
            cl = mode == VectorExpressionDescriptor.Mode.FILTER ? FilterLongColumnInList.class : LongColumnInList.class;
            inVals = new long[childrenForInList.size()];
            for (int i = 0; i != ((long[])inVals).length; ++i) {
                inVals[i] = (Long)this.getVectorTypeScalarValue((ExprNodeConstantDesc)childrenForInList.get(i));
            }
            expr = this.createVectorExpression(cl, childExpr.subList(0, 1), VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
            ((ILongInExpr)((Object)expr)).setInListValues((long[])inVals);
        }
        return expr;
    }

    private byte[] getStringScalarAsByteArray(ExprNodeConstantDesc exprNodeConstantDesc) throws HiveException {
        Object o = this.getScalarValue(exprNodeConstantDesc);
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        if (o instanceof HiveChar) {
            HiveChar hiveChar = (HiveChar)o;
            try {
                return hiveChar.getStrippedValue().getBytes(StandardCharsets.UTF_8);
            }
            catch (Exception ex) {
                throw new HiveException((Throwable)ex);
            }
        }
        if (o instanceof HiveVarchar) {
            HiveVarchar hiveVarchar = (HiveVarchar)o;
            try {
                return hiveVarchar.getValue().getBytes(StandardCharsets.UTF_8);
            }
            catch (Exception ex) {
                throw new HiveException((Throwable)ex);
            }
        }
        throw new HiveException("Expected constant argument of string family but found " + o.getClass().getSimpleName());
    }

    private PrimitiveObjectInspector.PrimitiveCategory getAnyIntegerPrimitiveCategoryFromUdfClass(Class<? extends UDF> udfClass) {
        if (udfClass.equals(UDFToByte.class)) {
            return PrimitiveObjectInspector.PrimitiveCategory.BYTE;
        }
        if (udfClass.equals(UDFToShort.class)) {
            return PrimitiveObjectInspector.PrimitiveCategory.SHORT;
        }
        if (udfClass.equals(UDFToInteger.class)) {
            return PrimitiveObjectInspector.PrimitiveCategory.INT;
        }
        if (udfClass.equals(UDFToLong.class)) {
            return PrimitiveObjectInspector.PrimitiveCategory.LONG;
        }
        throw new RuntimeException("Unexpected any integery UDF class " + udfClass.getName());
    }

    private VectorExpression getGenericUDFBridgeVectorExpression(GenericUDFBridge udf, List<ExprNodeDesc> childExpr, VectorExpressionDescriptor.Mode mode, TypeInfo returnType) throws HiveException {
        Class<? extends UDF> cl = udf.getUdfClass();
        VectorExpression ve = null;
        if (VectorizationContext.isCastToIntFamily(cl)) {
            PrimitiveObjectInspector.PrimitiveCategory integerPrimitiveCategory = this.getAnyIntegerPrimitiveCategoryFromUdfClass(cl);
            ve = this.getCastToLongExpression(childExpr, integerPrimitiveCategory);
        } else if (VectorizationContext.isCastToBoolean(cl)) {
            ve = this.getCastToBooleanExpression(childExpr, mode);
        } else if (VectorizationContext.isCastToFloatFamily(cl)) {
            ve = this.getCastToDoubleExpression(cl, childExpr, returnType);
        }
        if (ve == null && childExpr instanceof ExprNodeGenericFuncDesc) {
            ve = this.getCustomUDFExpression((ExprNodeGenericFuncDesc)((Object)childExpr), mode);
        }
        return ve;
    }

    private HiveDecimal castConstantToDecimal(Object scalar, TypeInfo type) throws HiveException {
        HiveDecimal rawDecimal;
        if (null == scalar) {
            return null;
        }
        PrimitiveTypeInfo ptinfo = (PrimitiveTypeInfo)type;
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ptinfo.getPrimitiveCategory();
        switch (primitiveCategory) {
            case FLOAT: {
                rawDecimal = HiveDecimal.create((String)String.valueOf(scalar));
                break;
            }
            case DOUBLE: {
                rawDecimal = HiveDecimal.create((String)String.valueOf(scalar));
                break;
            }
            case BYTE: {
                rawDecimal = HiveDecimal.create((int)((Byte)scalar).byteValue());
                break;
            }
            case SHORT: {
                rawDecimal = HiveDecimal.create((int)((Short)scalar).shortValue());
                break;
            }
            case INT: {
                rawDecimal = HiveDecimal.create((int)((Integer)scalar));
                break;
            }
            case LONG: {
                rawDecimal = HiveDecimal.create((long)((Long)scalar));
                break;
            }
            case STRING: {
                rawDecimal = HiveDecimal.create((String)((String)scalar));
                break;
            }
            case CHAR: {
                rawDecimal = HiveDecimal.create((String)((HiveChar)scalar).getStrippedValue());
                break;
            }
            case VARCHAR: {
                rawDecimal = HiveDecimal.create((String)((HiveVarchar)scalar).getValue());
                break;
            }
            case DECIMAL: {
                rawDecimal = (HiveDecimal)scalar;
                break;
            }
            default: {
                throw new HiveException("Unsupported primitive category " + primitiveCategory + " for cast to HiveDecimal");
            }
        }
        if (rawDecimal == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Casting constant scalar " + scalar + " to HiveDecimal resulted in null");
            }
            return null;
        }
        return rawDecimal;
    }

    private String castConstantToString(Object scalar, TypeInfo type) throws HiveException {
        if (null == scalar) {
            return null;
        }
        String typename = type.getTypeName();
        if (!(type instanceof PrimitiveTypeInfo)) {
            throw new HiveException("Unsupported type " + typename + " for cast to String");
        }
        PrimitiveTypeInfo ptinfo = (PrimitiveTypeInfo)type;
        switch (ptinfo.getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return ((Number)scalar).toString();
            }
            case DECIMAL: {
                HiveDecimal decimalVal = (HiveDecimal)scalar;
                DecimalTypeInfo decType = (DecimalTypeInfo)type;
                return decimalVal.toFormatString(decType.getScale());
            }
            case TIMESTAMP: {
                return CastTimestampToString.getTimestampString((Timestamp)scalar);
            }
        }
        throw new HiveException("Unsupported type " + typename + " for cast to String");
    }

    private Double castConstantToDouble(Object scalar, TypeInfo type) throws HiveException {
        if (null == scalar) {
            return null;
        }
        PrimitiveTypeInfo ptinfo = (PrimitiveTypeInfo)type;
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ptinfo.getPrimitiveCategory();
        switch (primitiveCategory) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return ((Number)scalar).doubleValue();
            }
            case STRING: {
                return Double.valueOf((String)scalar);
            }
            case CHAR: {
                return Double.valueOf(((HiveChar)scalar).getStrippedValue());
            }
            case VARCHAR: {
                return Double.valueOf(((HiveVarchar)scalar).getValue());
            }
            case DECIMAL: {
                HiveDecimal decimalVal = (HiveDecimal)scalar;
                return decimalVal.doubleValue();
            }
        }
        throw new HiveException("Unsupported primitive category " + primitiveCategory + " for cast to DOUBLE");
    }

    private Long castConstantToLong(Object scalar, TypeInfo type, PrimitiveObjectInspector.PrimitiveCategory integerPrimitiveCategory) throws HiveException {
        if (null == scalar) {
            return null;
        }
        PrimitiveTypeInfo ptinfo = (PrimitiveTypeInfo)type;
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ptinfo.getPrimitiveCategory();
        switch (primitiveCategory) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return ((Number)scalar).longValue();
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                long longValue = primitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.STRING ? Long.valueOf((String)scalar) : (primitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.CHAR ? Long.valueOf(((HiveChar)scalar).getStrippedValue()).longValue() : Long.valueOf(((HiveVarchar)scalar).getValue()).longValue());
                switch (integerPrimitiveCategory) {
                    case BYTE: {
                        if (longValue == (long)((byte)longValue)) break;
                        return null;
                    }
                    case SHORT: {
                        if (longValue == (long)((short)longValue)) break;
                        return null;
                    }
                    case INT: {
                        if (longValue == (long)((int)longValue)) break;
                        return null;
                    }
                    case LONG: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected integer primitive type " + integerPrimitiveCategory);
                    }
                }
                return longValue;
            }
            case DECIMAL: {
                HiveDecimal decimalVal = (HiveDecimal)scalar;
                switch (integerPrimitiveCategory) {
                    case BYTE: {
                        if (decimalVal.isByte()) break;
                        return null;
                    }
                    case SHORT: {
                        if (decimalVal.isShort()) break;
                        return null;
                    }
                    case INT: {
                        if (decimalVal.isInt()) break;
                        return null;
                    }
                    case LONG: {
                        if (decimalVal.isLong()) break;
                        return null;
                    }
                    default: {
                        throw new RuntimeException("Unexpected integer primitive type " + integerPrimitiveCategory);
                    }
                }
                return decimalVal.longValue();
            }
        }
        throw new HiveException("Unsupported primitive category " + primitiveCategory + " for cast to LONG");
    }

    private DecimalTypeInfo decimalTypeFromCastToDecimal(ExprNodeDesc exprNodeDesc, DecimalTypeInfo returnDecimalType) throws HiveException {
        if (exprNodeDesc instanceof ExprNodeConstantDesc) {
            Object constantValue = ((ExprNodeConstantDesc)exprNodeDesc).getValue();
            HiveDecimal decimalValue = this.castConstantToDecimal(constantValue, exprNodeDesc.getTypeInfo());
            if (decimalValue == null) {
                return returnDecimalType;
            }
            return new DecimalTypeInfo(decimalValue.precision(), decimalValue.scale());
        }
        String inputType = exprNodeDesc.getTypeString();
        if (VectorizationContext.isIntFamily(inputType) || VectorizationContext.isFloatFamily(inputType) || decimalTypePattern.matcher(inputType).matches() || VectorizationContext.isStringFamily(inputType) || inputType.equals("timestamp")) {
            return returnDecimalType;
        }
        return null;
    }

    private VectorExpression getCastToDecimal(List<ExprNodeDesc> childExpr, TypeInfo returnType) throws HiveException {
        ExprNodeDesc child = childExpr.get(0);
        String inputType = childExpr.get(0).getTypeString();
        if (child instanceof ExprNodeConstantDesc) {
            try {
                Object constantValue = ((ExprNodeConstantDesc)child).getValue();
                if (this.tryDecimal64Cast) {
                    if (((DecimalTypeInfo)returnType).precision() <= 18) {
                        Long longValue = this.castConstantToLong(constantValue, child.getTypeInfo(), PrimitiveObjectInspector.PrimitiveCategory.LONG);
                        return this.getConstantVectorExpression(longValue, (TypeInfo)TypeInfoFactory.longTypeInfo, VectorExpressionDescriptor.Mode.PROJECTION);
                    }
                    return null;
                }
                HiveDecimal decimalValue = this.castConstantToDecimal(constantValue, child.getTypeInfo());
                return this.getConstantVectorExpression(decimalValue, returnType, VectorExpressionDescriptor.Mode.PROJECTION);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (VectorizationContext.isIntFamily(inputType)) {
            if (this.tryDecimal64Cast) {
                if (((DecimalTypeInfo)returnType).precision() <= 18) {
                    return this.createVectorExpression(CastLongToDecimal64.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.DECIMAL_64);
                }
                return null;
            }
            return this.createVectorExpression(CastLongToDecimal.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (inputType.equals("float")) {
            return this.createVectorExpression(CastFloatToDecimal.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (inputType.equals("double")) {
            return this.createVectorExpression(CastDoubleToDecimal.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (decimalTypePattern.matcher(inputType).matches()) {
            if (child instanceof ExprNodeColumnDesc) {
                int colIndex = this.getInputColumnIndex((ExprNodeColumnDesc)child);
                DataTypePhysicalVariation dataTypePhysicalVariation = this.getDataTypePhysicalVariation(colIndex);
                if (dataTypePhysicalVariation == DataTypePhysicalVariation.DECIMAL_64) {
                    return this.createDecimal64ToDecimalConversion(colIndex, returnType);
                }
                return this.createVectorExpression(CastDecimalToDecimal.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
            }
            return this.createVectorExpression(CastDecimalToDecimal.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (VectorizationContext.isStringFamily(inputType)) {
            return this.createVectorExpression(CastStringToDecimal.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (inputType.equals("timestamp")) {
            return this.createVectorExpression(CastTimestampToDecimal.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        return null;
    }

    private VectorExpression getCastToString(List<ExprNodeDesc> childExpr, TypeInfo returnType) throws HiveException {
        ExprNodeDesc child = childExpr.get(0);
        String inputType = childExpr.get(0).getTypeString();
        if (child instanceof ExprNodeConstantDesc) {
            try {
                Object constantValue = ((ExprNodeConstantDesc)child).getValue();
                String strValue = this.castConstantToString(constantValue, child.getTypeInfo());
                return this.getConstantVectorExpression(strValue, returnType, VectorExpressionDescriptor.Mode.PROJECTION);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (inputType.equals("boolean")) {
            return this.createVectorExpression(CastBooleanToStringViaLongToString.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (VectorizationContext.isIntFamily(inputType)) {
            return this.createVectorExpression(CastLongToString.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (inputType.equals("float")) {
            return this.createVectorExpression(CastFloatToString.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (inputType.equals("double")) {
            return this.createVectorExpression(CastDoubleToString.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (VectorizationContext.isDecimalFamily(inputType)) {
            return this.createVectorExpression(CastDecimalToString.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (VectorizationContext.isDateFamily(inputType)) {
            return this.createVectorExpression(CastDateToString.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (VectorizationContext.isTimestampFamily(inputType)) {
            return this.createVectorExpression(CastTimestampToString.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (VectorizationContext.isStringFamily(inputType)) {
            return this.getIdentityExpression(childExpr);
        }
        return null;
    }

    private VectorExpression getCastToChar(List<ExprNodeDesc> childExpr, TypeInfo returnType) throws HiveException {
        ExprNodeDesc child = childExpr.get(0);
        String inputType = childExpr.get(0).getTypeString();
        if (child instanceof ExprNodeConstantDesc) {
            return null;
        }
        if (inputType.equals("boolean")) {
            return this.createVectorExpression(CastBooleanToCharViaLongToChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (VectorizationContext.isIntFamily(inputType)) {
            return this.createVectorExpression(CastLongToChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (inputType.equals("float")) {
            return this.createVectorExpression(CastFloatToChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (inputType.equals("double")) {
            return this.createVectorExpression(CastDoubleToChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (VectorizationContext.isDecimalFamily(inputType)) {
            return this.createVectorExpression(CastDecimalToChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (VectorizationContext.isDateFamily(inputType)) {
            return this.createVectorExpression(CastDateToChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (VectorizationContext.isTimestampFamily(inputType)) {
            return this.createVectorExpression(CastTimestampToChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (VectorizationContext.isStringFamily(inputType)) {
            return this.createVectorExpression(CastStringGroupToChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        return null;
    }

    private VectorExpression getCastToVarChar(List<ExprNodeDesc> childExpr, TypeInfo returnType) throws HiveException {
        ExprNodeDesc child = childExpr.get(0);
        String inputType = childExpr.get(0).getTypeString();
        if (child instanceof ExprNodeConstantDesc) {
            return null;
        }
        if (inputType.equals("boolean")) {
            return this.createVectorExpression(CastBooleanToVarCharViaLongToVarChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (VectorizationContext.isIntFamily(inputType)) {
            return this.createVectorExpression(CastLongToVarChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (inputType.equals("float")) {
            return this.createVectorExpression(CastFloatToVarChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (inputType.equals("double")) {
            return this.createVectorExpression(CastDoubleToVarChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (VectorizationContext.isDecimalFamily(inputType)) {
            return this.createVectorExpression(CastDecimalToVarChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (VectorizationContext.isDateFamily(inputType)) {
            return this.createVectorExpression(CastDateToVarChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (VectorizationContext.isTimestampFamily(inputType)) {
            return this.createVectorExpression(CastTimestampToVarChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (VectorizationContext.isStringFamily(inputType)) {
            return this.createVectorExpression(CastStringGroupToVarChar.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        return null;
    }

    private VectorExpression getCastToBinary(List<ExprNodeDesc> childExpr, TypeInfo returnType) throws HiveException {
        ExprNodeDesc child = childExpr.get(0);
        String inputType = childExpr.get(0).getTypeString();
        if (child instanceof ExprNodeConstantDesc) {
            return null;
        }
        if (inputType.equalsIgnoreCase("string") || varcharTypePattern.matcher(inputType).matches()) {
            return this.getIdentityExpression(childExpr);
        }
        if (charTypePattern.matcher(inputType).matches()) {
            return this.createVectorExpression(CastCharToBinary.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        return null;
    }

    private VectorExpression getCastToDoubleExpression(Class<?> udf, List<ExprNodeDesc> childExpr, TypeInfo returnType) throws HiveException {
        ExprNodeDesc child = childExpr.get(0);
        String inputType = childExpr.get(0).getTypeString();
        if (child instanceof ExprNodeConstantDesc) {
            Object constantValue = ((ExprNodeConstantDesc)child).getValue();
            Double doubleValue = this.castConstantToDouble(constantValue, child.getTypeInfo());
            return this.getConstantVectorExpression(doubleValue, returnType, VectorExpressionDescriptor.Mode.PROJECTION);
        }
        if (VectorizationContext.isIntFamily(inputType)) {
            if (udf.equals(UDFToFloat.class)) {
                return this.createVectorExpression(CastLongToFloatViaLongToDouble.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
            }
            return this.createVectorExpression(CastLongToDouble.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (inputType.equals("timestamp")) {
            return this.createVectorExpression(CastTimestampToDouble.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
        }
        if (VectorizationContext.isFloatFamily(inputType)) {
            return this.getIdentityExpression(childExpr);
        }
        return null;
    }

    private VectorExpression getCastToBooleanExpression(List<ExprNodeDesc> childExpr, VectorExpressionDescriptor.Mode mode) throws HiveException {
        ExprNodeDesc child = childExpr.get(0);
        TypeInfo inputTypeInfo = child.getTypeInfo();
        String inputType = inputTypeInfo.toString();
        if (child instanceof ExprNodeConstantDesc) {
            if (null == ((ExprNodeConstantDesc)child).getValue()) {
                return this.getConstantVectorExpression(null, (TypeInfo)TypeInfoFactory.booleanTypeInfo, mode);
            }
            return null;
        }
        VectorExpression ve = VectorizationContext.isStringFamily(inputType) ? this.createVectorExpression(CastStringToBoolean.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, (TypeInfo)TypeInfoFactory.booleanTypeInfo, DataTypePhysicalVariation.NONE) : this.getVectorExpressionForUdf(null, UDFToBoolean.class, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, (TypeInfo)TypeInfoFactory.booleanTypeInfo);
        if (ve == null || mode == VectorExpressionDescriptor.Mode.PROJECTION) {
            return ve;
        }
        int outputColumnNum = ve.getOutputColumnNum();
        SelectColumnIsTrue filterVectorExpr = new SelectColumnIsTrue(outputColumnNum);
        filterVectorExpr.setChildExpressions(new VectorExpression[]{ve});
        filterVectorExpr.setInputTypeInfos(ve.getOutputTypeInfo());
        filterVectorExpr.setInputDataTypePhysicalVariations(DataTypePhysicalVariation.NONE);
        return filterVectorExpr;
    }

    private VectorExpression getCastToLongExpression(List<ExprNodeDesc> childExpr, PrimitiveObjectInspector.PrimitiveCategory integerPrimitiveCategory) throws HiveException {
        ExprNodeDesc child = childExpr.get(0);
        String inputType = childExpr.get(0).getTypeString();
        if (child instanceof ExprNodeConstantDesc) {
            Object constantValue = ((ExprNodeConstantDesc)child).getValue();
            Long longValue = this.castConstantToLong(constantValue, child.getTypeInfo(), integerPrimitiveCategory);
            return this.getConstantVectorExpression(longValue, (TypeInfo)TypeInfoFactory.longTypeInfo, VectorExpressionDescriptor.Mode.PROJECTION);
        }
        if (VectorizationContext.isIntFamily(inputType)) {
            return this.getIdentityExpression(childExpr);
        }
        return null;
    }

    private VectorExpression getCastWithFormat(GenericUDF udf, List<ExprNodeDesc> childExpr, TypeInfo returnType) throws HiveException {
        String inputType = childExpr.get(1).getTypeString();
        childExpr.remove(0);
        Class<?> veClass = this.getCastFormatVectorExpressionClass(childExpr, returnType, inputType);
        return this.createVectorExpression(veClass, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
    }

    private Class<?> getCastFormatVectorExpressionClass(List<ExprNodeDesc> childExpr, TypeInfo returnType, String inputType) throws HiveException {
        switch (inputType) {
            case "timestamp": {
                if (returnType.getTypeName().equals("string")) {
                    return CastTimestampToStringWithFormat.class;
                }
                if (returnType.getTypeName().startsWith("varchar")) {
                    return CastTimestampToVarCharWithFormat.class;
                }
                if (returnType.getTypeName().startsWith("char")) {
                    return CastTimestampToCharWithFormat.class;
                }
            }
            case "date": {
                if (returnType.getTypeName().equals("string")) {
                    return CastDateToStringWithFormat.class;
                }
                if (returnType.getTypeName().startsWith("varchar")) {
                    return CastDateToVarCharWithFormat.class;
                }
                if (!returnType.getTypeName().startsWith("char")) break;
                return CastDateToCharWithFormat.class;
            }
        }
        if (inputType.equals("string") || inputType.startsWith("char") || inputType.startsWith("varchar")) {
            switch (returnType.getTypeName()) {
                case "timestamp": {
                    return CastStringToTimestampWithFormat.class;
                }
                case "date": {
                    return CastStringToDateWithFormat.class;
                }
            }
        }
        throw new HiveException("Expression cast " + inputType + " to " + returnType + " format not vectorizable");
    }

    private VectorExpression tryDecimal64Between(VectorExpressionDescriptor.Mode mode, boolean isNot, ExprNodeDesc colExpr, List<ExprNodeDesc> childrenAfterNot, TypeInfo returnTypeInfo) throws HiveException {
        Class cl = mode == VectorExpressionDescriptor.Mode.PROJECTION ? (isNot ? Decimal64ColumnNotBetween.class : Decimal64ColumnBetween.class) : (isNot ? FilterDecimal64ColumnNotBetween.class : FilterDecimal64ColumnBetween.class);
        return this.createDecimal64VectorExpression(cl, childrenAfterNot, VectorExpressionDescriptor.Mode.PROJECTION, true, ((DecimalTypeInfo)colExpr.getTypeInfo()).getScale(), returnTypeInfo, DataTypePhysicalVariation.NONE, false, new GenericUDFBetween());
    }

    private VectorExpression getBetweenExpression(List<ExprNodeDesc> childExpr, VectorExpressionDescriptor.Mode mode, TypeInfo returnType) throws HiveException {
        boolean hasDynamicValues = false;
        if (childExpr.get(2) instanceof ExprNodeDynamicValueDesc && childExpr.get(3) instanceof ExprNodeDynamicValueDesc) {
            hasDynamicValues = true;
            if (mode == VectorExpressionDescriptor.Mode.PROJECTION) {
                return null;
            }
        } else if (!(childExpr.get(2) instanceof ExprNodeConstantDesc) || !(childExpr.get(3) instanceof ExprNodeConstantDesc)) {
            return null;
        }
        boolean notKeywordPresent = (Boolean)((ExprNodeConstantDesc)childExpr.get(0)).getValue();
        ExprNodeDesc colExpr = childExpr.get(1);
        TypeInfo commonType = FunctionRegistry.getCommonClassForComparison(childExpr.get(1).getTypeInfo(), childExpr.get(2).getTypeInfo());
        if (commonType == null) {
            return null;
        }
        if ((commonType = FunctionRegistry.getCommonClassForComparison(commonType, childExpr.get(3).getTypeInfo())) == null) {
            return null;
        }
        ArrayList<ExprNodeDesc> castChildren = new ArrayList<ExprNodeDesc>();
        boolean wereCastUdfs = false;
        ObjectInspector.Category commonTypeCategory = commonType.getCategory();
        for (ExprNodeDesc desc : childExpr.subList(1, 4)) {
            boolean isNeedsCast;
            TypeInfo childTypeInfo = desc.getTypeInfo();
            ObjectInspector.Category childCategory = childTypeInfo.getCategory();
            if (childCategory != commonTypeCategory) {
                return null;
            }
            if (commonTypeCategory == ObjectInspector.Category.PRIMITIVE) {
                isNeedsCast = ((PrimitiveTypeInfo)commonType).getPrimitiveCategory() != ((PrimitiveTypeInfo)childTypeInfo).getPrimitiveCategory();
            } else {
                boolean bl = isNeedsCast = !commonType.equals((Object)desc.getTypeInfo());
            }
            if (!isNeedsCast) {
                castChildren.add(desc);
                continue;
            }
            GenericUDF castUdf = VectorizationContext.getGenericUDFForCast(commonType);
            ExprNodeGenericFuncDesc engfd = new ExprNodeGenericFuncDesc(commonType, castUdf, Arrays.asList(desc));
            castChildren.add(engfd);
            wereCastUdfs = true;
        }
        String colType = commonType.getTypeName();
        List<ExprNodeDesc> childrenAfterNot = this.evaluateCastOnConstants(castChildren);
        Class cl = null;
        if (VectorizationContext.isIntFamily(colType) && !notKeywordPresent) {
            cl = mode == VectorExpressionDescriptor.Mode.PROJECTION ? LongColumnBetween.class : (hasDynamicValues ? FilterLongColumnBetweenDynamicValue.class : FilterLongColumnBetween.class);
        } else if (VectorizationContext.isIntFamily(colType) && notKeywordPresent) {
            cl = mode == VectorExpressionDescriptor.Mode.PROJECTION ? LongColumnNotBetween.class : FilterLongColumnNotBetween.class;
        } else if (VectorizationContext.isFloatFamily(colType) && !notKeywordPresent) {
            cl = mode == VectorExpressionDescriptor.Mode.PROJECTION ? DoubleColumnBetween.class : (hasDynamicValues ? FilterDoubleColumnBetweenDynamicValue.class : FilterDoubleColumnBetween.class);
        } else if (VectorizationContext.isFloatFamily(colType) && notKeywordPresent) {
            cl = mode == VectorExpressionDescriptor.Mode.PROJECTION ? DoubleColumnNotBetween.class : FilterDoubleColumnNotBetween.class;
        } else if (colType.equals("string") && !notKeywordPresent) {
            cl = mode == VectorExpressionDescriptor.Mode.PROJECTION ? StringColumnBetween.class : (hasDynamicValues ? FilterStringColumnBetweenDynamicValue.class : FilterStringColumnBetween.class);
        } else if (colType.equals("string") && notKeywordPresent) {
            cl = mode == VectorExpressionDescriptor.Mode.PROJECTION ? StringColumnNotBetween.class : FilterStringColumnNotBetween.class;
        } else if (varcharTypePattern.matcher(colType).matches() && !notKeywordPresent) {
            cl = mode == VectorExpressionDescriptor.Mode.PROJECTION ? VarCharColumnBetween.class : (hasDynamicValues ? FilterVarCharColumnBetweenDynamicValue.class : FilterVarCharColumnBetween.class);
        } else if (varcharTypePattern.matcher(colType).matches() && notKeywordPresent) {
            cl = mode == VectorExpressionDescriptor.Mode.PROJECTION ? VarCharColumnNotBetween.class : FilterVarCharColumnNotBetween.class;
        } else if (charTypePattern.matcher(colType).matches() && !notKeywordPresent) {
            cl = mode == VectorExpressionDescriptor.Mode.PROJECTION ? CharColumnBetween.class : (hasDynamicValues ? FilterCharColumnBetweenDynamicValue.class : FilterCharColumnBetween.class);
        } else if (charTypePattern.matcher(colType).matches() && notKeywordPresent) {
            cl = mode == VectorExpressionDescriptor.Mode.PROJECTION ? CharColumnNotBetween.class : FilterCharColumnNotBetween.class;
        } else if (colType.equals("timestamp") && !notKeywordPresent) {
            cl = mode == VectorExpressionDescriptor.Mode.PROJECTION ? TimestampColumnBetween.class : (hasDynamicValues ? FilterTimestampColumnBetweenDynamicValue.class : FilterTimestampColumnBetween.class);
        } else if (colType.equals("timestamp") && notKeywordPresent) {
            cl = mode == VectorExpressionDescriptor.Mode.PROJECTION ? TimestampColumnNotBetween.class : FilterTimestampColumnNotBetween.class;
        } else if (VectorizationContext.isDecimalFamily(colType) && !notKeywordPresent) {
            VectorExpression decimal64VecExpr;
            boolean tryDecimal64;
            boolean bl = tryDecimal64 = this.checkExprNodeDescForDecimal64(colExpr) && !wereCastUdfs && !hasDynamicValues;
            if (tryDecimal64 && (decimal64VecExpr = this.tryDecimal64Between(mode, false, colExpr, childrenAfterNot, returnType)) != null) {
                return decimal64VecExpr;
            }
            cl = mode == VectorExpressionDescriptor.Mode.PROJECTION ? DecimalColumnBetween.class : (hasDynamicValues ? FilterDecimalColumnBetweenDynamicValue.class : FilterDecimalColumnBetween.class);
        } else if (VectorizationContext.isDecimalFamily(colType) && notKeywordPresent) {
            VectorExpression decimal64VecExpr;
            boolean tryDecimal64;
            boolean bl = tryDecimal64 = this.checkExprNodeDescForDecimal64(colExpr) && !wereCastUdfs && !hasDynamicValues;
            if (tryDecimal64 && (decimal64VecExpr = this.tryDecimal64Between(mode, true, colExpr, childrenAfterNot, returnType)) != null) {
                return decimal64VecExpr;
            }
            cl = mode == VectorExpressionDescriptor.Mode.PROJECTION ? DecimalColumnNotBetween.class : FilterDecimalColumnNotBetween.class;
        } else if (VectorizationContext.isDateFamily(colType) && !notKeywordPresent) {
            cl = mode == VectorExpressionDescriptor.Mode.PROJECTION ? LongColumnBetween.class : (hasDynamicValues ? FilterDateColumnBetweenDynamicValue.class : FilterLongColumnBetween.class);
        } else if (VectorizationContext.isDateFamily(colType) && notKeywordPresent) {
            cl = mode == VectorExpressionDescriptor.Mode.PROJECTION ? LongColumnNotBetween.class : FilterLongColumnNotBetween.class;
        }
        return this.createVectorExpression(cl, childrenAfterNot, VectorExpressionDescriptor.Mode.PROJECTION, returnType, DataTypePhysicalVariation.NONE);
    }

    private boolean isCondExpr(ExprNodeDesc exprNodeDesc) {
        return !(exprNodeDesc instanceof ExprNodeConstantDesc) && !(exprNodeDesc instanceof ExprNodeColumnDesc);
    }

    private boolean isNullConst(ExprNodeDesc exprNodeDesc) {
        return exprNodeDesc instanceof ExprNodeConstantDesc && ((ExprNodeConstantDesc)exprNodeDesc).getValue() == null;
    }

    private VectorExpression getIfExpression(GenericUDFIf genericUDFIf, List<ExprNodeDesc> childExpr, VectorExpressionDescriptor.Mode mode, TypeInfo returnType) throws HiveException {
        VectorExpression ve;
        boolean isFilter = false;
        if (mode == VectorExpressionDescriptor.Mode.FILTER) {
            if (returnType.getCategory() == ObjectInspector.Category.PRIMITIVE && ((PrimitiveTypeInfo)returnType).getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN) {
                isFilter = true;
            } else {
                return null;
            }
        }
        if ((ve = this.doGetIfExpression(genericUDFIf, childExpr, returnType)) == null) {
            return null;
        }
        if (isFilter) {
            SelectColumnIsTrue filterVectorExpr = new SelectColumnIsTrue(ve.getOutputColumnNum());
            filterVectorExpr.setChildExpressions(new VectorExpression[]{ve});
            filterVectorExpr.setInputTypeInfos(ve.getOutputTypeInfo());
            filterVectorExpr.setInputDataTypePhysicalVariations(ve.getOutputDataTypePhysicalVariation());
            return filterVectorExpr;
        }
        return ve;
    }

    private VectorExpression doGetIfExpression(GenericUDFIf genericUDFIf, List<ExprNodeDesc> childExpr, TypeInfo returnType) throws HiveException {
        boolean isOnlyGood;
        if (this.hiveVectorIfStmtMode == HiveVectorIfStmtMode.ADAPTOR) {
            return null;
        }
        childExpr = this.getChildExpressionsWithImplicitCast(genericUDFIf, childExpr, returnType);
        ExprNodeDesc ifDesc = Objects.requireNonNull(childExpr).get(0);
        ExprNodeDesc thenDesc = childExpr.get(1);
        ExprNodeDesc elseDesc = childExpr.get(2);
        boolean isThenNullConst = this.isNullConst(thenDesc);
        boolean isElseNullConst = this.isNullConst(elseDesc);
        if (isThenNullConst && isElseNullConst) {
            int outputColumnNum = this.ocm.allocateOutputColumn(returnType);
            IfExprNullNull resultExpr = new IfExprNullNull(outputColumnNum);
            resultExpr.setOutputTypeInfo(returnType);
            resultExpr.setOutputDataTypePhysicalVariation(DataTypePhysicalVariation.NONE);
            return resultExpr;
        }
        boolean isThenCondExpr = this.isCondExpr(thenDesc);
        boolean isElseCondExpr = this.isCondExpr(elseDesc);
        boolean bl = isOnlyGood = this.hiveVectorIfStmtMode == HiveVectorIfStmtMode.GOOD;
        if (isThenNullConst) {
            VectorExpression whenExpr = this.getVectorExpression(ifDesc, VectorExpressionDescriptor.Mode.PROJECTION);
            VectorExpression elseExpr = this.getVectorExpression(elseDesc, VectorExpressionDescriptor.Mode.PROJECTION);
            DataTypePhysicalVariation outputDataTypePhysicalVariation = elseExpr.getOutputDataTypePhysicalVariation() == null ? DataTypePhysicalVariation.NONE : elseExpr.getOutputDataTypePhysicalVariation();
            int outputColumnNum = this.ocm.allocateOutputColumn(returnType, outputDataTypePhysicalVariation);
            VectorExpression resultExpr = !isElseCondExpr || isOnlyGood ? new IfExprNullColumn(whenExpr.getOutputColumnNum(), elseExpr.getOutputColumnNum(), outputColumnNum) : new IfExprNullCondExpr(whenExpr.getOutputColumnNum(), elseExpr.getOutputColumnNum(), outputColumnNum);
            resultExpr.setChildExpressions(new VectorExpression[]{whenExpr, elseExpr});
            resultExpr.setInputTypeInfos(new TypeInfo[]{whenExpr.getOutputTypeInfo(), TypeInfoFactory.voidTypeInfo, elseExpr.getOutputTypeInfo()});
            resultExpr.setInputDataTypePhysicalVariations(whenExpr.getOutputDataTypePhysicalVariation(), outputDataTypePhysicalVariation, elseExpr.getOutputDataTypePhysicalVariation());
            resultExpr.setOutputTypeInfo(returnType);
            resultExpr.setOutputDataTypePhysicalVariation(outputDataTypePhysicalVariation);
            return resultExpr;
        }
        if (isElseNullConst) {
            VectorExpression whenExpr = this.getVectorExpression(ifDesc, VectorExpressionDescriptor.Mode.PROJECTION);
            VectorExpression thenExpr = this.getVectorExpression(thenDesc, VectorExpressionDescriptor.Mode.PROJECTION);
            DataTypePhysicalVariation outputDataTypePhysicalVariation = thenExpr.getOutputDataTypePhysicalVariation() == null ? DataTypePhysicalVariation.NONE : thenExpr.getOutputDataTypePhysicalVariation();
            int outputColumnNum = this.ocm.allocateOutputColumn(returnType, outputDataTypePhysicalVariation);
            VectorExpression resultExpr = !isThenCondExpr || isOnlyGood ? new IfExprColumnNull(whenExpr.getOutputColumnNum(), thenExpr.getOutputColumnNum(), outputColumnNum) : new IfExprCondExprNull(whenExpr.getOutputColumnNum(), thenExpr.getOutputColumnNum(), outputColumnNum);
            resultExpr.setChildExpressions(new VectorExpression[]{whenExpr, thenExpr});
            resultExpr.setInputTypeInfos(new TypeInfo[]{whenExpr.getOutputTypeInfo(), thenExpr.getOutputTypeInfo(), TypeInfoFactory.voidTypeInfo});
            resultExpr.setInputDataTypePhysicalVariations(whenExpr.getOutputDataTypePhysicalVariation(), thenExpr.getOutputDataTypePhysicalVariation(), outputDataTypePhysicalVariation);
            resultExpr.setOutputTypeInfo(returnType);
            resultExpr.setOutputDataTypePhysicalVariation(outputDataTypePhysicalVariation);
            return resultExpr;
        }
        if ((isThenCondExpr || isElseCondExpr) && !isOnlyGood) {
            VectorExpression whenExpr = this.getVectorExpression(ifDesc, VectorExpressionDescriptor.Mode.PROJECTION);
            VectorExpression thenExpr = this.getVectorExpression(thenDesc, VectorExpressionDescriptor.Mode.PROJECTION);
            VectorExpression elseExpr = this.getVectorExpression(elseDesc, VectorExpressionDescriptor.Mode.PROJECTION);
            if (thenExpr.getOutputColumnVectorType() == elseExpr.getOutputColumnVectorType()) {
                DataTypePhysicalVariation outputDataTypePhysicalVariation = thenExpr.getOutputDataTypePhysicalVariation() == elseExpr.getOutputDataTypePhysicalVariation() && thenExpr.getOutputDataTypePhysicalVariation() != null ? thenExpr.getOutputDataTypePhysicalVariation() : DataTypePhysicalVariation.NONE;
                int outputColumnNum = this.ocm.allocateOutputColumn(returnType, outputDataTypePhysicalVariation);
                IfExprCondExprBase resultExpr = isThenCondExpr && isElseCondExpr ? new IfExprCondExprCondExpr(whenExpr.getOutputColumnNum(), thenExpr.getOutputColumnNum(), elseExpr.getOutputColumnNum(), outputColumnNum) : (isThenCondExpr ? new IfExprCondExprColumn(whenExpr.getOutputColumnNum(), thenExpr.getOutputColumnNum(), elseExpr.getOutputColumnNum(), outputColumnNum) : new IfExprColumnCondExpr(whenExpr.getOutputColumnNum(), thenExpr.getOutputColumnNum(), elseExpr.getOutputColumnNum(), outputColumnNum));
                resultExpr.setChildExpressions(new VectorExpression[]{whenExpr, thenExpr, elseExpr});
                resultExpr.setInputTypeInfos(whenExpr.getOutputTypeInfo(), thenExpr.getOutputTypeInfo(), elseExpr.getOutputTypeInfo());
                resultExpr.setInputDataTypePhysicalVariations(whenExpr.getOutputDataTypePhysicalVariation(), thenExpr.getOutputDataTypePhysicalVariation(), elseExpr.getOutputDataTypePhysicalVariation());
                resultExpr.setOutputTypeInfo(returnType);
                resultExpr.setOutputDataTypePhysicalVariation(outputDataTypePhysicalVariation);
                return resultExpr;
            }
        }
        Class<?> udfClass = genericUDFIf.getClass();
        return this.getVectorExpressionForUdf(genericUDFIf, udfClass, childExpr, VectorExpressionDescriptor.Mode.PROJECTION, returnType);
    }

    private VectorExpression getWhenExpression(List<ExprNodeDesc> childExpr, VectorExpressionDescriptor.Mode mode, TypeInfo returnType) throws HiveException {
        ExprNodeDesc elseDesc;
        int size = childExpr.size();
        ExprNodeDesc whenDesc = childExpr.get(0);
        ExprNodeDesc thenDesc = childExpr.get(1);
        if (size == 2) {
            elseDesc = new ExprNodeConstantDesc(returnType, null);
        } else if (size == 3) {
            elseDesc = childExpr.get(2);
        } else {
            GenericUDFWhen udfWhen = new GenericUDFWhen();
            elseDesc = new ExprNodeGenericFuncDesc(returnType, (GenericUDF)udfWhen, udfWhen.getUdfName(), childExpr.subList(2, childExpr.size()));
        }
        GenericUDFIf genericUDFIf = new GenericUDFIf();
        List<ExprNodeDesc> ifChildExpr = Arrays.asList(whenDesc, thenDesc, elseDesc);
        return this.getIfExpression(genericUDFIf, ifChildExpr, mode, returnType);
    }

    private VectorExpression getCustomUDFExpression(ExprNodeGenericFuncDesc expr, VectorExpressionDescriptor.Mode mode) throws HiveException {
        boolean isFilter = false;
        if (mode == VectorExpressionDescriptor.Mode.FILTER) {
            TypeInfo resultTypeInfo = expr.getTypeInfo();
            if (resultTypeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE && ((PrimitiveTypeInfo)resultTypeInfo).getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN) {
                isFilter = true;
            } else {
                return null;
            }
        }
        List<ExprNodeDesc> childExprList = expr.getChildren();
        int childrenCount = childExprList.size();
        VectorUDFArgDesc[] argDescs = new VectorUDFArgDesc[childrenCount];
        for (int i = 0; i < argDescs.length; ++i) {
            argDescs[i] = new VectorUDFArgDesc();
        }
        ArrayList<Integer> variableArgPositions = new ArrayList<Integer>();
        ArrayList<Integer> exprResultColumnNums = new ArrayList<Integer>();
        ArrayList<VectorExpression> vectorExprs = new ArrayList<VectorExpression>();
        TypeInfo[] inputTypeInfos = new TypeInfo[childrenCount];
        DataTypePhysicalVariation[] inputDataTypePhysicalVariations = new DataTypePhysicalVariation[childrenCount];
        for (int i = 0; i < childrenCount; ++i) {
            VectorExpression e;
            ExprNodeDesc child = childExprList.get(i);
            inputTypeInfos[i] = child.getTypeInfo();
            inputDataTypePhysicalVariations[i] = DataTypePhysicalVariation.NONE;
            if (child instanceof ExprNodeGenericFuncDesc) {
                e = this.getVectorExpression(child, VectorExpressionDescriptor.Mode.PROJECTION);
                vectorExprs.add(e);
                variableArgPositions.add(i);
                exprResultColumnNums.add(e.getOutputColumnNum());
                argDescs[i].setVariable(e.getOutputColumnNum());
                continue;
            }
            if (child instanceof ExprNodeColumnDesc) {
                variableArgPositions.add(i);
                argDescs[i].setVariable(this.getInputColumnIndex(((ExprNodeColumnDesc)child).getColumn()));
                continue;
            }
            if (child instanceof ExprNodeConstantDesc) {
                if (child.getTypeInfo().getCategory() != ObjectInspector.Category.PRIMITIVE && child.getTypeInfo().getCategory() != ObjectInspector.Category.STRUCT) {
                    throw new HiveException("Unable to vectorize custom UDF. LIST, MAP, and UNION type constants not supported: " + child);
                }
                argDescs[i].setConstant((ExprNodeConstantDesc)child);
                continue;
            }
            if (child instanceof ExprNodeDynamicValueDesc) {
                e = this.getVectorExpression(child, VectorExpressionDescriptor.Mode.PROJECTION);
                vectorExprs.add(e);
                variableArgPositions.add(i);
                exprResultColumnNums.add(e.getOutputColumnNum());
                argDescs[i].setVariable(e.getOutputColumnNum());
                continue;
            }
            if (child instanceof ExprNodeFieldDesc) {
                e = this.getGenericUDFStructField((ExprNodeFieldDesc)child, VectorExpressionDescriptor.Mode.PROJECTION, child.getTypeInfo());
                vectorExprs.add(e);
                variableArgPositions.add(i);
                exprResultColumnNums.add(e.getOutputColumnNum());
                argDescs[i].setVariable(e.getOutputColumnNum());
                continue;
            }
            throw new HiveException("Unable to vectorize custom UDF. Encountered unsupported expr desc : " + child);
        }
        TypeInfo resultTypeInfo = expr.getTypeInfo();
        String resultTypeName = resultTypeInfo.getTypeName();
        int outputColumnNum = this.ocm.allocateOutputColumn(expr.getTypeInfo());
        VectorUDFAdaptor ve = new VectorUDFAdaptor(expr, outputColumnNum, resultTypeName, argDescs);
        ve.setSuppressEvaluateExceptions(this.adaptorSuppressEvaluateExceptions);
        VectorExpression[] childVEs = null;
        if (exprResultColumnNums.size() != 0) {
            childVEs = new VectorExpression[exprResultColumnNums.size()];
            for (int i = 0; i < childVEs.length; ++i) {
                childVEs[i] = (VectorExpression)vectorExprs.get(i);
            }
        }
        ve.setChildExpressions(childVEs);
        ve.setInputTypeInfos(inputTypeInfos);
        ve.setInputDataTypePhysicalVariations(inputDataTypePhysicalVariations);
        ve.setOutputTypeInfo(resultTypeInfo);
        ve.setOutputDataTypePhysicalVariation(DataTypePhysicalVariation.NONE);
        for (Integer i : exprResultColumnNums) {
            this.ocm.freeOutputColumn(i);
        }
        if (isFilter) {
            SelectColumnIsTrue filterVectorExpr = new SelectColumnIsTrue(outputColumnNum);
            filterVectorExpr.setChildExpressions(new VectorExpression[]{ve});
            filterVectorExpr.setInputTypeInfos(ve.getOutputTypeInfo());
            filterVectorExpr.setInputDataTypePhysicalVariations(ve.getOutputDataTypePhysicalVariation());
            return filterVectorExpr;
        }
        return ve;
    }

    public static boolean isStringFamily(String resultType) {
        return resultType.equalsIgnoreCase("string") || charVarcharTypePattern.matcher(resultType).matches() || resultType.equalsIgnoreCase("string_family");
    }

    public static boolean isDatetimeFamily(String resultType) {
        return resultType.equalsIgnoreCase("timestamp") || resultType.equalsIgnoreCase("date");
    }

    public static boolean isTimestampFamily(String resultType) {
        return resultType.equalsIgnoreCase("timestamp");
    }

    public static boolean isDateFamily(String resultType) {
        return resultType.equalsIgnoreCase("date");
    }

    public static boolean isIntervalYearMonthFamily(String resultType) {
        return resultType.equalsIgnoreCase("interval_year_month");
    }

    public static boolean isIntervalDayTimeFamily(String resultType) {
        return resultType.equalsIgnoreCase("interval_day_time");
    }

    public static boolean isFloatFamily(String resultType) {
        return resultType.equalsIgnoreCase("double") || resultType.equalsIgnoreCase("float");
    }

    public static boolean isIntFamily(String resultType) {
        return resultType.equalsIgnoreCase("tinyint") || resultType.equalsIgnoreCase("smallint") || resultType.equalsIgnoreCase("int") || resultType.equalsIgnoreCase("bigint") || resultType.equalsIgnoreCase("boolean") || resultType.equalsIgnoreCase("long");
    }

    public static boolean isDecimalFamily(String colType) {
        return decimalTypePattern.matcher(colType).matches();
    }

    private Object getScalarValue(ExprNodeConstantDesc constDesc) throws HiveException {
        String typeString = constDesc.getTypeString();
        if (typeString.equalsIgnoreCase("String")) {
            return ((String)constDesc.getValue()).getBytes(StandardCharsets.UTF_8);
        }
        if (charTypePattern.matcher(typeString).matches()) {
            return ((HiveChar)constDesc.getValue()).getStrippedValue().getBytes(StandardCharsets.UTF_8);
        }
        if (varcharTypePattern.matcher(typeString).matches()) {
            return ((HiveVarchar)constDesc.getValue()).getValue().getBytes(StandardCharsets.UTF_8);
        }
        if (typeString.equalsIgnoreCase("boolean")) {
            if (constDesc.getValue() == null) {
                return null;
            }
            return constDesc.getValue().equals(Boolean.TRUE) ? 1 : 0;
        }
        if (decimalTypePattern.matcher(typeString).matches()) {
            return constDesc.getValue();
        }
        return constDesc.getValue();
    }

    private long getIntFamilyScalarAsLong(ExprNodeConstantDesc constDesc) throws HiveException {
        Object o = this.getScalarValue(constDesc);
        if (o instanceof Byte) {
            return ((Byte)o).byteValue();
        }
        if (o instanceof Short) {
            return ((Short)o).shortValue();
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        throw new HiveException("Unexpected type when converting to long : " + o.getClass().getSimpleName());
    }

    private double getNumericScalarAsDouble(ExprNodeDesc constDesc) throws HiveException {
        Object o = this.getScalarValue((ExprNodeConstantDesc)constDesc);
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return ((Long)o).longValue();
        }
        throw new HiveException("Unexpected type when converting to double");
    }

    private Object getVectorTypeScalarValue(ExprNodeConstantDesc constDesc) throws HiveException {
        TypeInfo typeInfo = constDesc.getTypeInfo();
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
        Object scalarValue = this.getScalarValue(constDesc);
        switch (primitiveCategory) {
            case DATE: {
                return (long)DateWritableV2.dateToDays((Date)((Date)scalarValue));
            }
            case TIMESTAMP: {
                return ((org.apache.hadoop.hive.common.type.Timestamp)scalarValue).toSqlTimestamp();
            }
            case INTERVAL_YEAR_MONTH: {
                return ((HiveIntervalYearMonth)scalarValue).getTotalMonths();
            }
        }
        return scalarValue;
    }

    private Timestamp getTimestampScalar(ExprNodeDesc expr) throws HiveException {
        if (expr instanceof ExprNodeGenericFuncDesc && ((ExprNodeGenericFuncDesc)expr).getGenericUDF() instanceof GenericUDFTimestamp) {
            return this.evaluateCastToTimestamp(expr);
        }
        if (!(expr instanceof ExprNodeConstantDesc)) {
            throw new HiveException("Constant timestamp value expected for expression argument. Non-constant argument not supported for vectorization.");
        }
        ExprNodeConstantDesc constExpr = (ExprNodeConstantDesc)expr;
        String constTypeString = constExpr.getTypeString();
        if (VectorizationContext.isStringFamily(constTypeString) || VectorizationContext.isDatetimeFamily(constTypeString)) {
            ExprNodeGenericFuncDesc expr2 = new ExprNodeGenericFuncDesc();
            GenericUDFTimestamp f = new GenericUDFTimestamp();
            expr2.setGenericUDF(f);
            ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
            children.add(expr);
            expr2.setChildren(children);
            return this.evaluateCastToTimestamp(expr2);
        }
        throw new HiveException("Udf: unhandled constant type for scalar argument. Expecting string/date/timestamp.");
    }

    private Timestamp evaluateCastToTimestamp(ExprNodeDesc expr) throws HiveException {
        ExprNodeGenericFuncDesc expr2 = (ExprNodeGenericFuncDesc)expr;
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get(expr2);
        ObjectInspector output = evaluator.initialize(null);
        Object constant = evaluator.evaluate(null);
        Object java = ObjectInspectorUtils.copyToStandardJavaObject((Object)constant, (ObjectInspector)output);
        if (!(java instanceof org.apache.hadoop.hive.common.type.Timestamp)) {
            throw new HiveException("Udf: failed to convert to timestamp");
        }
        return ((org.apache.hadoop.hive.common.type.Timestamp)java).toSqlTimestamp();
    }

    private Constructor<?> getConstructor(Class<?> cl) throws HiveException {
        try {
            Constructor<?>[] ctors = cl.getDeclaredConstructors();
            if (ctors.length == 1) {
                return ctors[0];
            }
            Constructor<?> defaultCtor = cl.getConstructor(new Class[0]);
            for (Constructor<?> ctor : ctors) {
                if (ctor.equals(defaultCtor)) continue;
                return ctor;
            }
            throw new HiveException("Only default constructor found");
        }
        catch (Exception ex) {
            throw new HiveException((Throwable)ex);
        }
    }

    static String getScratchName(TypeInfo typeInfo) throws HiveException {
        if (typeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE && ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.DECIMAL) {
            return typeInfo.getTypeName();
        }
        if (typeInfo.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            return typeInfo.getTypeName();
        }
        ColumnVector.Type columnVectorType = VectorizationContext.getColumnVectorTypeFromTypeInfo(typeInfo);
        return columnVectorType.name().toLowerCase();
    }

    static String getUndecoratedName(String hiveTypeName) throws HiveException {
        VectorExpressionDescriptor.ArgumentType argType = VectorExpressionDescriptor.ArgumentType.fromHiveTypeName(hiveTypeName);
        switch (argType) {
            case INT_FAMILY: {
                return "Long";
            }
            case FLOAT_FAMILY: {
                return "Double";
            }
            case DECIMAL: {
                return "Decimal";
            }
            case STRING: {
                return "String";
            }
            case CHAR: {
                return "Char";
            }
            case VARCHAR: {
                return "VarChar";
            }
            case BINARY: {
                return "Binary";
            }
            case DATE: {
                return "Date";
            }
            case TIMESTAMP: {
                return "Timestamp";
            }
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY_TIME: {
                return hiveTypeName;
            }
            case STRUCT: {
                return "Struct";
            }
            case LIST: {
                return "List";
            }
            case MAP: {
                return "Map";
            }
        }
        throw new HiveException("Unexpected hive type name " + hiveTypeName);
    }

    public static String mapTypeNameSynonyms(String typeName) {
        switch (typeName = typeName.toLowerCase()) {
            case "long": {
                return "bigint";
            }
            case "string_family": {
                return "string";
            }
        }
        return typeName;
    }

    public static ColumnVector.Type getColumnVectorTypeFromTypeInfo(TypeInfo typeInfo) throws HiveException {
        return VectorizationContext.getColumnVectorTypeFromTypeInfo(typeInfo, DataTypePhysicalVariation.NONE);
    }

    public static ColumnVector.Type getColumnVectorTypeFromTypeInfo(TypeInfo typeInfo, DataTypePhysicalVariation dataTypePhysicalVariation) throws HiveException {
        switch (typeInfo.getCategory()) {
            case STRUCT: {
                return ColumnVector.Type.STRUCT;
            }
            case UNION: {
                return ColumnVector.Type.UNION;
            }
            case LIST: {
                return ColumnVector.Type.LIST;
            }
            case MAP: {
                return ColumnVector.Type.MAP;
            }
            case PRIMITIVE: {
                PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = primitiveTypeInfo.getPrimitiveCategory();
                switch (primitiveCategory) {
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case BOOLEAN: 
                    case DATE: 
                    case INTERVAL_YEAR_MONTH: {
                        return ColumnVector.Type.LONG;
                    }
                    case TIMESTAMP: {
                        return ColumnVector.Type.TIMESTAMP;
                    }
                    case INTERVAL_DAY_TIME: {
                        return ColumnVector.Type.INTERVAL_DAY_TIME;
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        return ColumnVector.Type.DOUBLE;
                    }
                    case STRING: 
                    case CHAR: 
                    case VARCHAR: 
                    case BINARY: {
                        return ColumnVector.Type.BYTES;
                    }
                    case DECIMAL: {
                        if (dataTypePhysicalVariation != null && dataTypePhysicalVariation == DataTypePhysicalVariation.DECIMAL_64) {
                            return ColumnVector.Type.DECIMAL_64;
                        }
                        return ColumnVector.Type.DECIMAL;
                    }
                    case VOID: {
                        return ColumnVector.Type.VOID;
                    }
                }
                throw new HiveException("Unexpected primitive type category " + primitiveCategory);
            }
        }
        throw new HiveException("Unexpected type category " + typeInfo.getCategory());
    }

    public int firstOutputColumnIndex() {
        return this.firstOutputColumnIndex;
    }

    public String[] getScratchColumnTypeNames() {
        String[] result = new String[this.ocm.outputColCount];
        for (int i = 0; i < this.ocm.outputColCount; ++i) {
            String vectorTypeName = this.ocm.scratchVectorTypeNames[i];
            String typeName = vectorTypeName.equalsIgnoreCase("bytes") ? "string" : (vectorTypeName.equalsIgnoreCase("long") ? "bigint" : vectorTypeName);
            result[i] = typeName;
        }
        return result;
    }

    public DataTypePhysicalVariation[] getScratchDataTypePhysicalVariations() {
        return Arrays.copyOf(this.ocm.scratchDataTypePhysicalVariations, this.ocm.outputColCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("Context name ").append(this.contextName).append(", level ").append(this.level).append(", ");
        Comparator comparerInteger = Integer::compareTo;
        TreeMap<Integer, String> sortedColumnMap = new TreeMap<Integer, String>(comparerInteger);
        for (Map.Entry<String, Integer> entry : this.projectionColumnMap.entrySet()) {
            sortedColumnMap.put(entry.getValue(), entry.getKey());
        }
        sb.append("sorted projectionColumnMap ").append(sortedColumnMap).append(", ");
        sb.append("initial column names ").append(this.initialColumnNames.toString()).append(",");
        sb.append("initial type infos ").append(this.initialTypeInfos.toString()).append(", ");
        sb.append("scratchColumnTypeNames ").append(Arrays.toString(this.getScratchColumnTypeNames()));
        return sb.toString();
    }

    static {
        castExpressionUdfs.add(GenericUDFToString.class);
        castExpressionUdfs.add(GenericUDFToDecimal.class);
        castExpressionUdfs.add(GenericUDFToBinary.class);
        castExpressionUdfs.add(GenericUDFToDate.class);
        castExpressionUdfs.add(GenericUDFToUnixTimeStamp.class);
        castExpressionUdfs.add(GenericUDFToUtcTimestamp.class);
        castExpressionUdfs.add(GenericUDFToChar.class);
        castExpressionUdfs.add(GenericUDFToVarchar.class);
        castExpressionUdfs.add(GenericUDFTimestamp.class);
        castExpressionUdfs.add(GenericUDFToIntervalYearMonth.class);
        castExpressionUdfs.add(GenericUDFToIntervalDayTime.class);
        castExpressionUdfs.add(UDFToByte.class);
        castExpressionUdfs.add(UDFToBoolean.class);
        castExpressionUdfs.add(UDFToDouble.class);
        castExpressionUdfs.add(UDFToFloat.class);
        castExpressionUdfs.add(UDFToInteger.class);
        castExpressionUdfs.add(UDFToLong.class);
        castExpressionUdfs.add(UDFToShort.class);
        udfsNeedingImplicitDecimalCast = new HashSet();
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPPlus.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPMinus.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPMultiply.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPDivide.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPMod.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFRound.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFBRound.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFFloor.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFCbrt.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFCeil.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFAbs.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFPosMod.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFPower.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFFactorial.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPPositive.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPNegative.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFCoalesce.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFElt.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFGreatest.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFLeast.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFIn.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPEqual.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPEqualNS.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPNotEqual.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPLessThan.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPEqualOrLessThan.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPGreaterThan.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFOPEqualOrGreaterThan.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFBetween.class);
        udfsNeedingImplicitDecimalCast.add(GenericUDFWhen.class);
        udfsNeedingImplicitDecimalCast.add(UDFSqrt.class);
        udfsNeedingImplicitDecimalCast.add(UDFRand.class);
        udfsNeedingImplicitDecimalCast.add(UDFLn.class);
        udfsNeedingImplicitDecimalCast.add(UDFLog2.class);
        udfsNeedingImplicitDecimalCast.add(UDFSin.class);
        udfsNeedingImplicitDecimalCast.add(UDFAsin.class);
        udfsNeedingImplicitDecimalCast.add(UDFCos.class);
        udfsNeedingImplicitDecimalCast.add(UDFAcos.class);
        udfsNeedingImplicitDecimalCast.add(UDFLog10.class);
        udfsNeedingImplicitDecimalCast.add(UDFLog.class);
        udfsNeedingImplicitDecimalCast.add(UDFExp.class);
        udfsNeedingImplicitDecimalCast.add(UDFDegrees.class);
        udfsNeedingImplicitDecimalCast.add(UDFRadians.class);
        udfsNeedingImplicitDecimalCast.add(UDFAtan.class);
        udfsNeedingImplicitDecimalCast.add(UDFTan.class);
        udfsNeedingImplicitDecimalCast.add(UDFOPLongDivide.class);
        POWEROFTENTABLE = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    }

    public static enum InConstantType {
        INT_FAMILY,
        TIMESTAMP,
        DATE,
        FLOAT_FAMILY,
        STRING_FAMILY,
        DECIMAL;

    }

    private static class OutputColumnManager {
        private final int initialOutputCol;
        private int outputColCount = 0;
        private boolean reuseScratchColumns = true;
        private String[] scratchVectorTypeNames = new String[100];
        private DataTypePhysicalVariation[] scratchDataTypePhysicalVariations = new DataTypePhysicalVariation[100];
        private boolean[] scratchColumnTrackWasUsed = new boolean[100];
        private final Set<Integer> usedOutputColumns = new HashSet<Integer>();
        private boolean[] markedScratchColumns;

        protected OutputColumnManager(int initialOutputCol) {
            this.initialOutputCol = initialOutputCol;
        }

        int allocateOutputColumn(TypeInfo typeInfo) throws HiveException {
            return this.allocateOutputColumn(typeInfo, DataTypePhysicalVariation.NONE);
        }

        int allocateOutputColumn(TypeInfo typeInfo, DataTypePhysicalVariation dataTypePhysicalVariation) throws HiveException {
            if (this.initialOutputCol < 0) {
                return 0;
            }
            String vectorTypeName = VectorizationContext.getScratchName(typeInfo);
            int relativeCol = this.allocateOutputColumnInternal(vectorTypeName, dataTypePhysicalVariation);
            return this.initialOutputCol + relativeCol;
        }

        private int allocateOutputColumnInternal(String columnType, DataTypePhysicalVariation dataTypePhysicalVariation) {
            int newIndex;
            for (int i = 0; i < this.outputColCount; ++i) {
                if (this.usedOutputColumns.contains(i) || !this.scratchVectorTypeNames[i].equalsIgnoreCase(columnType) || this.scratchDataTypePhysicalVariations[i] != dataTypePhysicalVariation || this.scratchColumnTrackWasUsed[i]) continue;
                this.usedOutputColumns.add(i);
                return i;
            }
            if (this.outputColCount < this.scratchVectorTypeNames.length) {
                newIndex = this.outputColCount;
                this.scratchVectorTypeNames[this.outputColCount] = columnType;
                this.scratchDataTypePhysicalVariations[this.outputColCount] = dataTypePhysicalVariation;
                this.scratchColumnTrackWasUsed[this.outputColCount++] = true;
                this.usedOutputColumns.add(newIndex);
                return newIndex;
            }
            this.scratchVectorTypeNames = Arrays.copyOf(this.scratchVectorTypeNames, 2 * this.outputColCount);
            this.scratchDataTypePhysicalVariations = Arrays.copyOf(this.scratchDataTypePhysicalVariations, 2 * this.outputColCount);
            this.scratchColumnTrackWasUsed = Arrays.copyOf(this.scratchColumnTrackWasUsed, 2 * this.outputColCount);
            newIndex = this.outputColCount;
            this.scratchVectorTypeNames[this.outputColCount] = columnType;
            this.scratchDataTypePhysicalVariations[this.outputColCount] = dataTypePhysicalVariation;
            this.scratchColumnTrackWasUsed[this.outputColCount++] = true;
            this.usedOutputColumns.add(newIndex);
            return newIndex;
        }

        void freeOutputColumn(int index) {
            if (this.initialOutputCol < 0 || !this.reuseScratchColumns) {
                return;
            }
            int colIndex = index - this.initialOutputCol;
            if (colIndex >= 0) {
                this.usedOutputColumns.remove(index - this.initialOutputCol);
            }
        }

        public int[] currentScratchColumns() {
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            for (Integer col : this.usedOutputColumns) {
                treeSet.add(this.initialOutputCol + col);
            }
            return ArrayUtils.toPrimitive((Integer[])treeSet.toArray(new Integer[0]));
        }

        public String getScratchTypeName(int columnNum) {
            return this.scratchVectorTypeNames[columnNum - this.initialOutputCol];
        }

        public DataTypePhysicalVariation getDataTypePhysicalVariation(int columnNum) {
            if (this.scratchDataTypePhysicalVariations == null) {
                return null;
            }
            return this.scratchDataTypePhysicalVariations[columnNum - this.initialOutputCol];
        }

        public void setReuseColumns(boolean reuseColumns) {
            this.reuseScratchColumns = reuseColumns;
        }

        public void freeMarkedScratchColumns() {
            if (this.markedScratchColumns == null) {
                throw new RuntimeException("Illegal call");
            }
            for (int i = 0; i < this.markedScratchColumns.length; ++i) {
                if (!this.markedScratchColumns[i]) continue;
                this.scratchColumnTrackWasUsed[i] = false;
            }
            this.markedScratchColumns = null;
        }

        public void markScratchColumns() {
            if (this.markedScratchColumns != null) {
                throw new RuntimeException("Illegal call");
            }
            this.markedScratchColumns = Arrays.copyOf(this.scratchColumnTrackWasUsed, this.scratchColumnTrackWasUsed.length);
        }
    }

    public static enum HiveVectorIfStmtMode {
        ADAPTOR,
        GOOD,
        BETTER;


        public static HiveVectorIfStmtMode getHiveConfValue(HiveConf hiveConf) {
            String string = HiveConf.getVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZED_IF_EXPR_MODE);
            return HiveVectorIfStmtMode.valueOf(string.toUpperCase());
        }
    }

    public static enum HiveVectorAdaptorUsageMode {
        NONE,
        CHOSEN,
        ALL;


        public static HiveVectorAdaptorUsageMode getHiveConfValue(HiveConf hiveConf) {
            String string = HiveConf.getVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTOR_ADAPTOR_USAGE_MODE);
            return HiveVectorAdaptorUsageMode.valueOf(string.toUpperCase());
        }
    }
}

