/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorAssignRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriterFactory;
import org.apache.hadoop.hive.ql.exec.vector.wrapper.VectorHashKeyWrapperBase;
import org.apache.hadoop.hive.ql.exec.vector.wrapper.VectorHashKeyWrapperBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.ql.plan.VectorSMBJoinDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorSMBMapJoinOperator
extends SMBMapJoinOperator
implements VectorizationOperator,
VectorizationContextRegion {
    private static final Logger LOG = LoggerFactory.getLogger((String)VectorSMBMapJoinOperator.class.getName());
    private static final long serialVersionUID = 1L;
    private VectorizationContext vContext;
    private VectorSMBJoinDesc vectorDesc;
    private VectorExpression[] bigTableValueExpressions;
    private VectorExpression[] bigTableFilterExpressions;
    private VectorExpression[] keyExpressions;
    private VectorExpressionWriter[] keyOutputWriters;
    private VectorizationContext vOutContext;
    private transient VectorizedRowBatch outputBatch;
    private transient VectorizedRowBatchCtx vrbCtx = null;
    private transient VectorHashKeyWrapperBatch keyWrapperBatch;
    private transient Map<ObjectInspector, VectorAssignRow> outputVectorAssignRowMap;
    private transient int batchIndex = -1;
    private transient VectorHashKeyWrapperBase[] keyValues;
    private transient SMBJoinKeyEvaluator keyEvaluator;
    private transient VectorExpressionWriter[] valueWriters;

    @VisibleForTesting
    public VectorSMBMapJoinOperator() {
    }

    public VectorSMBMapJoinOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorSMBMapJoinOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) throws HiveException {
        this(ctx);
        SMBJoinDesc desc = (SMBJoinDesc)conf;
        this.conf = desc;
        this.vContext = vContext;
        this.vectorDesc = (VectorSMBJoinDesc)vectorDesc;
        this.order = desc.getTagOrder();
        this.numAliases = desc.getExprs().size();
        this.posBigTable = (byte)desc.getPosBigTable();
        this.filterMaps = desc.getFilterMap();
        this.noOuterJoin = desc.isNoOuterJoin();
        Map<Byte, List<ExprNodeDesc>> filterExpressions = desc.getFilters();
        this.bigTableFilterExpressions = vContext.getVectorExpressions(filterExpressions.get(this.posBigTable), VectorExpressionDescriptor.Mode.FILTER);
        List<ExprNodeDesc> keyDesc = desc.getKeys().get(this.posBigTable);
        this.keyExpressions = vContext.getVectorExpressions(keyDesc);
        this.keyOutputWriters = VectorExpressionWriterFactory.getExpressionWriters(this.keyExpressions);
        Map<Byte, List<ExprNodeDesc>> exprs = desc.getExprs();
        this.bigTableValueExpressions = vContext.getVectorExpressions(exprs.get(this.posBigTable));
        this.vOutContext = new VectorizationContext(this.getName(), desc.getOutputColumnNames(), vContext);
    }

    @Override
    public VectorizationContext getInputVectorizationContext() {
        return this.vContext;
    }

    @Override
    protected List<Object> smbJoinComputeKeys(Object row, byte alias) throws HiveException {
        if (alias == this.posBigTable) {
            List<Object> singletonListAndObjects = this.keyEvaluator.evaluate(this.keyValues[this.batchIndex]);
            ArrayList<Object> result = new ArrayList<Object>(singletonListAndObjects.size());
            for (int i = 0; i < singletonListAndObjects.size(); ++i) {
                result.add(ObjectInspectorUtils.copyToStandardObject((Object)singletonListAndObjects.get(i), (ObjectInspector)((ObjectInspector)this.joinKeysObjectInspectors[alias].get(i)), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE));
            }
            return result;
        }
        return super.smbJoinComputeKeys(row, alias);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        VectorExpression.doTransientInit(this.bigTableFilterExpressions, hconf);
        VectorExpression.doTransientInit(this.keyExpressions, hconf);
        VectorExpression.doTransientInit(this.bigTableValueExpressions, hconf);
        this.vrbCtx = new VectorizedRowBatchCtx();
        this.vrbCtx.init((StructObjectInspector)this.outputObjInspector, this.vOutContext.getScratchColumnTypeNames());
        this.outputBatch = this.vrbCtx.createVectorizedRowBatch();
        this.keyWrapperBatch = VectorHashKeyWrapperBatch.compileKeyWrapperBatch(this.keyExpressions);
        this.outputVectorAssignRowMap = new HashMap<ObjectInspector, VectorAssignRow>();
        this.keyEvaluator = new SMBJoinKeyEvaluator(){
            private List<Object> key;

            public SMBJoinKeyEvaluator init() {
                this.key = new ArrayList<Object>();
                for (int i = 0; i < VectorSMBMapJoinOperator.this.keyExpressions.length; ++i) {
                    this.key.add(null);
                }
                return this;
            }

            @Override
            public List<Object> evaluate(VectorHashKeyWrapperBase kw) throws HiveException {
                for (int i = 0; i < VectorSMBMapJoinOperator.this.keyExpressions.length; ++i) {
                    this.key.set(i, VectorSMBMapJoinOperator.this.keyWrapperBatch.getWritableKeyValue(kw, i, VectorSMBMapJoinOperator.this.keyOutputWriters[i]));
                }
                return this.key;
            }
        }.init();
        Map<Byte, List<ExprNodeDesc>> valueExpressions = ((SMBJoinDesc)this.conf).getExprs();
        List<ExprNodeDesc> bigTableExpressions = valueExpressions.get(this.posBigTable);
        ArrayList<ExprNodeEvaluator> vectorNodeEvaluators = new ArrayList<ExprNodeEvaluator>(bigTableExpressions.size());
        VectorExpressionWriterFactory.processVectorExpressions(bigTableExpressions, new VectorExpressionWriterFactory.ListOIDClosure(){

            @Override
            public void assign(VectorExpressionWriter[] writers, List<ObjectInspector> oids) {
                VectorSMBMapJoinOperator.access$302(VectorSMBMapJoinOperator.this, writers);
                ((VectorSMBMapJoinOperator)VectorSMBMapJoinOperator.this).joinValuesObjectInspectors[((VectorSMBMapJoinOperator)VectorSMBMapJoinOperator.this).posBigTable] = oids;
            }
        });
        for (int i = 0; i < bigTableExpressions.size(); ++i) {
            ExprNodeDesc desc = bigTableExpressions.get(i);
            VectorExpression vectorExpr = this.bigTableValueExpressions[i];
            ExprNodeEvaluator eval = new ExprNodeEvaluator<ExprNodeDesc>(desc, hconf){
                int columnIndex;
                int writerIndex;

                public ExprNodeEvaluator initVectorExpr(int columnIndex, int writerIndex) {
                    this.columnIndex = columnIndex;
                    this.writerIndex = writerIndex;
                    return this;
                }

                @Override
                public ObjectInspector initialize(ObjectInspector rowInspector) throws HiveException {
                    throw new HiveException("should never reach here");
                }

                @Override
                protected Object _evaluate(Object row, int version) throws HiveException {
                    VectorizedRowBatch inBatch = (VectorizedRowBatch)row;
                    int rowIndex = inBatch.selectedInUse ? inBatch.selected[VectorSMBMapJoinOperator.this.batchIndex] : VectorSMBMapJoinOperator.this.batchIndex;
                    return VectorSMBMapJoinOperator.this.valueWriters[this.writerIndex].writeValue(inBatch.cols[this.columnIndex], rowIndex);
                }
            }.initVectorExpr(vectorExpr.getOutputColumnNum(), i);
            vectorNodeEvaluators.add(eval);
        }
        this.joinValues[this.posBigTable] = vectorNodeEvaluators;
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        byte alias = (byte)tag;
        if (alias != this.posBigTable) {
            super.process(row, tag);
        } else {
            VectorizedRowBatch inBatch = (VectorizedRowBatch)row;
            if (null != this.bigTableFilterExpressions) {
                for (VectorExpression ve : this.bigTableFilterExpressions) {
                    ve.evaluate(inBatch);
                }
            }
            if (null != this.bigTableValueExpressions) {
                for (VectorExpression ve : this.bigTableValueExpressions) {
                    ve.evaluate(inBatch);
                }
            }
            for (VectorExpression ve : this.keyExpressions) {
                ve.evaluate(inBatch);
            }
            this.keyWrapperBatch.evaluateBatch(inBatch);
            this.keyValues = this.keyWrapperBatch.getVectorHashKeyWrappers();
            this.batchIndex = 0;
            while (this.batchIndex < inBatch.size) {
                super.process(row, tag);
                ++this.batchIndex;
            }
            this.batchIndex = -1;
            this.keyValues = null;
        }
    }

    @Override
    public void closeOp(boolean aborted) throws HiveException {
        super.closeOp(aborted);
        if (!aborted && 0 < this.outputBatch.size) {
            this.flushOutput();
        }
    }

    @Override
    protected void internalForward(Object row, ObjectInspector outputOI) throws HiveException {
        Object[] values = (Object[])row;
        VectorAssignRow va = this.outputVectorAssignRowMap.get(outputOI);
        if (va == null) {
            va = new VectorAssignRow();
            va.init((StructObjectInspector)outputOI, this.vOutContext.getProjectedColumns());
            this.outputVectorAssignRowMap.put(outputOI, va);
        }
        va.assignRow(this.outputBatch, this.outputBatch.size, values);
        ++this.outputBatch.size;
        if (this.outputBatch.size == 1024) {
            this.flushOutput();
        }
    }

    private void flushOutput() throws HiveException {
        this.vectorForward(this.outputBatch);
        this.outputBatch.reset();
    }

    @Override
    public VectorizationContext getOutputVectorizationContext() {
        return this.vOutContext;
    }

    @Override
    public VectorDesc getVectorDesc() {
        return this.vectorDesc;
    }

    static /* synthetic */ VectorExpressionWriter[] access$302(VectorSMBMapJoinOperator x0, VectorExpressionWriter[] x1) {
        x0.valueWriters = x1;
        return x1;
    }

    private static interface SMBJoinKeyEvaluator {
        public List<Object> evaluate(VectorHashKeyWrapperBase var1) throws HiveException;
    }
}

