/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.Decimal64ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.UnionColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAssignRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.VectorPartitionConversion;
import org.apache.hadoop.hive.serde2.fast.DeserializeRead;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableUnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardUnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VectorDeserializeRow<T extends DeserializeRead> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(VectorDeserializeRow.class);
    private T deserializeRead;
    private TypeInfo[] sourceTypeInfos;
    protected DataTypePhysicalVariation[] dataTypePhysicalVariations;
    private byte[] inputBytes;
    private boolean useReadField;
    private int[] readFieldLogicalIndices;
    private int[] projectionColumnNums;
    private Field[] topLevelFields;
    private VectorAssignRow convertVectorAssignRow;

    public VectorDeserializeRow(T deserializeRead) {
        this();
        this.deserializeRead = deserializeRead;
        this.sourceTypeInfos = deserializeRead.typeInfos();
        this.dataTypePhysicalVariations = deserializeRead.getDataTypePhysicalVariations();
    }

    private VectorDeserializeRow() {
    }

    private void allocateArrays(int count) {
        this.projectionColumnNums = new int[count];
        Arrays.fill(this.projectionColumnNums, -1);
        this.topLevelFields = new Field[count];
    }

    private Field allocatePrimitiveField(TypeInfo sourceTypeInfo, DataTypePhysicalVariation dataTypePhysicalVariation) {
        VectorBatchDeserializer deserializer;
        PrimitiveTypeInfo sourcePrimitiveTypeInfo = (PrimitiveTypeInfo)sourceTypeInfo;
        PrimitiveObjectInspector.PrimitiveCategory sourcePrimitiveCategory = sourcePrimitiveTypeInfo.getPrimitiveCategory();
        int maxLength = 0;
        switch (sourcePrimitiveCategory) {
            case VOID: {
                deserializer = new VectorVoidDeserializer();
                break;
            }
            case BOOLEAN: {
                deserializer = new VectorBooleanDeserializer();
                break;
            }
            case BYTE: {
                deserializer = new VectorByteDeserializer();
                break;
            }
            case SHORT: {
                deserializer = new VectorShortDeserializer();
                break;
            }
            case INT: {
                deserializer = new VectorIntDeserializer();
                break;
            }
            case LONG: {
                deserializer = new VectorLongDeserializer();
                break;
            }
            case TIMESTAMP: {
                deserializer = new VectorTimestampDeserializer();
                break;
            }
            case DATE: {
                deserializer = new VectorDateDeserializer();
                break;
            }
            case FLOAT: {
                deserializer = new VectorFloatDeserializer();
                break;
            }
            case DOUBLE: {
                deserializer = new VectorDoubleDeserializer();
                break;
            }
            case BINARY: {
                deserializer = new VectorBinaryDeserializer();
                break;
            }
            case STRING: {
                deserializer = new VectorStringDeserializer();
                break;
            }
            case VARCHAR: {
                maxLength = ((VarcharTypeInfo)sourcePrimitiveTypeInfo).getLength();
                deserializer = new VectorVarcharDeserializer();
                break;
            }
            case CHAR: {
                maxLength = ((CharTypeInfo)sourcePrimitiveTypeInfo).getLength();
                deserializer = new VectorCharDeserializer();
                break;
            }
            case DECIMAL: {
                deserializer = new VectorDecimalDeserializer();
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                deserializer = new VectorIntervalYearMonthDeserializer();
                break;
            }
            case INTERVAL_DAY_TIME: {
                deserializer = new VectorIntervalDayTimeDeserializer();
                break;
            }
            default: {
                throw new RuntimeException("Primitive category " + sourcePrimitiveCategory + " not supported");
            }
        }
        return new Field(sourcePrimitiveCategory, dataTypePhysicalVariation, maxLength, deserializer);
    }

    private Field allocateComplexField(TypeInfo sourceTypeInfo) {
        ObjectInspector.Category category = sourceTypeInfo.getCategory();
        switch (category) {
            case LIST: {
                ListTypeInfo listTypeInfo = (ListTypeInfo)sourceTypeInfo;
                ListComplexTypeHelper listHelper = new ListComplexTypeHelper(this.allocateField(listTypeInfo.getListElementTypeInfo(), DataTypePhysicalVariation.NONE));
                return new Field(category, listHelper, sourceTypeInfo, (VectorBatchDeserializer)new VectorListDeserializer());
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)sourceTypeInfo;
                MapComplexTypeHelper mapHelper = new MapComplexTypeHelper(this.allocateField(mapTypeInfo.getMapKeyTypeInfo(), DataTypePhysicalVariation.NONE), this.allocateField(mapTypeInfo.getMapValueTypeInfo(), DataTypePhysicalVariation.NONE));
                return new Field(category, mapHelper, sourceTypeInfo, (VectorBatchDeserializer)new VectorMapDeserializer());
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)sourceTypeInfo;
                List fieldTypeInfoList = structTypeInfo.getAllStructFieldTypeInfos();
                int count = fieldTypeInfoList.size();
                Field[] fields = new Field[count];
                for (int i = 0; i < count; ++i) {
                    fields[i] = this.allocateField((TypeInfo)fieldTypeInfoList.get(i), DataTypePhysicalVariation.NONE);
                }
                StructComplexTypeHelper structHelper = new StructComplexTypeHelper(fields);
                return new Field(category, structHelper, sourceTypeInfo, (VectorBatchDeserializer)new VectorStructDeserializer());
            }
            case UNION: {
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)sourceTypeInfo;
                List fieldTypeInfoList = unionTypeInfo.getAllUnionObjectTypeInfos();
                int count = fieldTypeInfoList.size();
                Field[] fields = new Field[count];
                for (int i = 0; i < count; ++i) {
                    fields[i] = this.allocateField((TypeInfo)fieldTypeInfoList.get(i), DataTypePhysicalVariation.NONE);
                }
                UnionComplexTypeHelper unionHelper = new UnionComplexTypeHelper(fields);
                return new Field(category, unionHelper, sourceTypeInfo, (VectorBatchDeserializer)new VectorUnionDeserializer());
            }
        }
        throw new RuntimeException("Category " + category + " not supported");
    }

    private Field allocateField(TypeInfo sourceTypeInfo, DataTypePhysicalVariation dataTypePhysicalVariation) {
        switch (sourceTypeInfo.getCategory()) {
            case PRIMITIVE: {
                return this.allocatePrimitiveField(sourceTypeInfo, dataTypePhysicalVariation);
            }
            case LIST: 
            case MAP: 
            case STRUCT: 
            case UNION: {
                return this.allocateComplexField(sourceTypeInfo);
            }
        }
        throw new RuntimeException("Category " + sourceTypeInfo.getCategory() + " not supported");
    }

    private void initTopLevelField(int logicalColumnIndex, int projectionColumnNum, TypeInfo sourceTypeInfo, DataTypePhysicalVariation dataTypePhysicalVariation) {
        this.projectionColumnNums[logicalColumnIndex] = projectionColumnNum;
        this.topLevelFields[logicalColumnIndex] = this.allocateField(sourceTypeInfo, dataTypePhysicalVariation);
    }

    private void addTopLevelConversion(int logicalColumnIndex, TypeInfo targetTypeInfo) {
        Field field = this.topLevelFields[logicalColumnIndex];
        field.setIsConvert(true);
        if (field.getIsPrimitive()) {
            PrimitiveTypeInfo targetPrimitiveTypeInfo = (PrimitiveTypeInfo)targetTypeInfo;
            switch (targetPrimitiveTypeInfo.getPrimitiveCategory()) {
                case CHAR: {
                    field.setMaxLength(((CharTypeInfo)targetPrimitiveTypeInfo).getLength());
                    break;
                }
                case VARCHAR: {
                    field.setMaxLength(((VarcharTypeInfo)targetPrimitiveTypeInfo).getLength());
                    break;
                }
            }
            field.setConversionWritable(VectorizedBatchUtil.getPrimitiveWritable(field.getPrimitiveCategory()));
        }
    }

    public void init(int[] outputColumns) throws HiveException {
        int count = this.sourceTypeInfos.length;
        this.allocateArrays(count);
        for (int i = 0; i < count; ++i) {
            int outputColumn = outputColumns[i];
            this.initTopLevelField(i, outputColumn, this.sourceTypeInfos[i], this.dataTypePhysicalVariations[i]);
        }
    }

    public void init(List<Integer> outputColumns) throws HiveException {
        int count = this.sourceTypeInfos.length;
        this.allocateArrays(count);
        for (int i = 0; i < count; ++i) {
            int outputColumn = outputColumns.get(i);
            this.initTopLevelField(i, outputColumn, this.sourceTypeInfos[i], this.dataTypePhysicalVariations[i]);
        }
    }

    public void init(int startColumn) throws HiveException {
        int count = this.sourceTypeInfos.length;
        this.allocateArrays(count);
        for (int i = 0; i < count; ++i) {
            int outputColumn = startColumn + i;
            this.initTopLevelField(i, outputColumn, this.sourceTypeInfos[i], this.dataTypePhysicalVariations[i]);
        }
    }

    public void init(boolean[] columnsToIncludeTruncated) throws HiveException {
        Preconditions.checkState((columnsToIncludeTruncated == null || columnsToIncludeTruncated.length == this.sourceTypeInfos.length ? 1 : 0) != 0);
        int columnCount = this.sourceTypeInfos.length;
        this.allocateArrays(columnCount);
        int includedCount = 0;
        int[] includedIndices = new int[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            if (columnsToIncludeTruncated != null && !columnsToIncludeTruncated[i]) continue;
            this.initTopLevelField(i, i, this.sourceTypeInfos[i], this.dataTypePhysicalVariations[i]);
            includedIndices[includedCount++] = i;
        }
        if (includedCount < columnCount && this.deserializeRead.isReadFieldSupported()) {
            this.useReadField = true;
            this.readFieldLogicalIndices = Arrays.copyOf(includedIndices, includedCount);
        }
    }

    public void init(int[] outputColumns, boolean[] columnsToInclude) throws HiveException {
        Preconditions.checkState((outputColumns.length == columnsToInclude.length ? 1 : 0) != 0);
        int columnCount = this.sourceTypeInfos.length;
        this.allocateArrays(columnCount);
        int includedCount = 0;
        int[] includedIndices = new int[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            if (!columnsToInclude[i]) continue;
            this.initTopLevelField(i, outputColumns[i], this.sourceTypeInfos[i], this.dataTypePhysicalVariations[i]);
            includedIndices[includedCount++] = i;
        }
        if (includedCount < columnCount && this.deserializeRead.isReadFieldSupported()) {
            this.useReadField = true;
            this.readFieldLogicalIndices = Arrays.copyOf(includedIndices, includedCount);
        }
    }

    public void initConversion(TypeInfo[] targetTypeInfos, boolean[] columnsToIncludeTruncated) throws HiveException {
        Preconditions.checkState((targetTypeInfos.length >= this.sourceTypeInfos.length ? 1 : 0) != 0);
        Preconditions.checkState((columnsToIncludeTruncated == null || columnsToIncludeTruncated.length >= this.sourceTypeInfos.length ? 1 : 0) != 0);
        int columnCount = this.sourceTypeInfos.length;
        this.allocateArrays(columnCount);
        int includedCount = 0;
        int[] includedIndices = new int[columnCount];
        boolean atLeastOneConvert = false;
        for (int i = 0; i < columnCount; ++i) {
            if (columnsToIncludeTruncated != null && !columnsToIncludeTruncated[i]) continue;
            TypeInfo sourceTypeInfo = this.sourceTypeInfos[i];
            TypeInfo targetTypeInfo = targetTypeInfos[i];
            if (!sourceTypeInfo.equals((Object)targetTypeInfo)) {
                if (VectorPartitionConversion.isImplicitVectorColumnConversion(sourceTypeInfo, targetTypeInfo)) {
                    this.initTopLevelField(i, i, sourceTypeInfo, this.dataTypePhysicalVariations[i]);
                } else {
                    this.initTopLevelField(i, i, sourceTypeInfo, this.dataTypePhysicalVariations[i]);
                    this.addTopLevelConversion(i, targetTypeInfo);
                    atLeastOneConvert = true;
                }
            } else {
                this.initTopLevelField(i, i, sourceTypeInfo, this.dataTypePhysicalVariations[i]);
            }
            includedIndices[includedCount++] = i;
        }
        if (includedCount < columnCount && this.deserializeRead.isReadFieldSupported()) {
            this.useReadField = true;
            this.readFieldLogicalIndices = Arrays.copyOf(includedIndices, includedCount);
        }
        if (atLeastOneConvert) {
            this.convertVectorAssignRow = new VectorAssignRow();
            this.convertVectorAssignRow.initConversion(this.sourceTypeInfos, targetTypeInfos, columnsToIncludeTruncated);
        }
    }

    public void init() throws HiveException {
        this.init(0);
    }

    private void storeComplexFieldRowColumn(ColumnVector fieldColVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
        if (!this.deserializeRead.readComplexField()) {
            VectorizedBatchUtil.setNullColIsNullValue(fieldColVector, batchIndex);
            return;
        }
        field.deserializer.store(fieldColVector, field, batchIndex, canRetainByteRef);
        fieldColVector.isNull[batchIndex] = false;
    }

    private void storeRowColumn(VectorizedRowBatch batch, int batchIndex, Field field, int logicalColumnIndex, boolean canRetainByteRef) throws IOException {
        int projectionColumnNum = this.projectionColumnNums[logicalColumnIndex];
        ColumnVector colVector = batch.cols[projectionColumnNum];
        field.deserializer.store(colVector, field, batchIndex, canRetainByteRef);
        colVector.isNull[batchIndex] = false;
    }

    private void convertRowColumn(VectorizedRowBatch batch, int batchIndex, Field field, int logicalColumnIndex) throws IOException {
        int projectionColumnIndex = this.projectionColumnNums[logicalColumnIndex];
        ColumnVector colVector = batch.cols[projectionColumnIndex];
        Object convertSourceWritable = field.deserializer.convert(colVector, batchIndex, field);
        this.convertVectorAssignRow.assignConvertRowColumn(batch, batchIndex, logicalColumnIndex, convertSourceWritable);
    }

    private Object convertComplexFieldRowColumn(ColumnVector colVector, int batchIndex, Field field) throws IOException {
        if (!this.deserializeRead.readComplexField()) {
            VectorizedBatchUtil.setNullColIsNullValue(colVector, batchIndex);
            return null;
        }
        colVector.isNull[batchIndex] = false;
        return field.deserializer.convert(colVector, batchIndex, field);
    }

    public void setBytes(byte[] bytes, int offset, int length) {
        this.inputBytes = bytes;
        this.deserializeRead.set(bytes, offset, length);
    }

    public void deserialize(VectorizedRowBatch batch, int batchIndex) throws IOException {
        int count = this.topLevelFields.length;
        if (!this.useReadField) {
            for (int i = 0; i < count; ++i) {
                int projectionColumnNum = this.projectionColumnNums[i];
                if (projectionColumnNum == -1) {
                    this.deserializeRead.skipNextField();
                    continue;
                }
                if (!this.deserializeRead.readNextField()) {
                    ColumnVector colVector = batch.cols[projectionColumnNum];
                    colVector.isNull[batchIndex] = true;
                    colVector.noNulls = false;
                    continue;
                }
                Field field = this.topLevelFields[i];
                if (field.getIsConvert()) {
                    this.convertRowColumn(batch, batchIndex, field, i);
                    continue;
                }
                this.storeRowColumn(batch, batchIndex, field, i, false);
            }
        } else {
            for (int logicalIndex : this.readFieldLogicalIndices) {
                if (!this.deserializeRead.readField(logicalIndex)) {
                    ColumnVector colVector = batch.cols[this.projectionColumnNums[logicalIndex]];
                    colVector.isNull[batchIndex] = true;
                    colVector.noNulls = false;
                    continue;
                }
                Field field = this.topLevelFields[logicalIndex];
                if (field.getIsConvert()) {
                    this.convertRowColumn(batch, batchIndex, field, logicalIndex);
                    continue;
                }
                this.storeRowColumn(batch, batchIndex, field, logicalIndex, false);
            }
        }
    }

    public void deserializeByRef(VectorizedRowBatch batch, int batchIndex) throws IOException {
        int count = this.topLevelFields.length;
        if (!this.useReadField) {
            for (int i = 0; i < count; ++i) {
                int projectionColumnNum = this.projectionColumnNums[i];
                if (projectionColumnNum == -1) {
                    this.deserializeRead.skipNextField();
                    continue;
                }
                if (!this.deserializeRead.readNextField()) {
                    ColumnVector colVector = batch.cols[projectionColumnNum];
                    colVector.isNull[batchIndex] = true;
                    colVector.noNulls = false;
                    continue;
                }
                Field field = this.topLevelFields[i];
                if (field.getIsConvert()) {
                    this.convertRowColumn(batch, batchIndex, field, i);
                    continue;
                }
                this.storeRowColumn(batch, batchIndex, field, i, true);
            }
        } else {
            for (int logicalIndex : this.readFieldLogicalIndices) {
                if (!this.deserializeRead.readField(logicalIndex)) {
                    ColumnVector colVector = batch.cols[this.projectionColumnNums[logicalIndex]];
                    colVector.isNull[batchIndex] = true;
                    colVector.noNulls = false;
                    continue;
                }
                Field field = this.topLevelFields[logicalIndex];
                if (field.getIsConvert()) {
                    this.convertRowColumn(batch, batchIndex, field, logicalIndex);
                    continue;
                }
                this.storeRowColumn(batch, batchIndex, field, logicalIndex, true);
            }
        }
    }

    public String getDetailedReadPositionString() {
        return this.deserializeRead.getDetailedReadPositionString();
    }

    static abstract class VectorBatchDeserializer {
        VectorBatchDeserializer() {
        }

        abstract void store(ColumnVector var1, Field var2, int var3, boolean var4) throws IOException;

        abstract Object convert(ColumnVector var1, int var2, Field var3) throws IOException;
    }

    class VectorUnionDeserializer
    extends VectorBatchDeserializer {
        VectorUnionDeserializer() {
        }

        @Override
        void store(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
            this.storeUnionRowColumn(colVector, field, batchIndex, canRetainByteRef);
        }

        @Override
        Object convert(ColumnVector batch, int batchIndex, Field field) throws IOException {
            return this.convertUnionRowColumn(batch, batchIndex, field);
        }

        private Object convertUnionRowColumn(ColumnVector colVector, int batchIndex, Field field) throws IOException {
            SettableUnionObjectInspector unionOI = (SettableUnionObjectInspector)field.objectInspector;
            UnionComplexTypeHelper unionHelper = (UnionComplexTypeHelper)field.getComplexHelper();
            Field[] fields = unionHelper.getFields();
            UnionColumnVector unionColumnVector = (UnionColumnVector)colVector;
            Object union = unionOI.create();
            int tag = ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentInt;
            unionOI.setFieldAndTag(union, (Object)new StandardUnionObjectInspector.StandardUnion((byte)tag, VectorDeserializeRow.this.convertComplexFieldRowColumn(unionColumnVector.fields[tag], batchIndex, fields[tag])), (byte)tag);
            VectorDeserializeRow.this.deserializeRead.finishComplexVariableFieldsType();
            return union;
        }

        private void storeUnionRowColumn(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
            VectorDeserializeRow.this.deserializeRead.readComplexField();
            int tag = ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentInt;
            UnionColumnVector unionColVector = (UnionColumnVector)colVector;
            ColumnVector[] colVectorFields = unionColVector.fields;
            UnionComplexTypeHelper unionHelper = (UnionComplexTypeHelper)field.getComplexHelper();
            unionColVector.isNull[batchIndex] = false;
            unionColVector.tags[batchIndex] = tag;
            VectorDeserializeRow.this.storeComplexFieldRowColumn(colVectorFields[tag], unionHelper.getFields()[tag], batchIndex, canRetainByteRef);
            VectorDeserializeRow.this.deserializeRead.finishComplexVariableFieldsType();
        }
    }

    class VectorStructDeserializer
    extends VectorBatchDeserializer {
        VectorStructDeserializer() {
        }

        @Override
        void store(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
            this.storeStructRowColumn(colVector, field, batchIndex, canRetainByteRef);
        }

        @Override
        Object convert(ColumnVector batch, int batchIndex, Field field) throws IOException {
            return this.convertStructRowColumn(batch, batchIndex, field);
        }

        private Object convertStructRowColumn(ColumnVector colVector, int batchIndex, Field field) throws IOException {
            SettableStructObjectInspector structOI = (SettableStructObjectInspector)field.objectInspector;
            List structFields = structOI.getAllStructFieldRefs();
            StructComplexTypeHelper structHelper = (StructComplexTypeHelper)field.getComplexHelper();
            Field[] fields = structHelper.getFields();
            StructColumnVector structColumnVector = (StructColumnVector)colVector;
            Object struct = structOI.create();
            for (int i = 0; i < fields.length; ++i) {
                Object fieldObject = VectorDeserializeRow.this.convertComplexFieldRowColumn(structColumnVector.fields[i], batchIndex, fields[i]);
                structOI.setStructFieldData(struct, (StructField)structFields.get(i), fieldObject);
            }
            VectorDeserializeRow.this.deserializeRead.finishComplexVariableFieldsType();
            return struct;
        }

        private void storeStructRowColumn(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
            StructColumnVector structColVector = (StructColumnVector)colVector;
            ColumnVector[] colVectorFields = structColVector.fields;
            StructComplexTypeHelper structHelper = (StructComplexTypeHelper)field.getComplexHelper();
            Field[] fields = structHelper.getFields();
            structColVector.isNull[batchIndex] = false;
            int i = 0;
            for (ColumnVector colVectorField : colVectorFields) {
                VectorDeserializeRow.this.storeComplexFieldRowColumn(colVectorField, fields[i], batchIndex, canRetainByteRef);
                ++i;
            }
            VectorDeserializeRow.this.deserializeRead.finishComplexVariableFieldsType();
        }
    }

    class VectorMapDeserializer
    extends VectorBatchDeserializer {
        VectorMapDeserializer() {
        }

        @Override
        void store(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
            this.storeMapRowColumn(colVector, field, batchIndex, canRetainByteRef);
        }

        @Override
        Object convert(ColumnVector batch, int batchIndex, Field field) throws IOException {
            return this.convertMapRowColumn(batch, batchIndex, field);
        }

        private Object convertMapRowColumn(ColumnVector colVector, int batchIndex, Field field) throws IOException {
            SettableMapObjectInspector mapOI = (SettableMapObjectInspector)field.objectInspector;
            MapComplexTypeHelper mapHelper = (MapComplexTypeHelper)field.getComplexHelper();
            Field keyField = mapHelper.getKeyField();
            Field valueField = mapHelper.getValueField();
            MapColumnVector mapColumnVector = (MapColumnVector)colVector;
            Object map = mapOI.create();
            while (VectorDeserializeRow.this.deserializeRead.isNextComplexMultiValue()) {
                Object key = VectorDeserializeRow.this.convertComplexFieldRowColumn(mapColumnVector.keys, batchIndex, keyField);
                Object value = VectorDeserializeRow.this.convertComplexFieldRowColumn(mapColumnVector.values, batchIndex, valueField);
                mapOI.put(map, key, value);
            }
            return map;
        }

        private void storeMapRowColumn(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
            MapColumnVector mapColVector = (MapColumnVector)colVector;
            MapComplexTypeHelper mapHelper = (MapComplexTypeHelper)field.getComplexHelper();
            ColumnVector keysColVector = mapColVector.keys;
            ColumnVector valuesColVector = mapColVector.values;
            int offset = mapColVector.childCount;
            mapColVector.offsets[batchIndex] = offset;
            mapColVector.isNull[batchIndex] = false;
            int keyValueCount = 0;
            while (VectorDeserializeRow.this.deserializeRead.isNextComplexMultiValue()) {
                int childCapacity = mapColVector.keys.isNull.length;
                if ((double)childCapacity < (double)offset / 0.75) {
                    mapColVector.keys.ensureSize(childCapacity * 2, true);
                    mapColVector.values.ensureSize(childCapacity * 2, true);
                }
                VectorDeserializeRow.this.storeComplexFieldRowColumn(keysColVector, mapHelper.getKeyField(), offset, canRetainByteRef);
                VectorDeserializeRow.this.storeComplexFieldRowColumn(valuesColVector, mapHelper.getValueField(), offset, canRetainByteRef);
                ++offset;
                ++keyValueCount;
            }
            mapColVector.childCount += keyValueCount;
            mapColVector.lengths[batchIndex] = keyValueCount;
        }
    }

    class VectorListDeserializer
    extends VectorBatchDeserializer {
        VectorListDeserializer() {
        }

        @Override
        void store(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
            this.storeListRowColumn(colVector, field, batchIndex, canRetainByteRef);
        }

        @Override
        Object convert(ColumnVector batch, int batchIndex, Field field) throws IOException {
            return this.convertListRowColumn(batch, batchIndex, field);
        }

        private Object convertListRowColumn(ColumnVector colVector, int batchIndex, Field field) throws IOException {
            SettableListObjectInspector listOI = (SettableListObjectInspector)field.objectInspector;
            ListComplexTypeHelper listHelper = (ListComplexTypeHelper)field.getComplexHelper();
            Field elementField = listHelper.getElementField();
            ArrayList<Object> tempList = new ArrayList<Object>();
            ListColumnVector listColumnVector = (ListColumnVector)colVector;
            while (VectorDeserializeRow.this.deserializeRead.isNextComplexMultiValue()) {
                tempList.add(VectorDeserializeRow.this.convertComplexFieldRowColumn(listColumnVector.child, batchIndex, elementField));
            }
            int size = tempList.size();
            Object list = listOI.create(size);
            for (int i = 0; i < size; ++i) {
                listOI.set(list, i, tempList.get(i));
            }
            return list;
        }

        private void storeListRowColumn(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
            ListColumnVector listColVector = (ListColumnVector)colVector;
            ColumnVector elementColVector = listColVector.child;
            int offset = listColVector.childCount;
            listColVector.isNull[batchIndex] = false;
            listColVector.offsets[batchIndex] = offset;
            ListComplexTypeHelper listHelper = (ListComplexTypeHelper)field.getComplexHelper();
            int listLength = 0;
            while (VectorDeserializeRow.this.deserializeRead.isNextComplexMultiValue()) {
                int childCapacity = listColVector.child.isNull.length;
                if ((double)childCapacity < (double)offset / 0.75) {
                    listColVector.child.ensureSize(childCapacity * 2, true);
                }
                VectorDeserializeRow.this.storeComplexFieldRowColumn(elementColVector, listHelper.getElementField(), offset, canRetainByteRef);
                ++offset;
                ++listLength;
            }
            listColVector.childCount += listLength;
            listColVector.lengths[batchIndex] = listLength;
        }
    }

    private static class UnionComplexTypeHelper
    extends FieldsComplexTypeHelper {
        public UnionComplexTypeHelper(Field[] fields) {
            super(fields);
        }
    }

    private static class StructComplexTypeHelper
    extends FieldsComplexTypeHelper {
        public StructComplexTypeHelper(Field[] fields) {
            super(fields);
        }
    }

    private static class FieldsComplexTypeHelper
    extends ComplexTypeHelper {
        private Field[] fields;

        public FieldsComplexTypeHelper(Field[] fields) {
            this.fields = fields;
        }

        public Field[] getFields() {
            return this.fields;
        }
    }

    private static class MapComplexTypeHelper
    extends ComplexTypeHelper {
        private Field keyField;
        private Field valueField;

        public MapComplexTypeHelper(Field keyField, Field valueField) {
            this.keyField = keyField;
            this.valueField = valueField;
        }

        public Field getKeyField() {
            return this.keyField;
        }

        public Field getValueField() {
            return this.valueField;
        }
    }

    private static class ListComplexTypeHelper
    extends ComplexTypeHelper {
        private Field elementField;

        public ListComplexTypeHelper(Field elementField) {
            this.elementField = elementField;
        }

        public Field getElementField() {
            return this.elementField;
        }
    }

    private static class ComplexTypeHelper {
        private ComplexTypeHelper() {
        }
    }

    class VectorIntervalDayTimeDeserializer
    extends VectorBatchDeserializer {
        VectorIntervalDayTimeDeserializer() {
        }

        @Override
        void store(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
            ((IntervalDayTimeColumnVector)colVector).set(batchIndex, ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentHiveIntervalDayTimeWritable.getHiveIntervalDayTime());
        }

        @Override
        Object convert(ColumnVector batch, int batchIndex, Field field) throws IOException {
            return this.convertIntervalDayTime(field.getConversionWritable());
        }

        private Object convertIntervalDayTime(Object writable) {
            if (writable == null) {
                writable = new HiveIntervalDayTimeWritable();
            }
            ((HiveIntervalDayTimeWritable)writable).set(((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentHiveIntervalDayTimeWritable);
            return writable;
        }
    }

    class VectorIntervalYearMonthDeserializer
    extends VectorBatchDeserializer {
        VectorIntervalYearMonthDeserializer() {
        }

        @Override
        void store(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
            ((LongColumnVector)colVector).vector[batchIndex] = ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentHiveIntervalYearMonthWritable.getHiveIntervalYearMonth().getTotalMonths();
        }

        @Override
        Object convert(ColumnVector batch, int batchIndex, Field field) throws IOException {
            return this.convertIntervalYearMonth(field.getConversionWritable());
        }

        private Object convertIntervalYearMonth(Object writable) {
            if (writable == null) {
                writable = new HiveIntervalYearMonthWritable();
            }
            ((HiveIntervalYearMonthWritable)writable).set(((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentHiveIntervalYearMonthWritable);
            return writable;
        }
    }

    class VectorDecimalDeserializer
    extends VectorBatchDeserializer {
        VectorDecimalDeserializer() {
        }

        @Override
        void store(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
            if (field.getDataTypePhysicalVariation() == DataTypePhysicalVariation.DECIMAL_64) {
                ((Decimal64ColumnVector)colVector).vector[batchIndex] = ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentDecimal64;
            } else {
                ((DecimalColumnVector)colVector).set(batchIndex, ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentHiveDecimalWritable);
            }
        }

        @Override
        Object convert(ColumnVector batch, int batchIndex, Field field) throws IOException {
            return this.convertDecimal(field.getConversionWritable());
        }

        private Object convertDecimal(Object writable) {
            if (writable == null) {
                writable = new HiveDecimalWritable();
            }
            ((HiveDecimalWritable)writable).set(((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentHiveDecimalWritable);
            return writable;
        }
    }

    class VectorCharDeserializer
    extends VectorBatchDeserializer {
        VectorCharDeserializer() {
        }

        @Override
        void store(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
            BytesColumnVector bytesColVec = (BytesColumnVector)colVector;
            if (((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentExternalBufferNeeded) {
                bytesColVec.ensureValPreallocated(((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentExternalBufferNeededLen);
                byte[] convertBuffer = bytesColVec.getValPreallocatedBytes();
                int convertBufferStart = bytesColVec.getValPreallocatedStart();
                VectorDeserializeRow.this.deserializeRead.copyToExternalBuffer(convertBuffer, convertBufferStart);
                bytesColVec.setValPreallocated(batchIndex, StringExpr.rightTrimAndTruncate((byte[])convertBuffer, (int)convertBufferStart, (int)((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentExternalBufferNeededLen, (int)field.getMaxLength()));
            } else if (canRetainByteRef && VectorDeserializeRow.this.inputBytes == ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytes) {
                bytesColVec.setRef(batchIndex, ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytes, ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesStart, StringExpr.rightTrimAndTruncate((byte[])((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytes, (int)((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesStart, (int)((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesLength, (int)field.getMaxLength()));
            } else {
                bytesColVec.setVal(batchIndex, ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytes, ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesStart, StringExpr.rightTrimAndTruncate((byte[])((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytes, (int)((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesStart, (int)((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesLength, (int)field.getMaxLength()));
            }
        }

        @Override
        Object convert(ColumnVector batch, int batchIndex, Field field) throws IOException {
            return this.convertChar(field.getConversionWritable(), batchIndex, field);
        }

        private Object convertChar(Object writable, int batchIndex, Field field) {
            if (writable == null) {
                writable = new HiveCharWritable();
            }
            if (((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytes == null) {
                throw new RuntimeException("null char entry: batchIndex " + batchIndex);
            }
            int adjustedLength = StringExpr.rightTrimAndTruncate((byte[])((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytes, (int)((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesStart, (int)((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesLength, (int)field.getMaxLength());
            ((HiveCharWritable)writable).set(new String(((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytes, ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesStart, adjustedLength, Charsets.UTF_8), -1);
            return writable;
        }
    }

    class VectorVarcharDeserializer
    extends VectorBatchDeserializer {
        VectorVarcharDeserializer() {
        }

        @Override
        void store(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
            BytesColumnVector bytesColVec = (BytesColumnVector)colVector;
            if (((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentExternalBufferNeeded) {
                bytesColVec.ensureValPreallocated(((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentExternalBufferNeededLen);
                byte[] convertBuffer = bytesColVec.getValPreallocatedBytes();
                int convertBufferStart = bytesColVec.getValPreallocatedStart();
                VectorDeserializeRow.this.deserializeRead.copyToExternalBuffer(convertBuffer, convertBufferStart);
                bytesColVec.setValPreallocated(batchIndex, StringExpr.truncate((byte[])convertBuffer, (int)convertBufferStart, (int)((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentExternalBufferNeededLen, (int)field.getMaxLength()));
            } else if (canRetainByteRef && VectorDeserializeRow.this.inputBytes == ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytes) {
                bytesColVec.setRef(batchIndex, ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytes, ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesStart, StringExpr.truncate((byte[])((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytes, (int)((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesStart, (int)((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesLength, (int)field.getMaxLength()));
            } else {
                bytesColVec.setVal(batchIndex, ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytes, ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesStart, StringExpr.truncate((byte[])((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytes, (int)((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesStart, (int)((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesLength, (int)field.getMaxLength()));
            }
        }

        @Override
        Object convert(ColumnVector batch, int batchIndex, Field field) throws IOException {
            return this.convertVarchar(field.getConversionWritable(), batchIndex, field);
        }

        private Object convertVarchar(Object writable, int batchIndex, Field field) {
            if (writable == null) {
                writable = new HiveVarcharWritable();
            }
            if (((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytes == null) {
                throw new RuntimeException("null varchar entry: batchIndex " + batchIndex);
            }
            int adjustedLength = StringExpr.truncate((byte[])((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytes, (int)((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesStart, (int)((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesLength, (int)field.getMaxLength());
            ((HiveVarcharWritable)writable).set(new String(((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytes, ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesStart, adjustedLength, Charsets.UTF_8), -1);
            return writable;
        }
    }

    class VectorStringDeserializer
    extends VectorBatchDeserializer {
        VectorStringDeserializer() {
        }

        @Override
        void store(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
            this.storeString(colVector, field, batchIndex, canRetainByteRef);
        }

        @Override
        Object convert(ColumnVector batch, int batchIndex, Field field) throws IOException {
            return this.convertString(field.getConversionWritable(), batchIndex);
        }

        private void storeString(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
            BytesColumnVector bytesColVec = (BytesColumnVector)colVector;
            if (((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentExternalBufferNeeded) {
                bytesColVec.ensureValPreallocated(((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentExternalBufferNeededLen);
                VectorDeserializeRow.this.deserializeRead.copyToExternalBuffer(bytesColVec.getValPreallocatedBytes(), bytesColVec.getValPreallocatedStart());
                bytesColVec.setValPreallocated(batchIndex, ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentExternalBufferNeededLen);
            } else if (canRetainByteRef && VectorDeserializeRow.this.inputBytes == ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytes) {
                bytesColVec.setRef(batchIndex, ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytes, ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesStart, ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesLength);
            } else {
                bytesColVec.setVal(batchIndex, ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytes, ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesStart, ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesLength);
            }
        }

        private Object convertString(Object writable, int batchIndex) {
            if (writable == null) {
                writable = new Text();
            }
            if (((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytes == null) {
                throw new RuntimeException("null string entry: batchIndex " + batchIndex);
            }
            ((Text)writable).set(((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytes, ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesStart, ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesLength);
            return writable;
        }
    }

    class VectorBinaryDeserializer
    extends VectorStringDeserializer {
        VectorBinaryDeserializer() {
        }

        @Override
        Object convert(ColumnVector batch, int batchIndex, Field field) throws IOException {
            return this.convertBinary(field.getConversionWritable(), batchIndex);
        }

        private Object convertBinary(Object writable, int batchIndex) {
            if (writable == null) {
                writable = new BytesWritable();
            }
            if (((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytes == null) {
                LOG.info("null binary entry: batchIndex " + batchIndex);
            }
            ((BytesWritable)writable).set(((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytes, ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesStart, ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBytesLength);
            return writable;
        }
    }

    class VectorDoubleDeserializer
    extends VectorBatchDeserializer {
        VectorDoubleDeserializer() {
        }

        @Override
        void store(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
            ((DoubleColumnVector)colVector).vector[batchIndex] = ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentDouble;
        }

        @Override
        Object convert(ColumnVector batch, int batchIndex, Field field) throws IOException {
            return this.convertDouble(field.getConversionWritable());
        }

        private Object convertDouble(Object writable) {
            if (writable == null) {
                writable = new DoubleWritable();
            }
            ((DoubleWritable)writable).set(((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentDouble);
            return writable;
        }
    }

    class VectorFloatDeserializer
    extends VectorBatchDeserializer {
        VectorFloatDeserializer() {
        }

        @Override
        void store(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
            ((DoubleColumnVector)colVector).vector[batchIndex] = ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentFloat;
        }

        @Override
        Object convert(ColumnVector batch, int batchIndex, Field field) throws IOException {
            return this.convertFloat(field.getConversionWritable());
        }

        private Object convertFloat(Object writable) {
            if (writable == null) {
                writable = new FloatWritable();
            }
            ((FloatWritable)writable).set(((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentFloat);
            return writable;
        }
    }

    class VectorDateDeserializer
    extends VectorBatchDeserializer {
        VectorDateDeserializer() {
        }

        @Override
        void store(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
            ((LongColumnVector)colVector).vector[batchIndex] = ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentDateWritable.getDays();
        }

        @Override
        Object convert(ColumnVector batch, int batchIndex, Field field) throws IOException {
            return this.convertDate(field.getConversionWritable());
        }

        private Object convertDate(Object writable) {
            if (writable == null) {
                writable = new DateWritableV2();
            }
            ((DateWritableV2)writable).set(((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentDateWritable);
            return writable;
        }
    }

    class VectorTimestampDeserializer
    extends VectorBatchDeserializer {
        VectorTimestampDeserializer() {
        }

        @Override
        void store(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
            ((TimestampColumnVector)colVector).set(batchIndex, ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentTimestampWritable.getTimestamp().toSqlTimestamp());
        }

        @Override
        Object convert(ColumnVector batch, int batchIndex, Field field) throws IOException {
            return this.convertTimestamp(field.getConversionWritable());
        }

        private Object convertTimestamp(Object writable) {
            if (writable == null) {
                writable = new TimestampWritableV2();
            }
            ((TimestampWritableV2)writable).set(((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentTimestampWritable);
            return writable;
        }
    }

    class VectorLongDeserializer
    extends VectorBatchDeserializer {
        VectorLongDeserializer() {
        }

        @Override
        void store(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
            ((LongColumnVector)colVector).vector[batchIndex] = ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentLong;
        }

        @Override
        Object convert(ColumnVector batch, int batchIndex, Field field) throws IOException {
            return this.convertLong(field.getConversionWritable());
        }

        private Object convertLong(Object writable) {
            if (writable == null) {
                writable = new LongWritable();
            }
            ((LongWritable)writable).set(((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentLong);
            return writable;
        }
    }

    class VectorIntDeserializer
    extends VectorBatchDeserializer {
        VectorIntDeserializer() {
        }

        @Override
        void store(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
            ((LongColumnVector)colVector).vector[batchIndex] = ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentInt;
        }

        @Override
        Object convert(ColumnVector batch, int batchIndex, Field field) throws IOException {
            return this.convertInt(field.getConversionWritable());
        }

        private Object convertInt(Object writable) {
            if (writable == null) {
                writable = new IntWritable();
            }
            ((IntWritable)writable).set(((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentInt);
            return writable;
        }
    }

    class VectorShortDeserializer
    extends VectorBatchDeserializer {
        VectorShortDeserializer() {
        }

        @Override
        void store(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
            ((LongColumnVector)colVector).vector[batchIndex] = ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentShort;
        }

        @Override
        Object convert(ColumnVector batch, int batchIndex, Field field) throws IOException {
            return this.convertShort(field.getConversionWritable());
        }

        private Object convertShort(Object writable) {
            if (writable == null) {
                writable = new ShortWritable();
            }
            ((ShortWritable)writable).set(((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentShort);
            return writable;
        }
    }

    class VectorByteDeserializer
    extends VectorBatchDeserializer {
        VectorByteDeserializer() {
        }

        @Override
        void store(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
            ((LongColumnVector)colVector).vector[batchIndex] = ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentByte;
        }

        @Override
        Object convert(ColumnVector batch, int batchIndex, Field field) throws IOException {
            return this.convertByte(field.getConversionWritable());
        }

        private Object convertByte(Object writable) {
            if (writable == null) {
                writable = new ByteWritable();
            }
            ((ByteWritable)writable).set(((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentByte);
            return writable;
        }
    }

    class VectorBooleanDeserializer
    extends VectorBatchDeserializer {
        VectorBooleanDeserializer() {
        }

        @Override
        void store(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
            ((LongColumnVector)colVector).vector[batchIndex] = ((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBoolean ? 1 : 0;
        }

        @Override
        Object convert(ColumnVector batch, int batchIndex, Field field) throws IOException {
            return this.convertBoolean(field.getConversionWritable());
        }

        private Object convertBoolean(Object writable) {
            if (writable == null) {
                writable = new BooleanWritable();
            }
            ((BooleanWritable)writable).set(((VectorDeserializeRow)VectorDeserializeRow.this).deserializeRead.currentBoolean);
            return writable;
        }
    }

    class VectorVoidDeserializer
    extends VectorBatchDeserializer {
        VectorVoidDeserializer() {
        }

        @Override
        void store(ColumnVector colVector, Field field, int batchIndex, boolean canRetainByteRef) throws IOException {
            VectorizedBatchUtil.setNullColIsNullValue(colVector, batchIndex);
        }

        @Override
        Object convert(ColumnVector batch, int batchIndex, Field field) throws IOException {
            return null;
        }
    }

    private static class Field {
        private boolean isPrimitive;
        private ObjectInspector.Category category;
        private PrimitiveObjectInspector.PrimitiveCategory primitiveCategory;
        private DataTypePhysicalVariation dataTypePhysicalVariation;
        private int maxLength;
        private boolean isConvert;
        private Object conversionWritable;
        private ComplexTypeHelper complexTypeHelper;
        private ObjectInspector objectInspector;
        private VectorBatchDeserializer deserializer;

        public Field(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory, DataTypePhysicalVariation dataTypePhysicalVariation, int maxLength, VectorBatchDeserializer deserializer) {
            this.isPrimitive = true;
            this.category = ObjectInspector.Category.PRIMITIVE;
            this.primitiveCategory = primitiveCategory;
            this.dataTypePhysicalVariation = dataTypePhysicalVariation;
            this.maxLength = maxLength;
            this.isConvert = false;
            this.conversionWritable = null;
            this.complexTypeHelper = null;
            this.objectInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)primitiveCategory);
            this.deserializer = deserializer;
        }

        public Field(ObjectInspector.Category category, ComplexTypeHelper complexTypeHelper, TypeInfo typeInfo, VectorBatchDeserializer deserializer) {
            this.isPrimitive = false;
            this.category = category;
            this.objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)typeInfo);
            this.primitiveCategory = null;
            this.dataTypePhysicalVariation = null;
            this.maxLength = 0;
            this.isConvert = false;
            this.conversionWritable = null;
            this.complexTypeHelper = complexTypeHelper;
            this.deserializer = deserializer;
        }

        public boolean getIsPrimitive() {
            return this.isPrimitive;
        }

        public ObjectInspector.Category getCategory() {
            return this.category;
        }

        public PrimitiveObjectInspector.PrimitiveCategory getPrimitiveCategory() {
            return this.primitiveCategory;
        }

        public DataTypePhysicalVariation getDataTypePhysicalVariation() {
            return this.dataTypePhysicalVariation;
        }

        public void setMaxLength(int maxLength) {
            this.maxLength = maxLength;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public void setIsConvert(boolean isConvert) {
            this.isConvert = isConvert;
        }

        public boolean getIsConvert() {
            return this.isConvert;
        }

        public void setConversionWritable(Object conversionWritable) {
            this.conversionWritable = conversionWritable;
        }

        public Object getConversionWritable() {
            return this.conversionWritable;
        }

        public ComplexTypeHelper getComplexHelper() {
            return this.complexTypeHelper;
        }

        public ObjectInspector getObjectInspector() {
            return this.objectInspector;
        }

        public VectorBatchDeserializer getDeserializer() {
            return this.deserializer;
        }
    }
}

