/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.security.UserGroupInformation;

public class Retryable {
    private static final long MINIMUM_DELAY_IN_SEC = 60L;
    private long totalDurationInSeconds;
    private List<Class<? extends Exception>> retryOn = new ArrayList<Class<? extends Exception>>();
    private List<Class<? extends Exception>> failOn = new ArrayList<Class<? extends Exception>>();
    private long initialDelayInSeconds;
    private long maxRetryDelayInSeconds;
    private double backOff;
    private int maxJitterInSeconds;

    private Retryable() {
        this.initialDelayInSeconds = HiveConf.toTime((String)HiveConf.ConfVars.REPL_RETRY_INTIAL_DELAY.defaultStrVal, (TimeUnit)HiveConf.getDefaultTimeUnit((HiveConf.ConfVars)HiveConf.ConfVars.REPL_RETRY_INTIAL_DELAY), (TimeUnit)TimeUnit.SECONDS);
        this.maxRetryDelayInSeconds = HiveConf.toTime((String)HiveConf.ConfVars.REPL_RETRY_MAX_DELAY_BETWEEN_RETRIES.defaultStrVal, (TimeUnit)HiveConf.getDefaultTimeUnit((HiveConf.ConfVars)HiveConf.ConfVars.REPL_RETRY_MAX_DELAY_BETWEEN_RETRIES), (TimeUnit)TimeUnit.SECONDS);
        this.backOff = HiveConf.ConfVars.REPL_RETRY_BACKOFF_COEFFICIENT.defaultFloatVal;
        this.maxJitterInSeconds = (int)HiveConf.toTime((String)HiveConf.ConfVars.REPL_RETRY_JITTER.defaultStrVal, (TimeUnit)HiveConf.getDefaultTimeUnit((HiveConf.ConfVars)HiveConf.ConfVars.REPL_RETRY_JITTER), (TimeUnit)TimeUnit.SECONDS);
        this.totalDurationInSeconds = HiveConf.toTime((String)HiveConf.ConfVars.REPL_RETRY_TOTAL_DURATION.defaultStrVal, (TimeUnit)HiveConf.getDefaultTimeUnit((HiveConf.ConfVars)HiveConf.ConfVars.REPL_RETRY_TOTAL_DURATION), (TimeUnit)TimeUnit.SECONDS);
    }

    public static Builder builder() {
        return new Builder();
    }

    public <T> T executeCallable(Callable<T> callable) throws Exception {
        long startTime = System.currentTimeMillis();
        long delay = this.initialDelayInSeconds;
        Exception previousException = null;
        while (true) {
            try {
                if (UserGroupInformation.isSecurityEnabled()) {
                    SecurityUtils.reloginExpiringKeytabUser();
                    return (T)UserGroupInformation.getLoginUser().doAs(() -> callable.call());
                }
                return callable.call();
            }
            catch (Exception e) {
                if (this.failOn.stream().noneMatch(k -> e.getClass().equals(k)) && this.retryOn.stream().anyMatch(k -> e.getClass().isAssignableFrom((Class<?>)k))) {
                    if (this.elapsedTimeInSeconds(startTime) + delay > this.totalDurationInSeconds) {
                        throw e;
                    }
                    this.sleep(delay);
                    delay = this.getNextDelay(delay, previousException, e);
                    previousException = e;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private void sleep(long seconds) {
        try {
            Thread.sleep(seconds * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private long getNextDelay(long currentDelay, Exception previousException, Exception currentException) {
        if (previousException != null && !previousException.getClass().equals(currentException.getClass())) {
            return this.initialDelayInSeconds;
        }
        if (currentDelay <= 0L) {
            currentDelay = 60L;
        }
        currentDelay = (long)((double)currentDelay * this.backOff);
        if (this.maxJitterInSeconds > 0) {
            currentDelay += (long)new Random().nextInt(this.maxJitterInSeconds);
        }
        if (currentDelay > this.maxRetryDelayInSeconds) {
            currentDelay = this.maxRetryDelayInSeconds;
        }
        return currentDelay;
    }

    private long elapsedTimeInSeconds(long fromTimeMillis) {
        return (System.currentTimeMillis() - fromTimeMillis) / 1000L;
    }

    public static class Builder {
        private final Retryable runnable = new Retryable();

        public Builder withHiveConf(HiveConf conf) {
            this.runnable.totalDurationInSeconds = conf.getTimeVar(HiveConf.ConfVars.REPL_RETRY_TOTAL_DURATION, TimeUnit.SECONDS);
            this.runnable.initialDelayInSeconds = conf.getTimeVar(HiveConf.ConfVars.REPL_RETRY_INTIAL_DELAY, TimeUnit.SECONDS);
            this.runnable.maxRetryDelayInSeconds = conf.getTimeVar(HiveConf.ConfVars.REPL_RETRY_MAX_DELAY_BETWEEN_RETRIES, TimeUnit.SECONDS);
            this.runnable.backOff = conf.getFloatVar(HiveConf.ConfVars.REPL_RETRY_BACKOFF_COEFFICIENT);
            this.runnable.maxJitterInSeconds = (int)conf.getTimeVar(HiveConf.ConfVars.REPL_RETRY_JITTER, TimeUnit.SECONDS);
            return this;
        }

        public Retryable build() {
            return this.runnable;
        }

        public Builder withTotalDuration(long maxDuration) {
            this.runnable.totalDurationInSeconds = maxDuration;
            return this;
        }

        public synchronized Builder withRetryOnException(Class<? extends Exception> exceptionClass) {
            if (exceptionClass != null && this.runnable.retryOn.stream().noneMatch(k -> exceptionClass.equals(k))) {
                this.runnable.retryOn.add(exceptionClass);
            }
            return this;
        }

        public synchronized Builder withRetryOnExceptionList(List<Class<? extends Exception>> exceptionClassList) {
            for (Class<? extends Exception> exceptionClass : exceptionClassList) {
                if (exceptionClass == null || !this.runnable.retryOn.stream().noneMatch(k -> exceptionClass.equals(k))) continue;
                this.runnable.retryOn.add(exceptionClass);
            }
            return this;
        }

        public synchronized Builder withFailOnException(Class<? extends Exception> exceptionClass) {
            if (exceptionClass != null && this.runnable.failOn.stream().noneMatch(k -> exceptionClass.equals(k))) {
                this.runnable.failOn.add(exceptionClass);
            }
            return this;
        }

        public synchronized Builder withFailOnExceptionList(List<Class<? extends Exception>> exceptionClassList) {
            for (Class<? extends Exception> exceptionClass : exceptionClassList) {
                if (exceptionClass == null || !this.runnable.failOn.stream().noneMatch(k -> exceptionClass.equals(k))) continue;
                this.runnable.failOn.add(exceptionClass);
            }
            return this;
        }

        public Builder withInitialDelay(long initialDelayInSeconds) {
            this.runnable.initialDelayInSeconds = initialDelayInSeconds;
            return this;
        }

        public Builder withMaxRetryDelay(long maxRetryDelayInSeconds) {
            this.runnable.maxRetryDelayInSeconds = maxRetryDelayInSeconds;
            return this;
        }

        public Builder withBackoff(double backoff) {
            this.runnable.backOff = backoff;
            return this;
        }

        public Builder withMaxJitterValue(int maxJitterInSeconds) {
            this.runnable.maxJitterInSeconds = maxJitterInSeconds;
            return this;
        }
    }
}

