/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnQueueHelper {
    private static final Logger LOG = LoggerFactory.getLogger(YarnQueueHelper.class);
    private static final String PERMISSION_PATH = "/ws/v1/cluster/queues/%s/access?user=%s";
    private final String[] rmNodes;
    private int lastKnownGoodUrl;
    private boolean sslForYarn;
    private boolean isHA;
    private static String webapp_conf_key = "yarn.resourcemanager.webapp.address";
    private static String webapp_ssl_conf_key = "yarn.resourcemanager.webapp.https.address";
    private static String yarn_HA_enabled = "yarn.resourcemanager.ha.enabled";
    private static String yarn_HA_rmids = "yarn.resourcemanager.ha.rm-ids";

    public YarnQueueHelper(HiveConf conf) {
        ArrayList<String> nodeList = new ArrayList<String>();
        this.sslForYarn = YarnConfiguration.useHttps((Configuration)conf);
        this.isHA = conf.getBoolean(yarn_HA_enabled, false);
        LOG.info(String.format("Yarn is using SSL: %s", this.sslForYarn));
        LOG.info(String.format("Yarn HA is enabled: %s", this.isHA));
        if (this.isHA) {
            String[] rmids = conf.getStrings(yarn_HA_rmids);
            if (this.sslForYarn) {
                for (String rmid : rmids) {
                    nodeList.addAll(Arrays.asList(conf.getTrimmedStrings(webapp_ssl_conf_key + "." + rmid)));
                }
                Preconditions.checkArgument((nodeList.size() > 0 ? 1 : 0) != 0, (Object)"yarn.resourcemanager.ha.rm-ids must be set to enable queue access checks in Yarn HA mode");
            } else {
                for (String rmid : rmids) {
                    nodeList.addAll(Arrays.asList(conf.getTrimmedStrings(webapp_conf_key + "." + rmid)));
                    Preconditions.checkArgument((nodeList.size() > 0 ? 1 : 0) != 0, (Object)"yarn.resourcemanager.ha.rm-ids must be set to enable queue access checks in Yarn HA mode");
                }
            }
            this.rmNodes = nodeList.toArray(new String[nodeList.size()]);
        } else if (this.sslForYarn) {
            this.rmNodes = conf.getTrimmedStrings(webapp_ssl_conf_key);
            Preconditions.checkArgument((this.rmNodes != null && this.rmNodes.length > 0 ? 1 : 0) != 0, (Object)"yarn.resourcemanager.webapp.https.address must be set to enable queue access checks using TLS");
        } else {
            this.rmNodes = conf.getTrimmedStrings(webapp_conf_key);
            Preconditions.checkArgument((this.rmNodes != null && this.rmNodes.length > 0 ? 1 : 0) != 0, (Object)"yarn.resourcemanager.webapp.address must be set to enable queue access checks");
        }
        this.lastKnownGoodUrl = 0;
    }

    public void checkQueueAccess(String queueName, String userName) throws IOException, HiveException {
        String urlSuffix = String.format(PERMISSION_PATH, queueName, userName);
        int urlIx = this.lastKnownGoodUrl;
        int lastUrlIx = (urlIx == 0 ? this.rmNodes.length : urlIx) - 1;
        Exception firstError = null;
        while (true) {
            boolean isCallOk;
            String error;
            block6: {
                String node = this.rmNodes[urlIx];
                error = null;
                isCallOk = false;
                String urlToCheck = this.sslForYarn ? "https://" + node + urlSuffix : "http://" + node + urlSuffix;
                try {
                    error = this.checkQueueAccessFromSingleRm(urlToCheck);
                    isCallOk = true;
                }
                catch (Exception ex) {
                    LOG.warn("Cannot check queue access against RM " + node, (Throwable)ex);
                    if (firstError != null) break block6;
                    firstError = ex;
                }
            }
            if (isCallOk) {
                this.lastKnownGoodUrl = urlIx;
                if (error == null) {
                    return;
                }
                throw new HiveException(error.isEmpty() ? userName + " has no access to " + queueName : error);
            }
            if (urlIx == lastUrlIx) {
                throw new IOException("Cannot access any RM service; first error", firstError);
            }
            urlIx = (urlIx + 1) % this.rmNodes.length;
        }
    }

    private String checkQueueAccessFromSingleRm(String urlString) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection connection = UserGroupInformation.isSecurityEnabled() ? this.getSecureConnection(url) : (HttpURLConnection)url.openConnection();
        int statusCode = connection.getResponseCode();
        switch (statusCode) {
            case 200: {
                return this.processResponse(connection);
            }
            case 403: {
                throw new IOException(this.handleUnexpectedStatusCode(connection, statusCode, "check that the HiveServer2 principal is in the administrator list of the root YARN queue"));
            }
        }
        throw new IOException(this.handleUnexpectedStatusCode(connection, statusCode, null));
    }

    private String processResponse(HttpURLConnection connection) throws IOException {
        InputStream stream = connection.getInputStream();
        if (stream == null) {
            throw new IOException(this.handleUnexpectedStatusCode(connection, 200, "No input on successful API call"));
        }
        String jsonStr = IOUtils.toString((InputStream)stream);
        try {
            JSONObject obj = new JSONObject(jsonStr);
            boolean result = obj.getBoolean("allowed");
            if (result) {
                return null;
            }
            String diag = obj.getString("diagnostics");
            return diag == null ? "" : diag;
        }
        catch (JSONException ex) {
            LOG.error("Couldn't parse " + jsonStr, (Throwable)ex);
            throw ex;
        }
    }

    private HttpURLConnection getSecureConnection(URL url) throws IOException {
        AuthenticatedURL.Token token = new AuthenticatedURL.Token();
        try {
            return new AuthenticatedURL().openConnection(url, token);
        }
        catch (AuthenticationException e) {
            throw new IOException(e);
        }
    }

    public String handleUnexpectedStatusCode(HttpURLConnection connection, int statusCode, String errorStr) throws IOException {
        InputStream errorStream = connection.getErrorStream();
        String error = "Received " + statusCode + (errorStr == null ? "" : " (" + errorStr + ")");
        if (errorStream != null) {
            error = error + ": " + IOUtils.toString((InputStream)errorStream);
        } else {
            errorStream = connection.getInputStream();
            if (errorStream != null) {
                error = error + ": " + IOUtils.toString((InputStream)errorStream);
            }
        }
        return error;
    }
}

