/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.ObjectCacheFactory;
import org.apache.hadoop.hive.ql.exec.tez.MapRecordProcessor;
import org.apache.hadoop.hive.ql.exec.tez.ObjectCache;
import org.apache.hadoop.hive.ql.exec.tez.RecordProcessor;
import org.apache.hadoop.hive.ql.exec.tez.ReduceRecordProcessor;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.mapreduce.processor.MRTaskReporter;
import org.apache.tez.runtime.api.AbstractLogicalIOProcessor;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.ExecutionContext;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.api.TaskFailureType;
import org.apache.tez.runtime.api.events.CustomProcessorEvent;
import org.apache.tez.runtime.library.api.KeyValueWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezProcessor
extends AbstractLogicalIOProcessor {
    public static final String HIVE_TEZ_VERTEX_NAME = "hive.tez.vertex.name";
    public static final String HIVE_TEZ_VERTEX_INDEX = "hive.tez.vertex.index";
    public static final String HIVE_TEZ_TASK_INDEX = "hive.tez.task.index";
    public static final String HIVE_TEZ_TASK_ATTEMPT_NUMBER = "hive.tez.task.attempt.number";
    private static final Logger LOG = LoggerFactory.getLogger(TezProcessor.class);
    protected boolean isMap = false;
    protected RecordProcessor rproc = null;
    private final AtomicBoolean aborted = new AtomicBoolean(false);
    protected JobConf jobConf;
    private static final String CLASS_NAME = TezProcessor.class.getName();
    private final PerfLogger perfLogger = SessionState.getPerfLogger();
    protected ProcessorContext processorContext;
    private ReflectiveProgressHelper progressHelper;
    protected static final NumberFormat taskIdFormat = NumberFormat.getInstance();
    protected static final NumberFormat jobIdFormat = NumberFormat.getInstance();

    public TezProcessor(ProcessorContext context) {
        super(context);
        ObjectCache.setupObjectRegistry(context.getObjectRegistry());
    }

    public void close() throws IOException {
        if (this.progressHelper != null) {
            this.progressHelper.shutDownProgressTaskService();
        }
    }

    public void handleEvents(List<Event> arg0) {
        assert (arg0.size() <= 1);
        for (Event event : arg0) {
            CustomProcessorEvent cpEvent = (CustomProcessorEvent)event;
            ByteBuffer buffer = cpEvent.getPayload();
            IntBuffer intBuffer = buffer.asIntBuffer();
            this.jobConf.setInt("llap.num.buckets", intBuffer.get(0));
            this.jobConf.setInt("llap.bucket.id", intBuffer.get(1));
        }
    }

    public void initialize() throws IOException {
        this.perfLogger.perfLogBegin(CLASS_NAME, "TezInitializeProcessor");
        Configuration conf = TezUtils.createConfFromUserPayload((UserPayload)this.getContext().getUserPayload());
        this.jobConf = new JobConf(conf);
        this.processorContext = this.getContext();
        this.initTezAttributes();
        ExecutionContext execCtx = this.processorContext.getExecutionContext();
        if (execCtx instanceof Hook) {
            ((Hook)execCtx).initializeHook(this);
        }
        this.setupMRLegacyConfigs(this.processorContext);
        this.perfLogger.perfLogEnd(CLASS_NAME, "TezInitializeProcessor");
    }

    private void initTezAttributes() {
        this.jobConf.set(HIVE_TEZ_VERTEX_NAME, this.processorContext.getTaskVertexName());
        this.jobConf.setInt(HIVE_TEZ_VERTEX_INDEX, this.processorContext.getTaskVertexIndex());
        this.jobConf.setInt(HIVE_TEZ_TASK_INDEX, this.processorContext.getTaskIndex());
        this.jobConf.setInt(HIVE_TEZ_TASK_ATTEMPT_NUMBER, this.processorContext.getTaskAttemptNumber());
    }

    private void setupMRLegacyConfigs(ProcessorContext processorContext) {
        StringBuilder taskAttemptIdBuilder = new StringBuilder("attempt_");
        taskAttemptIdBuilder.append(processorContext.getApplicationId().getClusterTimestamp()).append("_").append(jobIdFormat.format(processorContext.getApplicationId().getId())).append("_");
        if (this.isMap) {
            taskAttemptIdBuilder.append("m_");
        } else {
            taskAttemptIdBuilder.append("r_");
        }
        taskAttemptIdBuilder.append(taskIdFormat.format(processorContext.getTaskIndex())).append("_").append(processorContext.getTaskAttemptNumber());
        String taskAttemptIdStr = taskAttemptIdBuilder.toString();
        this.jobConf.set("mapred.task.id", taskAttemptIdStr);
        this.jobConf.set("mapreduce.task.attempt.id", taskAttemptIdStr);
        this.jobConf.setInt("mapred.task.partition", processorContext.getTaskIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
        if (this.aborted.get()) {
            return;
        }
        this.perfLogger.perfLogBegin(CLASS_NAME, "TezRunProcessor");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running task: " + this.getContext().getUniqueIdentifier());
        }
        TezProcessor tezProcessor = this;
        synchronized (tezProcessor) {
            boolean limitReached = this.checkLimitReached();
            if (limitReached) {
                LOG.info("TezProcessor exits early as query limit already reached, vertex: {}, task: {}, attempt: {}", new Object[]{this.jobConf.get(HIVE_TEZ_VERTEX_NAME), this.jobConf.get(HIVE_TEZ_TASK_INDEX), this.jobConf.get(HIVE_TEZ_TASK_ATTEMPT_NUMBER)});
                this.aborted.set(true);
            }
            if (this.aborted.get()) {
                return;
            }
            this.progressHelper = new ReflectiveProgressHelper((Configuration)this.jobConf, inputs, this.getContext(), ((Object)((Object)this)).getClass().getSimpleName());
            this.rproc = this.isMap ? new MapRecordProcessor(this.jobConf, this.getContext()) : new ReduceRecordProcessor(this.jobConf, this.getContext());
        }
        this.progressHelper.scheduleProgressTaskService(0L, 100L);
        if (!this.aborted.get()) {
            this.initializeAndRunProcessor(inputs, outputs);
        }
    }

    private boolean checkLimitReached() {
        String queryId = HiveConf.getVar((Configuration)this.jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEQUERYID);
        String limitReachedKey = LimitOperator.getLimitReachedKey((Configuration)this.jobConf);
        try {
            return ObjectCacheFactory.getCache((Configuration)this.jobConf, queryId, false, true).retrieve(limitReachedKey, new Callable<AtomicBoolean>(){

                @Override
                public AtomicBoolean call() {
                    return new AtomicBoolean(false);
                }
            }).get();
        }
        catch (HiveException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeAndRunProcessor(Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
        Throwable originalThrowable = null;
        try {
            MRTaskReporter mrReporter = new MRTaskReporter(this.getContext());
            this.rproc.init(mrReporter, inputs, outputs);
            this.rproc.run();
            for (LogicalOutput output : outputs.values()) {
                MROutput mrOutput;
                if (!(output instanceof MROutput) || !(mrOutput = (MROutput)output).isCommitRequired()) continue;
                mrOutput.commit();
            }
            this.perfLogger.perfLogEnd(CLASS_NAME, "TezRunProcessor");
        }
        catch (Throwable t) {
            originalThrowable = t;
        }
        finally {
            block18: {
                if (originalThrowable != null && (originalThrowable instanceof Error || Throwables.getRootCause((Throwable)originalThrowable) instanceof Error)) {
                    LOG.error("Cannot recover from this FATAL error", originalThrowable);
                    this.getContext().reportFailure(TaskFailureType.FATAL, originalThrowable, "Cannot recover from this error");
                    throw new RuntimeException(originalThrowable);
                }
                try {
                    if (this.rproc != null) {
                        this.rproc.close();
                    }
                }
                catch (Throwable t) {
                    if (originalThrowable != null) break block18;
                    originalThrowable = t;
                }
            }
            if (originalThrowable != null) {
                LOG.error("Failed initializeAndRunProcessor", originalThrowable);
                for (LogicalOutput output : outputs.values()) {
                    MROutput mrOutput;
                    if (!(output instanceof MROutput) || !(mrOutput = (MROutput)output).isCommitRequired()) continue;
                    mrOutput.abort();
                }
                if (originalThrowable instanceof InterruptedException) {
                    throw (InterruptedException)originalThrowable;
                }
                throw new RuntimeException(originalThrowable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        RecordProcessor rProcLocal;
        TezProcessor tezProcessor = this;
        synchronized (tezProcessor) {
            LOG.info("Received abort");
            this.aborted.set(true);
            rProcLocal = this.rproc;
        }
        if (rProcLocal != null) {
            LOG.info("Forwarding abort to RecordProcessor");
            rProcLocal.abort();
        } else {
            LOG.info("RecordProcessor not yet setup. Abort will be ignored");
        }
    }

    public JobConf getConf() {
        return this.jobConf;
    }

    static {
        taskIdFormat.setGroupingUsed(false);
        taskIdFormat.setMinimumIntegerDigits(6);
        jobIdFormat.setGroupingUsed(false);
        jobIdFormat.setMinimumIntegerDigits(4);
    }

    static class TezKVOutputCollector
    implements OutputCollector {
        private KeyValueWriter writer;
        private final LogicalOutput output;

        TezKVOutputCollector(LogicalOutput logicalOutput) {
            this.output = logicalOutput;
        }

        void initialize() throws Exception {
            this.writer = (KeyValueWriter)this.output.getWriter();
        }

        public void collect(Object key, Object value) throws IOException {
            this.writer.write(key, value);
        }
    }

    private static class ReflectiveProgressHelper {
        Configuration conf;
        Class<?> progressHelperClass = null;
        Object progressHelper = null;

        ReflectiveProgressHelper(Configuration conf, Map<String, LogicalInput> inputs, ProcessorContext processorContext, String processorName) {
            this.conf = conf;
            try {
                this.progressHelperClass = this.conf.getClassByName("org.apache.tez.common.ProgressHelper");
                this.progressHelper = this.progressHelperClass.getDeclaredConstructor(Map.class, ProcessorContext.class, String.class).newInstance(inputs, processorContext, processorName);
                LOG.debug("ProgressHelper initialized!");
            }
            catch (Exception ex) {
                LOG.warn("Could not find ProgressHelper. " + ex);
            }
        }

        private boolean isValid() {
            return this.progressHelperClass != null && this.progressHelper != null;
        }

        void scheduleProgressTaskService(long delay, long period) {
            if (!this.isValid()) {
                LOG.warn("ProgressHelper uninitialized. Bailing on scheduleProgressTaskService()");
                return;
            }
            try {
                this.progressHelperClass.getDeclaredMethod("scheduleProgressTaskService", Long.TYPE, Long.TYPE).invoke(this.progressHelper, delay, period);
                LOG.debug("scheduleProgressTaskService() called!");
            }
            catch (Exception exception) {
                LOG.warn("Could not scheduleProgressTaskService.", (Throwable)exception);
            }
        }

        void shutDownProgressTaskService() {
            if (!this.isValid()) {
                LOG.warn("ProgressHelper uninitialized. Bailing on scheduleProgressTaskService()");
                return;
            }
            try {
                this.progressHelperClass.getDeclaredMethod("shutDownProgressTaskService", new Class[0]).invoke(this.progressHelper, new Object[0]);
                LOG.debug("shutDownProgressTaskService() called!");
            }
            catch (Exception exception) {
                LOG.warn("Could not shutDownProgressTaskService.", (Throwable)exception);
            }
        }
    }

    public static interface Hook {
        public void initializeHook(TezProcessor var1);
    }
}

