/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.ql.exec.DummyStoreOperator;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.ObjectCache;
import org.apache.hadoop.hive.ql.exec.ObjectCacheFactory;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapper;
import org.apache.hadoop.hive.ql.exec.tez.DynamicValueRegistryTez;
import org.apache.hadoop.hive.ql.exec.tez.RecordProcessor;
import org.apache.hadoop.hive.ql.exec.tez.ReduceRecordSource;
import org.apache.hadoop.hive.ql.exec.tez.TezContext;
import org.apache.hadoop.hive.ql.exec.tez.TezProcessor;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.tez.mapreduce.processor.MRTaskReporter;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.api.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReduceRecordProcessor
extends RecordProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ReduceRecordProcessor.class);
    private static final String REDUCE_PLAN_KEY = "__REDUCE_PLAN__";
    private final ObjectCache cache;
    private final ObjectCache dynamicValueCache;
    private ReduceWork reduceWork;
    private final List<BaseWork> mergeWorkList;
    private final List<String> cacheKeys;
    private final List<String> dynamicValueCacheKeys = new ArrayList<String>();
    private final Map<Integer, DummyStoreOperator> connectOps = new TreeMap<Integer, DummyStoreOperator>();
    private final Map<Integer, ReduceWork> tagToReducerMap = new HashMap<Integer, ReduceWork>();
    private Operator<?> reducer;
    private ReduceRecordSource[] sources;
    private byte bigTablePosition = 0;

    public ReduceRecordProcessor(JobConf jconf, ProcessorContext context) throws Exception {
        super(jconf, context);
        String queryId = HiveConf.getVar((Configuration)jconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEQUERYID);
        this.cache = ObjectCacheFactory.getCache((Configuration)jconf, queryId, true);
        this.dynamicValueCache = ObjectCacheFactory.getCache((Configuration)jconf, queryId, false, true);
        String cacheKey = this.processorContext.getTaskVertexName() + REDUCE_PLAN_KEY;
        this.cacheKeys = Lists.newArrayList((Object[])new String[]{cacheKey});
        this.reduceWork = this.cache.retrieve(cacheKey, () -> Utilities.getReduceWork((Configuration)jconf));
        Utilities.setReduceWork((Configuration)jconf, this.reduceWork);
        this.mergeWorkList = this.getMergeWorkList(jconf, cacheKey, queryId, this.cache, this.cacheKeys);
    }

    @Override
    void init(MRTaskReporter mrReporter, Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
        this.perfLogger.perfLogBegin(this.CLASS_NAME, "TezInitializeOperators");
        super.init(mrReporter, inputs, outputs);
        MapredContext.init(false, new JobConf((Configuration)this.jconf));
        List<LogicalInput> shuffleInputs = this.getShuffleInputs(inputs);
        this.checkAbortCondition();
        if (shuffleInputs != null) {
            LOG.info("Waiting for ShuffleInputs to become ready");
            this.processorContext.waitForAllInputsReady(new ArrayList<LogicalInput>(shuffleInputs));
        }
        this.connectOps.clear();
        ReduceWork redWork = this.reduceWork;
        LOG.info("Main work is " + this.reduceWork.getName());
        List<HashTableDummyOperator> workOps = this.reduceWork.getDummyOps();
        HashSet<HashTableDummyOperator> dummyOps = workOps == null ? new HashSet<HashTableDummyOperator>() : new HashSet<HashTableDummyOperator>(workOps);
        this.tagToReducerMap.put(redWork.getTag(), redWork);
        if (this.mergeWorkList != null) {
            for (BaseWork mergeWork : this.mergeWorkList) {
                LOG.debug("Additional work {}", (Object)mergeWork.getName());
                workOps = mergeWork.getDummyOps();
                if (workOps != null) {
                    dummyOps.addAll(workOps);
                }
                ReduceWork mergeReduceWork = (ReduceWork)mergeWork;
                this.reducer = mergeReduceWork.getReducer();
                this.checkAbortCondition();
                DummyStoreOperator dummyStoreOp = this.getJoinParentOp(this.reducer);
                this.connectOps.put(mergeReduceWork.getTag(), dummyStoreOp);
                this.tagToReducerMap.put(mergeReduceWork.getTag(), mergeReduceWork);
            }
            ((TezContext)MapredContext.get()).setDummyOpsMap(this.connectOps);
        }
        this.checkAbortCondition();
        this.bigTablePosition = (byte)this.reduceWork.getTag();
        ObjectInspector[] mainWorkOIs = null;
        ((TezContext)MapredContext.get()).setInputs(inputs);
        ((TezContext)MapredContext.get()).setTezProcessorContext(this.processorContext);
        int numTags = this.reduceWork.getTagToValueDesc().size();
        this.reducer = this.reduceWork.getReducer();
        this.checkAbortCondition();
        long memoryAvailableToTask = this.processorContext.getTotalMemoryAvailableToTask();
        if (this.reducer.getConf() != null) {
            this.reducer.getConf().setMaxMemoryAvailable(memoryAvailableToTask);
            LOG.info("Memory available for operators set to {}", (Object)LlapUtil.humanReadableByteCount((long)memoryAvailableToTask));
        }
        OperatorUtils.setMemoryAvailable(this.reducer.getChildOperators(), memoryAvailableToTask);
        String valueRegistryKey = "DynamicValueRegistry";
        DynamicValueRegistryTez registryTez = this.dynamicValueCache.retrieve(valueRegistryKey, () -> new DynamicValueRegistryTez());
        this.dynamicValueCacheKeys.add(valueRegistryKey);
        DynamicValueRegistryTez.RegistryConfTez registryConf = new DynamicValueRegistryTez.RegistryConfTez((Configuration)this.jconf, this.reduceWork, this.processorContext, inputs);
        registryTez.init(registryConf);
        this.checkAbortCondition();
        if (numTags > 1) {
            this.sources = new ReduceRecordSource[numTags];
            mainWorkOIs = new ObjectInspector[numTags];
            this.initializeMultipleSources(this.reduceWork, numTags, mainWorkOIs, this.sources);
            ((TezContext)MapredContext.get()).setRecordSources(this.sources);
            this.reducer.initialize((Configuration)this.jconf, mainWorkOIs);
        } else {
            numTags = this.tagToReducerMap.keySet().size();
            this.sources = new ReduceRecordSource[numTags];
            mainWorkOIs = new ObjectInspector[numTags];
            for (int i : this.tagToReducerMap.keySet()) {
                redWork = this.tagToReducerMap.get(i);
                this.reducer = redWork.getReducer();
                this.checkAbortCondition();
                this.initializeSourceForTag(redWork, i, mainWorkOIs, this.sources, redWork.getTagToValueDesc().get(0), redWork.getTagToInput().get(0));
                this.reducer.initializeLocalWork((Configuration)this.jconf);
            }
            this.reducer = this.reduceWork.getReducer();
            this.checkAbortCondition();
            ((TezContext)MapredContext.get()).setRecordSources(this.sources);
            this.reducer.initialize((Configuration)this.jconf, new ObjectInspector[]{mainWorkOIs[this.bigTablePosition]});
            for (int i : this.tagToReducerMap.keySet()) {
                if (i == this.bigTablePosition) continue;
                redWork = this.tagToReducerMap.get(i);
                this.reducer = redWork.getReducer();
                this.checkAbortCondition();
                this.reducer.initialize((Configuration)this.jconf, new ObjectInspector[]{mainWorkOIs[i]});
            }
        }
        this.checkAbortCondition();
        this.reducer = this.reduceWork.getReducer();
        try {
            LOG.info(this.reducer.dump(0));
            for (HashTableDummyOperator dummyOp : dummyOps) {
                dummyOp.initialize((Configuration)this.jconf, null);
                this.checkAbortCondition();
            }
            ArrayList<Operator<? extends OperatorDesc>> children = new ArrayList<Operator<? extends OperatorDesc>>();
            children.add(this.reducer);
            children.addAll(dummyOps);
            this.createOutputMap();
            OperatorUtils.setChildrenCollector(children, this.outMap);
            this.checkAbortCondition();
            this.reducer.setReporter((Reporter)this.reporter);
            MapredContext.get().setReporter((Reporter)this.reporter);
        }
        catch (Throwable e) {
            super.setAborted(true);
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            if (e instanceof InterruptedException) {
                LOG.info("Hit an interrupt while initializing ReduceRecordProcessor. Message={}", (Object)e.getMessage());
                throw (InterruptedException)e;
            }
            throw new RuntimeException(redWork.getName() + " operator initialization failed", e);
        }
        this.perfLogger.perfLogEnd(this.CLASS_NAME, "TezInitializeOperators");
    }

    private void initializeMultipleSources(ReduceWork redWork, int numTags, ObjectInspector[] ois, ReduceRecordSource[] sources) throws Exception {
        for (int tag = 0; tag < redWork.getTagToValueDesc().size(); ++tag) {
            if (redWork.getTagToValueDesc().get(tag) == null) continue;
            this.checkAbortCondition();
            this.initializeSourceForTag(redWork, tag, ois, sources, redWork.getTagToValueDesc().get(tag), redWork.getTagToInput().get(tag));
        }
    }

    private void initializeSourceForTag(ReduceWork redWork, int tag, ObjectInspector[] ois, ReduceRecordSource[] sources, TableDesc valueTableDesc, String inputName) throws Exception {
        this.reducer = redWork.getReducer();
        this.reducer.getParentOperators().clear();
        this.reducer.setParentOperators(null);
        TableDesc keyTableDesc = redWork.getKeyDesc();
        Reader reader = ((LogicalInput)this.inputs.get(inputName)).getReader();
        sources[tag] = new ReduceRecordSource();
        boolean vectorizedRecordSource = tag == this.bigTablePosition && redWork.getVectorMode();
        sources[tag].init(this.jconf, redWork.getReducer(), vectorizedRecordSource, keyTableDesc, valueTableDesc, reader, tag == this.bigTablePosition, (byte)tag, redWork.getVectorizedRowBatchCtx(), redWork.getVectorizedVertexNum(), redWork.getVectorizedTestingReducerBatchSize());
        ois[tag] = sources[tag].getObjectInspector();
    }

    @Override
    void run() throws Exception {
        for (Map.Entry outputEntry : this.outputs.entrySet()) {
            LOG.info("Starting Output: " + (String)outputEntry.getKey());
            if (this.isAborted()) continue;
            ((LogicalOutput)outputEntry.getValue()).start();
            ((TezProcessor.TezKVOutputCollector)this.outMap.get(outputEntry.getKey())).initialize();
        }
        this.startAbortChecks();
        while (this.sources[this.bigTablePosition].pushRecord()) {
            this.addRowAndMaybeCheckAbort();
        }
    }

    @Override
    public void abort() {
        super.abort();
        if (this.reducer != null) {
            LOG.info("Forwarding abort to reducer: {} " + this.reducer.getName());
            this.reducer.abort();
        } else {
            LOG.info("reducer not setup yet. abort not being forwarded");
        }
    }

    private List<LogicalInput> getShuffleInputs(Map<String, LogicalInput> inputs) throws Exception {
        Map<Integer, String> tagToinput = this.reduceWork.getTagToInput();
        ArrayList<LogicalInput> shuffleInputs = new ArrayList<LogicalInput>();
        for (String inpStr : tagToinput.values()) {
            if (inputs.get(inpStr) == null) {
                throw new AssertionError((Object)("Cound not find input: " + inpStr));
            }
            inputs.get(inpStr).start();
            shuffleInputs.add(inputs.get(inpStr));
        }
        return shuffleInputs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void close() {
        if (this.cache != null) {
            for (String key : this.cacheKeys) {
                this.cache.release(key);
            }
        }
        if (this.dynamicValueCache != null) {
            for (String k : this.dynamicValueCacheKeys) {
                this.dynamicValueCache.release(k);
            }
        }
        try {
            List<HashTableDummyOperator> dummyOps;
            if (this.isAborted()) {
                for (ReduceRecordSource reduceRecordSource : this.sources) {
                    if (reduceRecordSource.close()) continue;
                    this.setAborted(false);
                    break;
                }
            }
            boolean abort = this.isAborted();
            this.reducer.close(abort);
            if (this.mergeWorkList != null) {
                for (BaseWork redWork : this.mergeWorkList) {
                    ((ReduceWork)redWork).getReducer().close(abort);
                }
            }
            if ((dummyOps = this.reduceWork.getDummyOps()) != null) {
                for (Operator operator : dummyOps) {
                    operator.close(abort);
                }
            }
            ExecMapper.ReportStats rps = new ExecMapper.ReportStats((Reporter)this.reporter, (Configuration)this.jconf);
            this.reducer.preorderMap(rps);
        }
        catch (Exception e) {
            if (!this.isAborted()) {
                LOG.error("Hit error while closing operators - failing tree");
                throw new RuntimeException("Hive Runtime Error while closing operators: " + e.getMessage(), e);
            }
        }
        finally {
            Utilities.clearWorkMap((Configuration)this.jconf);
            MapredContext.close();
        }
    }

    private DummyStoreOperator getJoinParentOp(Operator<?> mergeReduceOp) {
        Iterator<Operator<OperatorDesc>> iterator = mergeReduceOp.getChildOperators().iterator();
        if (iterator.hasNext()) {
            Operator<OperatorDesc> childOp = iterator.next();
            if (childOp.getChildOperators() == null || childOp.getChildOperators().isEmpty()) {
                if (childOp instanceof DummyStoreOperator) {
                    return (DummyStoreOperator)childOp;
                }
                throw new IllegalStateException("Was expecting dummy store operator but found: " + childOp);
            }
            return this.getJoinParentOp(childOp);
        }
        throw new IllegalStateException("Expecting a DummyStoreOperator found op: " + mergeReduceOp);
    }
}

