/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.tez.runtime.api.ObjectRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectCache
implements org.apache.hadoop.hive.ql.exec.ObjectCache {
    private static final Logger LOG = LoggerFactory.getLogger((String)ObjectCache.class.getName());
    private static volatile ObjectRegistry staticRegistry;
    private static ExecutorService staticPool;
    private final ObjectRegistry registry;

    public ObjectCache() {
        Preconditions.checkNotNull((Object)staticRegistry, (Object)"Object registry not setup yet. This should have been setup by the TezProcessor");
        this.registry = staticRegistry;
    }

    public static boolean isObjectRegistryConfigured() {
        return staticRegistry != null;
    }

    public static void setupObjectRegistry(ObjectRegistry objectRegistry) {
        staticRegistry = objectRegistry;
        staticPool = Executors.newCachedThreadPool();
    }

    @Override
    public void release(String key) {
        LOG.info("Releasing key: " + key);
    }

    @Override
    public <T> T retrieve(String key) throws HiveException {
        Object value = null;
        try {
            value = this.registry.get(key);
            if (value != null) {
                LOG.info("Found " + key + " in cache with value: " + value);
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        return (T)value;
    }

    @Override
    public <T> T retrieve(String key, Callable<T> fn) throws HiveException {
        Object value;
        try {
            value = this.registry.get(key);
            if (value == null) {
                value = fn.call();
                LOG.info("Caching key: " + key);
                this.registry.cacheForVertex(key, value);
            } else {
                LOG.info("Found " + key + " in cache with value: " + value);
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
        return (T)value;
    }

    @Override
    public <T> Future<T> retrieveAsync(final String key, final Callable<T> fn) throws HiveException {
        return staticPool.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return ObjectCache.this.retrieve(key, fn);
            }
        });
    }

    @Override
    public void remove(String key) {
        LOG.info("Removing key: " + key);
        this.registry.delete(key);
    }
}

