/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.KillQuery;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.wm.Trigger;
import org.apache.hadoop.hive.ql.wm.TriggerActionHandler;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KillTriggerActionHandler
implements TriggerActionHandler<TezSessionState> {
    private static final Logger LOG = LoggerFactory.getLogger(KillTriggerActionHandler.class);

    @Override
    public void applyAction(Map<TezSessionState, Trigger> queriesViolated) {
        block5: for (Map.Entry<TezSessionState, Trigger> entry : queriesViolated.entrySet()) {
            switch (entry.getValue().getAction().getType()) {
                case KILL_QUERY: {
                    TezSessionState sessionState = entry.getKey();
                    String queryId = sessionState.getWmContext().getQueryId();
                    try {
                        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                        SessionState ss = new SessionState(new HiveConf(), ugi.getShortUserName());
                        ss.setIsHiveServerQuery(true);
                        SessionState.start(ss);
                        KillQuery killQuery = sessionState.getKillQuery();
                        if (killQuery == null) continue block5;
                        sessionState.getKillQuery().killQuery(queryId, entry.getValue().getViolationMsg(), sessionState.getConf());
                    }
                    catch (IOException | HiveException e) {
                        LOG.warn("Unable to kill query {} for trigger violation", (Object)queryId);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported action: " + entry.getValue());
                }
            }
        }
    }
}

