/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.status.impl;

import com.google.common.base.Throwables;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.spark.SparkUtilities;
import org.apache.hadoop.hive.ql.exec.spark.Statistic.SparkStatistics;
import org.apache.hadoop.hive.ql.exec.spark.Statistic.SparkStatisticsBuilder;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkJobStatus;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkStage;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkStageProgress;
import org.apache.hadoop.hive.ql.exec.spark.status.impl.SparkMetricsUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hive.spark.client.Job;
import org.apache.hive.spark.client.JobContext;
import org.apache.hive.spark.client.JobHandle;
import org.apache.hive.spark.client.MetricsCollection;
import org.apache.hive.spark.client.SparkClient;
import org.apache.hive.spark.counter.SparkCounters;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.SparkJobInfo;
import org.apache.spark.SparkStageInfo;
import org.apache.spark.api.java.JavaFutureAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteSparkJobStatus
implements SparkJobStatus {
    private static final Logger LOG = LoggerFactory.getLogger((String)RemoteSparkJobStatus.class.getName());
    private final SparkClient sparkClient;
    private final JobHandle<Serializable> jobHandle;
    private Throwable error;
    private final transient long sparkClientTimeoutInSeconds;

    public RemoteSparkJobStatus(SparkClient sparkClient, JobHandle<Serializable> jobHandle, long timeoutInSeconds) {
        this.sparkClient = sparkClient;
        this.jobHandle = jobHandle;
        this.error = null;
        this.sparkClientTimeoutInSeconds = timeoutInSeconds;
    }

    @Override
    public String getAppID() {
        Future getAppID = this.sparkClient.run((Job)new GetAppIDJob());
        try {
            return (String)getAppID.get(this.sparkClientTimeoutInSeconds, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.warn("Failed to get APP ID.", (Throwable)e);
            if (Thread.interrupted()) {
                this.error = e;
            }
            return null;
        }
    }

    @Override
    public int getJobId() {
        return this.jobHandle.getSparkJobIds().size() == 1 ? (Integer)this.jobHandle.getSparkJobIds().get(0) : -1;
    }

    @Override
    public JobExecutionStatus getState() throws HiveException {
        SparkJobInfo sparkJobInfo = this.getSparkJobInfo();
        return sparkJobInfo != null ? sparkJobInfo.status() : null;
    }

    @Override
    public int[] getStageIds() throws HiveException {
        SparkJobInfo sparkJobInfo = this.getSparkJobInfo();
        return sparkJobInfo != null ? sparkJobInfo.stageIds() : new int[]{};
    }

    @Override
    public Map<SparkStage, SparkStageProgress> getSparkStageProgress() throws HiveException {
        List<SparkStageInfo> sparkStagesInfo = this.getSparkStagesInfo();
        HashMap<SparkStage, SparkStageProgress> stageProgresses = new HashMap<SparkStage, SparkStageProgress>();
        if (sparkStagesInfo != null) {
            for (SparkStageInfo sparkStageInfo : sparkStagesInfo) {
                if (sparkStageInfo == null || sparkStageInfo.name() == null) continue;
                int runningTaskCount = sparkStageInfo.numActiveTasks();
                int completedTaskCount = sparkStageInfo.numCompletedTasks();
                int failedTaskCount = sparkStageInfo.numFailedTasks();
                int totalTaskCount = sparkStageInfo.numTasks();
                SparkStageProgress sparkStageProgress = new SparkStageProgress(totalTaskCount, completedTaskCount, runningTaskCount, failedTaskCount);
                SparkStage stage = new SparkStage(sparkStageInfo.stageId(), sparkStageInfo.currentAttemptId());
                stageProgresses.put(stage, sparkStageProgress);
            }
        }
        return stageProgresses;
    }

    @Override
    public SparkCounters getCounter() {
        return this.jobHandle.getSparkCounters();
    }

    @Override
    public SparkStatistics getSparkStatistics() {
        MetricsCollection metricsCollection = this.jobHandle.getMetrics();
        if (metricsCollection == null || this.getCounter() == null) {
            return null;
        }
        SparkStatisticsBuilder sparkStatisticsBuilder = new SparkStatisticsBuilder();
        sparkStatisticsBuilder.add(this.getCounter());
        Map<String, Long> flatJobMetric = SparkMetricsUtils.collectMetrics(metricsCollection.getAllMetrics());
        for (Map.Entry<String, Long> entry : flatJobMetric.entrySet()) {
            sparkStatisticsBuilder.add("SPARK", entry.getKey(), Long.toString(entry.getValue()));
        }
        return sparkStatisticsBuilder.build();
    }

    @Override
    public String getWebUIURL() {
        Future getWebUIURL = this.sparkClient.run((Job)new GetWebUIURLJob());
        try {
            return (String)getWebUIURL.get(this.sparkClientTimeoutInSeconds, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.warn("Failed to get web UI URL.", (Throwable)e);
            if (Thread.interrupted()) {
                this.error = e;
            }
            return "UNKNOWN";
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public Throwable getMonitorError() {
        return this.error;
    }

    @Override
    public void setMonitorError(Throwable e) {
        this.error = e;
    }

    @Override
    public Throwable getSparkJobException() {
        return this.jobHandle.getError();
    }

    public boolean isRemoteActive() {
        return this.sparkClient.isActive();
    }

    private SparkJobInfo getSparkJobInfo() throws HiveException {
        Integer sparkJobId;
        Integer n = sparkJobId = this.jobHandle.getSparkJobIds().size() == 1 ? (Integer)this.jobHandle.getSparkJobIds().get(0) : null;
        if (sparkJobId == null) {
            return null;
        }
        Future getJobInfo = this.sparkClient.run((Job)new GetJobInfoJob(this.jobHandle.getClientJobId(), sparkJobId));
        try {
            return (SparkJobInfo)getJobInfo.get(this.sparkClientTimeoutInSeconds, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new HiveException((Throwable)e, ErrorMsg.SPARK_GET_JOB_INFO_TIMEOUT, new String[]{Long.toString(this.sparkClientTimeoutInSeconds)});
        }
        catch (InterruptedException e) {
            throw new HiveException((Throwable)e, ErrorMsg.SPARK_GET_JOB_INFO_INTERRUPTED);
        }
        catch (ExecutionException e) {
            throw new HiveException((Throwable)e, ErrorMsg.SPARK_GET_JOB_INFO_EXECUTIONERROR, new String[]{Throwables.getRootCause((Throwable)e).getMessage()});
        }
    }

    private List<SparkStageInfo> getSparkStagesInfo() throws HiveException {
        Integer sparkJobId;
        Integer n = sparkJobId = this.jobHandle.getSparkJobIds().size() == 1 ? (Integer)this.jobHandle.getSparkJobIds().get(0) : null;
        if (sparkJobId == null) {
            return null;
        }
        Future getStagesInfo = this.sparkClient.run((Job)new GetSparkStagesInfoJob(this.jobHandle.getClientJobId(), sparkJobId));
        try {
            return (List)getStagesInfo.get(this.sparkClientTimeoutInSeconds, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new HiveException((Throwable)e, ErrorMsg.SPARK_GET_STAGES_INFO_TIMEOUT, new String[]{Long.toString(this.sparkClientTimeoutInSeconds)});
        }
        catch (InterruptedException e) {
            throw new HiveException((Throwable)e, ErrorMsg.SPARK_GET_STAGES_INFO_INTERRUPTED);
        }
        catch (ExecutionException e) {
            throw new HiveException((Throwable)e, ErrorMsg.SPARK_GET_STAGES_INFO_EXECUTIONERROR, new String[]{Throwables.getRootCause((Throwable)e).getMessage()});
        }
    }

    public JobHandle.State getRemoteJobState() {
        if (this.error != null) {
            return JobHandle.State.FAILED;
        }
        return this.jobHandle.getState();
    }

    private static SparkJobInfo getDefaultJobInfo(final Integer jobId, final JobExecutionStatus status) {
        return new SparkJobInfo(){

            public int jobId() {
                return jobId == null ? -1 : jobId;
            }

            public int[] stageIds() {
                return new int[0];
            }

            public JobExecutionStatus status() {
                return status;
            }
        };
    }

    private static class GetWebUIURLJob
    implements Job<String> {
        public String call(JobContext jc) throws Exception {
            if (jc.sc().sc().uiWebUrl().isDefined()) {
                return SparkUtilities.reverseDNSLookupURL((String)jc.sc().sc().uiWebUrl().get());
            }
            return "UNDEFINED";
        }
    }

    private static class GetAppIDJob
    implements Job<String> {
        public String call(JobContext jc) throws Exception {
            return jc.sc().sc().applicationId();
        }
    }

    private static class GetJobInfoJob
    implements Job<SparkJobInfo> {
        private final String clientJobId;
        private final int sparkJobId;

        private GetJobInfoJob() {
            this(null, -1);
        }

        GetJobInfoJob(String clientJobId, int sparkJobId) {
            this.clientJobId = clientJobId;
            this.sparkJobId = sparkJobId;
        }

        public SparkJobInfo call(JobContext jc) throws Exception {
            JavaFutureAction futureAction;
            List list;
            SparkJobInfo jobInfo = jc.sc().statusTracker().getJobInfo(this.sparkJobId);
            if (jobInfo == null && (list = (List)jc.getMonitoredJobs().get(this.clientJobId)) != null && list.size() == 1 && (futureAction = (JavaFutureAction)list.get(0)).isDone()) {
                boolean futureSucceed = true;
                try {
                    futureAction.get();
                }
                catch (Exception e) {
                    LOG.error("Failed to run job " + this.sparkJobId, (Throwable)e);
                    futureSucceed = false;
                }
                jobInfo = RemoteSparkJobStatus.getDefaultJobInfo(this.sparkJobId, futureSucceed ? JobExecutionStatus.SUCCEEDED : JobExecutionStatus.FAILED);
            }
            if (jobInfo == null) {
                jobInfo = RemoteSparkJobStatus.getDefaultJobInfo(this.sparkJobId, JobExecutionStatus.UNKNOWN);
            }
            return jobInfo;
        }
    }

    private static class GetSparkStagesInfoJob
    implements Job<ArrayList<SparkStageInfo>> {
        private final String clientJobId;
        private final int sparkJobId;

        private GetSparkStagesInfoJob() {
            this(null, -1);
        }

        GetSparkStagesInfoJob(String clientJobId, int sparkJobId) {
            this.clientJobId = clientJobId;
            this.sparkJobId = sparkJobId;
        }

        public ArrayList<SparkStageInfo> call(JobContext jc) throws Exception {
            int[] stageIds;
            JavaFutureAction futureAction;
            ArrayList list;
            SparkJobInfo jobInfo = jc.sc().statusTracker().getJobInfo(this.sparkJobId);
            if (jobInfo == null && (list = new ArrayList((Collection)jc.getMonitoredJobs().get(this.clientJobId))) != null && list.size() == 1 && (futureAction = (JavaFutureAction)list.get(0)).isDone()) {
                boolean futureSucceed = true;
                try {
                    futureAction.get();
                }
                catch (Exception e) {
                    LOG.error("Failed to run job " + this.sparkJobId, (Throwable)e);
                    futureSucceed = false;
                }
                jobInfo = RemoteSparkJobStatus.getDefaultJobInfo(this.sparkJobId, futureSucceed ? JobExecutionStatus.SUCCEEDED : JobExecutionStatus.FAILED);
            }
            if (jobInfo == null) {
                jobInfo = RemoteSparkJobStatus.getDefaultJobInfo(this.sparkJobId, JobExecutionStatus.UNKNOWN);
            }
            ArrayList<SparkStageInfo> sparkStageInfos = new ArrayList<SparkStageInfo>();
            int[] nArray = stageIds = jobInfo.stageIds();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer stageid = nArray[i];
                SparkStageInfo stageInfo = jc.sc().statusTracker().getStageInfo(stageid.intValue());
                sparkStageInfos.add(stageInfo);
            }
            return sparkStageInfos;
        }
    }
}

