/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.status;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.hadoop.hive.common.log.ProgressMonitor;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkJobMonitor;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkStage;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkStageProgress;

class SparkProgressMonitor
implements ProgressMonitor {
    private Map<SparkStage, SparkStageProgress> progressMap;
    private long startTime;
    private static final int COLUMN_1_WIDTH = 16;

    SparkProgressMonitor(Map<SparkStage, SparkStageProgress> progressMap, long startTime) {
        this.progressMap = progressMap;
        this.startTime = startTime;
    }

    public List<String> headers() {
        return Arrays.asList("STAGES", "ATTEMPT", "STATUS", "TOTAL", "COMPLETED", "RUNNING", "PENDING", "FAILED", "");
    }

    public List<List<String>> rows() {
        ArrayList<List<String>> progressRows = new ArrayList<List<String>>();
        TreeSet<SparkStage> keys = new TreeSet<SparkStage>(this.progressMap.keySet());
        for (SparkStage stage : keys) {
            SparkJobMonitor.StageState state;
            SparkStageProgress progress = this.progressMap.get(stage);
            int complete = progress.getSucceededTaskCount();
            int total = progress.getTotalTaskCount();
            int running = progress.getRunningTaskCount();
            int failed = progress.getFailedTaskCount();
            SparkJobMonitor.StageState stageState = state = total > 0 ? SparkJobMonitor.StageState.PENDING : SparkJobMonitor.StageState.FINISHED;
            if (complete > 0 || running > 0 || failed > 0) {
                state = complete < total ? SparkJobMonitor.StageState.RUNNING : SparkJobMonitor.StageState.FINISHED;
            }
            String attempt = String.valueOf(stage.getAttemptId());
            String stageName = "Stage-" + String.valueOf(stage.getStageId());
            String nameWithProgress = this.getNameWithProgress(stageName, complete, total);
            int pending = total - complete - running;
            progressRows.add(Arrays.asList(nameWithProgress, attempt, state.toString(), String.valueOf(total), String.valueOf(complete), String.valueOf(running), String.valueOf(pending), String.valueOf(failed), ""));
        }
        return progressRows;
    }

    public String footerSummary() {
        return String.format("STAGES: %02d/%02d", this.getCompletedStages(), this.progressMap.keySet().size());
    }

    public long startTime() {
        return this.startTime;
    }

    public String executionStatus() {
        if (this.getCompletedStages() == this.progressMap.keySet().size()) {
            return SparkJobMonitor.StageState.FINISHED.toString();
        }
        return SparkJobMonitor.StageState.RUNNING.toString();
    }

    public double progressedPercentage() {
        TreeSet<SparkStage> keys = new TreeSet<SparkStage>(this.progressMap.keySet());
        int sumTotal = 0;
        int sumComplete = 0;
        for (SparkStage stage : keys) {
            SparkStageProgress progress = this.progressMap.get(stage);
            int complete = progress.getSucceededTaskCount();
            int total = progress.getTotalTaskCount();
            sumTotal += total;
            sumComplete += complete;
        }
        double progress = sumTotal == 0 ? 1.0 : (double)((float)sumComplete / (float)sumTotal);
        return progress;
    }

    private int getCompletedStages() {
        int completed = 0;
        TreeSet<SparkStage> keys = new TreeSet<SparkStage>(this.progressMap.keySet());
        for (SparkStage stage : keys) {
            SparkStageProgress progress = this.progressMap.get(stage);
            int complete = progress.getSucceededTaskCount();
            int total = progress.getTotalTaskCount();
            if (total <= 0 || complete != total) continue;
            ++completed;
        }
        return completed;
    }

    private String getNameWithProgress(String s, int complete, int total) {
        if (s == null) {
            return "";
        }
        float percent = total == 0 ? 1.0f : (float)complete / (float)total;
        int spaceRemaining = 16 - s.length() - 1;
        String trimmedVName = s;
        if (s.length() > 16) {
            trimmedVName = s.substring(0, 14);
            trimmedVName = trimmedVName + "..";
        } else {
            trimmedVName = trimmedVName + " ";
        }
        StringBuilder result = new StringBuilder(trimmedVName);
        int toFill = (int)((float)spaceRemaining * percent);
        for (int i = 0; i < toFill; ++i) {
            result.append(".");
        }
        return result.toString();
    }
}

