/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.status;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.common.log.InPlaceUpdate;
import org.apache.hadoop.hive.common.log.ProgressMonitor;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.spark.status.RenderStrategy;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkProgressMonitor;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkStage;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkStageProgress;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SparkJobMonitor {
    protected static final String CLASS_NAME = SparkJobMonitor.class.getName();
    protected static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    protected final transient SessionState.LogHelper console;
    protected final PerfLogger perfLogger = SessionState.getPerfLogger();
    protected final int checkInterval = 1000;
    protected final long monitorTimeoutInterval;
    final RenderStrategy.UpdateFunction updateFunction;
    protected long startTime;
    protected final boolean inPlaceUpdate;

    protected SparkJobMonitor(HiveConf hiveConf) {
        this.monitorTimeoutInterval = hiveConf.getTimeVar(HiveConf.ConfVars.SPARK_JOB_MONITOR_TIMEOUT, TimeUnit.SECONDS);
        this.inPlaceUpdate = InPlaceUpdate.canRenderInPlace((HiveConf)hiveConf) && !SessionState.getConsole().getIsSilent();
        this.console = new SessionState.LogHelper(LOG);
        this.updateFunction = this.updateFunction();
    }

    public abstract int startMonitor();

    protected int getTotalTaskCount(Map<SparkStage, SparkStageProgress> progressMap) {
        int totalTasks = 0;
        for (SparkStageProgress progress : progressMap.values()) {
            totalTasks += progress.getTotalTaskCount();
        }
        return totalTasks;
    }

    protected int getStageMaxTaskCount(Map<SparkStage, SparkStageProgress> progressMap) {
        int stageMaxTasks = 0;
        for (SparkStageProgress progress : progressMap.values()) {
            int tasks = progress.getTotalTaskCount();
            if (tasks <= stageMaxTasks) continue;
            stageMaxTasks = tasks;
        }
        return stageMaxTasks;
    }

    ProgressMonitor getProgressMonitor(Map<SparkStage, SparkStageProgress> progressMap) {
        return new SparkProgressMonitor(progressMap, this.startTime);
    }

    private RenderStrategy.UpdateFunction updateFunction() {
        return this.inPlaceUpdate && !SessionState.get().isHiveServerQuery() ? new RenderStrategy.InPlaceUpdateFunction(this) : new RenderStrategy.LogToFileFunction(this);
    }

    protected static enum StageState {
        PENDING,
        RUNNING,
        FINISHED;

    }
}

