/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.status;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.hive.common.log.InPlaceUpdate;
import org.apache.hadoop.hive.common.log.ProgressMonitor;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkJobMonitor;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkStage;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkStageProgress;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RenderStrategy {
    RenderStrategy() {
    }

    static class InPlaceUpdateFunction
    extends BaseUpdateFunction {
        private final InPlaceUpdate inPlaceUpdate = new InPlaceUpdate(SessionState.LogHelper.getInfoStream());

        InPlaceUpdateFunction(SparkJobMonitor monitor) {
            super(monitor);
        }

        @Override
        void renderProgress(ProgressMonitor monitor) {
            this.inPlaceUpdate.render(monitor);
        }

        @Override
        void renderReport(String report) {
            this.monitor.console.logInfo(report);
        }
    }

    static class LogToFileFunction
    extends BaseUpdateFunction {
        private static final Logger LOGGER = LoggerFactory.getLogger(LogToFileFunction.class);
        private boolean hiveServer2InPlaceProgressEnabled = SessionState.get().getConf().getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_INPLACE_PROGRESS);

        LogToFileFunction(SparkJobMonitor monitor) {
            super(monitor);
        }

        @Override
        void renderProgress(ProgressMonitor monitor) {
            SessionState.get().updateProgressMonitor(monitor);
        }

        @Override
        void renderReport(String report) {
            if (this.hiveServer2InPlaceProgressEnabled) {
                LOGGER.info(report);
            } else {
                this.monitor.console.printInfo(report);
            }
        }
    }

    private static abstract class BaseUpdateFunction
    implements UpdateFunction {
        protected final SparkJobMonitor monitor;
        private final PerfLogger perfLogger;
        private long lastPrintTime;
        private static final int PRINT_INTERVAL = 3000;
        private final Set<String> completed = new HashSet<String>();
        private String lastReport = null;

        BaseUpdateFunction(SparkJobMonitor monitor) {
            this.monitor = monitor;
            this.perfLogger = SessionState.getPerfLogger();
        }

        private String getReport(Map<SparkStage, SparkStageProgress> progressMap) {
            StringBuilder reportBuffer = new StringBuilder();
            SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
            String currentDate = dt.format(new Date());
            reportBuffer.append(currentDate + "\t");
            int sumTotal = 0;
            int sumComplete = 0;
            TreeSet<SparkStage> keys = new TreeSet<SparkStage>(progressMap.keySet());
            for (SparkStage stage : keys) {
                SparkStageProgress progress = progressMap.get(stage);
                int complete = progress.getSucceededTaskCount();
                int total = progress.getTotalTaskCount();
                int running = progress.getRunningTaskCount();
                int failed = progress.getFailedTaskCount();
                sumTotal += total;
                sumComplete += complete;
                String s = stage.toString();
                String stageName = "Stage-" + s;
                if (total <= 0) {
                    reportBuffer.append(String.format("%s: -/-\t", stageName));
                    continue;
                }
                if (complete == total && !this.completed.contains(s)) {
                    this.completed.add(s);
                    if (!this.perfLogger.startTimeHasMethod("SparkRunStage." + s)) {
                        this.perfLogger.perfLogBegin(SparkJobMonitor.CLASS_NAME, "SparkRunStage." + s);
                    }
                    this.perfLogger.perfLogEnd(SparkJobMonitor.CLASS_NAME, "SparkRunStage." + s);
                }
                if (complete < total && (complete > 0 || running > 0 || failed > 0)) {
                    if (!this.perfLogger.startTimeHasMethod("SparkRunStage." + s)) {
                        this.perfLogger.perfLogBegin(SparkJobMonitor.CLASS_NAME, "SparkRunStage." + s);
                    }
                    if (failed > 0) {
                        reportBuffer.append(String.format("%s: %d(+%d,-%d)/%d\t", stageName, complete, running, failed, total));
                        continue;
                    }
                    reportBuffer.append(String.format("%s: %d(+%d)/%d\t", stageName, complete, running, total));
                    continue;
                }
                if (failed > 0) {
                    reportBuffer.append(String.format("%s: %d(-%d)/%d Finished with failed tasks\t", stageName, complete, failed, total));
                    continue;
                }
                if (complete == total) {
                    reportBuffer.append(String.format("%s: %d/%d Finished\t", stageName, complete, total));
                    continue;
                }
                reportBuffer.append(String.format("%s: %d/%d\t", stageName, complete, total));
            }
            if (SessionState.get() != null) {
                float progress = sumTotal == 0 ? 1.0f : (float)sumComplete / (float)sumTotal;
                SessionState.get().updateProgressedPercentage(progress);
            }
            return reportBuffer.toString();
        }

        private boolean isSameAsPreviousProgress(Map<SparkStage, SparkStageProgress> progressMap, Map<SparkStage, SparkStageProgress> lastProgressMap) {
            if (lastProgressMap == null) {
                return false;
            }
            if (progressMap.isEmpty()) {
                return lastProgressMap.isEmpty();
            }
            if (lastProgressMap.isEmpty()) {
                return false;
            }
            if (progressMap.size() != lastProgressMap.size()) {
                return false;
            }
            for (Map.Entry<SparkStage, SparkStageProgress> entry : progressMap.entrySet()) {
                if (lastProgressMap.containsKey(entry.getKey()) && progressMap.get(entry.getKey()).equals(lastProgressMap.get(entry.getKey()))) continue;
                return false;
            }
            return true;
        }

        private boolean showReport(String report) {
            return !report.equals(this.lastReport) || System.currentTimeMillis() >= this.lastPrintTime + 3000L;
        }

        @Override
        public void printStatus(Map<SparkStage, SparkStageProgress> progressMap, Map<SparkStage, SparkStageProgress> lastProgressMap) {
            boolean withinInterval;
            boolean isDuplicateState = this.isSameAsPreviousProgress(progressMap, lastProgressMap);
            boolean bl = withinInterval = System.currentTimeMillis() <= this.lastPrintTime + 3000L;
            if (isDuplicateState && withinInterval) {
                return;
            }
            String report = this.getReport(progressMap);
            this.renderProgress(this.monitor.getProgressMonitor(progressMap));
            if (this.showReport(report)) {
                this.renderReport(report);
                this.lastReport = report;
                this.lastPrintTime = System.currentTimeMillis();
            }
        }

        abstract void renderProgress(ProgressMonitor var1);

        abstract void renderReport(String var1);
    }

    static interface UpdateFunction {
        public void printStatus(Map<SparkStage, SparkStageProgress> var1, Map<SparkStage, SparkStageProgress> var2);
    }
}

