/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapper;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.spark.SparkRecordHandler;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorDeserializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.binarysortable.BinarySortableSerDe;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableDeserializeRead;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinaryDeserializeRead;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkReduceRecordHandler
extends SparkRecordHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SparkReduceRecordHandler.class);
    private final Deserializer[] inputValueDeserializer = new Deserializer[127];
    private final Object[] valueObject = new Object[127];
    private final List<Object> row = new ArrayList<Object>(Utilities.reduceFieldNameList.size());
    private AbstractSerDe inputKeySerDe;
    private Operator<?> reducer;
    private boolean isTagged = false;
    private TableDesc keyTableDesc;
    private TableDesc[] valueTableDesc;
    private ObjectInspector[] rowObjectInspector;
    private boolean vectorized = false;
    private VectorDeserializeRow<BinarySortableDeserializeRead> keyBinarySortableDeserializeToRow;
    private VectorDeserializeRow<LazyBinaryDeserializeRead> valueLazyBinaryDeserializeToRow;
    private VectorizedRowBatch batch;
    private VectorizedRowBatchCtx batchContext;
    private long batchBytes = 0L;
    private boolean handleGroupKey = true;
    private DataOutputBuffer buffer;
    private int firstValueColumnOffset;
    private static final int BATCH_SIZE = 1024;
    private static final int BATCH_BYTES = 0x2000000;
    private transient Object keyObject;
    private transient BytesWritable groupKey;
    private StructObjectInspector keyStructInspector;
    private StructObjectInspector valueStructInspector;
    private MapredLocalWork localWork = null;
    private DummyIterator dummyIterator = new DummyIterator();

    public void init(JobConf job, OutputCollector output, Reporter reporter) throws Exception {
        this.perfLogger.perfLogBegin(CLASS_NAME, "SparkInitializeOperators");
        super.init(job, output, reporter);
        this.rowObjectInspector = new ObjectInspector[127];
        ObjectInspector[] valueObjectInspector = new ObjectInspector[127];
        ReduceWork gWork = Utilities.getReduceWork((Configuration)job);
        this.reducer = gWork.getReducer();
        this.vectorized = gWork.getVectorMode();
        this.reducer.setParentOperators(null);
        this.batchContext = gWork.getVectorizedRowBatchCtx();
        this.isTagged = gWork.getNeedsTagging();
        try {
            this.keyTableDesc = gWork.getKeyDesc();
            this.inputKeySerDe = (AbstractSerDe)ReflectionUtils.newInstance(this.keyTableDesc.getSerDeClass(), null);
            this.inputKeySerDe.initialize(null, this.keyTableDesc.getProperties(), null);
            ObjectInspector keyObjectInspector = this.inputKeySerDe.getObjectInspector();
            this.valueTableDesc = new TableDesc[gWork.getTagToValueDesc().size()];
            if (this.vectorized) {
                int maxTags = gWork.getTagToValueDesc().size();
                Preconditions.checkState((maxTags == 1 ? 1 : 0) != 0);
                this.keyStructInspector = (StructObjectInspector)keyObjectInspector;
                this.firstValueColumnOffset = this.keyStructInspector.getAllStructFieldRefs().size();
                this.buffer = new DataOutputBuffer();
            }
            for (int tag = 0; tag < gWork.getTagToValueDesc().size(); ++tag) {
                this.valueTableDesc[tag] = gWork.getTagToValueDesc().get(tag);
                AbstractSerDe inputValueSerDe = (AbstractSerDe)ReflectionUtils.newInstance(this.valueTableDesc[tag].getSerDeClass(), null);
                inputValueSerDe.initialize(null, this.valueTableDesc[tag].getProperties(), null);
                this.inputValueDeserializer[tag] = inputValueSerDe;
                valueObjectInspector[tag] = inputValueSerDe.getObjectInspector();
                ArrayList<ObjectInspector> arrayList = new ArrayList<ObjectInspector>();
                if (this.vectorized) {
                    this.valueStructInspector = (StructObjectInspector)valueObjectInspector[tag];
                    int totalColumns = this.firstValueColumnOffset + this.valueStructInspector.getAllStructFieldRefs().size();
                    this.rowObjectInspector[tag] = Utilities.constructVectorizedReduceRowOI(this.keyStructInspector, this.valueStructInspector);
                    this.batch = gWork.getVectorizedRowBatchCtx().createVectorizedRowBatch();
                    BinarySortableSerDe binarySortableSerDe = (BinarySortableSerDe)this.inputKeySerDe;
                    this.keyBinarySortableDeserializeToRow = new VectorDeserializeRow<BinarySortableDeserializeRead>(new BinarySortableDeserializeRead(VectorizedBatchUtil.typeInfosFromStructObjectInspector(this.keyStructInspector), this.batchContext.getRowdataTypePhysicalVariations().length > this.firstValueColumnOffset ? Arrays.copyOfRange(this.batchContext.getRowdataTypePhysicalVariations(), 0, this.firstValueColumnOffset) : this.batchContext.getRowdataTypePhysicalVariations(), true, binarySortableSerDe.getSortOrders(), binarySortableSerDe.getNullMarkers(), binarySortableSerDe.getNotNullMarkers()));
                    this.keyBinarySortableDeserializeToRow.init(0);
                    int valuesSize = this.valueStructInspector.getAllStructFieldRefs().size();
                    if (valuesSize <= 0) continue;
                    this.valueLazyBinaryDeserializeToRow = new VectorDeserializeRow<LazyBinaryDeserializeRead>(new LazyBinaryDeserializeRead(VectorizedBatchUtil.typeInfosFromStructObjectInspector(this.valueStructInspector), this.batchContext.getRowdataTypePhysicalVariations().length >= totalColumns ? Arrays.copyOfRange(this.batchContext.getRowdataTypePhysicalVariations(), this.firstValueColumnOffset, totalColumns) : null, true));
                    this.valueLazyBinaryDeserializeToRow.init(this.firstValueColumnOffset);
                    for (int i = this.firstValueColumnOffset; i < this.batch.numCols; ++i) {
                        ColumnVector colVector = this.batch.cols[i];
                        if (!(colVector instanceof BytesColumnVector)) continue;
                        BytesColumnVector bytesColumnVector = (BytesColumnVector)colVector;
                        bytesColumnVector.initBuffer();
                    }
                    continue;
                }
                arrayList.add(keyObjectInspector);
                arrayList.add(valueObjectInspector[tag]);
                this.rowObjectInspector[tag] = ObjectInspectorFactory.getStandardStructObjectInspector(Utilities.reduceFieldNameList, arrayList);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ExecMapperContext execContext = new ExecMapperContext(job);
        this.localWork = gWork.getMapRedLocalWork();
        execContext.setJc(this.jc);
        execContext.setLocalWork(this.localWork);
        this.reducer.passExecContext(execContext);
        this.reducer.setReporter(this.rp);
        OperatorUtils.setChildrenCollector(Arrays.asList(this.reducer), output);
        try {
            LOG.info(this.reducer.dump(0));
            this.reducer.initialize((Configuration)this.jc, this.rowObjectInspector);
            if (this.localWork != null) {
                for (Operator operator : this.localWork.getDummyParentOp()) {
                    operator.setExecContext(execContext);
                    operator.initialize((Configuration)this.jc, null);
                }
            }
        }
        catch (Throwable e) {
            this.abort = true;
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            throw new RuntimeException("Reduce operator initialization failed", e);
        }
        this.perfLogger.perfLogEnd(CLASS_NAME, "SparkInitializeOperators");
    }

    @Override
    public void processRow(Object key, Object value) throws IOException {
        if (!this.anyRow) {
            this.anyRow = true;
        }
        if (this.vectorized) {
            this.processVectorRow(key, value);
        } else {
            this.dummyIterator.setValue(value);
            this.processRow(key, this.dummyIterator);
        }
    }

    @Override
    public <E> void processRow(Object key, Iterator<E> values) throws IOException {
        if (!this.anyRow) {
            this.anyRow = true;
        }
        if (this.vectorized) {
            this.processVectorRows(key, values);
            return;
        }
        if (this.reducer.getDone()) {
            return;
        }
        try {
            BytesWritable keyWritable = (BytesWritable)key;
            byte tag = 0;
            if (this.isTagged) {
                int size = keyWritable.getSize() - 1;
                tag = keyWritable.get()[size];
                keyWritable = new BytesWritable(keyWritable.getBytes(), size);
                keyWritable.setSize(size);
            }
            if (!keyWritable.equals((Object)this.groupKey)) {
                if (this.groupKey == null) {
                    this.groupKey = new BytesWritable();
                } else {
                    LOG.trace("End Group");
                    this.reducer.endGroup();
                }
                try {
                    this.keyObject = this.inputKeySerDe.deserialize((Writable)keyWritable);
                }
                catch (Exception e) {
                    LOG.trace("Hive Runtime Error: Unable to deserialize reduce input key from " + Utilities.formatBinaryString(keyWritable.get(), 0, keyWritable.getSize()) + " with properties " + this.keyTableDesc.getProperties());
                    throw new HiveException("Hive Runtime Error: Unable to deserialize reduce input key ", (Throwable)e);
                }
                this.groupKey.set(keyWritable.get(), 0, keyWritable.getSize());
                LOG.trace("Start Group");
                this.reducer.setGroupKeyObject(this.keyObject);
                this.reducer.startGroup();
            }
            this.processKeyValues(values, tag);
        }
        catch (Throwable e) {
            this.abort = true;
            Utilities.setReduceWork((Configuration)this.jc, null);
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            String msg = "Fatal error: " + e;
            LOG.error(msg, e);
            throw new RuntimeException(e);
        }
    }

    private <E> boolean processKeyValues(Iterator<E> values, byte tag) throws HiveException {
        while (values.hasNext()) {
            BytesWritable valueWritable = (BytesWritable)values.next();
            try {
                this.valueObject[tag] = this.inputValueDeserializer[tag].deserialize((Writable)valueWritable);
            }
            catch (SerDeException e) {
                LOG.trace("Hive Runtime Error: Unable to deserialize reduce input value (tag=" + tag + ") from " + Utilities.formatBinaryString(valueWritable.get(), 0, valueWritable.getSize()) + " with properties " + this.valueTableDesc[tag].getProperties());
                throw new HiveException("Hive Runtime Error: Unable to deserialize reduce input value ", (Throwable)e);
            }
            this.row.clear();
            this.row.add(this.keyObject);
            this.row.add(this.valueObject[tag]);
            this.incrementRowNumber();
            try {
                this.reducer.process(this.row, tag);
            }
            catch (Exception e) {
                String rowString = null;
                try {
                    rowString = SerDeUtils.getJSONString(this.row, (ObjectInspector)this.rowObjectInspector[tag]);
                }
                catch (Exception e2) {
                    rowString = "[Error getting row data with exception " + StringUtils.stringifyException((Throwable)e2) + " ]";
                }
                LOG.trace("Hive exception while processing row (tag=" + tag + ") " + rowString);
                throw new HiveException("Error while processing row ", (Throwable)e);
            }
        }
        return true;
    }

    private <E> void processVectorRows(Object key, Iterator<E> values) throws IOException {
        if (this.reducer.getDone()) {
            return;
        }
        while (values.hasNext()) {
            this.processVectorRow(key, values.next());
        }
    }

    private void processVectorRow(Object key, Object value) throws IOException {
        block17: {
            BytesWritable keyWritable = (BytesWritable)key;
            BytesWritable valueWritable = (BytesWritable)value;
            try {
                if (this.handleGroupKey) {
                    boolean isKeyChange;
                    if (this.groupKey == null) {
                        isKeyChange = true;
                        this.groupKey = new BytesWritable();
                    } else {
                        boolean bl = isKeyChange = !keyWritable.equals((Object)this.groupKey);
                    }
                    if (isKeyChange) {
                        if (this.batch.size > 0) {
                            this.reducer.setNextVectorBatchGroupStatus(true);
                            this.forwardBatch(false);
                        }
                        byte[] keyBytes = keyWritable.getBytes();
                        int keyLength = keyWritable.getLength();
                        this.groupKey.set(keyBytes, 0, keyLength);
                        this.keyBinarySortableDeserializeToRow.setBytes(keyBytes, 0, keyLength);
                        try {
                            this.keyBinarySortableDeserializeToRow.deserialize(this.batch, 0);
                        }
                        catch (Exception e) {
                            throw new HiveException("\nDeserializeRead details: " + this.keyBinarySortableDeserializeToRow.getDetailedReadPositionString(), (Throwable)e);
                        }
                        for (int i = 0; i < this.firstValueColumnOffset; ++i) {
                            VectorizedBatchUtil.setRepeatingColumn(this.batch, i);
                        }
                    }
                    if (this.batch.size >= this.batch.getMaxSize() || this.batch.size > 0 && this.batchBytes >= 0x2000000L) {
                        this.reducer.setNextVectorBatchGroupStatus(false);
                        this.forwardBatch(true);
                    }
                    if (this.valueLazyBinaryDeserializeToRow != null) {
                        byte[] valueBytes = valueWritable.getBytes();
                        int valueLength = valueWritable.getLength();
                        this.batchBytes += (long)valueLength;
                        this.valueLazyBinaryDeserializeToRow.setBytes(valueBytes, 0, valueLength);
                        this.valueLazyBinaryDeserializeToRow.deserialize(this.batch, this.batch.size);
                    }
                    ++this.batch.size;
                    break block17;
                }
                if (this.batch.size >= this.batch.getMaxSize() || this.batch.size > 0 && this.batchBytes >= 0x2000000L) {
                    this.forwardBatch(false);
                }
                byte[] keyBytes = keyWritable.getBytes();
                int keyLength = keyWritable.getLength();
                this.keyBinarySortableDeserializeToRow.setBytes(keyBytes, 0, keyLength);
                try {
                    this.keyBinarySortableDeserializeToRow.deserialize(this.batch, 0);
                }
                catch (Exception e) {
                    throw new HiveException("\nDeserializeRead details: " + this.keyBinarySortableDeserializeToRow.getDetailedReadPositionString(), (Throwable)e);
                }
                if (this.valueLazyBinaryDeserializeToRow != null) {
                    byte[] valueBytes = valueWritable.getBytes();
                    int valueLength = valueWritable.getLength();
                    this.batchBytes += (long)valueLength;
                    this.valueLazyBinaryDeserializeToRow.setBytes(valueBytes, 0, valueLength);
                    this.valueLazyBinaryDeserializeToRow.deserialize(this.batch, this.batch.size);
                }
                ++this.batch.size;
            }
            catch (Throwable e) {
                this.abort = true;
                if (e instanceof OutOfMemoryError) {
                    throw (OutOfMemoryError)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    private void forwardBatch(boolean resetValueColumnsOnly) throws HiveException {
        this.reducer.process(this.batch, 0);
        if (resetValueColumnsOnly) {
            for (int i = this.firstValueColumnOffset; i < this.batch.numCols; ++i) {
                this.batch.cols[i].reset();
            }
            this.batch.size = 0;
        } else {
            this.batch.reset();
        }
        this.batchBytes = 0L;
        this.incrementRowNumber();
    }

    private Object deserializeValue(BytesWritable valueWritable, byte tag) throws HiveException {
        try {
            return this.inputValueDeserializer[tag].deserialize((Writable)valueWritable);
        }
        catch (SerDeException e) {
            LOG.trace("Error: Unable to deserialize reduce input value (tag=" + tag + ") from " + Utilities.formatBinaryString(valueWritable.getBytes(), 0, valueWritable.getLength()) + " with properties " + this.valueTableDesc[tag].getProperties());
            throw new HiveException("Error: Unable to deserialize reduce input value ", (Throwable)e);
        }
    }

    @Override
    public void close() {
        super.close();
        if (!this.anyRow) {
            LOG.trace("Close called without any rows processed");
        }
        try {
            if (this.vectorized) {
                if (this.batch.size > 0) {
                    if (this.handleGroupKey) {
                        this.reducer.setNextVectorBatchGroupStatus(true);
                    }
                    this.forwardBatch(false);
                }
            } else if (this.groupKey != null) {
                LOG.trace("End Group");
                this.reducer.endGroup();
            }
            this.reducer.close(this.abort);
            if (this.localWork != null) {
                for (Operator<? extends OperatorDesc> dummyOp : this.localWork.getDummyParentOp()) {
                    dummyOp.close(this.abort);
                }
            }
            ExecMapper.ReportStats rps = new ExecMapper.ReportStats(this.rp, (Configuration)this.jc);
            this.reducer.preorderMap(rps);
        }
        catch (Exception e) {
            if (!this.abort) {
                LOG.error("Hit error while closing operators - failing tree");
                throw new RuntimeException("Hive Runtime Error while closing operators: " + e.getMessage(), e);
            }
        }
        finally {
            MapredContext.close();
            Utilities.clearWorkMap((Configuration)this.jc);
        }
    }

    @Override
    public boolean getDone() {
        return this.reducer.getDone();
    }

    public static String displayBytes(byte[] bytes, int start, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < start + length; ++i) {
            sb.append(String.format("\\%03d", bytes[i] & 0xFF));
        }
        return sb.toString();
    }

    private static class DummyIterator
    implements Iterator<Object> {
        private boolean done = false;
        private Object value = null;

        private DummyIterator() {
        }

        public void setValue(Object v) {
            this.value = v;
            this.done = false;
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        @Override
        public Object next() {
            this.done = true;
            return this.value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Iterator.remove() is not implemented/supported");
        }
    }
}

