/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.spark.MapInput;
import org.apache.hadoop.hive.ql.exec.spark.SparkTran;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.plan.ExplainWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.util.CallSite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkPlan {
    private static final String CLASS_NAME = SparkPlan.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(SparkPlan.class);
    private final PerfLogger perfLogger = SessionState.getPerfLogger();
    private final Set<SparkTran> rootTrans = new HashSet<SparkTran>();
    private final Set<SparkTran> leafTrans = new HashSet<SparkTran>();
    private final Map<SparkTran, List<SparkTran>> transGraph = new HashMap<SparkTran, List<SparkTran>>();
    private final Map<SparkTran, List<SparkTran>> invertedTransGraph = new HashMap<SparkTran, List<SparkTran>>();
    private final Set<Integer> cachedRDDIds = new HashSet<Integer>();
    private final JobConf jobConf;
    private final SparkContext sc;

    SparkPlan(JobConf jobConf, SparkContext sc) {
        this.jobConf = jobConf;
        this.sc = sc;
    }

    public JavaPairRDD<HiveKey, BytesWritable> generateGraph() {
        this.perfLogger.perfLogBegin(CLASS_NAME, "SparkBuildRDDGraph");
        HashMap<SparkTran, JavaPairRDD> tranToOutputRDDMap = new HashMap<SparkTran, JavaPairRDD>();
        for (SparkTran tran : this.getAllTrans()) {
            JavaPairRDD rdd = null;
            List<SparkTran> parents = this.getParents(tran);
            if (parents.size() == 0) {
                Preconditions.checkArgument((boolean)(tran instanceof MapInput), (Object)"AssertionError: tran must be an instance of MapInput");
                this.sc.setCallSite(CallSite.apply((String)tran.getName(), (String)this.getLongFormCallSite(tran)));
                rdd = tran.transform(null);
            } else {
                for (SparkTran parent : parents) {
                    JavaPairRDD prevRDD = (JavaPairRDD)tranToOutputRDDMap.get(parent);
                    if (rdd == null) {
                        rdd = prevRDD;
                        continue;
                    }
                    this.sc.setCallSite(CallSite.apply((String)("UnionRDD (" + rdd.name() + ", " + prevRDD.name() + ")"), (String)""));
                    rdd = rdd.union(prevRDD);
                    rdd.setName("UnionRDD (" + rdd.getNumPartitions() + ")");
                }
                this.sc.setCallSite(CallSite.apply((String)tran.getName(), (String)this.getLongFormCallSite(tran)));
                rdd = tran.transform(rdd);
            }
            tranToOutputRDDMap.put(tran, rdd);
        }
        JavaPairRDD finalRDD = null;
        for (SparkTran leafTran : this.leafTrans) {
            JavaPairRDD rdd = (JavaPairRDD)tranToOutputRDDMap.get(leafTran);
            if (finalRDD == null) {
                finalRDD = rdd;
                continue;
            }
            this.sc.setCallSite(CallSite.apply((String)("UnionRDD (" + rdd.name() + ", " + finalRDD.name() + ")"), (String)""));
            finalRDD = finalRDD.union(rdd);
            finalRDD.setName("UnionRDD (" + finalRDD.getNumPartitions() + ")");
        }
        this.perfLogger.perfLogEnd(CLASS_NAME, "SparkBuildRDDGraph");
        LOG.info("\n\nSpark RDD Graph:\n\n" + finalRDD.toDebugString() + "\n");
        return finalRDD;
    }

    private String getLongFormCallSite(SparkTran tran) {
        if (this.jobConf.getBoolean(HiveConf.ConfVars.HIVE_SPARK_LOG_EXPLAIN_WEBUI.varname, HiveConf.ConfVars.HIVE_SPARK_LOG_EXPLAIN_WEBUI.defaultBoolVal)) {
            this.perfLogger.perfLogBegin(CLASS_NAME, "SparkCreateExplainPlan." + tran.getName());
            ExplainWork explainWork = new ExplainWork();
            explainWork.setConfig(new ExplainConfiguration());
            ExplainTask explainTask = new ExplainTask();
            explainTask.setWork(explainWork);
            String explainOutput = "";
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                explainTask.outputPlan(tran.getBaseWork(), new PrintStream(outputStream), false, false, 0, null, this.jobConf.getBoolean(HiveConf.ConfVars.HIVE_IN_TEST.varname, HiveConf.ConfVars.HIVE_IN_TEST.defaultBoolVal));
                explainOutput = StringUtils.abbreviate((String)(tran.getName() + " Explain Plan:\n\n" + outputStream.toString()), (int)100000);
                LOG.debug(explainOutput);
            }
            catch (Exception e) {
                LOG.error("Error while generating explain plan for " + tran.getName(), (Throwable)e);
            }
            this.perfLogger.perfLogEnd(CLASS_NAME, "SparkCreateExplainPlan." + tran.getName());
            return explainOutput;
        }
        return "";
    }

    public void addTran(SparkTran tran) {
        this.rootTrans.add(tran);
        this.leafTrans.add(tran);
    }

    public void addCachedRDDId(int rddId) {
        this.cachedRDDIds.add(rddId);
    }

    public Set<Integer> getCachedRDDIds() {
        return this.cachedRDDIds;
    }

    private List<SparkTran> getAllTrans() {
        LinkedList<SparkTran> result = new LinkedList<SparkTran>();
        HashSet<SparkTran> seen = new HashSet<SparkTran>();
        for (SparkTran leaf : this.leafTrans) {
            this.visit(leaf, seen, result);
        }
        return result;
    }

    private void visit(SparkTran child, Set<SparkTran> seen, List<SparkTran> result) {
        if (seen.contains(child)) {
            return;
        }
        seen.add(child);
        for (SparkTran parent : this.getParents(child)) {
            if (seen.contains(parent)) continue;
            this.visit(parent, seen, result);
        }
        result.add(child);
    }

    public void connect(SparkTran parent, SparkTran child) {
        this.rootTrans.remove(child);
        this.leafTrans.remove(parent);
        if (this.transGraph.get(parent) == null) {
            this.transGraph.put(parent, new LinkedList());
        }
        if (this.invertedTransGraph.get(child) == null) {
            this.invertedTransGraph.put(child, new LinkedList());
        }
        this.transGraph.get(parent).add(child);
        this.invertedTransGraph.get(child).add(parent);
    }

    public List<SparkTran> getParents(SparkTran tran) {
        if (!this.invertedTransGraph.containsKey(tran)) {
            return Collections.emptyList();
        }
        return this.invertedTransGraph.get(tran);
    }

    public List<SparkTran> getChildren(SparkTran tran) {
        if (!this.transGraph.containsKey(tran)) {
            return Collections.emptyList();
        }
        return this.transGraph.get(tran);
    }
}

