/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.AbstractFileMergeOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.spark.SparkRecordHandler;
import org.apache.hadoop.hive.ql.io.merge.MergeFileWork;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.FileMergeDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkMergeFileRecordHandler
extends SparkRecordHandler {
    private static final String PLAN_KEY = "__MAP_PLAN__";
    private static final Logger LOG = LoggerFactory.getLogger(SparkMergeFileRecordHandler.class);
    private Operator<? extends OperatorDesc> op;
    private AbstractFileMergeOperator<? extends FileMergeDesc> mergeOp;
    private Object[] row;

    @Override
    public <K, V> void init(JobConf job, OutputCollector<K, V> output, Reporter reporter) throws Exception {
        super.init(job, output, reporter);
        try {
            this.jc = job;
            MapWork mapWork = Utilities.getMapWork((Configuration)job);
            if (mapWork instanceof MergeFileWork) {
                MergeFileWork mergeFileWork = (MergeFileWork)mapWork;
                String alias = mergeFileWork.getAliasToWork().keySet().iterator().next();
                this.op = mergeFileWork.getAliasToWork().get(alias);
                if (!(this.op instanceof AbstractFileMergeOperator)) {
                    this.abort = true;
                    throw new IllegalStateException("Merge file work's top operator should be an instance of AbstractFileMergeOperator");
                }
            } else {
                this.abort = true;
                throw new IllegalStateException("Map work should be a merge file work.");
            }
            this.mergeOp = (AbstractFileMergeOperator)this.op;
            this.mergeOp.initializeOp((Configuration)this.jc);
            this.row = new Object[2];
            this.abort = false;
            LOG.info(this.mergeOp.dump(0));
        }
        catch (HiveException e) {
            this.abort = true;
            throw new RuntimeException(e);
        }
    }

    @Override
    public void processRow(Object key, Object value) throws IOException {
        this.row[0] = key;
        this.row[1] = value;
        this.incrementRowNumber();
        try {
            this.mergeOp.process(this.row, 0);
        }
        catch (HiveException e) {
            this.abort = true;
            throw new IOException(e);
        }
    }

    @Override
    public <E> void processRow(Object key, Iterator<E> values) throws IOException {
        throw new UnsupportedOperationException("Do not support this method in " + this.getClass().getSimpleName());
    }

    @Override
    public void close() {
        super.close();
        LOG.info("Closing Merge Operator " + this.mergeOp.getName());
        try {
            this.mergeOp.closeOp(this.abort);
        }
        catch (HiveException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean getDone() {
        return this.mergeOp.getDone();
    }
}

