/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import org.apache.hadoop.hive.ql.exec.spark.SparkPlan;
import org.apache.hadoop.hive.ql.exec.spark.SparkShuffler;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.io.BytesWritable;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.rdd.ShuffledRDD;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.storage.StorageLevel;

public class SortByShuffler
implements SparkShuffler<BytesWritable> {
    private final boolean totalOrder;
    private final SparkPlan sparkPlan;
    private final KryoSerializer shuffleSerializer;

    public SortByShuffler(boolean totalOrder, SparkPlan sparkPlan, KryoSerializer shuffleSerializer) {
        this.totalOrder = totalOrder;
        this.sparkPlan = sparkPlan;
        this.shuffleSerializer = shuffleSerializer;
    }

    @Override
    public JavaPairRDD<HiveKey, BytesWritable> shuffle(JavaPairRDD<HiveKey, BytesWritable> input, int numPartitions) {
        JavaPairRDD rdd;
        if (this.totalOrder) {
            if (numPartitions > 0) {
                if (numPartitions > 1 && input.getStorageLevel() == StorageLevel.NONE()) {
                    input.persist(StorageLevel.DISK_ONLY());
                    this.sparkPlan.addCachedRDDId(input.id());
                }
                rdd = input.sortByKey(true, numPartitions);
            } else {
                rdd = input.sortByKey(true);
            }
        } else {
            HashPartitioner partitioner = new HashPartitioner(numPartitions);
            rdd = input.repartitionAndSortWithinPartitions((Partitioner)partitioner);
        }
        if (this.shuffleSerializer != null && rdd.rdd() instanceof ShuffledRDD) {
            ((ShuffledRDD)rdd.rdd()).setSerializer((Serializer)this.shuffleSerializer);
        }
        return rdd;
    }

    @Override
    public String getName() {
        return "SortBy";
    }
}

