/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmallTableCache {
    private static final Logger LOG = LoggerFactory.getLogger(SmallTableCache.class);
    private static final SmallTableLocalCache<String, MapJoinTableContainer> TABLE_CONTAINER_CACHE = new SmallTableLocalCache();
    private static volatile String queryId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Configuration conf) {
        String currentQueryId = conf.get(HiveConf.ConfVars.HIVEQUERYID.varname);
        if (!currentQueryId.equals(queryId)) {
            if (TABLE_CONTAINER_CACHE.size() != 0L) {
                SmallTableLocalCache<String, MapJoinTableContainer> smallTableLocalCache = TABLE_CONTAINER_CACHE;
                synchronized (smallTableLocalCache) {
                    if (!currentQueryId.equals(queryId) && TABLE_CONTAINER_CACHE.size() != 0L) {
                        TABLE_CONTAINER_CACHE.clear((path, tableContainer) -> tableContainer.clear());
                        LOG.debug("Cleaned up small table cache for query {}", (Object)queryId);
                    }
                }
            }
            queryId = currentQueryId;
        }
    }

    public static void cache(String key, MapJoinTableContainer tableContainer) {
        TABLE_CONTAINER_CACHE.put(key, tableContainer);
    }

    public static MapJoinTableContainer get(String key, Callable<MapJoinTableContainer> valueLoader) throws ExecutionException {
        return TABLE_CONTAINER_CACHE.get(key, valueLoader);
    }

    @VisibleForTesting
    static class SmallTableLocalCache<K, V> {
        private static final int MAINTENANCE_THREAD_CLEANUP_PERIOD = 10;
        private static final int L1_CACHE_EXPIRE_DURATION = 30;
        private final Cache<K, V> cacheL1;
        private final Cache<K, V> cacheL2;
        private final ScheduledExecutorService cleanupService = Executors.newScheduledThreadPool(NumberUtils.INTEGER_ONE, new ThreadFactoryBuilder().setNameFormat("SmallTableCache Cleanup Thread").setDaemon(true).build());

        SmallTableLocalCache() {
            this(Ticker.systemTicker());
        }

        @VisibleForTesting
        SmallTableLocalCache(Ticker ticker) {
            this.cacheL1 = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).ticker(ticker).build();
            this.cacheL2 = CacheBuilder.newBuilder().softValues().build();
            this.cleanupService.scheduleAtFixedRate(() -> this.cleanup(), NumberUtils.INTEGER_ZERO.intValue(), 10L, TimeUnit.SECONDS);
        }

        public long size() {
            return this.cacheL2.size();
        }

        public void clear(BiConsumer<? super K, ? super V> action) {
            this.cacheL1.invalidateAll();
            this.cacheL2.asMap().forEach(action);
            this.cacheL2.invalidateAll();
        }

        @VisibleForTesting
        void cleanup() {
            this.cacheL1.cleanUp();
        }

        public void put(K key, V value) {
            this.cacheL2.put(key, value);
            this.cacheL1.put(key, value);
        }

        public V get(K key, Callable<V> valueLoader) throws ExecutionException {
            return (V)this.cacheL1.get(key, () -> this.cacheL2.get(key, valueLoader));
        }
    }
}

