/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import org.apache.hadoop.hive.ql.exec.spark.SparkPlan;
import org.apache.hadoop.hive.ql.exec.spark.SparkShuffler;
import org.apache.hadoop.hive.ql.exec.spark.SparkTran;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.SparkEdgeProperty;
import org.apache.hadoop.io.BytesWritable;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.storage.StorageLevel;

public class ShuffleTran
implements SparkTran<HiveKey, BytesWritable, HiveKey, BytesWritable> {
    private final SparkShuffler shuffler;
    private final int numOfPartitions;
    private final boolean toCache;
    private final SparkPlan sparkPlan;
    private final String name;
    private final SparkEdgeProperty edge;
    private final BaseWork baseWork;

    public ShuffleTran(SparkPlan sparkPlan, SparkShuffler sf, int n) {
        this(sparkPlan, sf, n, false, "Shuffle", null, null);
    }

    public ShuffleTran(SparkPlan sparkPlan, SparkShuffler sf, int n, boolean toCache, String name, SparkEdgeProperty edge, BaseWork baseWork) {
        this.shuffler = sf;
        this.numOfPartitions = n;
        this.toCache = toCache;
        this.sparkPlan = sparkPlan;
        this.name = name;
        this.edge = edge;
        this.baseWork = baseWork;
    }

    @Override
    public JavaPairRDD<HiveKey, BytesWritable> transform(JavaPairRDD<HiveKey, BytesWritable> input) {
        JavaPairRDD result = this.shuffler.shuffle(input, this.numOfPartitions);
        if (this.toCache) {
            this.sparkPlan.addCachedRDDId(result.id());
            result = result.persist(StorageLevel.MEMORY_AND_DISK());
        }
        return result.setName(this.name + " (" + this.edge.getShuffleType() + ", " + this.numOfPartitions + (this.toCache ? ", cached)" : ")"));
    }

    public int getNoOfPartitions() {
        return this.numOfPartitions;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Boolean isCacheEnable() {
        return this.toCache;
    }

    @Override
    public BaseWork getBaseWork() {
        return this.baseWork;
    }

    public SparkShuffler getShuffler() {
        return this.shuffler;
    }
}

