/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.repl.ReplScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.misc.properties.AlterTableSetPropertiesDesc;
import org.apache.hadoop.hive.ql.ddl.table.partition.PartitionUtils;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.ReplAck;
import org.apache.hadoop.hive.ql.exec.repl.ReplStateLogWork;
import org.apache.hadoop.hive.ql.exec.util.Retryable;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.dump.metric.BootstrapDumpMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.dump.metric.IncrementalDumpMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.load.UpdatedMetaDataTracker;
import org.apache.hadoop.hive.ql.parse.repl.load.metric.BootstrapLoadMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.load.metric.IncrementalLoadMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Status;
import org.apache.hadoop.hive.ql.plan.ColumnStatsUpdateWork;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.ImportTableDesc;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplUtils {
    public static final String LAST_REPL_ID_KEY = "hive.repl.last.repl.id";
    public static final String REPL_CHECKPOINT_KEY = "hive.repl.ckpt.key";
    public static final String REPL_FIRST_INC_PENDING_FLAG = "hive.repl.first.inc.pending";
    public static final String REPL_CURRENT_TBL_WRITE_ID = "hive.repl.current.table.write.id";
    public static final String REPL_IS_CUSTOM_DB_LOC = "hive.repl.is.custom.db.loc";
    public static final String REPL_IS_CUSTOM_DB_MANAGEDLOC = "hive.repl.is.custom.db.managedloc";
    public static final String FUNCTIONS_ROOT_DIR_NAME = "_functions";
    public static final String CONSTRAINTS_ROOT_DIR_NAME = "_constraints";
    public static final String INC_BOOTSTRAP_ROOT_DIR_NAME = "_bootstrap";
    public static final String REPL_HIVE_BASE_DIR = "hive";
    public static final String REPL_RANGER_BASE_DIR = "ranger";
    public static final String REPL_ATLAS_BASE_DIR = "atlas";
    public static final String REPL_ATLAS_EXPORT_FILE_NAME = "atlas_export.zip";
    public static final String DEFAULT_FS_CONFIG = "fs.defaultFS";
    public static final String REPL_TABLE_LIST_DIR_NAME = "_tables";
    public static final String REPL_DUMP_INCLUDE_ACID_TABLES = "hive.repl.dump.include.acid.tables";
    public static final String DFS_MAX_DIR_ITEMS_CONFIG = "dfs.namenode.fs-limits.max-directory-items";
    public static final int RESERVED_DIR_ITEMS_COUNT = 10;
    public static final String RANGER_AUTHORIZER = "ranger";
    public static final String HIVE_RANGER_POLICIES_FILE_NAME = "ranger_policies.json";
    public static final String RANGER_REST_URL = "ranger.plugin.hive.policy.rest.url";
    public static final String RANGER_HIVE_SERVICE_NAME = "ranger.plugin.hive.service.name";
    public static final String RANGER_CONFIGURATION_RESOURCE_NAME = "ranger-hive-security.xml";
    public static final String TARGET_OF_REPLICATION = "repl.target.for";
    public static final String REPL_HIVE_SERVICE = "hive";
    public static final String REPL_RANGER_SERVICE = "ranger";
    public static final String REPL_ATLAS_SERVICE = "atlas";
    private static transient Logger LOG = LoggerFactory.getLogger(ReplUtils.class);

    public static Map<Integer, List<ExprNodeGenericFuncDesc>> genPartSpecs(Table table, List<Map<String, String>> partitions) throws SemanticException {
        HashMap<Integer, List<ExprNodeGenericFuncDesc>> partSpecs = new HashMap<Integer, List<ExprNodeGenericFuncDesc>>();
        int partPrefixLength = 0;
        if (partitions.size() > 0) {
            partPrefixLength = partitions.get(0).size();
        }
        ArrayList<ExprNodeGenericFuncDesc> partitionDesc = new ArrayList<ExprNodeGenericFuncDesc>();
        for (Map<String, String> ptn : partitions) {
            ExprNodeGenericFuncDesc expr = null;
            for (Map.Entry<String, String> kvp : ptn.entrySet()) {
                String key = kvp.getKey();
                String val = kvp.getValue();
                String type = table.getPartColByName(key).getType();
                PrimitiveTypeInfo pti = TypeInfoFactory.getPrimitiveTypeInfo((String)type);
                ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)pti, key, null, true);
                ExprNodeGenericFuncDesc op = PartitionUtils.makeBinaryPredicate("=", column, new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, val));
                expr = expr == null ? op : PartitionUtils.makeBinaryPredicate("and", expr, op);
            }
            if (expr == null) continue;
            partitionDesc.add(expr);
        }
        if (partitionDesc.size() > 0) {
            partSpecs.put(partPrefixLength, partitionDesc);
        }
        return partSpecs;
    }

    public static Task<?> getTableReplLogTask(ImportTableDesc tableDesc, ReplLogger replLogger, HiveConf conf, ReplicationMetricCollector metricCollector) throws SemanticException {
        TableType tableType = tableDesc.isExternal() ? TableType.EXTERNAL_TABLE : tableDesc.tableType();
        ReplStateLogWork replLogWork = new ReplStateLogWork(replLogger, metricCollector, tableDesc.getTableName(), tableType);
        return TaskFactory.get(replLogWork, conf);
    }

    public static Task<?> getTableReplLogTask(ImportTableDesc tableDesc, ReplLogger replLogger, HiveConf conf, ReplicationMetricCollector metricCollector, String dumpRoot) throws SemanticException {
        TableType tableType = tableDesc.isExternal() ? TableType.EXTERNAL_TABLE : tableDesc.tableType();
        ReplStateLogWork replLogWork = new ReplStateLogWork(replLogger, metricCollector, tableDesc.getTableName(), tableType, dumpRoot);
        return TaskFactory.get(replLogWork, conf);
    }

    public static Task<?> getTableCheckpointTask(ImportTableDesc tableDesc, HashMap<String, String> partSpec, String dumpRoot, HiveConf conf) throws SemanticException {
        HashMap<String, String> mapProp = new HashMap<String, String>();
        mapProp.put(REPL_CHECKPOINT_KEY, dumpRoot);
        TableName tName = TableName.fromString((String)tableDesc.getTableName(), null, (String)tableDesc.getDatabaseName());
        AlterTableSetPropertiesDesc alterTblDesc = new AlterTableSetPropertiesDesc(tName, partSpec, null, false, mapProp, false, false, null);
        return TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), alterTblDesc), conf);
    }

    public static Task<?> getTableCheckpointTask(ImportTableDesc tableDesc, HashMap<String, String> partSpec, String dumpRoot, ReplicationMetricCollector metricCollector, HiveConf conf) throws SemanticException {
        HashMap<String, String> mapProp = new HashMap<String, String>();
        mapProp.put(REPL_CHECKPOINT_KEY, dumpRoot);
        TableName tName = TableName.fromString((String)tableDesc.getTableName(), null, (String)tableDesc.getDatabaseName());
        AlterTableSetPropertiesDesc alterTblDesc = new AlterTableSetPropertiesDesc(tName, partSpec, null, false, mapProp, false, false, null);
        return TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), alterTblDesc, true, new Path(dumpRoot).getParent().toString(), metricCollector), conf);
    }

    public static boolean replCkptStatus(String dbName, Map<String, String> props, String dumpRoot) throws InvalidOperationException {
        if (props != null && props.containsKey(REPL_CHECKPOINT_KEY) && !props.get(REPL_CHECKPOINT_KEY).isEmpty()) {
            if (props.get(REPL_CHECKPOINT_KEY).equals(dumpRoot)) {
                return true;
            }
            throw new InvalidOperationException(ErrorMsg.REPL_BOOTSTRAP_LOAD_PATH_NOT_VALID.format(new String[]{dumpRoot, props.get(REPL_CHECKPOINT_KEY)}));
        }
        return false;
    }

    public static boolean isTargetOfReplication(Database db) {
        assert (db != null);
        Map m = db.getParameters();
        if (m != null && m.containsKey(TARGET_OF_REPLICATION)) {
            return !StringUtils.isEmpty((CharSequence)((CharSequence)m.get(TARGET_OF_REPLICATION)));
        }
        return false;
    }

    public static String getNonEmpty(String configParam, HiveConf hiveConf, String errorMsgFormat) throws SemanticException {
        String val = hiveConf.get(configParam);
        if (StringUtils.isEmpty((CharSequence)val)) {
            throw new SemanticException(ErrorMsg.REPL_INVALID_CONFIG_FOR_SERVICE.format(new String[]{String.format(errorMsgFormat, configParam), "atlas"}));
        }
        return val;
    }

    public static List<Task<?>> addChildTask(Task<?> childTask) {
        ArrayList taskList = new ArrayList();
        taskList.add(childTask);
        return taskList;
    }

    public static List<Task<?>> addTasksForLoadingColStats(ColumnStatistics colStats, HiveConf conf, UpdatedMetaDataTracker updatedMetadata, org.apache.hadoop.hive.metastore.api.Table tableObj, long writeId) throws IOException, TException {
        ArrayList taskList = new ArrayList();
        ColumnStatsUpdateWork work = new ColumnStatsUpdateWork(colStats);
        work.setWriteId(writeId);
        Task<ColumnStatsUpdateWork> task = TaskFactory.get(work, conf);
        taskList.add(task);
        return taskList;
    }

    public static List<Task<?>> addTasksForLoadingColStats(ColumnStatistics colStats, HiveConf conf, UpdatedMetaDataTracker updatedMetadata, org.apache.hadoop.hive.metastore.api.Table tableObj, long writeId, String nonRecoverableMarkPath, ReplicationMetricCollector metricCollector) throws IOException, TException {
        ArrayList taskList = new ArrayList();
        ColumnStatsUpdateWork work = new ColumnStatsUpdateWork(colStats, nonRecoverableMarkPath, metricCollector, true);
        work.setWriteId(writeId);
        Task<ColumnStatsUpdateWork> task = TaskFactory.get(work, conf);
        taskList.add(task);
        return taskList;
    }

    public static PathFilter getEventsDirectoryFilter(FileSystem fs) {
        return p -> {
            try {
                return fs.isDirectory(p) && !p.getName().equalsIgnoreCase(INC_BOOTSTRAP_ROOT_DIR_NAME) && !p.getName().equalsIgnoreCase(REPL_TABLE_LIST_DIR_NAME) && !p.getName().equalsIgnoreCase("metadata");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static PathFilter getBootstrapDirectoryFilter(FileSystem fs) {
        return p -> {
            try {
                return fs.isDirectory(p) && !p.getName().equalsIgnoreCase(REPL_TABLE_LIST_DIR_NAME) && !p.getName().equalsIgnoreCase("metadata");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static int handleException(boolean isReplication, Throwable e, String nonRecoverablePath, ReplicationMetricCollector metricCollector, String stageName, HiveConf conf) {
        int errorCode = ErrorMsg.getErrorMsg((String)e.getMessage()).getErrorCode();
        if (isReplication) {
            try {
                if (nonRecoverablePath != null) {
                    int recoverableLimit = ErrorMsg.GENERIC_ERROR.getErrorCode();
                    String metricStage = ReplUtils.getMetricStageName(stageName, metricCollector);
                    if (errorCode > recoverableLimit) {
                        Path nonRecoverableMarker = new Path(new Path(nonRecoverablePath), ReplAck.NON_RECOVERABLE_MARKER.toString());
                        Utils.writeStackTrace(e, nonRecoverableMarker, conf);
                        metricCollector.reportStageEnd(metricStage, Status.FAILED_ADMIN, nonRecoverableMarker.toString());
                    } else {
                        metricCollector.reportStageEnd(metricStage, Status.FAILED);
                    }
                }
            }
            catch (Exception ex) {
                LOG.error("Failed to collect Metrics ", (Throwable)ex);
            }
        }
        return errorCode;
    }

    private static String getMetricStageName(String stageName, ReplicationMetricCollector metricCollector) {
        if (stageName == "REPL_DUMP" || stageName == "REPL_LOAD" || stageName == "ATLAS_DUMP" || stageName == "ATLAS_LOAD" || stageName == "RANGER_DUMP" || stageName == "RANGER_LOAD") {
            return stageName;
        }
        if (ReplUtils.isDumpMetricCollector(metricCollector)) {
            return "REPL_DUMP";
        }
        return "REPL_LOAD";
    }

    private static boolean isDumpMetricCollector(ReplicationMetricCollector metricCollector) {
        return metricCollector instanceof BootstrapDumpMetricCollector || metricCollector instanceof IncrementalDumpMetricCollector;
    }

    private static boolean isLoadMetricCollector(ReplicationMetricCollector metricCollector) {
        return metricCollector instanceof BootstrapLoadMetricCollector || metricCollector instanceof IncrementalLoadMetricCollector;
    }

    public static boolean isFirstIncPending(Map<String, String> parameters) {
        if (parameters == null) {
            return false;
        }
        String firstIncPendFlag = parameters.get(REPL_FIRST_INC_PENDING_FLAG);
        return firstIncPendFlag != null && !firstIncPendFlag.isEmpty() && "true".equalsIgnoreCase(firstIncPendFlag);
    }

    public static EnvironmentContext setReplDataLocationChangedFlag(EnvironmentContext envContext) {
        if (envContext == null) {
            envContext = new EnvironmentContext();
        }
        envContext.putToProperties("REPL_DATA_LOCATION_CHANGED", "true");
        return envContext;
    }

    public static boolean includeAcidTableInDump(HiveConf conf) {
        if (conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST_REPL)) {
            return conf.getBoolean(REPL_DUMP_INCLUDE_ACID_TABLES, true);
        }
        return true;
    }

    public static boolean tableIncludedInReplScope(ReplScope replScope, String tableName) {
        return replScope == null || replScope.tableIncludedInReplScope(tableName);
    }

    public static boolean failedWithNonRecoverableError(Path dumpRoot, HiveConf conf) throws SemanticException {
        if (dumpRoot == null) {
            return false;
        }
        Retryable retryable = Retryable.builder().withHiveConf(conf).withRetryOnException(IOException.class).build();
        try {
            return retryable.executeCallable(() -> {
                FileSystem fs = dumpRoot.getFileSystem((Configuration)conf);
                if (fs.exists(new Path(dumpRoot, ReplAck.NON_RECOVERABLE_MARKER.toString()))) {
                    return true;
                }
                return false;
            });
        }
        catch (Exception e) {
            throw new SemanticException((Throwable)e);
        }
    }

    public static Path getEncodedDumpRootPath(HiveConf conf, String dbname) throws UnsupportedEncodingException {
        return new Path(conf.getVar(HiveConf.ConfVars.REPLDIR), Base64.getEncoder().encodeToString(dbname.getBytes(StandardCharsets.UTF_8.name())));
    }

    public static Path getLatestDumpPath(Path dumpRoot, HiveConf conf) throws IOException {
        FileStatus[] statuses;
        FileSystem fs = dumpRoot.getFileSystem((Configuration)conf);
        if (fs.exists(dumpRoot) && (statuses = fs.listStatus(dumpRoot)).length > 0) {
            FileStatus latestValidStatus = statuses[0];
            for (FileStatus status : statuses) {
                LOG.info("Evaluating previous dump dir path:{}", (Object)status.getPath());
                if (status.getModificationTime() <= latestValidStatus.getModificationTime()) continue;
                latestValidStatus = status;
            }
            return latestValidStatus.getPath();
        }
        return null;
    }

    public static enum MetricName {
        TABLES,
        FUNCTIONS,
        EVENTS,
        POLICIES,
        ENTITIES;

    }

    public static enum ReplLoadOpType {
        LOAD_NEW,
        LOAD_SKIP,
        LOAD_REPLACE;

    }
}

