/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.table;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.partition.add.AlterTableAddPartitionDesc;
import org.apache.hadoop.hive.ql.ddl.table.partition.drop.AlterTableDropPartitionDesc;
import org.apache.hadoop.hive.ql.exec.ReplCopyTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.ReplExternalTables;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.TableEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.ReplicationState;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.table.LoadTable;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.table.TableContext;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.util.Context;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.exec.repl.util.TaskTracker;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.HiveTableName;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.ImportTableDesc;
import org.datanucleus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadPartitions {
    private static Logger LOG = LoggerFactory.getLogger(LoadPartitions.class);
    private final Context context;
    private final ReplLogger replLogger;
    private final TableContext tableContext;
    private final TableEvent event;
    private final TaskTracker tracker;
    private final AlterTableAddPartitionDesc lastReplicatedPartition;
    private final AlterTableAddPartitionDesc.PartitionDesc lastReplicatedPartitionDesc;
    private final ReplicationState.PartitionState.Stage lastReplicatedStage;
    private final ReplicationMetricCollector metricCollector;
    private final ImportTableDesc tableDesc;
    private Table table;

    public LoadPartitions(Context context, ReplLogger replLogger, TaskTracker tableTracker, TableEvent event, String dbNameToLoadIn, TableContext tableContext, ReplicationMetricCollector metricCollector) throws HiveException {
        this(context, replLogger, tableContext, tableTracker, event, dbNameToLoadIn, null, metricCollector, null, ReplicationState.PartitionState.Stage.PARTITION);
    }

    public LoadPartitions(Context context, ReplLogger replLogger, TableContext tableContext, TaskTracker limiter, TableEvent event, String dbNameToLoadIn, AlterTableAddPartitionDesc lastReplicatedPartition, ReplicationMetricCollector metricCollector, AlterTableAddPartitionDesc.PartitionDesc lastReplicatedPartitionDesc, ReplicationState.PartitionState.Stage lastReplicatedStage) throws HiveException {
        this.tracker = new TaskTracker(limiter);
        this.event = event;
        this.context = context;
        this.replLogger = replLogger;
        this.lastReplicatedPartition = lastReplicatedPartition;
        this.tableContext = tableContext;
        this.tableDesc = event.tableDesc(dbNameToLoadIn);
        this.table = ImportSemanticAnalyzer.tableIfExists(this.tableDesc, context.hiveDb);
        this.metricCollector = metricCollector;
        this.lastReplicatedPartitionDesc = lastReplicatedPartitionDesc;
        this.lastReplicatedStage = lastReplicatedStage;
    }

    public TaskTracker tasks() throws Exception {
        Database parentDb = this.context.hiveDb.getDatabase(this.tableDesc.getDatabaseName());
        LoadTable.TableLocationTuple tableLocationTuple = LoadTable.tableLocation(this.tableDesc, parentDb, this.tableContext, this.context);
        this.tableDesc.setLocation(tableLocationTuple.location);
        if (this.table == null) {
            this.table = this.tableDesc.toTable(this.context.hiveConf);
            if (ImportSemanticAnalyzer.isPartitioned(this.tableDesc)) {
                this.updateReplicationState(this.initialReplicationState());
                if (!this.forNewTable().hasReplicationState()) {
                    Task<?> replLogTask = ReplUtils.getTableReplLogTask(this.tableDesc, this.replLogger, this.context.hiveConf, this.metricCollector, new Path(this.context.dumpDirectory).getParent().toString());
                    this.tracker.addDependentTask(replLogTask);
                }
                return this.tracker;
            }
        } else if (this.table.isPartitioned()) {
            List<AlterTableAddPartitionDesc> partitionDescs = this.event.partitionDescriptions(this.tableDesc);
            if (!this.event.replicationSpec().isMetadataOnly() && !partitionDescs.isEmpty()) {
                this.updateReplicationState(this.initialReplicationState());
                if (!this.forExistingTable(this.lastReplicatedPartition).hasReplicationState()) {
                    Task<?> replLogTask = ReplUtils.getTableReplLogTask(this.tableDesc, this.replLogger, this.context.hiveConf, this.metricCollector, new Path(this.context.dumpDirectory).getParent().toString());
                    this.tracker.addDependentTask(replLogTask);
                }
                return this.tracker;
            }
        }
        return this.tracker;
    }

    private void updateReplicationState(ReplicationState replicationState) {
        if (!this.tracker.canAddMoreTasks()) {
            this.tracker.setReplicationState(replicationState);
        }
    }

    private ReplicationState initialReplicationState() throws SemanticException {
        return new ReplicationState(new ReplicationState.PartitionState(this.tableDesc.getTableName(), this.lastReplicatedPartition));
    }

    private boolean isMetaDataOp() {
        return HiveConf.getBoolVar((Configuration)this.context.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.REPL_DUMP_SKIP_IMMUTABLE_DATA_COPY) || HiveConf.getBoolVar((Configuration)this.context.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.REPL_DUMP_METADATA_ONLY);
    }

    private void addConsolidatedPartitionDesc(AlterTableAddPartitionDesc lastAlterTableAddPartitionDesc) throws Exception {
        int maxTasks = 0;
        maxTasks = this.isMetaDataOp() || TableType.EXTERNAL_TABLE.equals((Object)this.table.getTableType()) ? this.context.hiveConf.getIntVar(HiveConf.ConfVars.REPL_LOAD_PARTITIONS_BATCH_SIZE) : this.context.hiveConf.getIntVar(HiveConf.ConfVars.REPL_LOAD_PARTITIONS_WITH_DATA_COPY_BATCH_SIZE);
        int currentPartitionCount = 0;
        Iterator<AlterTableAddPartitionDesc> partitionIterator = this.event.partitionDescriptions(this.tableDesc).iterator();
        if (lastAlterTableAddPartitionDesc != null) {
            while (partitionIterator.hasNext()) {
                ++currentPartitionCount;
                AlterTableAddPartitionDesc addPartitionDesc = partitionIterator.next();
                if (!lastAlterTableAddPartitionDesc.getPartitions().get(0).getPartSpec().equals(addPartitionDesc.getPartitions().get(0).getPartSpec())) continue;
                break;
            }
        }
        List<AlterTableAddPartitionDesc> partitionDescs = this.event.partitionDescriptions(this.tableDesc);
        int totalPartitionCount = partitionDescs.size();
        while (currentPartitionCount < totalPartitionCount) {
            LinkedList<AlterTableAddPartitionDesc.PartitionDesc> partitions = new LinkedList<AlterTableAddPartitionDesc.PartitionDesc>();
            int pendingPartitionCount = totalPartitionCount - currentPartitionCount;
            int toPartitionCount = currentPartitionCount + Math.min(pendingPartitionCount, maxTasks);
            List<AlterTableAddPartitionDesc> partitionBatch = partitionDescs.subList(currentPartitionCount, toPartitionCount);
            for (AlterTableAddPartitionDesc addPartitionDesc : partitionBatch) {
                AlterTableAddPartitionDesc.PartitionDesc src = addPartitionDesc.getPartitions().get(0);
                Map<String, String> partParams = src.getPartParams();
                if (partParams == null) {
                    partParams = new HashMap<String, String>();
                }
                partParams.put("hive.repl.ckpt.key", this.context.dumpDirectory);
                Path replicaWarehousePartitionLocation = this.locationOnReplicaWarehouse(this.table, src);
                partitions.add(new AlterTableAddPartitionDesc.PartitionDesc(src.getPartSpec(), replicaWarehousePartitionLocation.toString(), partParams, src.getInputFormat(), src.getOutputFormat(), src.getNumBuckets(), src.getCols(), src.getSerializationLib(), src.getSerdeParams(), src.getBucketCols(), src.getSortCols(), src.getColStats(), src.getWriteId()));
            }
            AlterTableAddPartitionDesc consolidatedPartitionDesc = new AlterTableAddPartitionDesc(this.tableDesc.getDatabaseName(), this.tableDesc.getTableName(), true, partitions);
            this.addPartition(toPartitionCount < totalPartitionCount, consolidatedPartitionDesc);
            if (!this.tracker.canAddMoreTasks()) {
                return;
            }
            currentPartitionCount = toPartitionCount;
        }
    }

    private TaskTracker forNewTable() throws Exception {
        this.addConsolidatedPartitionDesc(null);
        return this.tracker;
    }

    private void addPartition(boolean hasMorePartitions, AlterTableAddPartitionDesc addPartitionDesc) throws Exception {
        boolean processingComplete = this.addTasksForPartition(this.table, addPartitionDesc, null);
        if (processingComplete && hasMorePartitions && !this.tracker.canAddMoreTasks()) {
            ReplicationState currentReplicationState = new ReplicationState(new ReplicationState.PartitionState(this.table.getTableName(), addPartitionDesc));
            this.updateReplicationState(currentReplicationState);
        }
    }

    private boolean addTasksForPartition(Table table, AlterTableAddPartitionDesc addPartitionDesc, AlterTableAddPartitionDesc.PartitionDesc lastPartSpec) throws MetaException, HiveException {
        Task<DDLWork> addPartTask = TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), addPartitionDesc, true, new Path(this.context.dumpDirectory).getParent().toString(), this.metricCollector), this.context.hiveConf);
        if (this.isMetaDataOp() || TableType.EXTERNAL_TABLE.equals((Object)table.getTableType())) {
            this.tracker.addTask(addPartTask);
            return true;
        }
        boolean lastProcessedStageFound = false;
        for (AlterTableAddPartitionDesc.PartitionDesc partSpec : addPartitionDesc.getPartitions()) {
            if (!this.tracker.canAddMoreTasks()) {
                ReplicationState currentReplicationState = new ReplicationState(new ReplicationState.PartitionState(table.getTableName(), addPartitionDesc, partSpec, ReplicationState.PartitionState.Stage.COPY));
                this.updateReplicationState(currentReplicationState);
                return false;
            }
            Path replicaWarehousePartitionLocation = this.locationOnReplicaWarehouse(table, partSpec);
            partSpec.setLocation(replicaWarehousePartitionLocation.toString());
            LOG.debug("adding dependent CopyWork for partition " + ImportSemanticAnalyzer.partSpecToString(partSpec.getPartSpec()) + " with source location: " + partSpec.getLocation());
            if (!lastProcessedStageFound && lastPartSpec != null && lastPartSpec.getLocation() != partSpec.getLocation()) continue;
            lastProcessedStageFound = true;
            boolean copyAtLoad = this.context.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_RUN_DATA_COPY_TASKS_ON_TARGET);
            Task<?> copyTask = ReplCopyTask.getLoadCopyTask(this.event.replicationSpec(), new Path(this.event.dataPath() + "/" + Warehouse.makePartPath(partSpec.getPartSpec())), replicaWarehousePartitionLocation, this.context.hiveConf, copyAtLoad, false, new Path(this.context.dumpDirectory).getParent().toString(), this.metricCollector);
            this.tracker.addTask(copyTask);
        }
        this.tracker.addDependentTask(addPartTask);
        return true;
    }

    private Path locationOnReplicaWarehouse(Table table, AlterTableAddPartitionDesc.PartitionDesc partSpec) throws MetaException, HiveException {
        String child = Warehouse.makePartPath(partSpec.getPartSpec());
        if (this.tableDesc.isExternal()) {
            String externalLocation = ReplExternalTables.externalTableLocation(this.context.hiveConf, partSpec.getLocation());
            return new Path(externalLocation);
        }
        if (this.tableDesc.getLocation() == null) {
            if (table.getDataLocation() == null) {
                Database parentDb = this.context.hiveDb.getDatabase(this.tableDesc.getDatabaseName());
                return new Path(this.context.warehouse.getDefaultTablePath(parentDb, this.tableDesc.getTableName(), this.tableDesc.isExternal()), child);
            }
            return new Path(table.getDataLocation().toString(), child);
        }
        return new Path(this.tableDesc.getLocation(), child);
    }

    private Task<?> dropPartitionTask(Table table, Map<String, String> partSpec) throws SemanticException {
        Task<DDLWork> dropPtnTask = null;
        Map<Integer, List<ExprNodeGenericFuncDesc>> partSpecsExpr = ReplUtils.genPartSpecs(table, Collections.singletonList(partSpec));
        if (partSpecsExpr.size() > 0) {
            AlterTableDropPartitionDesc dropPtnDesc = new AlterTableDropPartitionDesc(HiveTableName.of(table), partSpecsExpr, true, this.event.replicationSpec());
            dropPtnTask = TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), dropPtnDesc, true, new Path(this.context.dumpDirectory).getParent().toString(), this.metricCollector), this.context.hiveConf);
        }
        return dropPtnTask;
    }

    private TaskTracker forExistingTable(AlterTableAddPartitionDesc lastPartitionReplicated) throws Exception {
        boolean encounteredTheLastReplicatedPartition = lastPartitionReplicated == null;
        Map<String, String> lastReplicatedPartSpec = null;
        if (!encounteredTheLastReplicatedPartition) {
            lastReplicatedPartSpec = lastPartitionReplicated.getPartitions().get(0).getPartSpec();
            LOG.info("Start processing from partition info spec : {}", (Object)StringUtils.mapToString(lastReplicatedPartSpec));
        }
        Iterator<AlterTableAddPartitionDesc> partitionIterator = this.event.partitionDescriptions(this.tableDesc).iterator();
        while (!encounteredTheLastReplicatedPartition && partitionIterator.hasNext()) {
            AlterTableAddPartitionDesc addPartitionDesc = partitionIterator.next();
            Map<String, String> currentSpec = addPartitionDesc.getPartitions().get(0).getPartSpec();
            encounteredTheLastReplicatedPartition = lastReplicatedPartSpec.equals(currentSpec);
        }
        if (ReplicationState.PartitionState.Stage.COPY.equals((Object)this.lastReplicatedStage)) {
            this.addTasksForPartition(this.table, lastPartitionReplicated, this.lastReplicatedPartitionDesc);
        }
        boolean pendingPartitions = false;
        while (partitionIterator.hasNext() && this.tracker.canAddMoreTasks()) {
            pendingPartitions = true;
            AlterTableAddPartitionDesc addPartitionDesc = partitionIterator.next();
            AlterTableAddPartitionDesc.PartitionDesc src = addPartitionDesc.getPartitions().get(0);
            HashMap<String, String> partParams = new HashMap<String, String>();
            partParams.put("hive.repl.ckpt.key", this.context.dumpDirectory);
            Path replicaWarehousePartitionLocation = this.locationOnReplicaWarehouse(this.table, src);
            src.setLocation(replicaWarehousePartitionLocation.toString());
            src.addPartParams(partParams);
            Map<String, String> partSpec = src.getPartSpec();
            ReplUtils.ReplLoadOpType loadPtnType = this.getLoadPartitionType(partSpec);
            switch (loadPtnType) {
                case LOAD_NEW: {
                    break;
                }
                case LOAD_REPLACE: {
                    this.tracker.addDependentTask(this.dropPartitionTask(this.table, partSpec));
                    break;
                }
                case LOAD_SKIP: {
                    break;
                }
            }
        }
        if (pendingPartitions) {
            this.addConsolidatedPartitionDesc(lastPartitionReplicated);
        }
        return this.tracker;
    }

    private ReplUtils.ReplLoadOpType getLoadPartitionType(Map<String, String> partSpec) throws InvalidOperationException, HiveException {
        Partition ptn = this.context.hiveDb.getPartition(this.table, partSpec, false);
        if (ptn == null) {
            return ReplUtils.ReplLoadOpType.LOAD_NEW;
        }
        if (ReplUtils.replCkptStatus(this.tableContext.dbNameToLoadIn, ptn.getParameters(), this.context.dumpDirectory)) {
            return ReplUtils.ReplLoadOpType.LOAD_SKIP;
        }
        return ReplUtils.ReplLoadOpType.LOAD_REPLACE;
    }
}

