/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.load;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.database.alter.owner.AlterDatabaseSetOwnerDesc;
import org.apache.hadoop.hive.ql.ddl.database.alter.poperties.AlterDatabaseSetPropertiesDesc;
import org.apache.hadoop.hive.ql.ddl.database.create.CreateDatabaseDesc;
import org.apache.hadoop.hive.ql.ddl.privilege.PrincipalDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.DatabaseEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.util.Context;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.exec.repl.util.TaskTracker;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadDatabase {
    final Context context;
    final TaskTracker tracker;
    private final DatabaseEvent event;
    private final String dbNameToLoadIn;
    transient ReplicationMetricCollector metricCollector;
    protected static transient Logger LOG = LoggerFactory.getLogger(LoadDatabase.class);

    public LoadDatabase(Context context, DatabaseEvent event, String dbNameToLoadIn, TaskTracker loadTaskTracker) {
        this.context = context;
        this.event = event;
        this.dbNameToLoadIn = dbNameToLoadIn;
        this.tracker = new TaskTracker(loadTaskTracker);
    }

    public LoadDatabase(Context context, DatabaseEvent event, String dbNameToLoadIn, TaskTracker loadTaskTracker, ReplicationMetricCollector metricCollector) {
        this.context = context;
        this.event = event;
        this.dbNameToLoadIn = dbNameToLoadIn;
        this.tracker = new TaskTracker(loadTaskTracker);
        this.metricCollector = metricCollector;
    }

    public TaskTracker tasks() throws Exception {
        Database dbInMetadata = this.readDbMetadata();
        String dbName = dbInMetadata.getName();
        Task<?> dbRootTask = null;
        ReplUtils.ReplLoadOpType loadDbType = this.getLoadDbType(dbName);
        switch (loadDbType) {
            case LOAD_NEW: {
                dbRootTask = this.createDbTask(dbInMetadata);
                break;
            }
            case LOAD_REPLACE: {
                dbRootTask = this.alterDbTask(dbInMetadata);
                break;
            }
        }
        if (dbRootTask != null) {
            dbRootTask.addDependentTask(this.setOwnerInfoTask(dbInMetadata));
            this.tracker.addTask(dbRootTask);
        }
        return this.tracker;
    }

    Database readDbMetadata() throws SemanticException {
        return this.event.dbInMetadata(this.dbNameToLoadIn);
    }

    String getDbLocation(Database dbInMetadata) {
        if (this.context.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_RETAIN_CUSTOM_LOCATIONS_FOR_DB_ON_TARGET) && Boolean.parseBoolean((String)dbInMetadata.getParameters().get("hive.repl.is.custom.db.loc"))) {
            String locOnTarget = new Path(dbInMetadata.getLocationUri()).toUri().getPath().toString();
            LOG.info("Using the custom location {} on the target", (Object)locOnTarget);
            return locOnTarget;
        }
        return null;
    }

    String getDbManagedLocation(Database dbInMetadata) {
        if (this.context.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_RETAIN_CUSTOM_LOCATIONS_FOR_DB_ON_TARGET) && Boolean.parseBoolean((String)dbInMetadata.getParameters().get("hive.repl.is.custom.db.managedloc"))) {
            String locOnTarget = new Path(dbInMetadata.getManagedLocationUri()).toUri().getPath().toString();
            LOG.info("Using the custom managed location {} on the target", (Object)locOnTarget);
            return locOnTarget;
        }
        return null;
    }

    private ReplUtils.ReplLoadOpType getLoadDbType(String dbName) throws InvalidOperationException, HiveException {
        Database db = this.context.hiveDb.getDatabase(dbName);
        if (db == null) {
            return ReplUtils.ReplLoadOpType.LOAD_NEW;
        }
        if (this.isDbAlreadyBootstrapped(db)) {
            throw new InvalidOperationException("Bootstrap REPL LOAD is not allowed on Database: " + dbName + " as it was already done.");
        }
        if (ReplUtils.replCkptStatus(dbName, db.getParameters(), this.context.dumpDirectory)) {
            return ReplUtils.ReplLoadOpType.LOAD_SKIP;
        }
        if (this.isDbEmpty(dbName)) {
            return ReplUtils.ReplLoadOpType.LOAD_REPLACE;
        }
        throw new InvalidOperationException("Bootstrap REPL LOAD is not allowed on Database: " + dbName + " as it is not empty. One or more tables/functions exist.");
    }

    private boolean isDbAlreadyBootstrapped(Database db) {
        Map props = db.getParameters();
        return props != null && props.containsKey(ReplicationSpec.KEY.CURR_STATE_ID.toString()) && !((String)props.get(ReplicationSpec.KEY.CURR_STATE_ID.toString())).isEmpty();
    }

    private boolean isDbEmpty(String dbName) throws HiveException {
        List<String> allTables = this.context.hiveDb.getAllTables(dbName);
        List<String> allFunctions = this.context.hiveDb.getFunctions(dbName, "*");
        return allTables.isEmpty() && allFunctions.isEmpty();
    }

    private Task<?> createDbTask(Database dbObj) throws MetaException {
        CreateDatabaseDesc createDbDesc = new CreateDatabaseDesc(dbObj.getName(), dbObj.getDescription(), this.getDbLocation(dbObj), this.getDbManagedLocation(dbObj), false, LoadDatabase.updateDbProps(dbObj, this.context.dumpDirectory));
        DDLWork work = new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), createDbDesc, true, new Path(this.context.dumpDirectory).getParent().toString(), this.metricCollector);
        return TaskFactory.get(work, this.context.hiveConf);
    }

    private Task<?> alterDbTask(Database dbObj) {
        return LoadDatabase.alterDbTask(dbObj.getName(), LoadDatabase.updateDbProps(dbObj, this.context.dumpDirectory), this.context.hiveConf, this.context.dumpDirectory, this.metricCollector);
    }

    private Task<?> setOwnerInfoTask(Database dbObj) {
        AlterDatabaseSetOwnerDesc alterDbDesc = new AlterDatabaseSetOwnerDesc(dbObj.getName(), new PrincipalDesc(dbObj.getOwnerName(), dbObj.getOwnerType()), null);
        DDLWork work = new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), alterDbDesc, true, new Path(this.context.dumpDirectory).getParent().toString(), this.metricCollector);
        return TaskFactory.get(work, this.context.hiveConf);
    }

    private static Map<String, String> updateDbProps(Database dbObj, String dumpDirectory) {
        HashMap<String, String> parameters = new HashMap<String, String>(dbObj.getParameters());
        parameters.remove(ReplicationSpec.KEY.CURR_STATE_ID.toString());
        parameters.remove("hive.repl.is.custom.db.loc");
        parameters.remove("hive.repl.is.custom.db.managedloc");
        parameters.put("hive.repl.ckpt.key", dumpDirectory);
        parameters.put("hive.repl.first.inc.pending", "true");
        parameters.put("repl.target.for", "true");
        return parameters;
    }

    private static Task<?> alterDbTask(String dbName, Map<String, String> props, HiveConf hiveConf, String dumpDirectory, ReplicationMetricCollector metricCollector) {
        AlterDatabaseSetPropertiesDesc alterDbDesc = new AlterDatabaseSetPropertiesDesc(dbName, props, null);
        DDLWork work = new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), alterDbDesc, true, new Path(dumpDirectory).getParent().toString(), metricCollector);
        return TaskFactory.get(work, hiveConf);
    }

    public static class AlterDatabase
    extends LoadDatabase {
        public AlterDatabase(Context context, DatabaseEvent event, String dbNameToLoadIn, TaskTracker loadTaskTracker) {
            super(context, event, dbNameToLoadIn, loadTaskTracker);
        }

        public AlterDatabase(Context context, DatabaseEvent event, String dbNameToLoadIn, TaskTracker loadTaskTracker, ReplicationMetricCollector metricCollector) {
            super(context, event, dbNameToLoadIn, loadTaskTracker, metricCollector);
        }

        @Override
        public TaskTracker tasks() throws SemanticException {
            Database dbObj = this.readDbMetadata();
            this.tracker.addTask(LoadDatabase.alterDbTask(dbObj.getName(), dbObj.getParameters(), this.context.hiveConf, this.context.dumpDirectory, this.metricCollector));
            return this.tracker;
        }
    }
}

