/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import com.google.common.collect.Collections2;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.repl.ReplScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.database.alter.poperties.AlterDatabaseSetPropertiesDesc;
import org.apache.hadoop.hive.ql.ddl.view.create.CreateViewDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.AckWork;
import org.apache.hadoop.hive.ql.exec.repl.AtlasLoadWork;
import org.apache.hadoop.hive.ql.exec.repl.PreAckTask;
import org.apache.hadoop.hive.ql.exec.repl.RangerLoadWork;
import org.apache.hadoop.hive.ql.exec.repl.ReplAck;
import org.apache.hadoop.hive.ql.exec.repl.ReplLoadWork;
import org.apache.hadoop.hive.ql.exec.repl.ReplStateLogWork;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.BootstrapEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.ConstraintEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.DatabaseEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.FunctionEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.PartitionEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.BootstrapEventsIterator;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.ConstraintEventsIterator;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.filesystem.FSTableEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.LoadConstraint;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.LoadDatabase;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.LoadFunction;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.table.LoadPartitions;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.table.LoadTable;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.table.TableContext;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.util.Context;
import org.apache.hadoop.hive.ql.exec.repl.incremental.IncrementalLoadTasksBuilder;
import org.apache.hadoop.hive.ql.exec.repl.util.AddDependencyToLeaves;
import org.apache.hadoop.hive.ql.exec.repl.util.FileList;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.exec.repl.util.TaskTracker;
import org.apache.hadoop.hive.ql.exec.util.DAGTraversal;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.HiveTableName;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.load.MetaData;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.thrift.TException;

public class ReplLoadTask
extends Task<ReplLoadWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int ZERO_TASKS = 0;
    private final String STAGE_NAME = "REPL_LOAD";

    public String getName() {
        return ((ReplLoadWork)this.work).isIncrementalLoad() ? "REPL_INCREMENTAL_LOAD" : "REPL_BOOTSTRAP_LOAD";
    }

    @Override
    public StageType getType() {
        return ((ReplLoadWork)this.work).isIncrementalLoad() ? StageType.REPL_INCREMENTAL_LOAD : StageType.REPL_BOOTSTRAP_LOAD;
    }

    @Override
    public int execute() {
        try {
            SecurityUtils.reloginExpiringKeytabUser();
            Task<?> rootTask = ((ReplLoadWork)this.work).getRootTask();
            if (rootTask != null) {
                rootTask.setChildTasks(null);
            }
            ((ReplLoadWork)this.work).setRootTask(this);
            this.parentTasks = null;
            if (this.shouldLoadAtlasMetadata()) {
                this.addAtlasLoadTask();
            }
            if (this.shouldLoadAuthorizationMetadata()) {
                this.initiateAuthorizationLoadTask();
            }
            LOG.info("Data copy at load enabled : {}", (Object)this.conf.getBoolVar(HiveConf.ConfVars.REPL_RUN_DATA_COPY_TASKS_ON_TARGET));
            if (((ReplLoadWork)this.work).isIncrementalLoad()) {
                return this.executeIncrementalLoad();
            }
            return this.executeBootStrapLoad();
        }
        catch (RuntimeException e) {
            LOG.error("replication failed with run time exception", (Throwable)e);
            this.setException(e);
            try {
                ReplUtils.handleException(true, e, new Path(((ReplLoadWork)this.work).getDumpDirectory()).getParent().toString(), ((ReplLoadWork)this.work).getMetricCollector(), "REPL_LOAD", this.conf);
            }
            catch (Exception ex) {
                LOG.error("Failed to collect replication metrics: ", (Throwable)ex);
            }
            throw e;
        }
        catch (Exception e) {
            this.setException(e);
            int errorCode = ErrorMsg.getErrorMsg((String)e.getMessage()).getErrorCode();
            try {
                return ReplUtils.handleException(true, e, new Path(((ReplLoadWork)this.work).getDumpDirectory()).getParent().toString(), ((ReplLoadWork)this.work).getMetricCollector(), "REPL_LOAD", this.conf);
            }
            catch (Exception ex) {
                LOG.error("Failed to collect replication metrics: ", (Throwable)ex);
                return errorCode;
            }
        }
    }

    private boolean shouldLoadAuthorizationMetadata() {
        return this.conf.getBoolVar(HiveConf.ConfVars.REPL_INCLUDE_AUTHORIZATION_METADATA);
    }

    private void initiateAuthorizationLoadTask() throws SemanticException {
        Task<RangerLoadWork> rangerLoadTask;
        if ("ranger".equalsIgnoreCase(this.conf.getVar(HiveConf.ConfVars.REPL_AUTHORIZATION_PROVIDER_SERVICE))) {
            Path rangerLoadRoot = new Path(new Path(((ReplLoadWork)this.work).dumpDirectory).getParent(), "ranger");
            LOG.info("Adding Import Ranger Metadata Task from {} ", (Object)rangerLoadRoot);
            String targetDbName = StringUtils.isEmpty((CharSequence)((ReplLoadWork)this.work).dbNameToLoadIn) ? ((ReplLoadWork)this.work).getSourceDbName() : ((ReplLoadWork)this.work).dbNameToLoadIn;
            RangerLoadWork rangerLoadWork = new RangerLoadWork(rangerLoadRoot, ((ReplLoadWork)this.work).getSourceDbName(), targetDbName, ((ReplLoadWork)this.work).getMetricCollector());
            rangerLoadTask = TaskFactory.get(rangerLoadWork, this.conf);
            if (this.childTasks == null) {
                this.childTasks = new ArrayList();
            }
        } else {
            throw new SemanticException(ErrorMsg.REPL_INVALID_CONFIG_FOR_SERVICE.format(new String[]{"Authorizer " + this.conf.getVar(HiveConf.ConfVars.REPL_AUTHORIZATION_PROVIDER_SERVICE) + " not supported for replication ", "ranger"}));
        }
        this.childTasks.add(rangerLoadTask);
    }

    private void addAtlasLoadTask() throws HiveException {
        Path atlasDumpDir = new Path(new Path(((ReplLoadWork)this.work).dumpDirectory).getParent(), "atlas");
        LOG.info("Adding task to load Atlas metadata from {} ", (Object)atlasDumpDir);
        String targetDbName = StringUtils.isEmpty((CharSequence)((ReplLoadWork)this.work).dbNameToLoadIn) ? ((ReplLoadWork)this.work).getSourceDbName() : ((ReplLoadWork)this.work).dbNameToLoadIn;
        AtlasLoadWork atlasLoadWork = new AtlasLoadWork(((ReplLoadWork)this.work).getSourceDbName(), targetDbName, atlasDumpDir, ((ReplLoadWork)this.work).getMetricCollector());
        Task<AtlasLoadWork> atlasLoadTask = TaskFactory.get(atlasLoadWork, this.conf);
        if (this.childTasks == null) {
            this.childTasks = new ArrayList();
        }
        this.childTasks.add(atlasLoadTask);
    }

    private boolean shouldLoadAtlasMetadata() {
        return this.conf.getBoolVar(HiveConf.ConfVars.REPL_INCLUDE_ATLAS_METADATA);
    }

    private int executeBootStrapLoad() throws Exception {
        boolean addAnotherLoadTask;
        int maxTasks = this.conf.getIntVar(HiveConf.ConfVars.REPL_APPROX_MAX_LOAD_TASKS);
        Context loadContext = new Context(((ReplLoadWork)this.work).dumpDirectory, this.conf, this.getHive(), ((ReplLoadWork)this.work).sessionStateLineageState, this.context);
        TaskTracker loadTaskTracker = new TaskTracker(maxTasks);
        this.addLazyDataCopyTask(loadTaskTracker);
        BootstrapEventsIterator iterator = ((ReplLoadWork)this.work).bootstrapIterator();
        ConstraintEventsIterator constraintIterator = ((ReplLoadWork)this.work).constraintsIterator();
        TaskTracker dbTracker = new TaskTracker(0);
        TaskTracker tableTracker = new TaskTracker(0);
        Scope scope = new Scope();
        boolean loadingConstraint = false;
        if (!iterator.hasNext() && constraintIterator.hasNext()) {
            loadingConstraint = true;
        }
        boolean dbEventFound = false;
        while ((iterator.hasNext() || loadingConstraint && constraintIterator.hasNext()) && loadTaskTracker.canAddMoreTasks()) {
            BootstrapEvent next = !loadingConstraint ? iterator.next() : constraintIterator.next();
            switch (next.eventType()) {
                case Database: {
                    DatabaseEvent dbEvent = (DatabaseEvent)next;
                    dbTracker = new LoadDatabase(loadContext, dbEvent, ((ReplLoadWork)this.work).dbNameToLoadIn, loadTaskTracker, ((ReplLoadWork)this.work).getMetricCollector()).tasks();
                    loadTaskTracker.update(dbTracker);
                    if (((ReplLoadWork)this.work).hasDbState()) {
                        loadTaskTracker.update(this.updateDatabaseLastReplID(maxTasks, loadContext, scope));
                    } else {
                        scope.database = false;
                    }
                    ((ReplLoadWork)this.work).updateDbEventState(dbEvent.toState());
                    if (dbTracker.hasTasks()) {
                        scope.rootTasks.addAll(dbTracker.tasks());
                        scope.database = true;
                        dbEventFound = true;
                    }
                    dbTracker.debugLog("database");
                    break;
                }
                case Table: {
                    TableContext tableContext = new TableContext(dbTracker, ((ReplLoadWork)this.work).dbNameToLoadIn);
                    FSTableEvent tableEvent = (FSTableEvent)next;
                    if (TableType.VIRTUAL_VIEW.name().equals(tableEvent.getMetaData().getTable().getTableType())) {
                        tableTracker = new TaskTracker(1);
                        tableTracker.addTask(ReplLoadTask.createViewTask(tableEvent.getMetaData(), ((ReplLoadWork)this.work).dbNameToLoadIn, this.conf, new Path(((ReplLoadWork)this.work).dumpDirectory).getParent().toString(), ((ReplLoadWork)this.work).getMetricCollector()));
                    } else {
                        LoadTable loadTable = new LoadTable(tableEvent, loadContext, iterator.replLogger(), tableContext, loadTaskTracker, ((ReplLoadWork)this.work).getMetricCollector());
                        tableTracker = loadTable.tasks(((ReplLoadWork)this.work).isIncrementalLoad());
                    }
                    this.setUpDependencies(dbTracker, tableTracker);
                    if (!scope.database && tableTracker.hasTasks()) {
                        scope.rootTasks.addAll(tableTracker.tasks());
                        scope.table = true;
                    } else {
                        scope.table = false;
                    }
                    if (TableType.VIRTUAL_VIEW.name().equals(tableEvent.getMetaData().getTable().getTableType())) break;
                    LoadPartitions loadPartitions = new LoadPartitions(loadContext, iterator.replLogger(), loadTaskTracker, tableEvent, ((ReplLoadWork)this.work).dbNameToLoadIn, tableContext, ((ReplLoadWork)this.work).getMetricCollector());
                    TaskTracker partitionsTracker = loadPartitions.tasks();
                    this.partitionsPostProcessing(iterator, scope, loadTaskTracker, tableTracker, partitionsTracker);
                    tableTracker.debugLog("table");
                    partitionsTracker.debugLog("partitions for table");
                    break;
                }
                case Partition: {
                    this.addLoadPartitionTasks(loadContext, next, dbTracker, iterator, scope, loadTaskTracker, tableTracker);
                    break;
                }
                case Function: {
                    loadTaskTracker.update(this.addLoadFunctionTasks(loadContext, iterator, next, dbTracker, scope));
                    break;
                }
                case Constraint: {
                    loadTaskTracker.update(this.addLoadConstraintsTasks(loadContext, next, dbTracker, scope));
                    break;
                }
            }
            if (!loadingConstraint && !iterator.currentDbHasNext()) {
                this.createEndReplLogTask(loadContext, scope, iterator.replLogger());
            }
            if (!dbEventFound || !this.conf.getBoolVar(HiveConf.ConfVars.REPL_RETAIN_CUSTOM_LOCATIONS_FOR_DB_ON_TARGET)) continue;
            LOG.info("Database event found, will be processed exclusively");
            break;
        }
        boolean bl = addAnotherLoadTask = iterator.hasNext() || loadTaskTracker.hasReplicationState() || constraintIterator.hasNext();
        if (addAnotherLoadTask) {
            this.createBuilderTask(scope.rootTasks);
        }
        if (!(iterator.hasNext() || constraintIterator.hasNext() || ((ReplLoadWork)this.work).isIncrementalLoad())) {
            loadTaskTracker.update(this.updateDatabaseLastReplID(maxTasks, loadContext, scope));
            ((ReplLoadWork)this.work).updateDbEventState(null);
        }
        if (this.childTasks == null) {
            this.childTasks = new ArrayList();
        }
        this.childTasks.addAll(scope.rootTasks);
        LOG.info("Root Tasks / Total Tasks : {} / {} ", (Object)this.childTasks.size(), (Object)loadTaskTracker.numberOfTasks());
        this.context.getFsScratchDirs().putAll(loadContext.pathInfo.getFsScratchDirs());
        if (!HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.REPL_DUMP_SKIP_IMMUTABLE_DATA_COPY)) {
            this.createReplLoadCompleteAckTask();
        }
        LOG.info("completed load task run : {}", (Object)((ReplLoadWork)this.work).executedLoadTask());
        return 0;
    }

    private void addLazyDataCopyTask(TaskTracker loadTaskTracker) throws IOException {
        boolean dataCopyAtLoad = this.conf.getBoolVar(HiveConf.ConfVars.REPL_RUN_DATA_COPY_TASKS_ON_TARGET);
        if (dataCopyAtLoad) {
            if (((ReplLoadWork)this.work).getExternalTableDataCopyItr() == null) {
                Path extTableBackingFile = new Path(((ReplLoadWork)this.work).dumpDirectory, "_file_list_external");
                try (FileList fileList = new FileList(extTableBackingFile, 0, this.conf);){
                    ((ReplLoadWork)this.work).setExternalTableDataCopyItr(fileList);
                }
            }
            if (this.childTasks == null) {
                this.childTasks = new ArrayList();
            }
            this.childTasks.addAll(((ReplLoadWork)this.work).externalTableCopyTasks(loadTaskTracker, this.conf));
        }
    }

    private TaskTracker addLoadPartitionTasks(Context loadContext, BootstrapEvent next, TaskTracker dbTracker, BootstrapEventsIterator iterator, Scope scope, TaskTracker loadTaskTracker, TaskTracker tableTracker) throws Exception {
        PartitionEvent event = (PartitionEvent)next;
        TableContext tableContext = new TableContext(dbTracker, ((ReplLoadWork)this.work).dbNameToLoadIn);
        LoadPartitions loadPartitions = new LoadPartitions(loadContext, iterator.replLogger(), tableContext, loadTaskTracker, event.asTableEvent(), ((ReplLoadWork)this.work).dbNameToLoadIn, event.lastPartitionReplicated(), ((ReplLoadWork)this.work).getMetricCollector(), event.lastPartSpecReplicated(), event.lastStageReplicated());
        TaskTracker partitionsTracker = loadPartitions.tasks();
        this.partitionsPostProcessing(iterator, scope, loadTaskTracker, tableTracker, partitionsTracker);
        partitionsTracker.debugLog("partitions");
        return partitionsTracker;
    }

    private TaskTracker addLoadConstraintsTasks(Context loadContext, BootstrapEvent next, TaskTracker dbTracker, Scope scope) throws IOException, SemanticException {
        LoadConstraint loadConstraint = new LoadConstraint(loadContext, (ConstraintEvent)next, ((ReplLoadWork)this.work).dbNameToLoadIn, dbTracker, new Path(((ReplLoadWork)this.work).dumpDirectory).getParent().toString(), ((ReplLoadWork)this.work).getMetricCollector());
        TaskTracker constraintTracker = loadConstraint.tasks();
        scope.rootTasks.addAll(constraintTracker.tasks());
        constraintTracker.debugLog("constraints");
        return constraintTracker;
    }

    private TaskTracker addLoadFunctionTasks(Context loadContext, BootstrapEventsIterator iterator, BootstrapEvent next, TaskTracker dbTracker, Scope scope) throws IOException, SemanticException {
        LoadFunction loadFunction = new LoadFunction(loadContext, iterator.replLogger(), (FunctionEvent)next, ((ReplLoadWork)this.work).dbNameToLoadIn, dbTracker, new Path(((ReplLoadWork)this.work).dumpDirectory).getParent().toString(), ((ReplLoadWork)this.work).getMetricCollector());
        TaskTracker functionsTracker = loadFunction.tasks();
        if (!scope.database) {
            scope.rootTasks.addAll(functionsTracker.tasks());
        } else {
            this.setUpDependencies(dbTracker, functionsTracker);
        }
        functionsTracker.debugLog("functions");
        return functionsTracker;
    }

    public static Task<?> createViewTask(MetaData metaData, String dbNameToLoadIn, HiveConf conf) throws SemanticException {
        Table table = new Table(metaData.getTable());
        String dbName = dbNameToLoadIn == null ? table.getDbName() : dbNameToLoadIn;
        TableName tableName = HiveTableName.ofNullable(table.getTableName(), dbName);
        String dbDotView = tableName.getNotEmptyDbTable();
        String viewOriginalText = table.getViewOriginalText();
        String viewExpandedText = table.getViewExpandedText();
        if (!dbName.equals(table.getDbName())) {
            // empty if block
        }
        CreateViewDesc desc = new CreateViewDesc(dbDotView, table.getAllCols(), null, table.getParameters(), table.getPartColNames(), false, false, viewOriginalText, viewExpandedText, table.getPartCols());
        desc.setReplicationSpec(metaData.getReplicationSpec());
        desc.setOwnerName(table.getOwner());
        return TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), desc), conf);
    }

    public static Task<?> createViewTask(MetaData metaData, String dbNameToLoadIn, HiveConf conf, String dumpDirectory, ReplicationMetricCollector metricCollector) throws SemanticException {
        Table table = new Table(metaData.getTable());
        String dbName = dbNameToLoadIn == null ? table.getDbName() : dbNameToLoadIn;
        TableName tableName = HiveTableName.ofNullable(table.getTableName(), dbName);
        String dbDotView = tableName.getNotEmptyDbTable();
        String viewOriginalText = table.getViewOriginalText();
        String viewExpandedText = table.getViewExpandedText();
        if (!dbName.equals(table.getDbName())) {
            // empty if block
        }
        CreateViewDesc desc = new CreateViewDesc(dbDotView, table.getAllCols(), null, table.getParameters(), table.getPartColNames(), false, false, viewOriginalText, viewExpandedText, table.getPartCols());
        desc.setReplicationSpec(metaData.getReplicationSpec());
        desc.setOwnerName(table.getOwner());
        return TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), desc, true, dumpDirectory, metricCollector), conf);
    }

    private void dropTablesExcludedInReplScope(ReplScope replScope) throws HiveException {
        if (replScope == null || replScope.includeAllTables()) {
            return;
        }
        Hive db = this.getHive();
        String dbName = replScope.getDbName();
        Collection tableNames = Collections2.filter(db.getAllTables(dbName), tableName -> {
            assert (tableName != null);
            return !tableName.toLowerCase().startsWith("Values__Tmp__Table__".toLowerCase()) && !replScope.tableIncludedInReplScope(tableName);
        });
        for (String table : tableNames) {
            db.dropTable(dbName + "." + table, true);
        }
        LOG.info("Tables in the Database: {} that are excluded in the replication scope are dropped.", (Object)dbName);
    }

    private void createReplLoadCompleteAckTask() {
        if (!(((ReplLoadWork)this.work).hasBootstrapLoadTasks() || ((ReplLoadWork)this.work).isIncrementalLoad() && ((ReplLoadWork)this.work).incrementalLoadTasksBuilder().hasMoreWork())) {
            LinkedList<PreAckTask> listOfPreAckTasks = new LinkedList<PreAckTask>();
            listOfPreAckTasks.add(new PreAckTask(){

                @Override
                public void run() throws SemanticException {
                    try {
                        HiveMetaStoreClient metaStoreClient = new HiveMetaStoreClient((Configuration)ReplLoadTask.this.conf);
                        long currentNotificationID = metaStoreClient.getCurrentNotificationEventId().getEventId();
                        Path loadMetadataFilePath = new Path(((ReplLoadWork)((ReplLoadTask)ReplLoadTask.this).work).dumpDirectory, ReplAck.LOAD_METADATA.toString());
                        Utils.writeOutput(String.valueOf(currentNotificationID), loadMetadataFilePath, ReplLoadTask.this.conf);
                        LOG.info("Created LOAD Metadata file : {} with NotificationID : {}", (Object)loadMetadataFilePath, (Object)currentNotificationID);
                    }
                    catch (TException ex) {
                        throw new SemanticException((Throwable)ex);
                    }
                }
            });
            AckWork replLoadAckWork = new AckWork(new Path(((ReplLoadWork)this.work).dumpDirectory, ReplAck.LOAD_ACKNOWLEDGEMENT.toString()), ((ReplLoadWork)this.work).getMetricCollector(), listOfPreAckTasks);
            Task<AckWork> loadAckWorkTask = TaskFactory.get(replLoadAckWork, this.conf);
            if (this.childTasks.isEmpty()) {
                this.childTasks.add(loadAckWorkTask);
            } else {
                DAGTraversal.traverse(this.childTasks, new AddDependencyToLeaves(Collections.singletonList(loadAckWorkTask)));
            }
        }
    }

    private void createEndReplLogTask(Context context, Scope scope, ReplLogger replLogger) throws SemanticException {
        HashMap<String, String> dbProps;
        if (((ReplLoadWork)this.work).isIncrementalLoad()) {
            dbProps = new HashMap<String, String>();
            dbProps.put(ReplicationSpec.KEY.CURR_STATE_ID.toString(), ((ReplLoadWork)this.work).incrementalLoadTasksBuilder().eventTo().toString());
        } else {
            Database dbInMetadata = ((ReplLoadWork)this.work).databaseEvent(context.hiveConf).dbInMetadata(((ReplLoadWork)this.work).dbNameToLoadIn);
            dbProps = dbInMetadata.getParameters();
        }
        ReplStateLogWork replLogWork = new ReplStateLogWork(replLogger, dbProps, new Path(((ReplLoadWork)this.work).dumpDirectory).getParent().toString(), ((ReplLoadWork)this.work).getMetricCollector());
        Task<ReplStateLogWork> replLogTask = TaskFactory.get(replLogWork, this.conf);
        if (scope.rootTasks.isEmpty()) {
            scope.rootTasks.add(replLogTask);
        } else {
            DAGTraversal.traverse(scope.rootTasks, new AddDependencyToLeaves(Collections.singletonList(replLogTask)));
        }
    }

    private TaskTracker updateDatabaseLastReplID(int maxTasks, Context context, Scope scope) throws SemanticException {
        TaskTracker taskTracker = new LoadDatabase.AlterDatabase(context, ((ReplLoadWork)this.work).databaseEvent(context.hiveConf), ((ReplLoadWork)this.work).dbNameToLoadIn, new TaskTracker(maxTasks), ((ReplLoadWork)this.work).getMetricCollector()).tasks();
        AddDependencyToLeaves function = new AddDependencyToLeaves(taskTracker.tasks());
        DAGTraversal.traverse(scope.rootTasks, function);
        return taskTracker;
    }

    private void partitionsPostProcessing(BootstrapEventsIterator iterator, Scope scope, TaskTracker loadTaskTracker, TaskTracker tableTracker, TaskTracker partitionsTracker) {
        this.setUpDependencies(tableTracker, partitionsTracker);
        if (!scope.database && !scope.table) {
            scope.rootTasks.addAll(partitionsTracker.tasks());
        }
        loadTaskTracker.update(tableTracker);
        loadTaskTracker.update(partitionsTracker);
        if (partitionsTracker.hasReplicationState()) {
            iterator.setReplicationState(partitionsTracker.replicationState());
        }
    }

    private void setUpDependencies(TaskTracker parentTasks, TaskTracker childTasks) {
        if (parentTasks.hasTasks()) {
            for (Task<?> parentTask : parentTasks.tasks()) {
                for (Task<?> childTask : childTasks.tasks()) {
                    parentTask.addDependentTask(childTask);
                }
            }
        } else {
            for (Task<?> childTask : childTasks.tasks()) {
                parentTasks.addTask(childTask);
            }
        }
    }

    private void createBuilderTask(List<Task<?>> rootTasks) {
        Task<Serializable> loadTask = TaskFactory.get(this.work, this.conf);
        DAGTraversal.traverse(rootTasks, new AddDependencyToLeaves(loadTask));
    }

    private int executeIncrementalLoad() throws Exception {
        IncrementalLoadTasksBuilder builder;
        if (((ReplLoadWork)this.work).replScopeModified) {
            this.dropTablesExcludedInReplScope(((ReplLoadWork)this.work).currentReplScope);
        }
        if (!(builder = ((ReplLoadWork)this.work).incrementalLoadTasksBuilder()).hasMoreWork() && ((ReplLoadWork)this.work).isLastReplIDUpdated() && ((ReplLoadWork)this.work).hasBootstrapLoadTasks()) {
            LOG.debug("Current incremental dump have tables to be bootstrapped. Switching to bootstrap mode after applying all events.");
            return this.executeBootStrapLoad();
        }
        ArrayList childTasks = new ArrayList();
        int maxTasks = this.conf.getIntVar(HiveConf.ConfVars.REPL_APPROX_MAX_LOAD_TASKS);
        TaskTracker tracker = new TaskTracker(maxTasks);
        this.addLazyDataCopyTask(tracker);
        childTasks.add(builder.build(this.context, this.getHive(), LOG, tracker));
        if (!builder.hasMoreWork()) {
            String replScopeDbName;
            String dbName = ((ReplLoadWork)this.work).dbNameToLoadIn;
            if ((dbName == null || StringUtils.isBlank((CharSequence)dbName)) && ((ReplLoadWork)this.work).currentReplScope != null && (replScopeDbName = ((ReplLoadWork)this.work).currentReplScope.getDbName()) != null && !"*".equals(replScopeDbName)) {
                dbName = replScopeDbName;
            }
            if (StringUtils.isNotBlank((CharSequence)dbName)) {
                String lastEventid = builder.eventTo().toString();
                HashMap<String, String> mapProp = new HashMap<String, String>();
                mapProp.put(ReplicationSpec.KEY.CURR_STATE_ID.toString(), lastEventid);
                AlterDatabaseSetPropertiesDesc alterDbDesc = new AlterDatabaseSetPropertiesDesc(dbName, mapProp, new ReplicationSpec(lastEventid, lastEventid));
                Task<DDLWork> updateReplIdTask = TaskFactory.get(new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), alterDbDesc, true, new Path(((ReplLoadWork)this.work).dumpDirectory).getParent().toString(), ((ReplLoadWork)this.work).getMetricCollector()), this.conf);
                DAGTraversal.traverse(childTasks, new AddDependencyToLeaves(updateReplIdTask));
                ((ReplLoadWork)this.work).setLastReplIDUpdated(true);
                LOG.debug("Added task to set last repl id of db " + dbName + " to " + lastEventid);
            }
        }
        if (builder.hasMoreWork() || ((ReplLoadWork)this.work).hasBootstrapLoadTasks()) {
            DAGTraversal.traverse(childTasks, new AddDependencyToLeaves(TaskFactory.get(this.work, this.conf)));
        }
        if (this.childTasks == null) {
            this.childTasks = new ArrayList();
        }
        this.childTasks.addAll(childTasks);
        this.createReplLoadCompleteAckTask();
        return 0;
    }

    private static class Scope {
        boolean database = false;
        boolean table = false;
        List<Task<?>> rootTasks = new ArrayList();

        private Scope() {
        }
    }
}

