/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.repl.ReplScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ReplCopyTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.DirCopyWork;
import org.apache.hadoop.hive.ql.exec.repl.util.TaskTracker;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Explain(displayName="Replication Dump Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ReplDumpWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ReplDumpWork.class);
    final ReplScope replScope;
    ReplScope oldReplScope;
    final String dbNameOrPattern;
    final String astRepresentationForErrorMsg;
    final String resultTempPath;
    Long eventTo;
    Long eventFrom;
    private boolean isBootstrap;
    private static String testInjectDumpDir = null;
    private static boolean testInjectDumpDirAutoIncrement = false;
    static boolean testDeletePreviousDumpMetaPath = false;
    private Integer maxEventLimit;
    private transient Iterator<String> externalTblCopyPathIterator;
    private transient Iterator<String> managedTblCopyPathIterator;
    private transient Iterator<EximUtil.DataCopyPath> functionCopyPathIterator;
    private Path currentDumpPath;
    private List<String> resultValues;
    private boolean shouldOverwrite;
    private transient ReplicationMetricCollector metricCollector;
    private ReplicationSpec replicationSpec;

    public static void injectNextDumpDirForTest(String dumpDir) {
        ReplDumpWork.injectNextDumpDirForTest(dumpDir, false);
    }

    public static void injectNextDumpDirForTest(String dumpDir, boolean autoIncr) {
        testInjectDumpDir = dumpDir;
        testInjectDumpDirAutoIncrement = autoIncr;
    }

    public static synchronized String getTestInjectDumpDir() {
        return testInjectDumpDir;
    }

    public static synchronized String getInjectNextDumpDirForTest() {
        if (testInjectDumpDirAutoIncrement) {
            testInjectDumpDir = String.valueOf(Integer.parseInt(testInjectDumpDir) + 1);
        }
        return testInjectDumpDir;
    }

    public static void testDeletePreviousDumpMetaPath(boolean failDeleteDumpMeta) {
        testDeletePreviousDumpMetaPath = failDeleteDumpMeta;
    }

    public ReplDumpWork(ReplScope replScope, String astRepresentationForErrorMsg, String resultTempPath) {
        this.replScope = replScope;
        this.dbNameOrPattern = replScope.getDbName();
        this.astRepresentationForErrorMsg = astRepresentationForErrorMsg;
        this.resultTempPath = resultTempPath;
    }

    void setOldReplScope(ReplScope replScope) {
        this.oldReplScope = replScope;
    }

    int maxEventLimit() throws Exception {
        if (this.eventTo < this.eventFrom) {
            throw new Exception("Invalid event ID input received in TO clause");
        }
        Integer maxRange = Ints.checkedCast((long)(this.eventTo - this.eventFrom + 1L));
        if (this.maxEventLimit == null || this.maxEventLimit > maxRange) {
            this.maxEventLimit = maxRange;
        }
        return this.maxEventLimit;
    }

    void setEventFrom(long eventId) {
        this.eventFrom = eventId;
    }

    void overrideLastEventToDump(Hive fromDb, long bootstrapLastId) throws Exception {
        if (bootstrapLastId > 0L) {
            this.eventTo = bootstrapLastId;
            LoggerFactory.getLogger(this.getClass()).debug("eventTo restricted to event id : {} because of bootstrap of ACID tables", (Object)this.eventTo);
            return;
        }
        if (this.eventTo == null) {
            this.eventTo = fromDb.getMSC().getCurrentNotificationEventId().getEventId();
            LoggerFactory.getLogger(this.getClass()).debug("eventTo not specified, using current event id : {}", (Object)this.eventTo);
        }
    }

    void setBootstrap(boolean bootstrap) {
        this.isBootstrap = bootstrap;
    }

    public void setExternalTblCopyPathIterator(Iterator<String> externalTblCopyPathIterator) {
        if (this.externalTblCopyPathIterator != null) {
            throw new IllegalStateException("External table copy path iterator has already been initialized");
        }
        this.externalTblCopyPathIterator = externalTblCopyPathIterator;
    }

    public void setManagedTableCopyPathIterator(Iterator<String> managedTblCopyPathIterator) {
        if (this.managedTblCopyPathIterator != null) {
            throw new IllegalStateException("Managed table copy path iterator has already been initialized");
        }
        this.managedTblCopyPathIterator = managedTblCopyPathIterator;
    }

    public void setFunctionCopyPathIterator(Iterator<EximUtil.DataCopyPath> functionCopyPathIterator) {
        if (this.functionCopyPathIterator != null) {
            throw new IllegalStateException("Function copy path iterator has already been initialized");
        }
        this.functionCopyPathIterator = functionCopyPathIterator;
    }

    public boolean dataCopyIteratorsInitialized() {
        return this.externalTblCopyPathIterator != null || this.managedTblCopyPathIterator != null || this.functionCopyPathIterator != null;
    }

    public Path getCurrentDumpPath() {
        return this.currentDumpPath;
    }

    public void setCurrentDumpPath(Path currentDumpPath) {
        this.currentDumpPath = currentDumpPath;
    }

    public List<String> getResultValues() {
        return this.resultValues;
    }

    public void setResultValues(List<String> resultValues) {
        this.resultValues = resultValues;
    }

    public List<Task<?>> externalTableCopyTasks(TaskTracker tracker, HiveConf conf) {
        if (conf.getBoolVar(HiveConf.ConfVars.REPL_DUMP_SKIP_IMMUTABLE_DATA_COPY)) {
            return Collections.emptyList();
        }
        ArrayList tasks = new ArrayList();
        while (this.externalTblCopyPathIterator.hasNext() && tracker.canAddMoreTasks()) {
            DirCopyWork dirCopyWork = new DirCopyWork(this.metricCollector, this.currentDumpPath.toString());
            dirCopyWork.loadFromString(this.externalTblCopyPathIterator.next());
            Task<DirCopyWork> task = TaskFactory.get(dirCopyWork, conf);
            tasks.add(task);
            tracker.addTask(task);
            LOG.debug("added task for {}", (Object)dirCopyWork);
        }
        return tasks;
    }

    public List<Task<?>> managedTableCopyTasks(TaskTracker tracker, HiveConf conf) {
        if (conf.getBoolVar(HiveConf.ConfVars.REPL_DUMP_SKIP_IMMUTABLE_DATA_COPY)) {
            return Collections.emptyList();
        }
        ArrayList tasks = new ArrayList();
        while (this.managedTblCopyPathIterator.hasNext() && tracker.canAddMoreTasks()) {
            ReplicationSpec replSpec = new ReplicationSpec();
            replSpec.setIsReplace(true);
            replSpec.setInReplicationScope(true);
            EximUtil.DataCopyPath managedTableCopyPath = new EximUtil.DataCopyPath(replSpec);
            managedTableCopyPath.loadFromString(this.managedTblCopyPathIterator.next());
            Task<?> copyTask = ReplCopyTask.getDumpCopyTask(managedTableCopyPath.getReplicationSpec(), managedTableCopyPath.getSrcPath(), managedTableCopyPath.getTargetPath(), conf, false, this.shouldOverwrite, !this.isBootstrap, this.getCurrentDumpPath().toString(), this.getMetricCollector());
            tasks.add(copyTask);
            tracker.addTask(copyTask);
            LOG.debug("added task for {}", (Object)managedTableCopyPath);
        }
        return tasks;
    }

    public List<Task<?>> functionsBinariesCopyTasks(TaskTracker tracker, HiveConf conf) {
        ArrayList tasks = new ArrayList();
        if (this.functionCopyPathIterator != null) {
            while (this.functionCopyPathIterator.hasNext() && tracker.canAddMoreTasks()) {
                EximUtil.DataCopyPath binaryCopyPath = this.functionCopyPathIterator.next();
                Task<?> copyTask = ReplCopyTask.getDumpCopyTask(binaryCopyPath.getReplicationSpec(), binaryCopyPath.getSrcPath(), binaryCopyPath.getTargetPath(), conf, this.getCurrentDumpPath().toString(), this.getMetricCollector());
                tasks.add(copyTask);
                tracker.addTask(copyTask);
                LOG.debug("added task for {}", (Object)binaryCopyPath);
            }
        }
        return tasks;
    }

    public void setShouldOverwrite(boolean shouldOverwrite) {
        this.shouldOverwrite = shouldOverwrite;
    }

    public ReplicationMetricCollector getMetricCollector() {
        return this.metricCollector;
    }

    public void setMetricCollector(ReplicationMetricCollector metricCollector) {
        this.metricCollector = metricCollector;
    }

    public ReplicationSpec getReplicationSpec() {
        return this.replicationSpec;
    }

    public void setReplicationSpec(ReplicationSpec replicationSpec) {
        this.replicationSpec = replicationSpec;
    }
}

