/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.repl.RangerLoadWork;
import org.apache.hadoop.hive.ql.exec.repl.ranger.NoOpRangerRestClient;
import org.apache.hadoop.hive.ql.exec.repl.ranger.RangerExportPolicyList;
import org.apache.hadoop.hive.ql.exec.repl.ranger.RangerPolicy;
import org.apache.hadoop.hive.ql.exec.repl.ranger.RangerRestClient;
import org.apache.hadoop.hive.ql.exec.repl.ranger.RangerRestClientImpl;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.parse.repl.load.log.RangerLoadLogger;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Status;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerLoadTask
extends Task<RangerLoadWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RangerLoadTask.class);
    private transient RangerRestClient rangerRestClient;
    private transient ReplLogger replLogger;

    public RangerLoadTask() {
    }

    @VisibleForTesting
    RangerLoadTask(RangerRestClient rangerRestClient, HiveConf conf, RangerLoadWork work) {
        this.conf = conf;
        this.work = work;
        this.rangerRestClient = rangerRestClient;
    }

    public String getName() {
        return "RANGER_LOAD";
    }

    @Override
    public int execute() {
        try {
            URL url;
            LOG.info("Importing Ranger Metadata");
            RangerExportPolicyList rangerExportPolicyList = null;
            List<RangerPolicy> rangerPolicies = null;
            SecurityUtils.reloginExpiringKeytabUser();
            if (this.rangerRestClient == null) {
                this.rangerRestClient = this.getRangerRestClient();
            }
            if ((url = ((RangerLoadWork)this.work).getRangerConfigResource()) == null) {
                throw new SemanticException(ErrorMsg.REPL_INVALID_CONFIG_FOR_SERVICE.format(new String[]{"Ranger configuration is not valid ranger-hive-security.xml", "ranger"}));
            }
            this.conf.addResource(url);
            String rangerHiveServiceName = this.conf.get("ranger.plugin.hive.service.name");
            String rangerEndpoint = this.conf.get("ranger.plugin.hive.policy.rest.url");
            if (StringUtils.isEmpty((CharSequence)rangerEndpoint)) {
                throw new SemanticException(ErrorMsg.REPL_INVALID_CONFIG_FOR_SERVICE.format(new String[]{"Ranger endpoint is not valid " + rangerEndpoint, "ranger"}));
            }
            if (!this.rangerRestClient.checkConnection(rangerEndpoint, this.conf)) {
                throw new SemanticException(ErrorMsg.REPL_EXTERNAL_SERVICE_CONNECTION_ERROR.format(new String[]{"ranger", "Ranger endpoint is not valid " + rangerEndpoint}));
            }
            if (((RangerLoadWork)this.work).getCurrentDumpPath() != null) {
                LOG.info("Importing Ranger Metadata from {} ", (Object)((RangerLoadWork)this.work).getCurrentDumpPath());
                rangerExportPolicyList = this.rangerRestClient.readRangerPoliciesFromJsonFile(new Path(((RangerLoadWork)this.work).getCurrentDumpPath(), "ranger_policies.json"), this.conf);
                int expectedPolicyCount = rangerExportPolicyList == null ? 0 : rangerExportPolicyList.getListSize();
                this.replLogger = new RangerLoadLogger(((RangerLoadWork)this.work).getSourceDbName(), ((RangerLoadWork)this.work).getTargetDbName(), ((RangerLoadWork)this.work).getCurrentDumpPath().toString(), expectedPolicyCount);
                this.replLogger.startLog();
                HashMap<String, Long> metricMap = new HashMap<String, Long>();
                metricMap.put(ReplUtils.MetricName.POLICIES.name(), Long.valueOf(expectedPolicyCount));
                ((RangerLoadWork)this.work).getMetricCollector().reportStageStart(this.getName(), metricMap);
                if (rangerExportPolicyList != null && !CollectionUtils.isEmpty(rangerExportPolicyList.getPolicies())) {
                    rangerPolicies = rangerExportPolicyList.getPolicies();
                }
            }
            if (CollectionUtils.isEmpty(rangerPolicies)) {
                LOG.info("There are no ranger policies to import");
                rangerPolicies = new ArrayList<RangerPolicy>();
            }
            List<RangerPolicy> rangerPoliciesWithDenyPolicy = rangerPolicies;
            if (this.conf.getBoolVar(HiveConf.ConfVars.REPL_RANGER_ADD_DENY_POLICY_TARGET)) {
                rangerPoliciesWithDenyPolicy = this.rangerRestClient.addDenyPolicies(rangerPolicies, rangerHiveServiceName, ((RangerLoadWork)this.work).getSourceDbName(), ((RangerLoadWork)this.work).getTargetDbName());
            }
            List<RangerPolicy> updatedRangerPolicies = this.rangerRestClient.changeDataSet(rangerPoliciesWithDenyPolicy, ((RangerLoadWork)this.work).getSourceDbName(), ((RangerLoadWork)this.work).getTargetDbName());
            long importCount = 0L;
            if (!CollectionUtils.isEmpty(updatedRangerPolicies)) {
                if (rangerExportPolicyList == null) {
                    rangerExportPolicyList = new RangerExportPolicyList();
                }
                rangerExportPolicyList.setPolicies(updatedRangerPolicies);
                this.rangerRestClient.importRangerPolicies(rangerExportPolicyList, ((RangerLoadWork)this.work).getTargetDbName(), rangerEndpoint, rangerHiveServiceName, this.conf);
                LOG.info("Number of ranger policies imported {}", (Object)rangerExportPolicyList.getListSize());
                importCount = rangerExportPolicyList.getListSize();
                ((RangerLoadWork)this.work).getMetricCollector().reportStageProgress(this.getName(), ReplUtils.MetricName.POLICIES.name(), importCount);
                this.replLogger.endLog(importCount);
                LOG.info("Ranger policy import finished {} ", (Object)importCount);
            }
            ((RangerLoadWork)this.work).getMetricCollector().reportStageEnd(this.getName(), Status.SUCCESS);
            return 0;
        }
        catch (RuntimeException e) {
            LOG.error("Runtime Excepton during RangerLoad", (Throwable)e);
            this.setException(e);
            try {
                ReplUtils.handleException(true, e, ((RangerLoadWork)this.work).getCurrentDumpPath().getParent().toString(), ((RangerLoadWork)this.work).getMetricCollector(), this.getName(), this.conf);
            }
            catch (Exception ex) {
                LOG.error("Failed to collect replication metrics: ", (Throwable)ex);
            }
            throw e;
        }
        catch (Exception e) {
            LOG.error("RangerLoad Failed", (Throwable)e);
            int errorCode = ErrorMsg.getErrorMsg((String)e.getMessage()).getErrorCode();
            this.setException(e);
            try {
                return ReplUtils.handleException(true, e, ((RangerLoadWork)this.work).getCurrentDumpPath().getParent().toString(), ((RangerLoadWork)this.work).getMetricCollector(), this.getName(), this.conf);
            }
            catch (Exception ex) {
                LOG.error("Failed to collect replication metrics: ", (Throwable)ex);
                return errorCode;
            }
        }
    }

    private RangerRestClient getRangerRestClient() {
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST_REPL) || this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST)) {
            return new NoOpRangerRestClient();
        }
        return new RangerRestClientImpl();
    }

    @Override
    public StageType getType() {
        return StageType.RANGER_LOAD;
    }

    @Override
    public boolean canExecuteInParallel() {
        return false;
    }
}

