/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.GcTimeMonitor;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.MemoryExhaustionChecker;
import org.apache.hadoop.hive.ql.exec.mapjoin.MapJoinMemoryExhaustionError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SparkMemoryExhaustionChecker
implements MemoryExhaustionChecker {
    private static final Logger LOG = LoggerFactory.getLogger(SparkMemoryExhaustionChecker.class);
    private static SparkMemoryExhaustionChecker INSTANCE;
    private volatile int lastAlertGcTimePercentage;
    private final int criticalGcTimePercentage;

    private SparkMemoryExhaustionChecker(Configuration conf) {
        this.criticalGcTimePercentage = (int)(HiveConf.getFloatVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEHASHTABLEMAXGCTIMEPERCENTAGE) * 100.0f);
        HiveGcTimeMonitor hiveGcTimeMonitor = new HiveGcTimeMonitor(this.criticalGcTimePercentage);
        hiveGcTimeMonitor.start();
    }

    static synchronized SparkMemoryExhaustionChecker get(Configuration conf) {
        if (INSTANCE == null) {
            INSTANCE = new SparkMemoryExhaustionChecker(conf);
        }
        return INSTANCE;
    }

    @Override
    public void checkMemoryOverhead(long rowNumber, long hashTableScale, int tableContainerSize) {
        if (this.lastAlertGcTimePercentage >= this.criticalGcTimePercentage) {
            String msg = "GC time percentage = " + this.lastAlertGcTimePercentage + "% exceeded threshold " + this.criticalGcTimePercentage + "%";
            throw new MapJoinMemoryExhaustionError(msg);
        }
    }

    private class HiveGcTimeAlertHandler
    implements GcTimeMonitor.GcTimeAlertHandler {
        private HiveGcTimeAlertHandler() {
        }

        public void alert(GcTimeMonitor.GcData gcData) {
            SparkMemoryExhaustionChecker.this.lastAlertGcTimePercentage = gcData.getGcTimePercentage();
            LOG.warn("GcTimeMonitor alert called. Current GC time = " + SparkMemoryExhaustionChecker.this.lastAlertGcTimePercentage + "%");
        }
    }

    private class HiveGcTimeMonitor
    extends GcTimeMonitor {
        HiveGcTimeMonitor(int criticalGcTimePercentage) {
            super(45000L, 200L, criticalGcTimePercentage, (GcTimeMonitor.GcTimeAlertHandler)new HiveGcTimeAlertHandler());
        }
    }
}

