/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.serializers.MapSerializer;
import com.esotericsoftware.kryo.util.DefaultInstantiatorStrategy;
import com.esotericsoftware.kryo.util.Pool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.CopyOnFirstWriteProperties;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationUtilities {
    private static final String CLASS_NAME = SerializationUtilities.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    private static final Map<Class<?>, Hook> kryoTypeHooks = new HashMap();
    private static Hook globalHook = null;
    private static final Object FAKE_REFERENCE = new Object();
    private static Pool<Kryo> kryoPool = new Pool<Kryo>(true, true, 32){

        protected Kryo create() {
            return SerializationUtilities.createNewKryo();
        }
    };

    public static void addKryoTypeHook(Class<?> clazz, Hook hook) {
        kryoTypeHooks.put(clazz, hook);
    }

    public static void setGlobalHook(Hook hook) {
        globalHook = hook;
    }

    public static Kryo createNewKryo() {
        KryoWithHooks kryo = new KryoWithHooks();
        kryo.setReferences(true);
        kryo.setRegistrationRequired(false);
        kryo.register(Date.class, new SqlDateSerializer());
        kryo.register(Timestamp.class, new TimestampSerializer());
        kryo.register(TimestampTZ.class, new TimestampTZSerializer());
        kryo.register(Path.class, new PathSerializer());
        kryo.register(Arrays.asList("").getClass(), new ArraysAsListSerializer());
        kryo.register(new ArrayList().subList(0, 0).getClass(), new ArrayListSubListSerializer());
        kryo.register(CopyOnFirstWriteProperties.class, (Serializer)new CopyOnFirstWritePropertiesSerializer());
        kryo.register(PartitionDesc.class, (Serializer)new PartitionDescSerializer(kryo, PartitionDesc.class));
        ((DefaultInstantiatorStrategy)kryo.getInstantiatorStrategy()).setFallbackInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
        SerializationUtilities.removeField(kryo, AbstractOperatorDesc.class, "colExprMap");
        SerializationUtilities.removeField(kryo, AbstractOperatorDesc.class, "statistics");
        return kryo.processHooks(kryoTypeHooks, globalHook);
    }

    public static Kryo borrowKryo() {
        Kryo kryo = (Kryo)kryoPool.obtain();
        kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
        return kryo;
    }

    public static void releaseKryo(Kryo kryo) {
        kryoPool.free((Object)kryo);
    }

    private static void removeField(Kryo kryo, Class type, String fieldName) {
        FieldSerializer fld = new FieldSerializer(kryo, type);
        fld.removeField(fieldName);
        kryo.register(type, (Serializer)fld);
    }

    public static void serializePlan(Object plan, OutputStream out) {
        SerializationUtilities.serializePlan(plan, out, false);
    }

    public static void serializePlan(Kryo kryo, Object plan, OutputStream out) {
        SerializationUtilities.serializePlan(kryo, plan, out, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void serializePlan(Object plan, OutputStream out, boolean cloningPlan) {
        Kryo kryo = SerializationUtilities.borrowKryo();
        try {
            SerializationUtilities.serializePlan(kryo, plan, out, cloningPlan);
        }
        finally {
            SerializationUtilities.releaseKryo(kryo);
        }
    }

    private static void serializePlan(Kryo kryo, Object plan, OutputStream out, boolean cloningPlan) {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.perfLogBegin(CLASS_NAME, "serializePlan");
        LOG.info("Serializing " + plan.getClass().getSimpleName() + " using kryo");
        if (cloningPlan) {
            SerializationUtilities.serializeObjectByKryo(kryo, plan, out);
        } else {
            SerializationUtilities.serializeObjectByKryo(kryo, plan, out);
        }
        perfLogger.perfLogEnd(CLASS_NAME, "serializePlan");
    }

    public static <T> T deserializePlan(InputStream in, Class<T> planClass) {
        return SerializationUtilities.deserializePlan(in, planClass, false);
    }

    public static <T> T deserializePlan(Kryo kryo, InputStream in, Class<T> planClass) {
        return SerializationUtilities.deserializePlan(kryo, in, planClass, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T deserializePlan(InputStream in, Class<T> planClass, boolean cloningPlan) {
        Kryo kryo = SerializationUtilities.borrowKryo();
        T result = null;
        try {
            result = SerializationUtilities.deserializePlan(kryo, in, planClass, cloningPlan);
        }
        finally {
            SerializationUtilities.releaseKryo(kryo);
        }
        return result;
    }

    private static <T> T deserializePlan(Kryo kryo, InputStream in, Class<T> planClass, boolean cloningPlan) {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.perfLogBegin(CLASS_NAME, "deserializePlan");
        LOG.info("Deserializing " + planClass.getSimpleName() + " using kryo");
        T plan = cloningPlan ? SerializationUtilities.deserializeObjectByKryo(kryo, in, planClass) : SerializationUtilities.deserializeObjectByKryo(kryo, in, planClass);
        perfLogger.perfLogEnd(CLASS_NAME, "deserializePlan");
        return plan;
    }

    public static MapredWork clonePlan(MapredWork plan) {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.perfLogBegin(CLASS_NAME, "clonePlan");
        Operator<?> op = plan.getAnyOperator();
        CompilationOpContext ctx = op == null ? null : op.getCompilationOpContext();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        SerializationUtilities.serializePlan(plan, baos, true);
        MapredWork newPlan = SerializationUtilities.deserializePlan(new ByteArrayInputStream(baos.toByteArray()), MapredWork.class, true);
        for (Operator<?> newOp : newPlan.getAllOperators()) {
            newOp.setCompilationOpContext(ctx);
        }
        perfLogger.perfLogEnd(CLASS_NAME, "clonePlan");
        return newPlan;
    }

    public static List<Operator<?>> cloneOperatorTree(List<Operator<?>> roots) {
        if (roots.isEmpty()) {
            return Collections.emptyList();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        CompilationOpContext ctx = roots.get(0).getCompilationOpContext();
        SerializationUtilities.serializePlan(roots, baos, true);
        List result = (List)SerializationUtilities.deserializePlan(new ByteArrayInputStream(baos.toByteArray()), roots.getClass(), true);
        LinkedList<Operator<OperatorDesc>> newOps = new LinkedList<Operator<OperatorDesc>>(result);
        while (!newOps.isEmpty()) {
            Operator newOp = (Operator)newOps.poll();
            newOp.setCompilationOpContext(ctx);
            List<Operator<OperatorDesc>> children = newOp.getChildOperators();
            if (children == null) continue;
            newOps.addAll(children);
        }
        return result;
    }

    public static BaseWork cloneBaseWork(BaseWork plan) {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.perfLogBegin(CLASS_NAME, "clonePlan");
        Operator<? extends OperatorDesc> op = plan.getAnyRootOperator();
        CompilationOpContext ctx = op == null ? null : op.getCompilationOpContext();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        SerializationUtilities.serializePlan(plan, baos, true);
        BaseWork newPlan = (BaseWork)SerializationUtilities.deserializePlan(new ByteArrayInputStream(baos.toByteArray()), plan.getClass(), true);
        for (Operator<?> newOp : newPlan.getAllOperators()) {
            newOp.setCompilationOpContext(ctx);
        }
        perfLogger.perfLogEnd(CLASS_NAME, "clonePlan");
        return newPlan;
    }

    private static void serializeObjectByKryo(Kryo kryo, Object plan, OutputStream out) {
        Output output = new Output(out);
        kryo.setClassLoader(Utilities.getSessionSpecifiedClassLoader());
        kryo.writeObject(output, plan);
        output.close();
    }

    private static <T> T deserializeObjectByKryo(Kryo kryo, InputStream in, Class<T> clazz) {
        Input inp = new Input(in);
        kryo.setClassLoader(Utilities.getSessionSpecifiedClassLoader());
        Object t = kryo.readObject(inp, clazz);
        inp.close();
        return (T)t;
    }

    public static byte[] serializeExpressionToKryo(ExprNodeGenericFuncDesc expr) {
        return SerializationUtilities.serializeObjectToKryo(expr);
    }

    public static ExprNodeGenericFuncDesc deserializeExpressionFromKryo(byte[] bytes) {
        return SerializationUtilities.deserializeObjectFromKryo(bytes, ExprNodeGenericFuncDesc.class);
    }

    public static String serializeExpression(ExprNodeGenericFuncDesc expr) {
        return new String(Base64.encodeBase64((byte[])SerializationUtilities.serializeExpressionToKryo(expr)), StandardCharsets.UTF_8);
    }

    public static ExprNodeGenericFuncDesc deserializeExpression(String s) {
        byte[] bytes = Base64.decodeBase64((byte[])s.getBytes(StandardCharsets.UTF_8));
        return SerializationUtilities.deserializeExpressionFromKryo(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serializeObjectToKryo(Serializable object) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)baos);
        Kryo kryo = SerializationUtilities.borrowKryo();
        try {
            kryo.writeObject(output, (Object)object);
        }
        finally {
            SerializationUtilities.releaseKryo(kryo);
        }
        output.close();
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends Serializable> T deserializeObjectFromKryo(byte[] bytes, Class<T> clazz) {
        Input inp = new Input((InputStream)new ByteArrayInputStream(bytes));
        Kryo kryo = SerializationUtilities.borrowKryo();
        Serializable func = null;
        try {
            func = (Serializable)kryo.readObject(inp, clazz);
        }
        finally {
            SerializationUtilities.releaseKryo(kryo);
        }
        inp.close();
        return (T)func;
    }

    public static String serializeObject(Serializable expr) {
        return new String(Base64.encodeBase64((byte[])SerializationUtilities.serializeObjectToKryo(expr)), StandardCharsets.UTF_8);
    }

    public static <T extends Serializable> T deserializeObject(String s, Class<T> clazz) {
        return SerializationUtilities.deserializeObjectFromKryo(Base64.decodeBase64((byte[])s.getBytes(StandardCharsets.UTF_8)), clazz);
    }

    private static class PartitionDescSerializer
    extends FieldSerializer<PartitionDesc> {
        PartitionDescSerializer(Kryo kryo, Class type) {
            super(kryo, type);
        }

        public PartitionDesc read(Kryo kryo, Input input, Class<? extends PartitionDesc> type) {
            PartitionDesc partitionDesc = (PartitionDesc)super.read(kryo, input, type);
            partitionDesc.setBaseFileName(partitionDesc.getBaseFileName());
            partitionDesc.setPartSpec(partitionDesc.getPartSpec());
            partitionDesc.setInputFileFormatClass(partitionDesc.getInputFileFormatClass());
            partitionDesc.setOutputFileFormatClass(partitionDesc.getOutputFileFormatClass());
            return partitionDesc;
        }
    }

    private static class CopyOnFirstWritePropertiesSerializer
    extends MapSerializer<Map> {
        private CopyOnFirstWritePropertiesSerializer() {
        }

        public void write(Kryo kryo, Output output, Map map) {
            super.write(kryo, output, map);
            CopyOnFirstWriteProperties p = (CopyOnFirstWriteProperties)map;
            Properties ip = p.getInterned();
            kryo.writeObjectOrNull(output, (Object)ip, Properties.class);
        }

        public Map read(Kryo kryo, Input input, Class<? extends Map> type) {
            Map map = super.read(kryo, input, type);
            Properties ip = (Properties)kryo.readObjectOrNull(input, Properties.class);
            ((CopyOnFirstWriteProperties)map).setInterned(ip);
            return map;
        }
    }

    private static class ArraysAsListSerializer
    extends Serializer<List<?>> {
        private Field _arrayField;

        public ArraysAsListSerializer() {
            try {
                this._arrayField = Class.forName("java.util.Arrays$ArrayList").getDeclaredField("a");
                this._arrayField.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.setImmutable(true);
        }

        public List<?> read(Kryo kryo, Input input, Class<? extends List<?>> type) {
            int length = input.readInt(true);
            Class<?> componentType = kryo.readClass(input).getType();
            if (componentType.isPrimitive()) {
                componentType = this.getPrimitiveWrapperClass(componentType);
            }
            try {
                Object items = Array.newInstance(componentType, length);
                for (int i = 0; i < length; ++i) {
                    Array.set(items, i, kryo.readClassAndObject(input));
                }
                return Arrays.asList((Object[])items);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void write(Kryo kryo, Output output, List<?> obj) {
            try {
                Object[] array = (Object[])this._arrayField.get(obj);
                output.writeInt(array.length, true);
                Class<?> componentType = array.getClass().getComponentType();
                kryo.writeClass(output, componentType);
                for (Object item : array) {
                    kryo.writeClassAndObject(output, item);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private Class<?> getPrimitiveWrapperClass(Class<?> c) {
            if (c.isPrimitive()) {
                if (c.equals(Long.TYPE)) {
                    return Long.class;
                }
                if (c.equals(Integer.TYPE)) {
                    return Integer.class;
                }
                if (c.equals(Double.TYPE)) {
                    return Double.class;
                }
                if (c.equals(Float.TYPE)) {
                    return Float.class;
                }
                if (c.equals(Boolean.TYPE)) {
                    return Boolean.class;
                }
                if (c.equals(Character.TYPE)) {
                    return Character.class;
                }
                if (c.equals(Short.TYPE)) {
                    return Short.class;
                }
                if (c.equals(Byte.TYPE)) {
                    return Byte.class;
                }
            }
            return c;
        }
    }

    private static class ArrayListSubListSerializer
    extends Serializer<List<?>> {
        private Field _parentField;
        private Field _parentOffsetField;
        private Field _sizeField;

        public ArrayListSubListSerializer() {
            try {
                Class<?> clazz = Class.forName("java.util.ArrayList$SubList");
                this._parentField = ArrayListSubListSerializer.getParentField(clazz);
                this._parentOffsetField = ArrayListSubListSerializer.getOffsetField(clazz);
                this._sizeField = clazz.getDeclaredField("size");
                this._parentField.setAccessible(true);
                this._parentOffsetField.setAccessible(true);
                this._sizeField.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private static Field getParentField(Class clazz) throws NoSuchFieldException {
            try {
                return clazz.getDeclaredField("root");
            }
            catch (NoSuchFieldException e) {
                return clazz.getDeclaredField("parent");
            }
        }

        private static Field getOffsetField(Class<?> clazz) throws NoSuchFieldException {
            try {
                return clazz.getDeclaredField("parentOffset");
            }
            catch (NoSuchFieldException e) {
                return clazz.getDeclaredField("offset");
            }
        }

        public List<?> read(Kryo kryo, Input input, Class<? extends List<?>> clazz) {
            kryo.reference(FAKE_REFERENCE);
            List list = (List)kryo.readClassAndObject(input);
            int fromIndex = input.readInt(true);
            int toIndex = input.readInt(true);
            return list.subList(fromIndex, toIndex);
        }

        public void write(Kryo kryo, Output output, List<?> obj) {
            try {
                int parentOffset;
                kryo.writeClassAndObject(output, this._parentField.get(obj));
                int fromIndex = parentOffset = this._parentOffsetField.getInt(obj);
                output.writeInt(fromIndex, true);
                int toIndex = fromIndex + this._sizeField.getInt(obj);
                output.writeInt(toIndex, true);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public List<?> copy(Kryo kryo, List<?> original) {
            kryo.reference(FAKE_REFERENCE);
            try {
                int parentOffset;
                List list = (List)this._parentField.get(original);
                int fromIndex = parentOffset = this._parentOffsetField.getInt(original);
                int toIndex = fromIndex + this._sizeField.getInt(original);
                return ((List)kryo.copy((Object)list)).subList(fromIndex, toIndex);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class PathSerializer
    extends Serializer<Path> {
        private PathSerializer() {
        }

        public void write(Kryo kryo, Output output, Path path) {
            output.writeString(path.toUri().toString());
        }

        public Path read(Kryo kryo, Input input, Class<? extends Path> type) {
            return new Path(URI.create(input.readString()));
        }
    }

    private static class SqlDateSerializer
    extends Serializer<Date> {
        private SqlDateSerializer() {
        }

        public Date read(Kryo kryo, Input input, Class<? extends Date> clazz) {
            return new Date(input.readLong());
        }

        public void write(Kryo kryo, Output output, Date sqlDate) {
            output.writeLong(sqlDate.getTime());
        }
    }

    private static class TimestampTZSerializer
    extends Serializer<TimestampTZ> {
        private TimestampTZSerializer() {
        }

        public void write(Kryo kryo, Output output, TimestampTZ object) {
            output.writeLong(object.getEpochSecond());
            output.writeInt(object.getNanos());
            output.writeString(object.getZonedDateTime().getZone().getId());
        }

        public TimestampTZ read(Kryo kryo, Input input, Class<? extends TimestampTZ> type) {
            long seconds = input.readLong();
            int nanos = input.readInt();
            String zoneId = input.readString();
            return new TimestampTZ(seconds, nanos, ZoneId.of(zoneId));
        }
    }

    private static class TimestampSerializer
    extends Serializer<Timestamp> {
        private TimestampSerializer() {
        }

        public Timestamp read(Kryo kryo, Input input, Class<? extends Timestamp> clazz) {
            Timestamp ts = new Timestamp(input.readLong());
            ts.setNanos(input.readInt());
            return ts;
        }

        public void write(Kryo kryo, Output output, Timestamp ts) {
            output.writeLong(ts.getTime());
            output.writeInt(ts.getNanos());
        }
    }

    private static class KryoWithHooks
    extends Kryo {
        private Hook globalHook;

        private KryoWithHooks() {
        }

        public Kryo processHooks(Map<Class<?>, Hook> hooks, Hook globalHook) {
            for (Map.Entry<Class<?>, Hook> e : hooks.entrySet()) {
                this.register(e.getKey(), new SerializerWithHook(this.newDefaultSerializer(e.getKey()), e.getValue()));
            }
            this.globalHook = globalHook;
            return this;
        }

        private Hook ponderGlobalPreReadHook(Class<?> clazz) {
            Hook globalHook = this.globalHook;
            return globalHook != null && globalHook.preRead(clazz) ? globalHook : null;
        }

        private <T> T ponderGlobalPostReadHook(Hook hook, T result) {
            return (T)(hook == null ? result : hook.postRead(result));
        }

        private Object ponderGlobalPostHook(Object result) {
            Hook globalHook = this.globalHook;
            return globalHook != null ? globalHook.postRead(result) : result;
        }

        public Object readClassAndObject(Input input) {
            return this.ponderGlobalPostHook(super.readClassAndObject(input));
        }

        public Registration readClass(Input input) {
            Registration reg = super.readClass(input);
            if (reg != null) {
                this.ponderGlobalPreReadHook(reg.getType());
            }
            return reg;
        }

        public <T> T readObjectOrNull(Input input, Class<T> type) {
            Hook hook = this.ponderGlobalPreReadHook(type);
            Object result = super.readObjectOrNull(input, type);
            return (T)this.ponderGlobalPostReadHook(hook, result);
        }

        public <T> T readObjectOrNull(Input input, Class<T> type, Serializer serializer) {
            Hook hook = this.ponderGlobalPreReadHook(type);
            Object result = super.readObjectOrNull(input, type, serializer);
            return (T)this.ponderGlobalPostReadHook(hook, result);
        }

        public <T> T readObject(Input input, Class<T> type) {
            Hook hook = this.ponderGlobalPreReadHook(type);
            Object result = super.readObject(input, type);
            return (T)this.ponderGlobalPostReadHook(hook, result);
        }

        public <T> T readObject(Input input, Class<T> type, Serializer serializer) {
            Hook hook = this.ponderGlobalPreReadHook(type);
            Object result = super.readObject(input, type, serializer);
            return (T)this.ponderGlobalPostReadHook(hook, result);
        }

        private static final class SerializerWithHook
        extends Serializer {
            private final Serializer old;
            private final Hook hook;

            private SerializerWithHook(Serializer old, Hook hook) {
                this.old = old;
                this.hook = hook;
            }

            public Object read(Kryo kryo, Input input, Class type) {
                return this.hook.preRead(type) ? this.hook.postRead(this.old.read(kryo, input, type)) : this.old.read(kryo, input, type);
            }

            public void write(Kryo kryo, Output output, Object object) {
                this.old.write(kryo, output, object);
            }
        }
    }

    public static class Hook {
        public boolean preRead(Class<?> type) {
            return true;
        }

        public Object postRead(Object o) {
            return o;
        }
    }
}

