/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.ql.optimizer.physical.LlapClusterStateForCompile;

public class MemoryInfo {
    private Configuration conf;
    private boolean isTez;
    private boolean isLlap;
    private long maxExecutorMemory;
    private long mapJoinMemoryThreshold;
    private long dynPartJoinMemoryThreshold;

    public MemoryInfo(Configuration conf) {
        this.isTez = "tez".equalsIgnoreCase(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE));
        this.isLlap = "llap".equalsIgnoreCase(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_MODE));
        if (this.isLlap) {
            LlapClusterStateForCompile llapInfo = LlapClusterStateForCompile.getClusterInfo(conf);
            llapInfo.initClusterInfo();
            if (llapInfo.hasClusterInfo()) {
                this.maxExecutorMemory = llapInfo.getMemoryPerExecutor();
            } else {
                long memPerInstance = HiveConf.getLongVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_MEMORY_PER_INSTANCE_MB) * 1024L * 1024L;
                long numExecutors = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS);
                this.maxExecutorMemory = memPerInstance / numExecutors;
            }
        } else if (this.isTez) {
            int containerSizeMb;
            float heapFraction = HiveConf.getFloatVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.TEZ_CONTAINER_MAX_JAVA_HEAP_FRACTION);
            int n = containerSizeMb = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVETEZCONTAINERSIZE) > 0 ? HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVETEZCONTAINERSIZE) : conf.getInt("mapreduce.map.memory.mb", 1024);
            if (containerSizeMb < 0) {
                containerSizeMb = 1024;
            }
            this.maxExecutorMemory = (long)((float)((long)containerSizeMb * 1024L * 1024L) * heapFraction);
        } else {
            this.maxExecutorMemory = (long)conf.getInt("mapreduce.map.memory.mb", 1024) * 1024L * 1024L;
            if (this.maxExecutorMemory < 0L) {
                this.maxExecutorMemory = 0x40000000L;
            }
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public boolean isTez() {
        return this.isTez;
    }

    public boolean isLlap() {
        return this.isLlap;
    }

    public long getMaxExecutorMemory() {
        return this.maxExecutorMemory;
    }

    public long getMapJoinMemoryThreshold() {
        return this.mapJoinMemoryThreshold;
    }

    public long getDynPartJoinMemoryThreshold() {
        return this.dynPartJoinMemoryThreshold;
    }

    public String toString() {
        return "MEMORY INFO - { isTez: " + this.isTez() + ", isLlap: " + this.isLlap() + ", maxExecutorMemory: " + LlapUtil.humanReadableByteCount((long)this.getMaxExecutorMemory()) + ", mapJoinMemoryThreshold: " + LlapUtil.humanReadableByteCount((long)this.getMapJoinMemoryThreshold()) + ", dynPartJoinMemoryThreshold: " + LlapUtil.humanReadableByteCount((long)this.getDynPartJoinMemoryThreshold()) + " }";
    }
}

