/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.MemoryExhaustionChecker;
import org.apache.hadoop.hive.ql.exec.MemoryExhaustionCheckerFactory;
import org.apache.hadoop.hive.ql.exec.TerminalOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.persistence.HashMapWrapper;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinEagerRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKeyObject;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinPersistableTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainerSerDe;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.HashTableSinkDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashTableSinkOperator
extends TerminalOperator<HashTableSinkDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOG = LoggerFactory.getLogger((String)HashTableSinkOperator.class.getName());
    private transient List<ExprNodeEvaluator>[] joinKeys;
    private transient List<ObjectInspector>[] joinKeysObjectInspectors;
    private transient int posBigTableAlias = -1;
    private transient List<ExprNodeEvaluator>[] joinFilters;
    private transient int[][] filterMaps;
    private transient List<ExprNodeEvaluator>[] joinValues;
    private transient List<ObjectInspector>[] joinValuesObjectInspectors;
    private transient List<ObjectInspector>[] joinFilterObjectInspectors;
    private transient Byte[] order;
    protected Configuration hconf;
    protected transient MapJoinPersistableTableContainer[] mapJoinTables;
    protected transient MapJoinTableContainerSerDe[] mapJoinTableSerdes;
    private final Object[] emptyObjectArray = new Object[0];
    private final MapJoinEagerRowContainer emptyRowContainer = new MapJoinEagerRowContainer();
    private long rowNumber = 0L;
    protected transient SessionState.LogHelper console;
    private long hashTableScale;
    private MemoryExhaustionChecker memoryExhaustionChecker;

    protected HashTableSinkOperator() {
    }

    public HashTableSinkOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public HashTableSinkOperator(CompilationOpContext ctx, MapJoinOperator mjop) {
        this(ctx);
        this.conf = new HashTableSinkDesc((MapJoinDesc)mjop.getConf());
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        boolean isSilent = HiveConf.getBoolVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVESESSIONSILENT);
        this.console = new SessionState.LogHelper(LOG, isSilent);
        this.memoryExhaustionChecker = MemoryExhaustionCheckerFactory.getChecker(this.console, hconf, (HashTableSinkDesc)this.conf);
        this.emptyRowContainer.addRow(this.emptyObjectArray);
        this.posBigTableAlias = ((HashTableSinkDesc)this.conf).getPosBigTable();
        this.order = ((HashTableSinkDesc)this.conf).getTagOrder();
        this.hconf = hconf;
        this.filterMaps = ((HashTableSinkDesc)this.conf).getFilterMap();
        int tagLen = ((HashTableSinkDesc)this.conf).getTagLength();
        this.joinKeys = new List[tagLen];
        JoinUtil.populateJoinKeyValue(this.joinKeys, ((HashTableSinkDesc)this.conf).getKeys(), this.posBigTableAlias, hconf);
        this.joinKeysObjectInspectors = JoinUtil.getObjectInspectorsFromEvaluators(this.joinKeys, this.inputObjInspectors, this.posBigTableAlias, tagLen);
        this.joinValues = new List[tagLen];
        JoinUtil.populateJoinKeyValue(this.joinValues, ((HashTableSinkDesc)this.conf).getExprs(), this.posBigTableAlias, hconf);
        this.joinValuesObjectInspectors = JoinUtil.getObjectInspectorsFromEvaluators(this.joinValues, this.inputObjInspectors, this.posBigTableAlias, tagLen);
        this.joinFilters = new List[tagLen];
        JoinUtil.populateJoinKeyValue(this.joinFilters, ((HashTableSinkDesc)this.conf).getFilters(), this.posBigTableAlias, hconf);
        this.joinFilterObjectInspectors = JoinUtil.getObjectInspectorsFromEvaluators(this.joinFilters, this.inputObjInspectors, this.posBigTableAlias, tagLen);
        if (!((HashTableSinkDesc)this.conf).isNoOuterJoin()) {
            for (Byte alias : this.order) {
                if (alias == this.posBigTableAlias || this.joinValues[alias] == null) continue;
                List<ObjectInspector> rcOIs = this.joinValuesObjectInspectors[alias];
                if (this.filterMaps == null || this.filterMaps[alias] == null) continue;
                rcOIs = new ArrayList<ObjectInspector>(rcOIs);
                rcOIs.add((ObjectInspector)PrimitiveObjectInspectorFactory.writableShortObjectInspector);
            }
        }
        this.mapJoinTables = new MapJoinPersistableTableContainer[tagLen];
        this.mapJoinTableSerdes = new MapJoinTableContainerSerDe[tagLen];
        this.hashTableScale = HiveConf.getLongVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEHASHTABLESCALE);
        if (this.hashTableScale <= 0L) {
            this.hashTableScale = 1L;
        }
        try {
            TableDesc keyTableDesc = ((HashTableSinkDesc)this.conf).getKeyTblDesc();
            AbstractSerDe keySerDe = (AbstractSerDe)ReflectionUtils.newInstance(keyTableDesc.getSerDeClass(), null);
            keySerDe.initialize(null, keyTableDesc.getProperties(), null);
            MapJoinObjectSerDeContext keyContext = new MapJoinObjectSerDeContext(keySerDe, false);
            for (Byte pos : this.order) {
                if (pos == this.posBigTableAlias) continue;
                this.mapJoinTables[pos.byteValue()] = new HashMapWrapper(hconf, -1L);
                TableDesc valueTableDesc = ((HashTableSinkDesc)this.conf).getValueTblFilteredDescs().get(pos.byteValue());
                AbstractSerDe valueSerDe = (AbstractSerDe)ReflectionUtils.newInstance(valueTableDesc.getSerDeClass(), null);
                valueSerDe.initialize(null, valueTableDesc.getProperties(), null);
                this.mapJoinTableSerdes[pos.byteValue()] = new MapJoinTableContainerSerDe(keyContext, new MapJoinObjectSerDeContext(valueSerDe, this.hasFilter(pos.byteValue())));
            }
        }
        catch (SerDeException e) {
            throw new HiveException((Throwable)e);
        }
    }

    public MapJoinTableContainer[] getMapJoinTables() {
        return this.mapJoinTables;
    }

    private static List<ObjectInspector>[] getStandardObjectInspectors(List<ObjectInspector>[] aliasToObjectInspectors, int maxTag) {
        List[] result = new List[maxTag];
        for (int alias = 0; alias < aliasToObjectInspectors.length; alias = (int)((byte)(alias + 1))) {
            List<ObjectInspector> oiList = aliasToObjectInspectors[alias];
            if (oiList == null) continue;
            ArrayList<ObjectInspector> fieldOIList = new ArrayList<ObjectInspector>(oiList.size());
            for (int i = 0; i < oiList.size(); ++i) {
                fieldOIList.add(ObjectInspectorUtils.getStandardObjectInspector((ObjectInspector)oiList.get(i), (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE));
            }
            result[alias] = fieldOIList;
        }
        return result;
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        MapJoinPersistableTableContainer tableContainer;
        MapJoinRowContainer rowContainer;
        byte alias = (byte)tag;
        Object[] currentKey = new Object[this.joinKeys[alias].size()];
        for (int keyIndex = 0; keyIndex < this.joinKeys[alias].size(); ++keyIndex) {
            currentKey[keyIndex] = this.joinKeys[alias].get(keyIndex).evaluate(row);
        }
        MapJoinKeyObject key = new MapJoinKeyObject();
        key.readFromRow(currentKey, this.joinKeysObjectInspectors[alias]);
        Object[] value = this.emptyObjectArray;
        if (this.hasFilter(alias) && this.filterMaps[alias].length > 0 || this.joinValues[alias].size() > 0) {
            value = JoinUtil.computeMapJoinValues(row, this.joinValues[alias], this.joinValuesObjectInspectors[alias], this.joinFilters[alias], this.joinFilterObjectInspectors[alias], this.filterMaps == null ? null : this.filterMaps[alias]);
        }
        if ((rowContainer = (tableContainer = this.mapJoinTables[alias]).get(key)) == null) {
            if (value.length != 0) {
                rowContainer = new MapJoinEagerRowContainer();
                rowContainer.addRow(value);
            } else {
                rowContainer = this.emptyRowContainer;
            }
            ++this.rowNumber;
            this.memoryExhaustionChecker.checkMemoryOverhead(this.rowNumber, this.hashTableScale, tableContainer.size());
            tableContainer.put(key, rowContainer);
        } else if (rowContainer == this.emptyRowContainer) {
            rowContainer = rowContainer.copy();
            rowContainer.addRow(value);
            tableContainer.put(key, rowContainer);
        } else {
            rowContainer.addRow(value);
        }
    }

    private boolean hasFilter(int alias) {
        return this.filterMaps != null && this.filterMaps[alias] != null;
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        try {
            if (this.mapJoinTables == null) {
                LOG.debug("mapJoinTables is null");
            } else {
                this.flushToFile();
            }
            super.closeOp(abort);
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushToFile() throws IOException, HiveException {
        Path tmpURI = this.getExecContext().getLocalWork().getTmpPath();
        LOG.info("Temp URI for side table: {}", (Object)tmpURI);
        for (byte tag = 0; tag < this.mapJoinTables.length; tag = (byte)((byte)(tag + 1))) {
            MapJoinPersistableTableContainer tableContainer = this.mapJoinTables[tag];
            if (tableContainer == null) continue;
            String bigBucketFileName = this.getExecContext().getCurrentBigBucketFile();
            String fileName = this.getExecContext().getLocalWork().getBucketFileName(bigBucketFileName);
            String dumpFilePrefix = ((HashTableSinkDesc)this.conf).getDumpFilePrefix();
            Path path = Utilities.generatePath(tmpURI, dumpFilePrefix, tag, fileName);
            this.console.printInfo(Utilities.now() + "\tDump the side-table for tag: " + tag + " with group count: " + tableContainer.size() + " into file: " + path);
            FileSystem fs = path.getFileSystem(this.hconf);
            try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream((OutputStream)fs.create(path)));){
                this.mapJoinTableSerdes[tag].persist(out, tableContainer);
            }
            tableContainer.clear();
            FileStatus status = fs.getFileStatus(path);
            this.console.printInfo(Utilities.now() + "\tUploaded 1 File to: " + path + " (" + status.getLen() + " bytes)");
        }
    }

    @Override
    public String getName() {
        return HashTableSinkOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "HASHTABLESINK";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.HASHTABLESINK;
    }
}

