/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.datasketches.hive.cpc.GetEstimateAndErrorBoundsUDF;
import org.apache.datasketches.hive.cpc.GetEstimateUDF;
import org.apache.datasketches.hive.cpc.UnionSketchUDF;
import org.apache.datasketches.hive.frequencies.GetFrequentItemsFromStringsSketchUDTF;
import org.apache.datasketches.hive.hll.SketchToEstimateAndErrorBoundsUDF;
import org.apache.datasketches.hive.hll.SketchToEstimateUDF;
import org.apache.datasketches.hive.hll.SketchToStringUDF;
import org.apache.datasketches.hive.kll.DataToSketchUDAF;
import org.apache.datasketches.hive.kll.GetCdfUDF;
import org.apache.datasketches.hive.kll.GetNUDF;
import org.apache.datasketches.hive.kll.GetPmfUDF;
import org.apache.datasketches.hive.kll.GetQuantileUDF;
import org.apache.datasketches.hive.kll.GetQuantilesUDF;
import org.apache.datasketches.hive.kll.GetRankUDF;
import org.apache.datasketches.hive.kll.UnionSketchUDAF;
import org.apache.datasketches.hive.quantiles.DataToDoublesSketchUDAF;
import org.apache.datasketches.hive.quantiles.DataToStringsSketchUDAF;
import org.apache.datasketches.hive.quantiles.DoublesSketchToStringUDF;
import org.apache.datasketches.hive.quantiles.GetCdfFromDoublesSketchUDF;
import org.apache.datasketches.hive.quantiles.GetCdfFromStringsSketchUDF;
import org.apache.datasketches.hive.quantiles.GetKFromDoublesSketchUDF;
import org.apache.datasketches.hive.quantiles.GetKFromStringsSketchUDF;
import org.apache.datasketches.hive.quantiles.GetNFromDoublesSketchUDF;
import org.apache.datasketches.hive.quantiles.GetNFromStringsSketchUDF;
import org.apache.datasketches.hive.quantiles.GetPmfFromDoublesSketchUDF;
import org.apache.datasketches.hive.quantiles.GetPmfFromStringsSketchUDF;
import org.apache.datasketches.hive.quantiles.GetQuantileFromDoublesSketchUDF;
import org.apache.datasketches.hive.quantiles.GetQuantileFromStringsSketchUDF;
import org.apache.datasketches.hive.quantiles.GetQuantilesFromDoublesSketchUDF;
import org.apache.datasketches.hive.quantiles.GetQuantilesFromStringsSketchUDF;
import org.apache.datasketches.hive.quantiles.StringsSketchToStringUDF;
import org.apache.datasketches.hive.quantiles.UnionDoublesSketchUDAF;
import org.apache.datasketches.hive.quantiles.UnionStringsSketchUDAF;
import org.apache.datasketches.hive.theta.EstimateSketchUDF;
import org.apache.datasketches.hive.theta.ExcludeSketchUDF;
import org.apache.datasketches.hive.theta.IntersectSketchUDAF;
import org.apache.datasketches.hive.theta.IntersectSketchUDF;
import org.apache.datasketches.hive.tuple.ArrayOfDoublesSketchToEstimateAndErrorBoundsUDF;
import org.apache.datasketches.hive.tuple.ArrayOfDoublesSketchToEstimatesUDF;
import org.apache.datasketches.hive.tuple.ArrayOfDoublesSketchToMeansUDF;
import org.apache.datasketches.hive.tuple.ArrayOfDoublesSketchToNumberOfRetainedEntriesUDF;
import org.apache.datasketches.hive.tuple.ArrayOfDoublesSketchToQuantilesSketchUDF;
import org.apache.datasketches.hive.tuple.ArrayOfDoublesSketchToValuesUDTF;
import org.apache.datasketches.hive.tuple.ArrayOfDoublesSketchToVariancesUDF;
import org.apache.datasketches.hive.tuple.ArrayOfDoublesSketchesTTestUDF;
import org.apache.datasketches.hive.tuple.DataToArrayOfDoublesSketchUDAF;
import org.apache.datasketches.hive.tuple.DataToDoubleSummarySketchUDAF;
import org.apache.datasketches.hive.tuple.DoubleSummarySketchToEstimatesUDF;
import org.apache.datasketches.hive.tuple.DoubleSummarySketchToPercentileUDF;
import org.apache.datasketches.hive.tuple.UnionArrayOfDoublesSketchUDAF;
import org.apache.datasketches.hive.tuple.UnionDoubleSummarySketchUDAF;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.Registry;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveTypeSystemImpl;
import org.apache.hadoop.hive.ql.optimizer.calcite.functions.HiveMergeableAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSqlFunction;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver2;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hive.plugin.api.HiveUDFPlugin;

public final class DataSketchesFunctions
implements HiveUDFPlugin {
    public static final DataSketchesFunctions INSTANCE = new DataSketchesFunctions();
    private static final String DATASKETCHES_PREFIX = "ds";
    public static final String DATA_TO_SKETCH = "sketch";
    public static final String SKETCH_TO_ESTIMATE = "estimate";
    private static final String SKETCH_TO_ESTIMATE_WITH_ERROR_BOUNDS = "estimate_bounds";
    private static final String SKETCH_TO_STRING = "stringify";
    private static final String UNION_SKETCH = "union";
    private static final String UNION_SKETCH1 = "union_f";
    public static final String GET_N = "n";
    public static final String GET_CDF = "cdf";
    private static final String GET_PMF = "pmf";
    private static final String GET_QUANTILES = "quantiles";
    public static final String GET_QUANTILE = "quantile";
    public static final String GET_RANK = "rank";
    private static final String INTERSECT_SKETCH = "intersect";
    private static final String INTERSECT_SKETCH1 = "intersect_f";
    private static final String EXCLUDE_SKETCH = "exclude";
    private static final String GET_K = "k";
    private static final String GET_FREQUENT_ITEMS = "frequent_items";
    private static final String T_TEST = "ttest";
    private static final String SKETCH_TO_MEANS = "means";
    private static final String SKETCH_TO_NUMBER_OF_RETAINED_ENTRIES = "n_retained";
    private static final String SKETCH_TO_QUANTILES_SKETCH = "quantiles_sketch";
    private static final String SKETCH_TO_VALUES = "values";
    private static final String SKETCH_TO_VARIANCES = "variances";
    private static final String SKETCH_TO_PERCENTILE = "percentile";
    private final Map<String, SketchDescriptor> sketchClasses = new HashMap<String, SketchDescriptor>();
    private final ArrayList<HiveUDFPlugin.UDFDescriptor> descriptors = new ArrayList();

    private DataSketchesFunctions() {
        this.registerHll();
        this.registerCpc();
        this.registerKll();
        this.registerTheta();
        this.registerTuple();
        this.registerQuantiles();
        this.registerFrequencies();
        this.buildCalciteFns();
        this.buildDescritors();
    }

    @Override
    public Iterable<HiveUDFPlugin.UDFDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public SketchFunctionDescriptor getSketchFunction(String className, String function) {
        if (!this.sketchClasses.containsKey(className)) {
            throw new IllegalArgumentException(String.format("Sketch-class '%s' doesn't exists", className));
        }
        SketchDescriptor sc = this.sketchClasses.get(className);
        if (!sc.fnMap.containsKey(function)) {
            throw new IllegalArgumentException(String.format("The Sketch-class '%s' doesn't have a '%s' method", className, function));
        }
        return this.sketchClasses.get((Object)className).fnMap.get(function);
    }

    private void buildDescritors() {
        for (SketchDescriptor sketchDescriptor : this.sketchClasses.values()) {
            this.descriptors.addAll(sketchDescriptor.fnMap.values());
        }
    }

    private void buildCalciteFns() {
        for (SketchDescriptor sd : this.sketchClasses.values()) {
            this.registerAsHiveFunction(sd.fnMap.get(SKETCH_TO_ESTIMATE));
            this.registerAsHiveFunction(sd.fnMap.get(GET_QUANTILE));
            this.registerAsHiveFunction(sd.fnMap.get(GET_CDF));
            this.registerAsHiveFunction(sd.fnMap.get(GET_N));
            this.registerAsHiveFunction(sd.fnMap.get(GET_RANK));
            RelProtoDataType sketchType = RelDataTypeImpl.proto((SqlTypeName)SqlTypeName.BINARY, (boolean)true);
            SketchFunctionDescriptor sketchSFD = sd.fnMap.get(DATA_TO_SKETCH);
            SketchFunctionDescriptor unionSFD = sd.fnMap.get(UNION_SKETCH);
            if (sketchSFD == null || unionSFD == null) continue;
            HiveMergeableAggregate unionFn = new HiveMergeableAggregate(unionSFD.name, SqlKind.OTHER_FUNCTION, (SqlReturnTypeInference)ReturnTypes.explicit((RelProtoDataType)sketchType), InferTypes.ANY_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[0]), null);
            HiveMergeableAggregate sketchFn = new HiveMergeableAggregate(sketchSFD.name, SqlKind.OTHER_FUNCTION, (SqlReturnTypeInference)ReturnTypes.explicit((RelProtoDataType)sketchType), InferTypes.ANY_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[0]), unionFn);
            unionSFD.setCalciteFunction((SqlFunction)unionFn);
            sketchSFD.setCalciteFunction((SqlFunction)sketchFn);
        }
    }

    private void registerAsHiveFunction(SketchFunctionDescriptor sfd) {
        if (sfd != null && sfd.getReturnRelDataType().isPresent()) {
            HiveSqlFunction cdfFn = new HiveSqlFunction(sfd.name, SqlKind.OTHER_FUNCTION, (SqlReturnTypeInference)ReturnTypes.explicit((RelDataType)sfd.getReturnRelDataType().get()), InferTypes.ANY_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[0]), SqlFunctionCategory.USER_DEFINED_FUNCTION, true, false);
            sfd.setCalciteFunction(cdfFn);
        }
    }

    private void registerHiveFunctionsInternal(Registry system) {
        for (SketchDescriptor sketchDescriptor : this.sketchClasses.values()) {
            Collection<SketchFunctionDescriptor> functions = sketchDescriptor.fnMap.values();
            for (SketchFunctionDescriptor fn : functions) {
                if (UDF.class.isAssignableFrom(fn.udfClass)) {
                    system.registerUDF(fn.name, fn.udfClass, false, new FunctionInfo.FunctionResource[0]);
                    continue;
                }
                if (GenericUDAFResolver2.class.isAssignableFrom(fn.udfClass)) {
                    String name = fn.name;
                    try {
                        system.registerGenericUDAF(name, (GenericUDAFResolver)fn.udfClass.newInstance(), new FunctionInfo.FunctionResource[0]);
                        continue;
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new RuntimeException("Unable to register: " + name, e);
                    }
                }
                if (GenericUDTF.class.isAssignableFrom(fn.udfClass)) {
                    system.registerGenericUDTF(fn.name, fn.udfClass, new FunctionInfo.FunctionResource[0]);
                    continue;
                }
                throw new RuntimeException("Don't know how to register: " + fn.name);
            }
        }
    }

    private void registerHll() {
        SketchDescriptor sd = new SketchDescriptor("hll");
        sd.register(DATA_TO_SKETCH, org.apache.datasketches.hive.hll.DataToSketchUDAF.class);
        sd.register(SKETCH_TO_ESTIMATE_WITH_ERROR_BOUNDS, SketchToEstimateAndErrorBoundsUDF.class);
        sd.register(SKETCH_TO_ESTIMATE, SketchToEstimateUDF.class);
        sd.register(SKETCH_TO_STRING, SketchToStringUDF.class);
        sd.register(UNION_SKETCH1, org.apache.datasketches.hive.hll.UnionSketchUDF.class);
        sd.register(UNION_SKETCH, org.apache.datasketches.hive.hll.UnionSketchUDAF.class);
        this.sketchClasses.put("hll", sd);
    }

    private void registerCpc() {
        SketchDescriptor sd = new SketchDescriptor("cpc");
        sd.register(DATA_TO_SKETCH, org.apache.datasketches.hive.cpc.DataToSketchUDAF.class);
        sd.register(SKETCH_TO_ESTIMATE_WITH_ERROR_BOUNDS, GetEstimateAndErrorBoundsUDF.class);
        sd.register(SKETCH_TO_ESTIMATE, GetEstimateUDF.class);
        sd.register(SKETCH_TO_STRING, org.apache.datasketches.hive.cpc.SketchToStringUDF.class);
        sd.register(UNION_SKETCH1, UnionSketchUDF.class);
        sd.register(UNION_SKETCH, org.apache.datasketches.hive.cpc.UnionSketchUDAF.class);
        this.sketchClasses.put("cpc", sd);
    }

    private void registerKll() {
        SketchDescriptor sd = new SketchDescriptor("kll");
        sd.register(DATA_TO_SKETCH, DataToSketchUDAF.class);
        sd.register(SKETCH_TO_STRING, org.apache.datasketches.hive.kll.SketchToStringUDF.class);
        sd.register(UNION_SKETCH, UnionSketchUDAF.class);
        sd.register(GET_N, GetNUDF.class);
        sd.register(GET_CDF, GetCdfUDF.class);
        sd.register(GET_PMF, GetPmfUDF.class);
        sd.register(GET_QUANTILES, GetQuantilesUDF.class);
        sd.register(GET_QUANTILE, GetQuantileUDF.class);
        sd.register(GET_RANK, GetRankUDF.class);
        this.sketchClasses.put("kll", sd);
    }

    private void registerTheta() {
        SketchDescriptor sd = new SketchDescriptor("theta");
        sd.register(DATA_TO_SKETCH, org.apache.datasketches.hive.theta.DataToSketchUDAF.class);
        sd.register(UNION_SKETCH1, org.apache.datasketches.hive.theta.UnionSketchUDF.class);
        sd.register(UNION_SKETCH, org.apache.datasketches.hive.theta.UnionSketchUDAF.class);
        sd.register(INTERSECT_SKETCH1, IntersectSketchUDF.class);
        sd.register(INTERSECT_SKETCH, IntersectSketchUDAF.class);
        sd.register(SKETCH_TO_ESTIMATE, EstimateSketchUDF.class);
        sd.register(EXCLUDE_SKETCH, ExcludeSketchUDF.class);
        this.sketchClasses.put("theta", sd);
    }

    private void registerTuple() {
        this.registerTupleArrayOfDoubles();
        this.registerTupleDoubleSummary();
    }

    private void registerTupleArrayOfDoubles() {
        SketchDescriptor sd = new SketchDescriptor("tuple_arrayofdouble");
        sd.register(DATA_TO_SKETCH, DataToArrayOfDoublesSketchUDAF.class);
        sd.register(UNION_SKETCH, UnionArrayOfDoublesSketchUDAF.class);
        sd.register(T_TEST, ArrayOfDoublesSketchesTTestUDF.class);
        sd.register(SKETCH_TO_ESTIMATE, ArrayOfDoublesSketchToEstimatesUDF.class);
        sd.register(SKETCH_TO_ESTIMATE_WITH_ERROR_BOUNDS, ArrayOfDoublesSketchToEstimateAndErrorBoundsUDF.class);
        sd.register(SKETCH_TO_MEANS, ArrayOfDoublesSketchToMeansUDF.class);
        sd.register(SKETCH_TO_NUMBER_OF_RETAINED_ENTRIES, ArrayOfDoublesSketchToNumberOfRetainedEntriesUDF.class);
        sd.register(SKETCH_TO_QUANTILES_SKETCH, ArrayOfDoublesSketchToQuantilesSketchUDF.class);
        sd.register(SKETCH_TO_VALUES, ArrayOfDoublesSketchToValuesUDTF.class);
        sd.register(SKETCH_TO_VARIANCES, ArrayOfDoublesSketchToVariancesUDF.class);
        this.sketchClasses.put("tuple_arrayofdouble", sd);
    }

    private void registerTupleDoubleSummary() {
        SketchDescriptor sd = new SketchDescriptor("tuple_doublesummary");
        sd.register(DATA_TO_SKETCH, DataToDoubleSummarySketchUDAF.class);
        sd.register(UNION_SKETCH, UnionDoubleSummarySketchUDAF.class);
        sd.register(SKETCH_TO_ESTIMATE, DoubleSummarySketchToEstimatesUDF.class);
        sd.register(SKETCH_TO_PERCENTILE, DoubleSummarySketchToPercentileUDF.class);
        this.sketchClasses.put("tuple_doublesummary", sd);
    }

    private void registerQuantiles() {
        this.registerQuantilesString();
        this.registerQuantilesDoubles();
    }

    private void registerFrequencies() {
        SketchDescriptor sd = new SketchDescriptor("freq");
        sd.register(DATA_TO_SKETCH, org.apache.datasketches.hive.frequencies.DataToStringsSketchUDAF.class);
        sd.register(UNION_SKETCH, org.apache.datasketches.hive.frequencies.UnionStringsSketchUDAF.class);
        sd.register(GET_FREQUENT_ITEMS, GetFrequentItemsFromStringsSketchUDTF.class);
        this.sketchClasses.put("freq", sd);
    }

    private void registerQuantilesString() {
        SketchDescriptor sd = new SketchDescriptor("quantile_strings");
        sd.register(DATA_TO_SKETCH, DataToStringsSketchUDAF.class);
        sd.register(SKETCH_TO_STRING, StringsSketchToStringUDF.class);
        sd.register(UNION_SKETCH, UnionStringsSketchUDAF.class);
        sd.register(GET_N, GetNFromStringsSketchUDF.class);
        sd.register(GET_K, GetKFromStringsSketchUDF.class);
        sd.register(GET_CDF, GetCdfFromStringsSketchUDF.class);
        sd.register(GET_PMF, GetPmfFromStringsSketchUDF.class);
        sd.register(GET_QUANTILE, GetQuantileFromStringsSketchUDF.class);
        sd.register(GET_QUANTILES, GetQuantilesFromStringsSketchUDF.class);
        this.sketchClasses.put("quantile_strings", sd);
    }

    private void registerQuantilesDoubles() {
        SketchDescriptor sd = new SketchDescriptor("quantile_doubles");
        sd.register(DATA_TO_SKETCH, DataToDoublesSketchUDAF.class);
        sd.register(SKETCH_TO_STRING, DoublesSketchToStringUDF.class);
        sd.register(UNION_SKETCH, UnionDoublesSketchUDAF.class);
        sd.register(GET_N, GetNFromDoublesSketchUDF.class);
        sd.register(GET_K, GetKFromDoublesSketchUDF.class);
        sd.register(GET_CDF, GetCdfFromDoublesSketchUDF.class);
        sd.register(GET_PMF, GetPmfFromDoublesSketchUDF.class);
        sd.register(GET_QUANTILE, GetQuantileFromDoublesSketchUDF.class);
        sd.register(GET_QUANTILES, GetQuantilesFromDoublesSketchUDF.class);
        this.sketchClasses.put("quantile_doubles", sd);
    }

    private static class SketchDescriptor {
        Map<String, SketchFunctionDescriptor> fnMap = new HashMap<String, SketchFunctionDescriptor>();
        private String functionPrefix;

        public SketchDescriptor(String string) {
            this.functionPrefix = "ds_" + string + "_";
        }

        private void register(String name, Class<?> clazz) {
            Optional<Method> evaluateMethod;
            SketchFunctionDescriptor value = new SketchFunctionDescriptor(this.functionPrefix + name, clazz);
            if (UDF.class.isAssignableFrom(clazz) && (evaluateMethod = this.getEvaluateMethod(clazz)).isPresent()) {
                value.setReturnType(evaluateMethod.get().getGenericReturnType());
            }
            this.fnMap.put(name, value);
        }

        private Optional<Method> getEvaluateMethod(Class<?> clazz) {
            ArrayList<Method> evaluateMethods = new ArrayList<Method>();
            for (Method method : clazz.getMethods()) {
                if (!"evaluate".equals(method.getName())) continue;
                evaluateMethods.add(method);
            }
            if (evaluateMethods.size() > 0) {
                return Optional.of(evaluateMethods.get(0));
            }
            return Optional.empty();
        }
    }

    static class SketchFunctionDescriptor
    implements HiveUDFPlugin.UDFDescriptor {
        String name;
        Class<?> udfClass;
        private SqlFunction calciteFunction;
        private Type returnType;

        public SketchFunctionDescriptor(String name, Class<?> udfClass) {
            this.name = name;
            this.udfClass = udfClass;
        }

        @Override
        public Class<?> getUDFClass() {
            return this.udfClass;
        }

        @Override
        public String getFunctionName() {
            return this.name;
        }

        public Optional<RelDataType> getReturnRelDataType() {
            if (this.returnType == null) {
                return Optional.empty();
            }
            JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl((RelDataTypeSystem)new HiveTypeSystemImpl());
            if (this.returnType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)this.returnType;
                if (parameterizedType.getRawType() == List.class) {
                    RelDataType componentRelType = typeFactory.createType(parameterizedType.getActualTypeArguments()[0]);
                    return Optional.of(typeFactory.createArrayType(typeFactory.createTypeWithNullability(componentRelType, true), -1L));
                }
                return Optional.empty();
            }
            return Optional.of(typeFactory.createType(this.returnType));
        }

        public void setReturnType(Type type) {
            this.returnType = type;
        }

        @Override
        public Optional<SqlFunction> getCalciteFunction() {
            return Optional.ofNullable(this.calciteFunction);
        }

        public void setCalciteFunction(SqlFunction calciteFunction) {
            this.calciteFunction = calciteFunction;
        }

        public String toString() {
            return this.getClass().getCanonicalName() + "[" + this.name + "]";
        }
    }
}

