/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ConditionalResolver;
import org.apache.hadoop.hive.ql.plan.ConditionalWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;

public class ConditionalTask
extends Task<ConditionalWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<Task<?>> listTasks;
    private boolean resolved = false;
    private List<Task<?>> resTasks;
    private ConditionalResolver resolver;
    private Object resolverCtx;

    @Override
    public boolean isMapRedTask() {
        for (Task<?> task : this.listTasks) {
            if (!task.isMapRedTask()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canExecuteInParallel() {
        return this.isMapRedTask();
    }

    @Override
    public boolean hasReduce() {
        for (Task<?> task : this.listTasks) {
            if (!task.hasReduce()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int execute() {
        this.resTasks = this.resolver.getTasks(this.conf, this.resolverCtx);
        this.resolved = true;
        try {
            this.resolveTask();
        }
        catch (Exception e) {
            this.setException(e);
            return 1;
        }
        return 0;
    }

    private void resolveTask() throws HiveException {
        for (Task<?> tsk : this.getListTasks()) {
            if (!this.resTasks.contains(tsk)) {
                this.taskQueue.remove(tsk);
                this.console.printInfo(tsk.getId() + " is filtered out by condition resolver.");
                if (tsk.isMapRedTask()) {
                    this.taskQueue.incCurJobNo(1);
                }
                tsk.removeFromChildrenTasks();
                continue;
            }
            if (this.getParentTasks() != null) {
                for (Task<?> task : this.getParentTasks()) {
                    task.addDependentTask(tsk);
                }
            }
            if (!this.taskQueue.addToRunnable(tsk)) continue;
            this.console.printInfo(tsk.getId() + " is selected by condition resolver.");
        }
    }

    public ConditionalResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(ConditionalResolver resolver) {
        this.resolver = resolver;
    }

    public Object getResolverCtx() {
        return this.resolverCtx;
    }

    @Override
    public boolean done() {
        boolean ret = true;
        List<Task<?>> parentTasks = this.getParentTasks();
        if (parentTasks != null) {
            for (Task<?> par : parentTasks) {
                ret = ret && par.done();
            }
        }
        List<Task<?>> retTasks = this.resolved ? this.resTasks : this.getListTasks();
        if (ret && retTasks != null) {
            for (Task<?> tsk : retTasks) {
                ret = ret && tsk.done();
            }
        }
        return ret;
    }

    public void setResolverCtx(Object resolverCtx) {
        this.resolverCtx = resolverCtx;
    }

    public List<Task<?>> getListTasks() {
        return this.listTasks;
    }

    public void setListTasks(List<Task<?>> listTasks) {
        this.listTasks = listTasks;
    }

    @Override
    public StageType getType() {
        return StageType.CONDITIONAL;
    }

    public String getName() {
        return "CONDITION";
    }

    @Override
    public boolean addDependentTask(Task<?> dependent) {
        boolean ret = false;
        if (this.getListTasks() != null) {
            ret = true;
            for (Task<?> tsk : this.getListTasks()) {
                ret &= tsk.addDependentTask(dependent);
            }
        }
        return ret;
    }

    @Override
    public List<Task<?>> getDependentTasks() {
        return this.listTasks;
    }
}

