/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Timestamp;
import org.apache.hadoop.hive.metastore.api.TimestampColumnStatsData;
import org.apache.hadoop.hive.metastore.api.utils.DecimalUtils;
import org.apache.hadoop.hive.metastore.columnstats.cache.DateColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.DecimalColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.DoubleColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.LongColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.StringColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.TimestampColumnStatsDataInspector;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ColumnStatsUpdateWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnStatsUpdateTask
extends Task<ColumnStatsUpdateWork> {
    private static final long serialVersionUID = 1L;
    private static final transient Logger LOG = LoggerFactory.getLogger(ColumnStatsUpdateTask.class);

    private ColumnStatistics constructColumnStatsFromInput() throws SemanticException, MetaException {
        Map<String, String> mapProp;
        if (((ColumnStatsUpdateWork)this.work).getColStats() != null) {
            ColumnStatistics colStats = ((ColumnStatsUpdateWork)this.work).getColStats();
            LOG.debug("Got stats through replication for " + colStats.getStatsDesc().getDbName() + "." + colStats.getStatsDesc().getTableName());
            return colStats;
        }
        String dbName = ((ColumnStatsUpdateWork)this.work).dbName();
        String tableName = ((ColumnStatsUpdateWork)this.work).getTableName();
        String partName = ((ColumnStatsUpdateWork)this.work).getPartName();
        String colName = ((ColumnStatsUpdateWork)this.work).getColName();
        String columnType = ((ColumnStatsUpdateWork)this.work).getColType();
        ColumnStatisticsObj statsObj = new ColumnStatisticsObj();
        statsObj.setColName(colName);
        statsObj.setColType(columnType);
        ColumnStatisticsData statsData = new ColumnStatisticsData();
        if (columnType.equalsIgnoreCase("long") || columnType.equalsIgnoreCase("tinyint") || columnType.equalsIgnoreCase("smallint") || columnType.equalsIgnoreCase("int") || columnType.equalsIgnoreCase("bigint")) {
            LongColumnStatsDataInspector longStats = new LongColumnStatsDataInspector();
            longStats.setNumNullsIsSet(false);
            longStats.setNumDVsIsSet(false);
            longStats.setLowValueIsSet(false);
            longStats.setHighValueIsSet(false);
            mapProp = ((ColumnStatsUpdateWork)this.work).getMapProp();
            for (Map.Entry<String, String> entry : mapProp.entrySet()) {
                String fName = entry.getKey();
                String value = entry.getValue();
                if (fName.equals("numNulls")) {
                    longStats.setNumNulls(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("numDVs")) {
                    longStats.setNumDVs(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("lowValue")) {
                    longStats.setLowValue(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("highValue")) {
                    longStats.setHighValue(Long.parseLong(value));
                    continue;
                }
                throw new SemanticException("Unknown stat");
            }
            statsData.setLongStats((LongColumnStatsData)longStats);
            statsObj.setStatsData(statsData);
        } else if (columnType.equalsIgnoreCase("double") || columnType.equalsIgnoreCase("float")) {
            DoubleColumnStatsDataInspector doubleStats = new DoubleColumnStatsDataInspector();
            doubleStats.setNumNullsIsSet(false);
            doubleStats.setNumDVsIsSet(false);
            doubleStats.setLowValueIsSet(false);
            doubleStats.setHighValueIsSet(false);
            mapProp = ((ColumnStatsUpdateWork)this.work).getMapProp();
            for (Map.Entry<String, String> entry : mapProp.entrySet()) {
                String fName = entry.getKey();
                String value = entry.getValue();
                if (fName.equals("numNulls")) {
                    doubleStats.setNumNulls(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("numDVs")) {
                    doubleStats.setNumDVs(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("lowValue")) {
                    doubleStats.setLowValue(Double.parseDouble(value));
                    continue;
                }
                if (fName.equals("highValue")) {
                    doubleStats.setHighValue(Double.parseDouble(value));
                    continue;
                }
                throw new SemanticException("Unknown stat");
            }
            statsData.setDoubleStats((DoubleColumnStatsData)doubleStats);
            statsObj.setStatsData(statsData);
        } else if (columnType.equalsIgnoreCase("string") || columnType.toLowerCase().startsWith("char") || columnType.toLowerCase().startsWith("varchar")) {
            StringColumnStatsDataInspector stringStats = new StringColumnStatsDataInspector();
            stringStats.setMaxColLenIsSet(false);
            stringStats.setAvgColLenIsSet(false);
            stringStats.setNumNullsIsSet(false);
            stringStats.setNumDVsIsSet(false);
            mapProp = ((ColumnStatsUpdateWork)this.work).getMapProp();
            for (Map.Entry<String, String> entry : mapProp.entrySet()) {
                String fName = entry.getKey();
                String value = entry.getValue();
                if (fName.equals("numNulls")) {
                    stringStats.setNumNulls(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("numDVs")) {
                    stringStats.setNumDVs(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("avgColLen")) {
                    stringStats.setAvgColLen(Double.parseDouble(value));
                    continue;
                }
                if (fName.equals("maxColLen")) {
                    stringStats.setMaxColLen(Long.parseLong(value));
                    continue;
                }
                throw new SemanticException("Unknown stat");
            }
            statsData.setStringStats((StringColumnStatsData)stringStats);
            statsObj.setStatsData(statsData);
        } else if (columnType.equalsIgnoreCase("boolean")) {
            BooleanColumnStatsData booleanStats = new BooleanColumnStatsData();
            booleanStats.setNumNullsIsSet(false);
            booleanStats.setNumTruesIsSet(false);
            booleanStats.setNumFalsesIsSet(false);
            mapProp = ((ColumnStatsUpdateWork)this.work).getMapProp();
            for (Map.Entry<String, String> entry : mapProp.entrySet()) {
                String fName = entry.getKey();
                String value = entry.getValue();
                if (fName.equals("numNulls")) {
                    booleanStats.setNumNulls(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("numTrues")) {
                    booleanStats.setNumTrues(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("numFalses")) {
                    booleanStats.setNumFalses(Long.parseLong(value));
                    continue;
                }
                throw new SemanticException("Unknown stat");
            }
            statsData.setBooleanStats(booleanStats);
            statsObj.setStatsData(statsData);
        } else if (columnType.equalsIgnoreCase("binary")) {
            BinaryColumnStatsData binaryStats = new BinaryColumnStatsData();
            binaryStats.setNumNullsIsSet(false);
            binaryStats.setAvgColLenIsSet(false);
            binaryStats.setMaxColLenIsSet(false);
            mapProp = ((ColumnStatsUpdateWork)this.work).getMapProp();
            for (Map.Entry<String, String> entry : mapProp.entrySet()) {
                String fName = entry.getKey();
                String value = entry.getValue();
                if (fName.equals("numNulls")) {
                    binaryStats.setNumNulls(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("avgColLen")) {
                    binaryStats.setAvgColLen(Double.parseDouble(value));
                    continue;
                }
                if (fName.equals("maxColLen")) {
                    binaryStats.setMaxColLen(Long.parseLong(value));
                    continue;
                }
                throw new SemanticException("Unknown stat");
            }
            statsData.setBinaryStats(binaryStats);
            statsObj.setStatsData(statsData);
        } else if (columnType.toLowerCase().startsWith("decimal")) {
            DecimalColumnStatsDataInspector decimalStats = new DecimalColumnStatsDataInspector();
            decimalStats.setNumNullsIsSet(false);
            decimalStats.setNumDVsIsSet(false);
            decimalStats.setLowValueIsSet(false);
            decimalStats.setHighValueIsSet(false);
            mapProp = ((ColumnStatsUpdateWork)this.work).getMapProp();
            for (Map.Entry<String, String> entry : mapProp.entrySet()) {
                BigDecimal d;
                String fName = entry.getKey();
                String value = entry.getValue();
                if (fName.equals("numNulls")) {
                    decimalStats.setNumNulls(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("numDVs")) {
                    decimalStats.setNumDVs(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("lowValue")) {
                    d = new BigDecimal(value);
                    decimalStats.setLowValue(DecimalUtils.getDecimal((ByteBuffer)ByteBuffer.wrap(d.unscaledValue().toByteArray()), (short)((short)d.scale())));
                    continue;
                }
                if (fName.equals("highValue")) {
                    d = new BigDecimal(value);
                    decimalStats.setHighValue(DecimalUtils.getDecimal((ByteBuffer)ByteBuffer.wrap(d.unscaledValue().toByteArray()), (short)((short)d.scale())));
                    continue;
                }
                throw new SemanticException("Unknown stat");
            }
            statsData.setDecimalStats((DecimalColumnStatsData)decimalStats);
            statsObj.setStatsData(statsData);
        } else if (columnType.equalsIgnoreCase("date")) {
            DateColumnStatsDataInspector dateStats = new DateColumnStatsDataInspector();
            mapProp = ((ColumnStatsUpdateWork)this.work).getMapProp();
            for (Map.Entry<String, String> entry : mapProp.entrySet()) {
                String fName = entry.getKey();
                String value = entry.getValue();
                if (fName.equals("numNulls")) {
                    dateStats.setNumNulls(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("numDVs")) {
                    dateStats.setNumDVs(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("lowValue")) {
                    dateStats.setLowValue(this.readDateValue(value));
                    continue;
                }
                if (fName.equals("highValue")) {
                    dateStats.setHighValue(this.readDateValue(value));
                    continue;
                }
                throw new SemanticException("Unknown stat");
            }
            statsData.setDateStats((DateColumnStatsData)dateStats);
            statsObj.setStatsData(statsData);
        } else if (columnType.equalsIgnoreCase("timestamp")) {
            TimestampColumnStatsDataInspector timestampStats = new TimestampColumnStatsDataInspector();
            mapProp = ((ColumnStatsUpdateWork)this.work).getMapProp();
            for (Map.Entry<String, String> entry : mapProp.entrySet()) {
                String fName = entry.getKey();
                String value = entry.getValue();
                if (fName.equals("numNulls")) {
                    timestampStats.setNumNulls(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("numDVs")) {
                    timestampStats.setNumDVs(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("lowValue")) {
                    timestampStats.setLowValue(this.readTimestampValue(value));
                    continue;
                }
                if (fName.equals("highValue")) {
                    timestampStats.setHighValue(this.readTimestampValue(value));
                    continue;
                }
                throw new SemanticException("Unknown stat");
            }
            statsData.setTimestampStats((TimestampColumnStatsData)timestampStats);
            statsObj.setStatsData(statsData);
        } else {
            throw new SemanticException("Unsupported type");
        }
        ColumnStatisticsDesc statsDesc = this.getColumnStatsDesc(dbName, tableName, partName, partName == null);
        ColumnStatistics colStat = new ColumnStatistics();
        colStat.setStatsDesc(statsDesc);
        colStat.addToStatsObj(statsObj);
        colStat.setEngine("hive");
        return colStat;
    }

    private ColumnStatisticsDesc getColumnStatsDesc(String dbName, String tableName, String partName, boolean isTblLevel) {
        ColumnStatisticsDesc statsDesc = new ColumnStatisticsDesc();
        statsDesc.setDbName(dbName);
        statsDesc.setTableName(tableName);
        statsDesc.setIsTblLevel(isTblLevel);
        if (!isTblLevel) {
            statsDesc.setPartName(partName);
        } else {
            statsDesc.setPartName(null);
        }
        return statsDesc;
    }

    private int persistColumnStats(Hive db) throws HiveException, MetaException, IOException {
        ColumnStatistics colStats = this.constructColumnStatsFromInput();
        SetPartitionsStatsRequest request = new SetPartitionsStatsRequest(Collections.singletonList(colStats), "hive");
        if (((ColumnStatsUpdateWork)this.work).getColStats() != null) {
            String dbName = colStats.getStatsDesc().getDbName();
            String tblName = colStats.getStatsDesc().getTableName();
            Table tbl = db.getTable(dbName, tblName);
            long writeId = ((ColumnStatsUpdateWork)this.work).getWriteId();
            if (AcidUtils.isTransactionalTable(tbl)) {
                ValidReaderWriteIdList writeIds = new ValidReaderWriteIdList(TableName.getDbTable((String)dbName, (String)tblName), new long[0], new BitSet(), writeId);
                request.setValidWriteIdList(writeIds.toString());
                request.setWriteId(writeId);
            }
        }
        db.setPartitionColumnStatistics(request);
        return 0;
    }

    @Override
    public int execute() {
        try {
            Hive db = this.getHive();
            return this.persistColumnStats(db);
        }
        catch (Exception e) {
            this.setException(e);
            LOG.info("Failed to persist stats in metastore", (Throwable)e);
            return ReplUtils.handleException(((ColumnStatsUpdateWork)this.work).isReplication(), e, ((ColumnStatsUpdateWork)this.work).getDumpDirectory(), ((ColumnStatsUpdateWork)this.work).getMetricCollector(), this.getName(), this.conf);
        }
    }

    @Override
    public StageType getType() {
        return StageType.COLUMNSTATS;
    }

    public String getName() {
        return "COLUMNSTATS UPDATE TASK";
    }

    private Date readDateValue(String dateStr) {
        try {
            DateWritableV2 writableVal = new DateWritableV2(org.apache.hadoop.hive.common.type.Date.valueOf((String)dateStr));
            return new Date((long)writableVal.getDays());
        }
        catch (IllegalArgumentException err) {
            LOG.debug("Reading date value as days since epoch: {}", (Object)dateStr);
            return new Date(Long.parseLong(dateStr));
        }
    }

    private Timestamp readTimestampValue(String timestampStr) {
        try {
            TimestampWritableV2 writableVal = new TimestampWritableV2(org.apache.hadoop.hive.common.type.Timestamp.valueOf((String)timestampStr));
            return new Timestamp(writableVal.getSeconds());
        }
        catch (IllegalArgumentException err) {
            LOG.debug("Reading timestamp value as seconds since epoch: {}", (Object)timestampStr);
            return new Timestamp(Long.parseLong(timestampStr));
        }
    }
}

