/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.trigger.drop;

import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.trigger.drop.DropWMTriggerDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={912})
public class DropWMTriggerAnalyzer
extends BaseSemanticAnalyzer {
    public DropWMTriggerAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        if (root.getChildCount() != 2) {
            throw new SemanticException("Invalid syntax for drop trigger.");
        }
        String resourcePlanName = DropWMTriggerAnalyzer.unescapeIdentifier(root.getChild(0).getText());
        String triggerName = DropWMTriggerAnalyzer.unescapeIdentifier(root.getChild(1).getText());
        DropWMTriggerDesc desc = new DropWMTriggerDesc(resourcePlanName, triggerName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        DDLUtils.addServiceOutput(this.conf, this.getOutputs());
    }
}

