/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.trigger.alter;

import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.trigger.TriggerUtils;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.trigger.alter.AlterWMTriggerDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={844})
public class AlterWMTriggerAnalyzer
extends BaseSemanticAnalyzer {
    public AlterWMTriggerAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        if (root.getChildCount() != 4) {
            throw new SemanticException("Invalid syntax for alter trigger statement");
        }
        String resourcePlanName = AlterWMTriggerAnalyzer.unescapeIdentifier(root.getChild(0).getText());
        String triggerName = AlterWMTriggerAnalyzer.unescapeIdentifier(root.getChild(1).getText());
        String triggerExpression = TriggerUtils.buildTriggerExpression((ASTNode)root.getChild(2));
        String actionExpression = TriggerUtils.buildTriggerActionExpression((ASTNode)root.getChild(3));
        AlterWMTriggerDesc desc = new AlterWMTriggerDesc(resourcePlanName, triggerName, triggerExpression, actionExpression);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        DDLUtils.addServiceOutput(this.conf, this.getOutputs());
    }
}

