/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.pool.create;

import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.WMUtils;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.pool.create.CreateWMPoolDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.PlanUtils;

@DDLSemanticAnalyzerFactory.DDLType(types={869})
public class CreateWMPoolAnalyzer
extends BaseSemanticAnalyzer {
    public CreateWMPoolAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        if (root.getChildCount() < 3) {
            throw new SemanticException("Expected more arguments: " + root.toStringTree());
        }
        String resourcePlanName = CreateWMPoolAnalyzer.unescapeIdentifier(root.getChild(0).getText());
        String poolPath = WMUtils.poolPath(root.getChild(1));
        Double allocFraction = null;
        Integer queryParallelism = null;
        String schedulingPolicy = null;
        block6: for (int i = 2; i < root.getChildCount(); ++i) {
            Tree child = root.getChild(i);
            if (child.getChildCount() != 1) {
                throw new SemanticException("Expected 1 paramter for: " + child.getText());
            }
            String param = child.getChild(0).getText();
            switch (child.getType()) {
                case 775: {
                    allocFraction = Double.parseDouble(param);
                    continue block6;
                }
                case 1050: {
                    queryParallelism = Integer.parseInt(param);
                    continue block6;
                }
                case 1081: {
                    schedulingPolicy = PlanUtils.stripQuotes(param);
                    continue block6;
                }
                case 1029: {
                    throw new SemanticException("Invalid parameter path in create pool");
                }
                default: {
                    throw new SemanticException("Invalid parameter " + child.getText() + " in create pool");
                }
            }
        }
        if (allocFraction == null) {
            throw new SemanticException("alloc_fraction should be specified for a pool");
        }
        if (queryParallelism == null) {
            throw new SemanticException("query_parallelism should be specified for a pool");
        }
        CreateWMPoolDesc desc = new CreateWMPoolDesc(resourcePlanName, poolPath, allocFraction, queryParallelism, schedulingPolicy);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        DDLUtils.addServiceOutput(this.conf, this.getOutputs());
    }
}

