/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.workloadmanagement.pool.alter;

import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.WMUtils;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.pool.alter.AlterWMPoolDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.PlanUtils;

@DDLSemanticAnalyzerFactory.DDLType(types={833})
public class AlterWMPoolAnalyzer
extends BaseSemanticAnalyzer {
    public AlterWMPoolAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        if (root.getChildCount() < 3) {
            throw new SemanticException("Invalid syntax for alter pool: " + root.toStringTree());
        }
        String resourcePlanName = AlterWMPoolAnalyzer.unescapeIdentifier(root.getChild(0).getText());
        String poolPath = WMUtils.poolPath(root.getChild(1));
        Double allocFraction = null;
        Integer queryParallelism = null;
        String schedulingPolicy = null;
        boolean removeSchedulingPolicy = false;
        String newPath = null;
        block6: for (int i = 2; i < root.getChildCount(); ++i) {
            Tree child = root.getChild(i);
            if (child.getChildCount() != 1) {
                throw new SemanticException("Invalid syntax in alter pool expected parameter.");
            }
            Tree param = child.getChild(0);
            switch (child.getType()) {
                case 775: {
                    allocFraction = Double.parseDouble(param.getText());
                    continue block6;
                }
                case 1050: {
                    queryParallelism = Integer.parseInt(param.getText());
                    continue block6;
                }
                case 1081: {
                    if (param.getType() != 995) {
                        schedulingPolicy = PlanUtils.stripQuotes(param.getText());
                        continue block6;
                    }
                    removeSchedulingPolicy = true;
                    continue block6;
                }
                case 1029: {
                    newPath = WMUtils.poolPath(param);
                    continue block6;
                }
                default: {
                    throw new SemanticException("Incorrect alter syntax: " + child.toStringTree());
                }
            }
        }
        AlterWMPoolDesc desc = new AlterWMPoolDesc(resourcePlanName, poolPath, allocFraction, queryParallelism, schedulingPolicy, removeSchedulingPolicy, newPath);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
        DDLUtils.addServiceOutput(this.conf, this.getOutputs());
    }
}

