/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.materialized.show;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Show Materialized Views", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ShowMaterializedViewsDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SCHEMA = "mv_name,rewrite_enabled,mode#string:string:string";
    private final String resFile;
    private final String dbName;
    private final String pattern;

    public ShowMaterializedViewsDesc(Path resFile, String dbName, String pattern) {
        this.resFile = resFile.toString();
        this.dbName = dbName;
        this.pattern = pattern;
    }

    @Explain(displayName="pattern")
    public String getPattern() {
        return this.pattern;
    }

    @Explain(displayName="result file", explainLevels={Explain.Level.EXTENDED})
    public String getResFile() {
        return this.resFile;
    }

    @Explain(displayName="database name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getDbName() {
        return this.dbName;
    }
}

