/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.view.materialized.alter.rewrite;

import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.view.materialized.alter.rewrite.AlterMaterializedViewRewriteDesc;
import org.apache.hadoop.hive.ql.ddl.view.materialized.update.MaterializedViewUpdateDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={832})
public class AlterMaterializedViewRewriteAnalyzer
extends BaseSemanticAnalyzer {
    private DDLDesc.DDLDescWithWriteId ddlDescWithWriteId;

    public AlterMaterializedViewRewriteAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        boolean rewriteEnable;
        TableName tableName = AlterMaterializedViewRewriteAnalyzer.getQualifiedTableName((ASTNode)root.getChild(0));
        switch (root.getChild(1).getType()) {
            case 1074: {
                rewriteEnable = true;
                break;
            }
            case 1073: {
                rewriteEnable = false;
                break;
            }
            default: {
                throw new SemanticException("Invalid alter materialized view expression");
            }
        }
        Table materializedViewTable = this.getTable(tableName, true);
        if (rewriteEnable) {
            for (String sourceTableName : materializedViewTable.getCreationMetadata().getTablesUsed()) {
                Table table = this.getTable(sourceTableName, true);
                if (AcidUtils.isTransactionalTable(table)) continue;
                throw new SemanticException("Automatic rewriting for materialized view cannot be enabled if the materialized view uses non-transactional tables");
            }
        }
        AlterMaterializedViewRewriteDesc desc = new AlterMaterializedViewRewriteDesc(tableName.getNotEmptyDbTable(), rewriteEnable);
        if (AcidUtils.isTransactionalTable(materializedViewTable)) {
            this.ddlDescWithWriteId = desc;
        }
        this.inputs.add(new ReadEntity(materializedViewTable));
        this.outputs.add(new WriteEntity(materializedViewTable, WriteEntity.WriteType.DDL_EXCLUSIVE));
        DDLWork work = new DDLWork(this.getInputs(), this.getOutputs(), desc);
        Task<DDLWork> targetTask = TaskFactory.get(work);
        MaterializedViewUpdateDesc materializedViewUpdateDesc = new MaterializedViewUpdateDesc(tableName.getNotEmptyDbTable(), rewriteEnable, !rewriteEnable, false);
        DDLWork updateDdlWork = new DDLWork(this.getInputs(), this.getOutputs(), materializedViewUpdateDesc);
        targetTask.addDependentTask(TaskFactory.get(updateDdlWork, this.conf));
        this.rootTasks.add(targetTask);
    }

    @Override
    public DDLDesc.DDLDescWithWriteId getAcidDdlDesc() {
        return this.ddlDescWithWriteId;
    }
}

